/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MyHashProg;
import ic.doc.ltsa.lts.MyHashProgEntry;
import ic.doc.ltsa.lts.MyList;
import ic.doc.ltsa.lts.MyStack;
import ic.doc.ltsa.lts.ProgressTest;
import ic.doc.ltsa.lts.StateCodec;
import ic.doc.ltsa.lts.ltl.FluentTrace;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class ProgressCheck {
    public static boolean strongFairFlag = true;
    private Automata mach;
    private Stack stack;
    int id = 0;
    int ncomp = 0;
    LTSOutput output;
    int violation = 0;
    boolean hasERROR = false;
    static final int Maxviolation = 10;
    String tnames;
    int accept = -1;
    boolean progress;
    FluentTrace tracer = null;
    private int sccId;
    private int nTrans;
    Vector errorTrace;
    Vector cycleTrace;

    public ProgressCheck(Automata m, LTSOutput o) {
        this.mach = m;
        this.output = o;
    }

    public ProgressCheck(Automata m, LTSOutput o, FluentTrace t) {
        this.mach = m;
        this.output = o;
        this.tracer = t;
    }

    public void doProgressCheck() {
        this.progress = true;
        this.output.outln("Progress Check...");
        long start = System.currentTimeMillis();
        ProgressTest.initTests(this.mach.getAlphabet());
        this.stack = new Stack();
        this.findCC();
        long finish = System.currentTimeMillis();
        if (this.hasERROR) {
            this.output.outln("Safety property violation detected - check safety.");
        } else if (this.violation == 0) {
            this.output.outln("No progress violations detected.");
        } else if (this.violation > 10) {
            this.output.outln("More than 10 violations");
        }
        this.output.outln("Progress Check in: " + (finish - start) + "ms");
    }

    public void doLTLCheck() {
        this.progress = false;
        this.output.outln("LTL Property Check...");
        long start = System.currentTimeMillis();
        this.accept = this.acceptLabel(this.mach.getAlphabet());
        if (this.accept < 0) {
            this.output.outln("No labeled acceptance states.");
            return;
        }
        this.stack = new Stack();
        this.findCC();
        long finish = System.currentTimeMillis();
        if (this.hasERROR) {
            this.output.outln("Safety property violation detected - check safety.");
        } else if (this.violation == 0) {
            this.output.outln("No LTL Property violations detected.");
        } else if (this.violation > 10) {
            this.output.outln("More than 10 violations");
        }
        this.output.outln("LTL Property Check in: " + (finish - start) + "ms");
    }

    public int numberComponents() {
        return this.ncomp;
    }

    private void findCC() {
        MyHashProg hh = new MyHashProg();
        MyStack stk = new MyStack();
        this.mach.setStackChecker(hh);
        this.sccId = 0;
        this.nTrans = 0;
        byte[] zero = this.mach.START();
        stk.push(zero);
        hh.add(zero, null);
        while (!stk.empty()) {
            MyHashProgEntry currentState = hh.get(stk.peek());
            while (currentState.isReturn || currentState.isProcessed) {
                if (currentState.isReturn && !currentState.isProcessed) {
                    currentState.isProcessed = true;
                    if (currentState.parent != null) {
                        currentState.parent.low = Math.min(currentState.parent.low, currentState.low);
                    }
                    if (currentState.low == currentState.dfn && this.component(hh, this.stack, currentState.key)) {
                        return;
                    }
                }
                stk.pop();
                if (stk.empty()) {
                    this.outStatistics(this.sccId, this.nTrans);
                    return;
                }
                currentState = hh.get(stk.peek());
            }
            currentState.dfn = ++this.sccId;
            currentState.low = this.sccId;
            if (this.sccId % 10000 == 0) {
                this.outStatistics(this.sccId, this.nTrans);
            }
            this.stack.push(currentState.key);
            currentState.isReturn = true;
            MyList transitions = this.mach.getTransitions(currentState.key);
            while (!transitions.empty()) {
                ++this.nTrans;
                if (transitions.getTo() == null) {
                    this.hasERROR = true;
                    return;
                }
                if (this.accept < 0 || transitions.getAction() != this.accept) {
                    MyHashProgEntry child = hh.get(transitions.getTo());
                    if (child == null) {
                        hh.add(transitions.getTo(), currentState);
                        stk.push(transitions.getTo());
                    } else if (child.dfn == 0) {
                        child.parent = currentState;
                        stk.push(transitions.getTo());
                    } else if (child.dfn < currentState.dfn) {
                        currentState.low = Math.min(child.dfn, currentState.low);
                    }
                }
                transitions.next();
            }
        }
        this.outStatistics(this.sccId, this.nTrans);
    }

    private void outhse(MyHashProgEntry e) {
        this.output.outln("state: " + e.key + " dfn: " + e.dfn + " low: " + e.low + " ret " + e.isReturn);
    }

    private boolean component(MyHashProg hstk, Stack stack, byte[] currentState) {
        byte[] m;
        ++this.ncomp;
        boolean hasAccept = false;
        Stack trace = new Stack();
        BitSet hasActions = new BitSet(this.mach.getAlphabet().length);
        do {
            trace.push(stack.pop());
            m = (byte[])trace.peek();
            if (this.progress) {
                MyList transitions = this.mach.getTransitions(m);
                while (!transitions.empty()) {
                    int act = transitions.getAction();
                    hasActions.set(act);
                    transitions.next();
                }
            } else {
                if (hasAccept) continue;
                hasAccept = this.mach.isAccepting(m);
            }
        } while (!StateCodec.equals(m, currentState));
        if (this.progress) {
            if (this.missing(hasActions) && this.terminalComponent(hstk, trace)) {
                this.outStatistics(this.sccId, this.nTrans);
                this.printCycle(trace, hasActions, currentState);
                return true;
            }
        } else if (hasAccept) {
            if (!strongFairFlag) {
                if (this.nontrivial(trace)) {
                    this.outStatistics(this.sccId, this.nTrans);
                    this.printCounterExample(trace, currentState);
                    return true;
                }
            } else if (this.terminalComponent(hstk, trace)) {
                this.outStatistics(this.sccId, this.nTrans);
                this.printCounterExample(null, currentState);
                return true;
            }
        }
        Enumeration e = trace.elements();
        while (e.hasMoreElements()) {
            byte[] i = (byte[])e.nextElement();
            MyHashProgEntry hse = hstk.get(i);
            hse.dfn = Integer.MAX_VALUE;
        }
        return false;
    }

    private boolean missing(BitSet actions) {
        int alphalen = this.mach.getAlphabet().length;
        if (ProgressTest.noTests()) {
            int i = 1;
            while (i < alphalen) {
                if (!actions.get(i)) {
                    return true;
                }
                ++i;
            }
        } else {
            this.tnames = null;
            Enumeration e = ProgressTest.tests.elements();
            while (e.hasMoreElements()) {
                ProgressTest p = (ProgressTest)e.nextElement();
                if (p.cset == null) {
                    if (!this.contains_none_of(alphalen, actions, p.pset)) continue;
                    if (this.tnames == null) {
                        this.tnames = p.name;
                        continue;
                    }
                    this.tnames = String.valueOf(this.tnames) + " " + p.name;
                    continue;
                }
                if (this.contains_none_of(alphalen, actions, p.pset) || !this.contains_none_of(alphalen, actions, p.cset)) continue;
                this.tnames = this.tnames == null ? p.name : String.valueOf(this.tnames) + " " + p.name;
            }
            if (this.tnames != null) {
                return true;
            }
        }
        return false;
    }

    private boolean contains_none_of(int length, BitSet actions, BitSet target) {
        int i = 1;
        while (i < length) {
            if (actions.get(i) && target.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean terminalComponent(MyHashProg hstk, Vector component) {
        byte[] i;
        BitSet tc = new BitSet(10001);
        Enumeration e = component.elements();
        while (e.hasMoreElements()) {
            i = (byte[])e.nextElement();
            MyHashProgEntry hse = hstk.get(i);
            tc.set(hse.dfn);
        }
        e = component.elements();
        while (e.hasMoreElements()) {
            i = (byte[])e.nextElement();
            MyList tr = this.mach.getTransitions(i);
            while (!tr.empty()) {
                if (tr.getTo() == null) {
                    this.hasERROR = true;
                    return false;
                }
                MyHashProgEntry hse = hstk.get(tr.getTo());
                if (hse == null) {
                    return false;
                }
                if (hse.dfn == 0) {
                    return false;
                }
                if (hse.dfn == Integer.MAX_VALUE) {
                    return false;
                }
                if (!tc.get(hse.dfn)) {
                    return false;
                }
                tr.next();
            }
        }
        return true;
    }

    private boolean inComponent(Vector component, byte[] state) {
        Enumeration e = component.elements();
        while (e.hasMoreElements()) {
            byte[] i = (byte[])e.nextElement();
            if (!StateCodec.equals(i, state)) continue;
            return true;
        }
        return false;
    }

    private boolean nontrivial(Vector component) {
        if (component.size() > 1) {
            return true;
        }
        byte[] i = (byte[])component.elementAt(0);
        MyList transitions = this.mach.getTransitions(i);
        while (!transitions.empty()) {
            int act = transitions.getAction();
            if ((act != this.accept || this.accept < 0) && StateCodec.equals(i, transitions.getTo())) {
                return true;
            }
            transitions.next();
        }
        return false;
    }

    private void printSet(BitSet actions, boolean missing) {
        Vector<String> v = new Vector<String>();
        String[] alphabet = this.mach.getAlphabet();
        int i = 1;
        while (i < alphabet.length) {
            if (missing && !actions.get(i) || !missing && actions.get(i)) {
                v.addElement(alphabet[i]);
            }
            ++i;
        }
        this.output.outln("\t" + new Alphabet(v).toString());
    }

    Vector getErrorTrace() {
        if (this.errorTrace == null) {
            return null;
        }
        if (this.cycleTrace != null) {
            this.errorTrace.addAll(this.cycleTrace);
            this.errorTrace.addAll(this.cycleTrace);
        }
        return this.errorTrace;
    }

    private void printCycle(Stack trace, BitSet actions, byte[] root) {
        ++this.violation;
        if (this.violation > 10) {
            return;
        }
        this.errorTrace = this.getRootTrace(root);
        if (this.errorTrace == null) {
            return;
        }
        this.cycleTrace = this.getCycleTrace(null, root);
        if (ProgressTest.noTests()) {
            this.output.outln("Progress violation for actions: ");
            this.printSet(actions, true);
        } else {
            this.output.outln("Progress violation: " + this.tnames);
        }
        this.output.outln("Trace to terminal set of states:");
        this.printTrace(this.errorTrace);
        this.output.outln("Cycle in terminal set:");
        this.printTrace(this.cycleTrace);
        this.output.outln("Actions in terminal set:");
        this.printSet(actions, false);
    }

    private void printCounterExample(Stack trace, byte[] root) {
        ++this.violation;
        if (this.violation > 10) {
            return;
        }
        this.errorTrace = this.getRootTrace(root);
        if (this.errorTrace == null) {
            return;
        }
        this.cycleTrace = this.getCycleTrace(trace, root);
        this.output.outln("Violation of LTL property: " + this.mach.getAlphabet()[this.accept]);
        this.output.outln("Trace to terminal set of states:");
        this.tracer.print(this.output, this.errorTrace, true);
        this.output.outln("Cycle in terminal set:");
        this.tracer.print(this.output, this.cycleTrace, false);
    }

    Vector getRootTrace(byte[] root) {
        this.output.outln("Finding trace to cycle...");
        Vector trace = this.mach.getTraceToState(this.mach.START(), root);
        if (trace == null) {
            this.hasERROR = true;
        }
        return trace;
    }

    Vector getCycleTrace(Vector component, byte[] root) {
        this.output.outln("Finding trace in cycle...");
        Vector trace = null;
        MyList transitions = this.mach.getTransitions(root);
        byte[] cycle = null;
        int act = 0;
        while (!transitions.empty()) {
            act = transitions.getAction();
            if (act == this.accept && this.accept > 0 || this.stateLabel(act)) {
                transitions.next();
                continue;
            }
            cycle = transitions.getTo();
            if (component == null || this.inComponent(component, cycle)) break;
            transitions.next();
        }
        if (cycle != null) {
            trace = this.mach.getTraceToState(cycle, root);
            trace.add(0, this.mach.getAlphabet()[act]);
        }
        return trace;
    }

    private void printTrace(Vector trace) {
        if (trace == null) {
            return;
        }
        Enumeration e = trace.elements();
        while (e.hasMoreElements()) {
            this.output.outln("\t" + (String)e.nextElement());
        }
    }

    private boolean stateLabel(int act) {
        String s = this.mach.getAlphabet()[act];
        return s.charAt(0) == '_';
    }

    private void outStatistics(int states, int transitions) {
        Runtime r = Runtime.getRuntime();
        this.output.outln("-- States: " + states + " Transitions: " + transitions + " Memory used: " + (r.totalMemory() - r.freeMemory()) / 1000L + "K");
    }

    private boolean isAccept(String label) {
        if (label.charAt(0) == '@') {
            return true;
        }
        int begin = 0;
        int end = label.indexOf(46);
        while (end > 0) {
            if (label.substring(begin, end).charAt(0) == '@') {
                return true;
            }
            begin = end + 1;
            end = label.indexOf(46, end + 1);
        }
        return label.substring(begin).charAt(0) == '@';
    }

    private int acceptLabel(String[] alphabet) {
        int i = 1;
        while (i < alphabet.length) {
            if (this.isAccept(alphabet[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

