/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

public class StateCodec {
    int[] bitSize;
    int NBIT;
    int NBYTE;
    static int[] masks;
    int[] boundaries;

    static {
        int[] nArray = new int[32];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        nArray[17] = 131071;
        nArray[18] = 262143;
        nArray[19] = 524287;
        nArray[20] = 1048575;
        nArray[21] = 0x1FFFFF;
        nArray[22] = 0x3FFFFF;
        nArray[23] = 0x7FFFFF;
        nArray[24] = 0xFFFFFF;
        nArray[25] = 0x1FFFFFF;
        nArray[26] = 0x3FFFFFF;
        nArray[27] = 0x7FFFFFF;
        nArray[28] = 0xFFFFFFF;
        nArray[29] = 0x1FFFFFFF;
        nArray[30] = 0x3FFFFFFF;
        nArray[31] = Integer.MAX_VALUE;
        masks = nArray;
    }

    public StateCodec(int[] sm) {
        this.bitSize = new int[sm.length];
        this.NBIT = 0;
        int longwords = 1;
        int i = sm.length - 1;
        while (i >= 0) {
            this.bitSize[i] = this.nbits(sm[i] - 1);
            if (this.NBIT + this.bitSize[i] > longwords * 64) {
                this.NBIT = longwords * 64;
                ++longwords;
            }
            this.NBIT += this.bitSize[i];
            --i;
        }
        this.NBYTE = this.NBIT / 8;
        if (this.NBIT % 8 > 0) {
            ++this.NBYTE;
        }
        this.boundaries = new int[longwords];
        int bits = 0;
        int boundary = 0;
        int i2 = sm.length - 1;
        while (i2 >= 0) {
            if (bits + this.bitSize[i2] <= 64) {
                bits += this.bitSize[i2];
            } else {
                this.boundaries[boundary] = i2 + 1;
                bits = this.bitSize[i2];
                ++boundary;
            }
            --i2;
        }
        this.boundaries[boundary] = 0;
    }

    private void longToBytes(byte[] code, long x, int start, int finish) {
        int i = start;
        while (i < finish) {
            int n = i++;
            code[n] = (byte)(code[n] | (byte)x);
            x >>>= 8;
        }
    }

    private long bytesToLong(byte[] code, int start, int finish) {
        long x = 0L;
        int i = finish - 1;
        while (i >= start) {
            x |= (long)code[i] & 0xFFL;
            if (i > start) {
                x <<= 8;
            }
            --i;
        }
        return x;
    }

    public int bits() {
        int nb = 0;
        int i = 0;
        while (i < this.bitSize.length) {
            nb += this.bitSize[i];
            ++i;
        }
        return nb;
    }

    public byte[] zero() {
        return new byte[this.NBYTE];
    }

    public byte[] encode(int[] states) {
        byte[] code = new byte[this.NBYTE];
        int start = this.bitSize.length - 1;
        int insertfrom = this.NBYTE;
        int lw = 0;
        while (lw < this.boundaries.length) {
            long x = 0L;
            int i = start;
            while (i >= this.boundaries[lw]) {
                if (states[i] < 0) {
                    return null;
                }
                x |= (long)states[i];
                if (i > this.boundaries[lw]) {
                    x <<= this.bitSize[i - 1];
                }
                --i;
            }
            int t = insertfrom - 8;
            if (t < 0) {
                t = 0;
            }
            this.longToBytes(code, x, t, insertfrom);
            insertfrom = t;
            start = this.boundaries[lw] - 1;
            ++lw;
        }
        return code;
    }

    public int[] decode(byte[] code) {
        int[] states = new int[this.bitSize.length + 1];
        int finish = this.bitSize.length;
        int getfrom = this.NBYTE;
        int lw = 0;
        while (lw < this.boundaries.length) {
            int t = getfrom - 8;
            if (t < 0) {
                t = 0;
            }
            long x = this.bytesToLong(code, t, getfrom);
            int i = this.boundaries[lw];
            while (i < finish) {
                states[i] = (int)x & masks[this.bitSize[i]];
                x >>>= this.bitSize[i];
                ++i;
            }
            getfrom = t;
            finish = this.boundaries[lw];
            ++lw;
        }
        return states;
    }

    public static int hash(byte[] code) {
        long h = 0L;
        int i = 0;
        while (i < code.length) {
            h = h * 127L + (long)code[i];
            ++i;
        }
        int ih = (int)(h ^ h >>> 32);
        return ih & Integer.MAX_VALUE;
    }

    public static long hashLong(byte[] code) {
        long h = 0L;
        int i = 0;
        while (i < code.length) {
            h = h * 255L + (long)code[i];
            ++i;
        }
        return h;
    }

    public static boolean equals(byte[] code1, byte[] code2) {
        if (code1 == null && code2 == null) {
            return true;
        }
        if (code1 == null || code2 == null) {
            return false;
        }
        if (code1.length != code2.length) {
            return true;
        }
        int i = 0;
        while (i < code1.length) {
            if (code1[i] != code2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int nbits(int i) {
        int count = 0;
        while (i != 0) {
            i >>>= 1;
            ++count;
        }
        return count;
    }
}

