/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.ws;

import ic.doc.ltsa.ws.wsaction;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSCDL2FSP {
    private Document currentDoc = null;
    private NodeList docnodelist = null;
    private Node currentdocnode = null;
    private String docname = "";
    private String currChoreographyName = "";
    private String currProcessLabel = "";
    private OutputStream outFSPStream = null;
    private OutputStream outStream = null;
    private LinkedList PackageList = null;
    private LinkedList ChoreographyList = null;
    private LinkedList SequenceList = null;
    private LinkedList actionList = null;
    private LinkedList choiceList = null;
    private LinkedList parallelList = null;
    private LinkedList tempList = null;

    public WSCDL2FSP() {
        this.initVars();
    }

    private void initVars() {
        this.PackageList = new LinkedList();
        this.ChoreographyList = new LinkedList();
        this.SequenceList = new LinkedList();
        this.actionList = new LinkedList();
        this.choiceList = new LinkedList();
        this.parallelList = new LinkedList();
        this.tempList = new LinkedList();
    }

    private boolean writeFSPOutput(String strOut) {
        boolean result = false;
        try {
            if (this.outFSPStream != null) {
                strOut = String.valueOf(strOut) + "\n";
                this.outFSPStream.write(strOut.getBytes());
                this.outFSPStream.flush();
            } else {
                System.out.println(strOut);
            }
        }
        catch (Exception E) {
            E.printStackTrace(System.err);
        }
        return result;
    }

    private boolean writeOutput(String strOut) {
        boolean result = false;
        try {
            if (this.outStream != null) {
                strOut = String.valueOf(strOut) + "\n";
                this.outStream.write(strOut.getBytes());
                this.outStream.flush();
            } else {
                System.out.println(strOut);
            }
        }
        catch (Exception E) {
            E.printStackTrace(System.err);
        }
        return result;
    }

    public void setFSPOutput(OutputStream os) {
        this.outFSPStream = os;
    }

    public void setOutput(OutputStream os) {
        this.outStream = os;
    }

    public boolean loadDoc(String DocInput, String DocNode, boolean isFilename) {
        boolean result = false;
        if (DocInput.length() > 0) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (isFilename) {
                    this.writeOutput("Loading document input.");
                    this.currentDoc = db.parse(DocInput);
                } else {
                    StringBufferInputStream is = new StringBufferInputStream(DocInput);
                    this.currentDoc = db.parse(is);
                }
                this.docnodelist = this.currentDoc.getElementsByTagName(DocNode);
                if (this.docnodelist.getLength() > 0) {
                    this.currentdocnode = this.docnodelist.item(0);
                    this.docname = this.currentdocnode.getAttributes().getNamedItem("name").getNodeValue().toString().toUpperCase();
                } else {
                    this.writeOutput("ERROR: No document found.");
                }
                result = true;
            }
            catch (Exception E) {
                E.printStackTrace(System.err);
            }
            if (result) {
                this.writeOutput("Document successfully loaded.)");
            } else {
                this.writeOutput("Document load failed.");
            }
        } else {
            this.writeOutput("ERROR: No document input specified to load.");
        }
        return result;
    }

    private boolean isTextNode(Node currentNode) {
        return currentNode.getNodeName().equals("#text");
    }

    public void writeHeader() {
        this.writeFSPOutput("// /////////////////////////////////////////////////////////////////");
        this.writeFSPOutput("// BEGIN Package: " + this.docname);
        this.writeFSPOutput("// /////////////////////////////////////////////////////////////////");
    }

    public void writeFooter() {
        this.writeFSPOutput("\n// /////////////////////////////////////////////////////////////////");
        this.writeFSPOutput("// END Package: " + this.docname);
        this.writeFSPOutput("// /////////////////////////////////////////////////////////////////");
    }

    private Node getChildNodeByName(NodeList constructNodeList, String nodeName) {
        Node currentNode = null;
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            currentNode = constructNodeList.item(loop);
            if (!this.isTextNode(currentNode) && !currentNode.getNodeName().equals("#comment") && currentNode.getNodeName().compareTo(nodeName) == 0) {
                return currentNode;
            }
            ++loop;
        }
        return null;
    }

    private String queryChildAttribute(NodeList constructNodeList, String nodeName, String nodeAttribute) {
        String value = "";
        Node aNode = null;
        Node itemNode = null;
        aNode = this.getChildNodeByName(constructNodeList, nodeName);
        if (aNode != null && (itemNode = aNode.getAttributes().getNamedItem(nodeAttribute)) != null) {
            value = itemNode.getNodeValue().toLowerCase();
        }
        return value;
    }

    private String doChildren(NodeList constructNodeList, boolean ReturnFlag) {
        String compositionName = "";
        Node constructNode = null;
        int constructcounter = 0;
        String fsp = "";
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            constructNode = constructNodeList.item(loop);
            if (!this.isTextNode(constructNode) && !constructNode.getNodeName().equals("#comment") && (compositionName = this.processANode(constructNode, false)).length() > 0) {
                if (constructcounter > 0) {
                    fsp = String.valueOf(fsp) + " ; ";
                }
                ++constructcounter;
                fsp = String.valueOf(fsp) + compositionName;
                if (ReturnFlag) {
                    return fsp;
                }
            }
            ++loop;
        }
        return fsp;
    }

    private void buildPackage(Node currentNode) {
        this.doChildren(currentNode.getChildNodes(), false);
    }

    private String buildChoreographyFSP(Node currentNode) {
        NodeList constructNodeList = null;
        String attributeName = "";
        String compositionName = "";
        String fsp = "";
        constructNodeList = currentNode.getChildNodes();
        compositionName = attributeName = currentNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        this.ChoreographyList.add(compositionName);
        this.currChoreographyName = compositionName;
        fsp = "||" + compositionName + " = (";
        fsp = String.valueOf(fsp) + this.doChildren(constructNodeList, false);
        fsp = String.valueOf(fsp) + ").";
        this.writeFSPOutput(fsp);
        return compositionName;
    }

    public String buildParallelFSP(Node currentNode) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionName = "";
        String fsp = "";
        String processNodename = "";
        constructNodeList = currentNode.getChildNodes();
        if (constructNodeList.getLength() >= 2) {
            compositionName = "PARALLEL" + this.parallelList.size() + 1;
            this.parallelList.add(compositionName);
            fsp = "||" + compositionName + " = (";
            int item = 0;
            int loop = 0;
            while (loop < constructNodeList.getLength()) {
                constructNode = constructNodeList.item(loop);
                if (!this.isTextNode(constructNode) && !constructNode.getNodeName().equals("#comment")) {
                    if (++item > 1) {
                        fsp = String.valueOf(fsp) + " || ";
                    }
                    this.actionList.clear();
                    processNodename = this.processANode(constructNode, false);
                    fsp = String.valueOf(fsp) + processNodename;
                }
                ++loop;
            }
            fsp = String.valueOf(fsp) + ").";
            this.writeFSPOutput("// build parallel composition");
            this.writeFSPOutput(fsp);
        }
        return compositionName;
    }

    public String buildChoiceFSP(Node currentNode) {
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionName = "";
        String fsp = "";
        String choicecompstr = "";
        String processNodename = "";
        constructNodeList = currentNode.getChildNodes();
        if (constructNodeList.getLength() >= 2) {
            compositionName = "CHOICE" + this.choiceList.size() + 1;
            this.choiceList.add(compositionName);
            this.tempList = (LinkedList)this.actionList.clone();
            fsp = String.valueOf(compositionName) + " = (";
            int item = 0;
            choicecompstr = "\n||" + compositionName + "COMP = (" + compositionName;
            int loop = 0;
            while (loop < constructNodeList.getLength()) {
                constructNode = constructNodeList.item(loop);
                if (!this.isTextNode(constructNode) && !constructNode.getNodeName().equals("#comment")) {
                    if (++item > 1) {
                        fsp = String.valueOf(fsp) + " | ";
                        choicecompstr = String.valueOf(choicecompstr) + " || ";
                    }
                    this.actionList.clear();
                    processNodename = this.processANode(constructNode, false);
                    if (item > 1) {
                        choicecompstr = String.valueOf(choicecompstr) + processNodename;
                    }
                    fsp = String.valueOf(fsp) + (String)this.actionList.getFirst();
                    fsp = String.valueOf(fsp) + " -> END ";
                }
                ++loop;
            }
            fsp = String.valueOf(fsp) + ").";
            choicecompstr = String.valueOf(choicecompstr) + ").";
            fsp = String.valueOf(fsp) + choicecompstr;
            this.writeFSPOutput("// build Choice composition");
            this.writeFSPOutput(fsp);
            this.actionList = (LinkedList)this.tempList.clone();
        }
        return String.valueOf(compositionName) + "COMP";
    }

    public String buildPerformFSP(Node currentNode) {
        String compositionName = "";
        currentNode.getChildNodes();
        Node namenode = currentNode.getAttributes().getNamedItem("choreographyName");
        compositionName = namenode != null ? namenode.getNodeValue().toUpperCase() : "UNKNOWN";
        return compositionName;
    }

    public String buildSequenceFSP(Node currentNode, boolean hasname, boolean addAlphabet) {
        NodeList constructNodeList = null;
        String compositionName = "";
        String fsp = "";
        constructNodeList = currentNode.getChildNodes();
        compositionName = String.valueOf(this.currChoreographyName) + "SEQ";
        if (this.SequenceList.contains(compositionName)) {
            compositionName = String.valueOf(compositionName) + this.SequenceList.size() + 1;
        }
        this.currProcessLabel = compositionName;
        this.SequenceList.add(compositionName);
        fsp = this.doChildren(constructNodeList, false);
        fsp = String.valueOf(compositionName) + " = " + fsp + ";END.";
        this.writeFSPOutput(fsp);
        return compositionName;
    }

    public String buildExchangesFSP(NodeList constructNodeList, String partner1, String partner2, String operation, String compositionName) {
        Node currentNode = null;
        Node actionNode = null;
        String fsp = "";
        String fspseq = "";
        fspseq = String.valueOf(compositionName) + "EXCHSEQ = ";
        int loop = 0;
        while (loop < constructNodeList.getLength()) {
            currentNode = constructNodeList.item(loop);
            if (!this.isTextNode(currentNode) && !currentNode.getNodeName().equals("#comment") && currentNode.getNodeName().compareTo("exchange") == 0) {
                String action = "unknown";
                actionNode = currentNode.getAttributes().getNamedItem("action");
                if (actionNode != null) {
                    action = actionNode.getNodeValue().toLowerCase();
                }
                compositionName = String.valueOf(compositionName) + operation + action;
                wsaction wsa = new wsaction(action, partner1, partner2, operation, "infotype", "");
                if (action.equals("respond")) {
                    wsa.switchPartners();
                }
                fsp = String.valueOf(fsp) + compositionName + " = (";
                fsp = String.valueOf(fsp) + wsa.toString();
                fsp = String.valueOf(fsp) + " -> END).\n";
                fspseq = String.valueOf(fspseq) + compositionName + ";";
                this.actionList.add(wsa.toString());
            }
            ++loop;
        }
        fspseq = String.valueOf(fspseq) + "END.";
        fsp = String.valueOf(fsp) + fspseq;
        return fsp;
    }

    public String buildInteractionFSP(Node currentNode) {
        NodeList constructNodeList = null;
        String compositionName = "";
        String fsp = "";
        Node namenode = null;
        Node operationnode = null;
        String operation = "";
        String partner1 = "";
        String partner2 = "";
        constructNodeList = currentNode.getChildNodes();
        namenode = currentNode.getAttributes().getNamedItem("name");
        compositionName = namenode != null ? namenode.getNodeValue().toUpperCase() : "INTERACTION" + this.actionList.size() + 1;
        operationnode = currentNode.getAttributes().getNamedItem("operation");
        operation = operationnode != null ? operationnode.getNodeValue().toLowerCase() : "unknown";
        partner1 = this.queryChildAttribute(constructNodeList, "participate", "fromRole");
        partner2 = this.queryChildAttribute(constructNodeList, "participate", "toRole");
        if (partner1.indexOf(":") > 0) {
            partner1 = partner1.split(":")[1];
        }
        if (partner2.indexOf(":") > 0) {
            partner2 = partner2.split(":")[1];
        }
        fsp = this.buildExchangesFSP(constructNodeList, partner1, partner2, operation, String.valueOf(this.currProcessLabel) + compositionName);
        this.writeFSPOutput(fsp);
        return String.valueOf(this.currProcessLabel) + compositionName + "EXCHSEQ";
    }

    private String processANode(Node currentNode, boolean addAlphabet) {
        String currentNodeString = "";
        currentNode.getNodeName();
        if (currentNode.getNodeName().compareTo("choreography") == 0) {
            currentNodeString = this.buildChoreographyFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("sequence") == 0) {
            currentNodeString = this.buildSequenceFSP(currentNode, true, addAlphabet);
        }
        if (currentNode.getNodeName().compareTo("interaction") == 0) {
            currentNodeString = this.buildInteractionFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("choice") == 0) {
            currentNodeString = this.buildChoiceFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("parallel") == 0) {
            currentNodeString = this.buildParallelFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("perform") == 0) {
            currentNodeString = this.buildPerformFSP(currentNode);
        }
        return currentNodeString;
    }

    public boolean toFSP() {
        boolean result = false;
        this.writeHeader();
        this.buildPackage(this.currentdocnode);
        this.writeFooter();
        return result;
    }
}

