/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.ws;

import ic.doc.ltsa.ws.WSExchange;
import ic.doc.ltsa.ws.bpelaction;

public class WSInteraction {
    private String name;
    private String channelVariable;
    private String initiate;
    private String operation;
    private String description;
    private String relationshipType;
    private String fromRole;
    private String toRole;
    private WSExchange exchange;

    private void init_vars() {
        this.name = "";
        this.channelVariable = "";
        this.initiate = "";
        this.operation = "";
        this.description = "";
        this.exchange = new WSExchange();
    }

    public WSInteraction() {
        this.init_vars();
    }

    public WSInteraction(String interactionString) {
    }

    public WSInteraction(bpelaction bpa) {
        this.init_vars();
        this.fromString(bpa.toString());
        this.name = String.valueOf(bpa.getPartner1()) + bpa.getPartner2() + "Interaction";
        this.fromRole = String.valueOf(bpa.getPartner1()) + "Role";
        this.toRole = String.valueOf(bpa.getPartner2()) + "Role";
        this.exchange.setName(String.valueOf(bpa.getAction()) + "Exchange");
        if (bpa.getAction().equals("invoke") || bpa.getAction().equals("receive")) {
            this.exchange.setAction("request");
        } else {
            this.exchange.setAction("respond");
        }
        this.exchange.setInformationType(String.valueOf(bpa.getAction()) + "InformationType");
        this.exchange.setSendVariable(String.valueOf(bpa.getAction()) + "SendVariable");
        this.exchange.setReceiveVariable(String.valueOf(bpa.getAction()) + "ReceiveVariable");
        this.channelVariable = String.valueOf(this.exchange.getSendVariable()) + "CV";
    }

    public String getName() {
        return this.name;
    }

    public String getChannelVariable() {
        return this.channelVariable;
    }

    public String getInitiate() {
        return this.initiate;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getDescription() {
        return this.description;
    }

    public WSExchange getExchange() {
        return this.exchange;
    }

    public String getRelationshipType() {
        return this.fromRole;
    }

    public String getFromRole() {
        return this.fromRole;
    }

    public String getToRole() {
        return this.toRole;
    }

    public String toString() {
        return String.valueOf(this.name) + "_" + this.channelVariable + "_" + this.initiate + "_" + this.operation;
    }

    public String toWSCDL() {
        String WSCDL = "";
        WSCDL = String.valueOf(WSCDL) + "\t<interaction name=\"" + this.getName() + "\" channelVariable=\"" + this.getChannelVariable() + "\" operation=\"" + this.getOperation() + "\" initiate=\"" + this.getInitiate() + "\">\n";
        WSCDL = String.valueOf(WSCDL) + "\t<!-- operation = //roleType/behavior/@name-->\n";
        WSCDL = String.valueOf(WSCDL) + "\t<participate relationshipType=\"tns:" + this.getRelationshipType() + "\" fromRole=\"tns:" + this.getFromRole() + "\" toRole=\"tns:" + this.getToRole() + "\"/>\n";
        WSCDL = String.valueOf(WSCDL) + this.exchange.toWSCDL();
        WSCDL = String.valueOf(WSCDL) + "\t</interaction>\n";
        return WSCDL;
    }

    public void fromString(String actionString) {
        this.description = actionString;
        int start = 0;
        int end = actionString.indexOf("_");
        if (end > 0) {
            actionString.substring(start, end);
            start = end + 1;
            end = actionString.indexOf("_", start);
            if (end > 0) {
                this.fromRole = actionString.substring(start, end);
                start = end + 1;
                if ((end = actionString.indexOf("_", start)) > 0) {
                    this.toRole = actionString.substring(start, end);
                    start = end + 1;
                    if (end > 0) {
                        this.operation = actionString.substring(start);
                    }
                }
            }
        }
    }
}

