/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.editor.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.ltsaeclipsePlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.EditorActionBarContributor;

public class LTSAEditorActionBarContributor
extends EditorActionBarContributor
implements ISelectionChangedListener {
    MultiPageEditor editor;
    ArrayList actions = new ArrayList();
    Action compileAction;
    Action composeAction;
    Action parseAction;
    Action safetycheckAction;
    Action progresscheckAction;
    Action minimiseAction;
    Action translateAction;
    Action choreographAction;
    Action translateMapAction;
    Action tmpAction;
    private ResourceBundle resourceBundle;

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.translateAction);
        toolBarManager.add((IContributionItem)new GroupMarker("additions"));
        toolBarManager.add((IAction)this.translateMapAction);
        toolBarManager.add((IContributionItem)new GroupMarker("additions"));
        toolBarManager.add((IAction)this.choreographAction);
        toolBarManager.add((IContributionItem)new GroupMarker("additions"));
        toolBarManager.add((IContributionItem)new GroupMarker("additions"));
        toolBarManager.add((IContributionItem)new GroupMarker("additions"));
        Iterator actioniterator = this.actions.iterator();
        while (actioniterator.hasNext()) {
            Action action = (Action)actioniterator.next();
            toolBarManager.add((IAction)action);
            toolBarManager.add((IContributionItem)new GroupMarker("additions"));
        }
    }

    private ImageDescriptor getIconFromPlugin(String iconid) {
        String iconpath = "icons/" + iconid;
        return ltsaeclipsePlugin.imageDescriptorFromPlugin((String)"ltsaeclipse", (String)iconpath);
    }

    protected void createActions() {
        this.compileAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doCompile();
            }
        };
        this.compileAction.setText("&Compile");
        this.compileAction.setToolTipText("Compile FSP");
        this.compileAction.setImageDescriptor(this.getIconFromPlugin("compile.gif"));
        this.actions.add(this.compileAction);
        this.composeAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doCompose();
            }
        };
        this.composeAction.setText("&Compose");
        this.composeAction.setToolTipText("Compose FSP");
        this.composeAction.setImageDescriptor(this.getIconFromPlugin("compose.gif"));
        this.actions.add(this.composeAction);
        this.parseAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doParse(true);
            }
        };
        this.parseAction.setText("&Parse");
        this.parseAction.setToolTipText("Parse FSP");
        this.parseAction.setImageDescriptor(this.getIconFromPlugin("parse.gif"));
        this.actions.add(this.parseAction);
        this.safetycheckAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doAnalyse();
            }
        };
        this.safetycheckAction.setText("&Safety");
        this.safetycheckAction.setToolTipText("Perform Safety Check on FSP");
        this.safetycheckAction.setImageDescriptor(this.getIconFromPlugin("safety.gif"));
        this.actions.add(this.safetycheckAction);
        this.minimiseAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doMinimise();
            }
        };
        this.minimiseAction.setText("&Minimise");
        this.minimiseAction.setToolTipText("Minimise FSP");
        this.minimiseAction.setImageDescriptor(this.getIconFromPlugin("minimize.gif"));
        this.actions.add(this.minimiseAction);
        this.progresscheckAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doProgress();
            }
        };
        this.progresscheckAction.setText("&Progress");
        this.progresscheckAction.setToolTipText("Perform Progress Check on FSP");
        this.progresscheckAction.setImageDescriptor(this.getIconFromPlugin("progress.gif"));
        this.actions.add(this.progresscheckAction);
        this.translateAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doTranslate(true);
            }
        };
        this.translateAction.setText("&Translate");
        this.translateAction.setToolTipText("BPEL4WS to FSP");
        this.translateAction.setImageDescriptor(this.getIconFromPlugin("translate.gif"));
        this.tmpAction = new Action(){

            public void run() {
            }
        };
        this.tmpAction.setText("&TmpAction");
        this.tmpAction.setToolTipText("msc command");
        this.tmpAction.setImageDescriptor(this.getIconFromPlugin("translate.gif"));
        this.choreographAction = new Action(){

            public void run() {
            }
        };
        this.choreographAction.setText("&Choreograph");
        this.choreographAction.setToolTipText("Choreograph BPEL4WS to FSP");
        this.choreographAction.setImageDescriptor(this.getIconFromPlugin("choreograph.gif"));
        this.translateMapAction = new Action(){

            public void run() {
                LTSAEditorActionBarContributor.this.editor.doTranslateMap();
            }
        };
        this.translateMapAction.setText("&Translate with Mappings");
        this.translateMapAction.setToolTipText("Translate BPEL4WS and Specification");
        this.translateMapAction.setImageDescriptor(this.getIconFromPlugin("checked.gif"));
        this.enableLTSActions(false);
    }

    private void enableLTSActions(boolean enable) {
        Iterator actioniterator = this.actions.iterator();
        while (actioniterator.hasNext()) {
            Action action = (Action)actioniterator.next();
            action.setEnabled(enable);
        }
    }

    public void contributeToMenu(IMenuManager menuManager) {
        MenuManager buildmenu = new MenuManager("&Build");
        menuManager.prependToGroup("additions", (IContributionItem)buildmenu);
        buildmenu.add((IAction)this.parseAction);
        buildmenu.add((IContributionItem)new GroupMarker("additions"));
        buildmenu.add((IAction)this.compileAction);
        buildmenu.add((IContributionItem)new GroupMarker("additions"));
        buildmenu.add((IAction)this.composeAction);
        buildmenu.add((IContributionItem)new GroupMarker("additions"));
        buildmenu.add((IAction)this.minimiseAction);
        buildmenu.add((IContributionItem)new GroupMarker("additions"));
        buildmenu.add((IAction)this.translateAction);
        MenuManager checkmenu = new MenuManager("&Check");
        menuManager.prependToGroup("additions", (IContributionItem)checkmenu);
        checkmenu.add((IAction)this.safetycheckAction);
        checkmenu.add((IContributionItem)new GroupMarker("additions"));
        checkmenu.add((IAction)this.progresscheckAction);
        checkmenu.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (this.editor != null) {
            this.editor.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.editor = (MultiPageEditor)targetEditor;
        if (this.editor != null) {
            this.editor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        this.createActions();
        super.init(bars, page);
        bars.setGlobalActionHandler("delete", (IAction)this.compileAction);
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.editor.getLTS().length() > 0) {
            this.enableLTSActions(true);
        } else {
            this.enableLTSActions(false);
        }
    }

    private void showMessage(String message) {
        MessageDialog.openInformation(null, (String)((Object)((Object)this)).getClass().getName(), (String)message);
    }
}

