/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.editor.ui.actions;

import ic.doc.ltsa.ws.MscFSP2WSCDL;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import ltsaeclipse.FSPIStorage;
import ltsaeclipse.FSPIStorageEditorInput;
import mscedit.BMSC;
import mscedit.Instance;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;

public class MSC2CDLActionDelegate
extends ActionDelegate
implements IViewActionDelegate {
    IViewPart thisview;

    private IEditorInput createEditorInputFromString(String contents, String location) {
        FSPIStorage storage = new FSPIStorage(contents);
        FSPIStorageEditorInput input = new FSPIStorageEditorInput(storage);
        input.setFileType("CDL");
        input.setFilename(location);
        return input;
    }

    private IEditorInput createWSCDLEditorInput(IPath filepath, IPath projfilepath, String contents, String ext) {
        IFile workspaceFile = null;
        try {
            File test = new File(String.valueOf(filepath.toString()) + ext);
            test.createNewFile();
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            workspaceFile = myWorkspaceRoot.getFile(projfilepath.addFileExtension(ext));
            if (workspaceFile != null) {
                workspaceFile.delete(false, null);
                workspaceFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
            }
        }
        catch (Exception E) {
            this.showMessage("ERROR: " + E.getMessage());
            return null;
        }
        return null;
    }

    public void run(IAction action) {
        BMSC bMscelem = null;
        this.thisview.getTitle().equals("Navigator");
        IStructuredSelection selection = (IStructuredSelection)this.thisview.getSite().getPage().getSelection();
        IFile file = (IFile)selection.getFirstElement();
        ResourcesPlugin.getWorkspace().getRoot();
        MscFSP2WSCDL m2cdl = new MscFSP2WSCDL(file.getLocation().toString(), true);
        LinkedList<String> components = new LinkedList<String>();
        Iterator cit = m2cdl.getSpecification().getBMSCs().iterator();
        while (cit.hasNext()) {
            bMscelem = (BMSC)cit.next();
            Iterator instances = bMscelem.getInstances().iterator();
            while (instances.hasNext()) {
                Instance inst = (Instance)instances.next();
                if (components.contains(inst.getName())) continue;
                components.add(inst.getName());
            }
        }
        componentsDialog cd = new componentsDialog(this.thisview.getViewSite().getShell(), components);
        cd.open();
        if (cd.getReturnCode() == 0) {
            m2cdl.setInstanceFilter("");
            this.generateWSCDLFile(file, m2cdl, cd.getSelected());
        }
    }

    public void generateWSCDLFile(IFile file, MscFSP2WSCDL m2cdl, String filter) {
        String full_filename = "";
        try {
            String ext = "_" + filter + ".cdl";
            full_filename = file.getFullPath() + ext;
            this.createWSCDLEditorInput(file.getLocation(), file.getFullPath(), m2cdl.toWSCDL(), ext);
        }
        catch (Exception exception) {
            this.showMessage("Could not create WSCDL file " + full_filename + " from MSC.");
        }
    }

    public void init(IViewPart view) {
        this.thisview = view;
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.thisview.getViewSite().getShell(), (String)"MSC2WSCDL Action Delegate", (String)message);
    }

    public class componentsDialog
    extends Dialog {
        LinkedList componentList = new LinkedList();
        String valueSelected = "";
        List list = null;

        public componentsDialog(Shell parentShell, LinkedList list) {
            super(parentShell);
            this.componentList.add("All             ");
        }

        protected void okPressed() {
            this.valueSelected = this.list.getSelection()[0];
            super.okPressed();
        }

        public String getSelected() {
            return this.valueSelected;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.list = new List(composite, 2048);
            Iterator cit = this.componentList.iterator();
            while (cit.hasNext()) {
                this.list.add((String)cit.next());
            }
            new ListViewer(this.list);
            return composite;
        }
    }
}

