/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.editors;

import ltsaeclipse.editor.ui.actions.CompileAction;
import ltsaeclipse.editor.ui.actions.LTSAEditorActions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class MultiPageEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;
    private LTSAEditorActions sampleAction;

    public MultiPageEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler("delete", this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler("undo", this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler("redo", this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler("cut", this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler("copy", this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler("paste", this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler("selectAll", this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler("find", this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler("bookmark", this.getAction(editor, "bookmark"));
            actionBars.updateActionBars();
        }
    }

    private void createActions() {
        this.sampleAction = new CompileAction();
        this.sampleAction.setText("Compile");
        this.sampleAction.setToolTipText("Compile FSP");
        this.sampleAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("&Build");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.sampleAction);
        MenuManager submenu = new MenuManager("&Check");
        manager.appendToGroup("additions", (IContributionItem)submenu);
        submenu.add((IAction)this.sampleAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sampleAction);
    }
}

