/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.LTSAActionTable;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ExampleCellModifier
implements ICellModifier {
    private LTSAActionTable tableViewerExample;
    private String[] columnNames;
    private boolean isFirstColumnSelect = false;

    public ExampleCellModifier(LTSAActionTable tableViewerExample) {
        this.tableViewerExample = tableViewerExample;
    }

    public void setFirstColumnSelect(boolean isselect) {
        this.isFirstColumnSelect = isselect;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.tableViewerExample.getColumnNames().indexOf(property);
        Object result = null;
        ExampleTask task = (ExampleTask)element;
        switch (columnIndex) {
            case 0: {
                result = new Boolean(task.isCompleted());
                break;
            }
            case 1: {
                result = task.getDescription();
                break;
            }
            case 2: {
                String stringValue = task.getOwner();
                String[] choices = this.tableViewerExample.getChoices(property);
                int i = choices.length - 1;
                while (!stringValue.equals(choices[i]) && i > 0) {
                    --i;
                }
                result = new Integer(i);
                break;
            }
            case 3: {
                result = String.valueOf(task.getPercentComplete());
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.tableViewerExample.getColumnNames().indexOf(property);
        TableItem item = (TableItem)element;
        ExampleTask task = (ExampleTask)item.getData();
        switch (columnIndex) {
            case 0: {
                task.setCompleted((Boolean)value);
                break;
            }
            case 1: {
                String valueString = ((String)value).trim();
                task.setDescription(valueString);
                break;
            }
            case 2: {
                String valueString = this.tableViewerExample.getChoices(property)[(Integer)value].trim();
                if (task.getOwner().equals(valueString)) break;
                task.setOwner(valueString);
                break;
            }
            case 3: {
                String valueString = ((String)value).trim();
                if (valueString.length() == 0) {
                    valueString = "0";
                }
                task.setPercentComplete(Integer.parseInt(valueString));
            }
        }
        this.tableViewerExample.getTaskList().taskChanged(task);
    }
}

