/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import ic.doc.ltsa.lts.CompositeState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import ltsaeclipse.LTSAFunctions;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.ltsaeclipsePlugin;
import ltsaeclipse.views.LTSADrawView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LTSACompilerView
extends ViewPart
implements ISelectionListener {
    public TextViewer viewer;
    private Action action1;
    private Action MSCaction;
    private Action doubleClickAction;
    private Document doc;
    private LTSAFunctions LTSAfunctions;
    private ISelection lastselection;
    private MultiPageEditor mpe;
    private int outpos = 0;
    private int currline = 0;
    private int currpos = 0;

    private ImageDescriptor getIconFromPlugin(String iconid) {
        String iconpath = "icons/" + iconid;
        return ltsaeclipsePlugin.imageDescriptorFromPlugin((String)"ltsaeclipse", (String)iconpath);
    }

    public void setMPE(MultiPageEditor aMPE) {
        this.mpe = aMPE;
    }

    public void clearView() {
        if (this.viewer != null) {
            this.viewer.setDocument((IDocument)new Document(" "));
        }
    }

    public void addtoCompilerView(final String addstring) {
        Display display = this.viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                int offset = 0;
                IDocument doc = LTSACompilerView.this.viewer.getDocument();
                doc.getNumberOfLines();
                try {
                    offset = doc.getLength();
                    doc.replace(offset - 1, 0, addstring);
                    LTSACompilerView lTSACompilerView = LTSACompilerView.this;
                    lTSACompilerView.currline = lTSACompilerView.currline + 1;
                    LTSACompilerView.this.outpos = 0;
                }
                catch (Exception E) {
                    LTSACompilerView.this.viewer.setDocument((IDocument)new Document(E.getMessage()));
                }
            }
        });
    }

    public void addOutToCompilerView(final String addstring) {
        Display display = this.viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                String temp = addstring;
                int offset = 0;
                IDocument doc = LTSACompilerView.this.viewer.getDocument();
                doc.getNumberOfLines();
                try {
                    offset = doc.getLength();
                    doc.replace(--offset, 0, temp);
                    temp = LTSACompilerView.this.viewer.getDocument().get();
                }
                catch (Exception E) {
                    LTSACompilerView.this.viewer.setDocument((IDocument)new Document(E.getMessage()));
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.doc = new Document("nothing");
        this.viewer = new TextViewer(parent, 770);
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().toString());
        this.LTSAfunctions = new LTSAFunctions();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.selectionChanged(null, this.getSite().getPage().getSelection());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.viewer.setDocument((IDocument)new Document(" "));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.lastselection = sel;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LTSACompilerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.MSCaction);
    }

    public Hashtable getParsetable() {
        return this.LTSAfunctions.getParsetable();
    }

    public boolean doParse(MultiPageEditor mpe) {
        boolean parsed = false;
        this.SetStatusLine("Parsing... ");
        parsed = this.LTSAfunctions.doParse(this.doc.get());
        if (!parsed) {
            mpe.createMarkerProblem(this.LTSAfunctions.errorline, this.LTSAfunctions.errorpos, this.LTSAfunctions.error);
        }
        this.SetStatusLine("Parsed.");
        Hashtable cs = this.LTSAfunctions.getParsetable();
        if (cs == null) {
            return parsed;
        }
        Enumeration e = cs.keys();
        ArrayList forSort = new ArrayList();
        while (e.hasMoreElements()) {
            forSort.add(e.nextElement());
        }
        Collections.sort(forSort);
        Iterator i = forSort.iterator();
        while (i.hasNext()) {
            this.LTSAfunctions.result = String.valueOf(this.LTSAfunctions.result) + i.next().toString() + ",";
        }
        return parsed;
    }

    public void doCompose(CompositeState cs) {
        final CompositeState thisstate = cs;
        this.SetStatusLine("Composing FSP... ");
        this.viewer.setDocument((IDocument)new Document(" "));
        this.viewer.getControl().getDisplay();
        this.LTSAfunctions.setCompilerView(this);
        this.outpos = 0;
        this.currline = 1;
        Job job = new Job("Composing FSP"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LTSACompilerView.this.LTSAfunctions.doCompose(thisstate);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.addJobChangeListener((IJobChangeListener)new MyCompileJobListener(this));
        job.schedule();
    }

    public void doAnalyse(CompositeState cs) {
        this.SetStatusLine("Analysing... ");
        this.LTSAfunctions.doAnalyse(cs);
        this.SetStatusLine("Analysed.");
        Document docresult = new Document(this.LTSAfunctions.result);
        this.viewer.setDocument((IDocument)docresult);
        this.viewer.setSelectedRange(this.LTSAfunctions.result.length(), this.LTSAfunctions.result.length());
    }

    public void doProgress(CompositeState cs) {
        this.clearView();
        this.SetStatusLine("Performing Progress Check... ");
        this.LTSAfunctions.doProgress(cs);
        this.SetStatusLine("Progress Checked.");
    }

    public void doMinimise(CompositeState cs) {
        this.SetStatusLine("Minimising... ");
        this.LTSAfunctions.doMinimise(cs);
        this.SetStatusLine("Minimised.");
        Document docresult = new Document(this.LTSAfunctions.result);
        this.viewer.setDocument((IDocument)docresult);
        this.viewer.setSelectedRange(this.LTSAfunctions.result.length(), this.LTSAfunctions.result.length());
    }

    public CompositeState doCompile(MultiPageEditor parent, String name) {
        MultiPageEditor asMPE;
        final String asname = name;
        this.mpe = asMPE = parent;
        this.outpos = 0;
        this.currline = 1;
        this.SetStatusLine("Compiling FSP... ");
        this.viewer.setDocument((IDocument)new Document(" "));
        this.viewer.getControl().getDisplay();
        this.LTSAfunctions.setCompilerView(this);
        Job job = new Job("Compiling FSP for " + name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LTSACompilerView.this.LTSAfunctions.doCompile(LTSACompilerView.this.doc.get(), asname);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.addJobChangeListener((IJobChangeListener)new MyCompileJobListener(this));
        job.schedule();
        return this.LTSAfunctions.getCurrentState();
    }

    public void updateViews() {
        LTSADrawView drawv = (LTSADrawView)this.getSite().getPage().findView("ltsaeclipse.views.LTSADrawView");
        if (drawv != null) {
            try {
                drawv.CState = this.LTSAfunctions.getCurrentState();
                drawv.updateView("");
            }
            catch (Exception exception) {}
        }
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                LTSACompilerView.this.getFile(LTSACompilerView.this.lastselection);
                LTSACompilerView.this.doCompile(null, "Default");
            }
        };
        this.action1.setText("&Compile");
        this.action1.setToolTipText("Compile FSP");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.MSCaction = new Action(){

            public void run() {
                if (LTSACompilerView.this.mpe != null) {
                    LTSACompilerView.this.mpe.traceToMSC(LTSACompilerView.this.getdocString());
                }
            }
        };
        this.MSCaction.setToolTipText("Open MSC of Trace");
        this.MSCaction.setImageDescriptor(this.getIconFromPlugin("msc.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = LTSACompilerView.this.viewer.getSelection();
                ((IStructuredSelection)selection).getFirstElement();
            }
        };
    }

    private void hookDoubleClickAction() {
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void getFile(ISelection sel) {
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)sel;
        Object object = structured.getFirstElement();
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            this.doc.set(this.getText(file));
        }
    }

    public void setSource(String source) {
        this.doc.set(source);
    }

    protected String getText(IFile file) {
        try {
            InputStream in = file.getContents();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int read = in.read(buf);
            while (read > 0) {
                out.write(buf, 0, read);
                read = in.read(buf);
            }
            return out.toString();
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return "";
    }

    private void SetStatusLine(String msg) {
        IStatusLineManager slm;
        IActionBars actionbars = this.getViewSite().getActionBars();
        if (actionbars != null && (slm = actionbars.getStatusLineManager()) != null) {
            slm.setErrorMessage(msg);
        }
    }

    private String getdocString() {
        return this.viewer.getDocument().get();
    }

    public class MyCompileJobListener
    extends JobChangeAdapter {
        public LTSACompilerView compilerview;

        MyCompileJobListener(LTSACompilerView cv) {
            this.compilerview = cv;
        }

        public void done(IJobChangeEvent event) {
            Display display = this.compilerview.viewer.getControl().getDisplay();
            display.asyncExec(new Runnable(this){
                final /* synthetic */ MyCompileJobListener this$1;
                {
                    this.this$1 = myCompileJobListener;
                }

                public void run() {
                    if (LTSACompilerView.access$0((LTSACompilerView)MyCompileJobListener.access$0((MyCompileJobListener)this.this$1)).error.length() > 0) {
                        LTSACompilerView.access$1(this.this$1.compilerview).createMarkerProblem(LTSACompilerView.access$0((LTSACompilerView)MyCompileJobListener.access$0((MyCompileJobListener)this.this$1)).errorline, LTSACompilerView.access$0((LTSACompilerView)MyCompileJobListener.access$0((MyCompileJobListener)this.this$1)).errorpos, LTSACompilerView.access$0((LTSACompilerView)MyCompileJobListener.access$0((MyCompileJobListener)this.this$1)).error);
                    }
                    if (LTSACompilerView.access$1(this.this$1.compilerview) != null) {
                        LTSACompilerView.access$1(this.this$1.compilerview).setCurrentState(LTSACompilerView.access$0(MyCompileJobListener.access$0(this.this$1)).getCurrentState());
                        LTSACompilerView.access$1(this.this$1.compilerview).updateViews();
                    }
                }
            });
        }

        static /* synthetic */ LTSACompilerView access$0(MyCompileJobListener myCompileJobListener) {
            return myCompileJobListener.LTSACompilerView.this;
        }
    }
}

