/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.ws.bpel2fsp;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import ltsaeclipse.FSPIStorage;
import ltsaeclipse.FSPIStorageEditorInput;
import ltsaeclipse.LTSAFunctions;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.ltsaeclipsePlugin;
import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.ExampleTaskList;
import ltsaeclipse.views.LTSACompositionTable;
import ltsaeclipse.views.LTSADrawView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class LTSAWSCompatibilityView
extends ViewPart
implements ISelectionListener {
    public LTSACompositionTable compositiontable;
    public LTSACompositionTable viewer;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private Document doc;
    private LTSAFunctions LTSAfunctions;
    private ISelection lastselection;
    private MultiPageEditor mpe;
    private bpel2fsp bpeltranslator = new bpel2fsp();

    public void setMPE(MultiPageEditor aMPE) {
        this.mpe = aMPE;
    }

    public void doTranslateFile(String bpel4wsfile) {
        String bpelprocess = "";
        bpelprocess = this.getTextFromFilePath(bpel4wsfile);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.bpeltranslator.loadBPEL(bpelprocess, false);
            this.bpeltranslator.setFSPOutput(baos);
            this.bpeltranslator.setOutput(out);
            this.bpeltranslator.translateToFSP(false);
        }
        catch (Exception exception) {}
    }

    public void createPartControl(Composite parent) {
        this.doc = new Document("nothing");
        int[] nArray = new int[]{10, 150};
        new FillLayout();
        SashForm MappingSashForm = new SashForm(parent, 512);
        this.viewer = this.compositiontable = new LTSACompositionTable((Composite)MappingSashForm, null, "");
        int operations = 19;
        DropTarget target = new DropTarget(this.compositiontable.getControl(), operations);
        TextTransfer textTransfer = TextTransfer.getInstance();
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        types = new Transfer[]{fileTransfer, textTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                new LinkedList();
                String bpelfilename = "";
                String wsdlfilename = "";
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].endsWith(".bpel")) {
                            LTSAWSCompatibilityView.this.doTranslateFile(files[i]);
                            bpelfilename = files[i];
                        }
                        if (files[i].endsWith(".wsdl")) {
                            wsdlfilename = files[i];
                        }
                        ++i;
                    }
                    if (bpelfilename.length() > 0 && wsdlfilename.length() > 0) {
                        ExampleTask task = new ExampleTask(((LTSAWSCompatibilityView)LTSAWSCompatibilityView.this).bpeltranslator.strBPELProcessName, bpelfilename);
                        task.setColumn3(wsdlfilename);
                        LTSAWSCompatibilityView.this.compositiontable.getTaskList().addTask(task);
                    } else {
                        LTSAWSCompatibilityView.this.showMessage("Unable to locate .bpel or .wsdl pair in files selected.");
                    }
                }
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.selectionChanged(null, this.getSite().getPage().getSelection());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.lastselection = sel;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LTSAWSCompatibilityView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.compositiontable.getControl());
        this.compositiontable.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("Additions"));
        manager.add((IAction)this.action2);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    public Hashtable getParsetable() {
        return this.LTSAfunctions.getParsetable();
    }

    public boolean doParse(MultiPageEditor mpe) {
        boolean parsed = false;
        this.SetStatusLine("Parsing... ");
        parsed = this.LTSAfunctions.doParse(this.doc.get());
        if (!parsed) {
            mpe.createMarkerProblem(this.LTSAfunctions.errorline, this.LTSAfunctions.errorpos, this.LTSAfunctions.error);
        }
        this.SetStatusLine("Parsed.");
        Hashtable cs = this.LTSAfunctions.getParsetable();
        if (cs == null) {
            return parsed;
        }
        Enumeration e = cs.keys();
        ArrayList forSort = new ArrayList();
        while (e.hasMoreElements()) {
            forSort.add(e.nextElement());
        }
        Collections.sort(forSort);
        Iterator i = forSort.iterator();
        while (i.hasNext()) {
            this.LTSAfunctions.result = String.valueOf(this.LTSAfunctions.result) + i.next().toString() + ",";
        }
        return parsed;
    }

    public void doCompose(CompositeState cs) {
        this.SetStatusLine("Composing... ");
        try {
            this.LTSAfunctions.doCompose(cs);
        }
        catch (Exception exception) {}
        this.SetStatusLine("Composed ");
        new Document(this.LTSAfunctions.result);
    }

    public void doAnalyse(CompositeState cs) {
        this.SetStatusLine("Analysing... ");
        this.LTSAfunctions.doAnalyse(cs);
        this.SetStatusLine("Analysed.");
        new Document(this.LTSAfunctions.result);
    }

    public void doProgress(CompositeState cs) {
        this.SetStatusLine("Performing Progress Check... ");
        this.LTSAfunctions.doProgress(cs);
        this.SetStatusLine("Progress Checked.");
        new Document(this.LTSAfunctions.result);
    }

    public void doMinimise(CompositeState cs) {
        this.SetStatusLine("Minimising... ");
        this.LTSAfunctions.doMinimise(cs);
        this.SetStatusLine("Minimised.");
        new Document(this.LTSAfunctions.result);
    }

    public CompositeState doCompile(MultiPageEditor parent, String name) {
        final String asname = name;
        final MultiPageEditor asMPE = parent;
        this.SetStatusLine("Compiling... " + name);
        new Document("Compiling: " + asname);
        Display display = this.viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    if (!LTSAWSCompatibilityView.this.LTSAfunctions.doCompile(LTSAWSCompatibilityView.this.doc.get(), asname)) {
                        asMPE.createMarkerProblem(((LTSAWSCompatibilityView)LTSAWSCompatibilityView.this).LTSAfunctions.errorline, ((LTSAWSCompatibilityView)LTSAWSCompatibilityView.this).LTSAfunctions.errorpos, ((LTSAWSCompatibilityView)LTSAWSCompatibilityView.this).LTSAfunctions.error);
                    }
                }
                catch (CoreException coreException) {}
                LTSAWSCompatibilityView.this.SetStatusLine("Compiled " + asname);
                if (asMPE != null) {
                    asMPE.setCurrentState(LTSAWSCompatibilityView.this.LTSAfunctions.getCurrentState());
                    LTSAWSCompatibilityView.this.updateDraw();
                }
            }
        });
        return this.LTSAfunctions.getCurrentState();
    }

    public void updateDraw() {
        LTSADrawView drawv = (LTSADrawView)this.getSite().getPage().findView("ltsaeclipse.views.LTSADrawView");
        if (drawv != null) {
            try {
                drawv.CState = this.LTSAfunctions.getCurrentState();
                drawv.updateView("");
            }
            catch (Exception exception) {}
        }
    }

    private void doBuildChoreographyModel() {
        HashMap<String, String> wsdlList = new HashMap<String, String>();
        HashMap<String, String> processList = new HashMap<String, String>();
        String srctext = "";
        ExampleTaskList tasklist = this.compositiontable.getTaskList();
        Iterator i = tasklist.getTasks().iterator();
        while (i.hasNext()) {
            ExampleTask task = (ExampleTask)i.next();
            srctext = this.getTextFromFilePath(task.getOwner());
            processList.put(task.getDescription(), srctext);
            srctext = this.getTextFromFilePath(task.getColumn3());
            wsdlList.put(task.getDescription(), srctext);
        }
        srctext = this.bpeltranslator.buildChoreographyModel(processList, wsdlList);
        try {
            this.getSite().getPage().openEditor(this.createEditorInputFromString(srctext), "ltsaeclipse.editors.MultiPageEditor");
        }
        catch (Exception exception) {
            this.showMessage("Could not create editor for choreography model.");
        }
    }

    private ImageDescriptor getIconFromPlugin(String iconid) {
        String iconpath = "icons/" + iconid;
        return ltsaeclipsePlugin.imageDescriptorFromPlugin((String)"ltsaeclipse", (String)iconpath);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                LTSAWSCompatibilityView.this.doBuildChoreographyModel();
            }
        };
        this.action1.setText("&Translate");
        this.action1.setToolTipText("Choreograph BPEL4WS to FSP");
        this.action1.setImageDescriptor(this.getIconFromPlugin("choreograph.gif"));
        this.action2 = new Action(){

            public void run() {
                LTSAWSCompatibilityView.this.compositiontable.getTaskList().clearTasks();
                LTSAWSCompatibilityView.this.compositiontable.updateRelabelList();
            }
        };
        this.action2.setText("&Clear");
        this.action2.setToolTipText("Clear List");
        this.action2.setImageDescriptor(this.getIconFromPlugin("choreograph.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = LTSAWSCompatibilityView.this.viewer.getSelection();
                ((IStructuredSelection)selection).getFirstElement();
                ExampleTask task = (ExampleTask)LTSAWSCompatibilityView.this.compositiontable.getViewer().getElementAt(0);
                Path newpath = new Path(task.getOwner());
                IEditorInput newinput = LTSAWSCompatibilityView.this.createEditorInput((IPath)newpath, "c:\\test.lts");
                try {
                    LTSAWSCompatibilityView.this.getSite().getPage().openEditor(newinput, "ltsaeclipse.editors.MultiPageEditor");
                }
                catch (Exception exception) {
                    LTSAWSCompatibilityView.this.showMessage("Could not create editor for " + newpath.toString());
                }
            }
        };
    }

    private IEditorInput createEditorInputFromString(String contents) {
        FSPIStorage storage = new FSPIStorage(contents);
        FSPIStorageEditorInput input = new FSPIStorageEditorInput(storage);
        return input;
    }

    private IEditorInput createEditorInput(IPath path, String filename) {
        IFile workspaceFile = null;
        try {
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            workspaceFile = myWorkspaceRoot.getFileForLocation(path);
            if (workspaceFile != null) {
                return new FileEditorInput(workspaceFile);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private void hookDoubleClickAction() {
        this.compositiontable.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LTSAWSCompatibilityView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)this.getTitle(), (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void getFile(ISelection sel) {
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)sel;
        Object object = structured.getFirstElement();
        if (object instanceof IFile) {
            IFile cfr_ignored_0 = (IFile)object;
        }
    }

    public void setSource(String source) {
        this.doc.set(source);
    }

    protected String getTextFromFilePath(String filepath) {
        try {
            File bpelfile = new File(filepath);
            return this.getText(bpelfile);
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected String getText(File file) {
        String contents = "";
        String line = "";
        try {
            BufferedReader read = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            line = read.readLine();
            while (line != null) {
                contents = String.valueOf(contents) + line + "\n";
                line = read.readLine();
            }
            read.close();
        }
        catch (Exception exception) {
            return "";
        }
        return contents;
    }

    private void SetStatusLine(String msg) {
        IStatusLineManager slm;
        IActionBars actionbars = this.getViewSite().getActionBars();
        if (actionbars != null && (slm = actionbars.getStatusLineManager()) != null) {
            slm.setErrorMessage(msg);
        }
    }
}

