/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import java.util.LinkedList;
import ltsaeclipse.editors.MultiPageEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MappingLTSView {
    private TableViewer viewer;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private SashForm thisparentView;
    private ViewContentProvider content;
    private MultiPageEditor mpe;
    Composite parent;

    public Control getControl() {
        return this.parent;
    }

    public MappingLTSView(Composite parentComp, MultiPageEditor aMPE) {
        this.parent = parentComp;
        this.addChildControls(parentComp);
        this.mpe = aMPE;
    }

    private void addChildControls(Composite composite) {
        this.content = new ViewContentProvider();
        this.content.addfile("...drag and drop specification file here to use for mapping source actions.");
        this.content.addfile("[no specification currently assigned]");
        this.viewer = new TableViewer(this.parent, 770);
        this.viewer.setContentProvider((IContentProvider)this.content);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.parent);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void addMappingLTSFile(String filepath) {
        this.content.removeAll();
        this.content.addfile(filepath);
        this.viewer.refresh();
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MappingLTSView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                if (MappingLTSView.this.mpe != null) {
                    MappingLTSView.this.mpe.doTranslateMap();
                }
            }
        };
        this.action1.setText("Verification");
        this.action1.setToolTipText("Compose specification and source");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                MappingLTSView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Clear Mappings");
        this.action2.setToolTipText("Clear all mappings");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = MappingLTSView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                MappingLTSView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MappingLTSView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"MappingLTSView", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        public LinkedList filelist = new LinkedList();

        public void addfile(String filepath) {
            this.filelist.add(filepath);
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public void removeAll() {
            this.filelist.clear();
        }

        public Object[] getElements(Object parent) {
            return this.filelist.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

