/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mscedit.BMSCComponent;
import mscedit.Divider;
import mscedit.Input;
import mscedit.InputOrOutput;
import mscedit.Instance;
import mscedit.Link;
import mscedit.Output;
import mscedit.Visitor;
import org.jdom.Element;

public class BMSC {
    private Element o_root;

    public BMSC() {
    }

    public BMSC(String p_name) {
        this.o_root = new Element("bmsc").setAttribute("name", p_name);
    }

    public BMSC(Element p_root) {
        this.o_root = p_root;
    }

    public BMSC addInstance(String p_instance) {
        this.o_root.addContent(new Element("instance").setAttribute("name", p_instance));
        return this;
    }

    public Element getXML() {
        return this.o_root;
    }

    public List getInstances() {
        List x_elems = this.o_root.getChildren("instance");
        ArrayList<Instance> x_instances = new ArrayList<Instance>();
        Iterator i = x_elems.iterator();
        while (i.hasNext()) {
            x_instances.add(new Instance((Element)i.next()));
        }
        return x_instances;
    }

    public List getLinks() {
        List x_instances = this.getInstances();
        Vector x_outputs = new Vector();
        Vector x_inputs = new Vector();
        Vector<Link> x_links = new Vector<Link>();
        Iterator i = x_instances.iterator();
        while (i.hasNext()) {
            Instance x_inst = (Instance)i.next();
            x_outputs.addAll(x_inst.getOutputs());
            x_inputs.addAll(x_inst.getInputs());
        }
        i = x_outputs.iterator();
        while (i.hasNext()) {
            Output x_output = (Output)i.next();
            String x_out_id = x_output.getId();
            Iterator j = x_inputs.iterator();
            while (j.hasNext()) {
                Input x_input = (Input)j.next();
                String x_in_id = x_input.getId();
                if (!x_out_id.equals(x_in_id)) continue;
                Link x_link = new Link(x_input.getFrom(), x_output.getTo(), x_output.getName(), x_input.getTimeIndex());
                if (x_input.isNegative()) {
                    x_link.setNegative();
                }
                x_links.add(x_link);
            }
        }
        return x_links;
    }

    public List getDividers() {
        List x_elems = this.o_root.getChildren("divider");
        ArrayList<Divider> x_dividers = new ArrayList<Divider>();
        Iterator i = x_elems.iterator();
        while (i.hasNext()) {
            x_dividers.add(new Divider((Element)i.next()));
        }
        return x_dividers;
    }

    public BMSC addLink(Link p_link) {
        this.addLink(p_link.getFrom(), p_link.getTo(), p_link.getName(), p_link.getTimeIndex());
        this.sortChronologically();
        return this;
    }

    public BMSC addLink(String p_from, String p_to, String p_name, int p_timeindex) {
        this.addOutput(p_from, p_to, p_name, p_timeindex, false);
        this.addInput(p_from, p_to, p_name, p_timeindex, false);
        return this;
    }

    public BMSC addNegativeLink(String p_from, String p_to, String p_name, int p_timeindex) {
        this.addOutput(p_from, p_to, p_name, p_timeindex, true);
        this.addInput(p_from, p_to, p_name, p_timeindex, true);
        this.setNegativeLink(p_name);
        return this;
    }

    public BMSC addDivider(int p_timeindex) {
        this.o_root.addContent(new Element("divider").setAttribute("timeindex", String.valueOf(p_timeindex)));
        return this;
    }

    public BMSC deleteLink(String p_id) {
        this.deleteInput(p_id);
        this.deleteOutput(p_id);
        return this;
    }

    public BMSC setNegativeLink(String p_name) {
        this.o_root.setAttribute("negative", p_name);
        return this;
    }

    public BMSC unsetNegativeLink() {
        this.o_root.removeAttribute("negative");
        return this;
    }

    public String getNegativeLink() {
        String x_name = this.o_root.getAttribute("negative").getValue();
        if (x_name != null && !x_name.equals("")) {
            return x_name;
        }
        return null;
    }

    public boolean isNegative() {
        String x_neg;
        return this.o_root.getAttribute("negative") != null && (x_neg = this.o_root.getAttribute("negative").getValue()) != null && !x_neg.equals("");
    }

    public String getName() {
        return this.o_root.getAttribute("name").getValue();
    }

    public void setName(String p_name) {
        this.o_root.setAttribute("name", p_name);
    }

    public Element asXML() {
        return this.o_root;
    }

    public void apply(Visitor v) {
        if (this.isNegative()) {
            v.caseANegativeBMSC(this);
        } else {
            v.caseABMSC(this);
        }
    }

    private BMSC addOutput(String p_from, String p_to, String p_name, int p_timeindex, boolean p_neg) {
        List x_instances = this.getInstances();
        Instance x_from = null;
        Iterator i = x_instances.iterator();
        while (i.hasNext()) {
            x_from = (Instance)i.next();
            if (x_from.getName().equals(p_from)) break;
        }
        Element x_output = new Element("output");
        x_output.setAttribute("timeindex", String.valueOf(p_timeindex));
        if (p_neg) {
            x_output.setAttribute("negative", "true");
        }
        x_output.addContent(new Element("name").setText(p_name));
        x_output.addContent(new Element("to").setText(p_to));
        x_from.add(x_output);
        return this;
    }

    private BMSC addInput(String p_from, String p_to, String p_name, int p_timeindex, boolean p_neg) {
        List x_instances = this.getInstances();
        Instance x_to = null;
        Iterator i = x_instances.iterator();
        while (i.hasNext()) {
            x_to = (Instance)i.next();
            if (x_to.getName().equals(p_to)) break;
        }
        Element x_input = new Element("input");
        x_input.setAttribute("timeindex", String.valueOf(p_timeindex));
        if (p_neg) {
            x_input.setAttribute("negative", "true");
        }
        x_input.addContent(new Element("name").setText(p_name));
        x_input.addContent(new Element("from").setText(p_from));
        x_to.add(x_input);
        return this;
    }

    private void deleteInput(String p_id) {
        this.delete("input", p_id);
    }

    private void deleteOutput(String p_id) {
        this.delete("output", p_id);
    }

    private void delete(String p_in_or_out, String p_id) {
        List x_instances = this.getInstances();
        Iterator i = x_instances.iterator();
        while (i.hasNext()) {
            Instance x_inst = (Instance)i.next();
            List x_children = p_in_or_out.equals("output") ? x_inst.getOutputs() : x_inst.getInputs();
            Iterator j = x_children.iterator();
            while (j.hasNext()) {
                InputOrOutput x_child = (InputOrOutput)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_inst.remove(x_child);
                return;
            }
        }
    }

    public void changeLinkName(String p_id, String p_to) {
        List x_instances = this.getInstances();
        Iterator i = x_instances.iterator();
        block0: while (i.hasNext()) {
            InputOrOutput x_child;
            Instance x_inst = (Instance)i.next();
            List x_children = x_inst.getInputs();
            Iterator j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Input)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_child.setName(p_to);
                break;
            }
            x_children = x_inst.getOutputs();
            j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Output)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_child.setName(p_to);
                continue block0;
            }
        }
    }

    public void moveDivider(int p_old_ti, int p_new_ti) {
        List x_dividers = this.getDividers();
        Iterator i = x_dividers.iterator();
        while (i.hasNext()) {
            Divider x_div = (Divider)i.next();
            if (x_div.getTimeIndex() != p_old_ti) continue;
            x_div.setTimeIndex(p_new_ti);
            break;
        }
    }

    public void deleteDivider(int p_timeindex) {
        List x_dividers = this.o_root.getChildren("divider");
        Iterator i = x_dividers.iterator();
        while (i.hasNext()) {
            Element x_div = (Element)i.next();
            if (Integer.parseInt(x_div.getAttribute("timeindex").getValue()) != p_timeindex) continue;
            i.remove();
            break;
        }
    }

    public void deleteInstance(String p_name) {
        List x_instances = this.o_root.getChildren("instance");
        Iterator i = x_instances.iterator();
        while (i.hasNext()) {
            Instance x_inst = new Instance((Element)i.next());
            List x_ins = x_inst.getInputs();
            Iterator j = x_ins.iterator();
            while (j.hasNext()) {
                Input x_i = (Input)j.next();
                if (x_i.getFrom() == null || !p_name.equals(x_i.getFrom())) continue;
                j.remove();
            }
            List x_outs = x_inst.getOutputs();
            Iterator j2 = x_outs.iterator();
            while (j2.hasNext()) {
                Output x_o = (Output)j2.next();
                if (x_o.getTo() == null || !p_name.equals(x_o.getTo())) continue;
                j2.remove();
            }
            if (!x_inst.getName().equals(p_name)) continue;
            i.remove();
        }
    }

    public void changeTimeIndex(String p_id, int p_timeindex) {
        List x_instances = this.getInstances();
        Iterator i = x_instances.iterator();
        block0: while (i.hasNext()) {
            InputOrOutput x_child;
            Instance x_inst = (Instance)i.next();
            List x_children = x_inst.getInputs();
            Iterator j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Input)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_child.setTimeIndex(p_timeindex);
                break;
            }
            x_children = x_inst.getOutputs();
            j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Output)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_child.setTimeIndex(p_timeindex);
                continue block0;
            }
        }
    }

    public void reverseLink(String p_id) {
        String x_from = "";
        String x_to = "";
        String x_name = "";
        int x_time = 0;
        List x_instances = this.getInstances();
        Iterator i = x_instances.iterator();
        block0: while (i.hasNext()) {
            Instance x_inst = (Instance)i.next();
            List x_children = x_inst.getOutputs();
            Iterator j = x_children.iterator();
            while (j.hasNext()) {
                Output x_child = (Output)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                x_name = x_child.getName();
                x_from = x_inst.getName();
                x_to = x_child.getTo();
                x_time = x_child.getTimeIndex();
                continue block0;
            }
        }
        this.deleteLink(p_id);
        this.addLink(x_to, x_from, x_name, x_time);
    }

    public void negateLastMessage() {
        List x_links = this.getLinks();
        if (x_links.size() < 1) {
            return;
        }
        Link x_last_link = (Link)x_links.get(0);
        Iterator i = x_links.iterator();
        while (i.hasNext()) {
            Link x_link = (Link)i.next();
            if (x_link.getTimeIndex() <= x_last_link.getTimeIndex()) continue;
            x_last_link = x_link;
        }
        this.negateLink(x_last_link.getId());
        this.changeTimeIndex(x_last_link.getId(), x_last_link.getTimeIndex() + 1);
        this.addDivider(x_last_link.getTimeIndex());
    }

    public void negateLink(String p_id) {
        List x_instances = this.getInstances();
        String x_name = "";
        Iterator i = x_instances.iterator();
        block0: while (i.hasNext()) {
            InputOrOutput x_child;
            Instance x_inst = (Instance)i.next();
            List x_children = x_inst.getInputs();
            Iterator j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Input)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                if (x_child.isNegative()) {
                    x_child.setNegative(false);
                    break;
                }
                x_child.setNegative(true);
                x_name = x_child.getName();
                break;
            }
            x_children = x_inst.getOutputs();
            j = x_children.iterator();
            while (j.hasNext()) {
                x_child = (Output)j.next();
                if (!x_child.getId().equals(p_id)) continue;
                if (x_child.isNegative()) {
                    x_child.setNegative(false);
                    continue block0;
                }
                x_child.setNegative(true);
                continue block0;
            }
        }
        if (!this.isNegative()) {
            this.setNegativeLink(x_name);
        } else {
            this.unsetNegativeLink();
        }
    }

    public void tidy() {
        List x_components = this.getLinks();
        x_components.addAll(this.getDividers());
        int x_high = this.getHighestTimeIndex(x_components);
        int x_current = 0;
        int i = 0;
        while (i <= x_high) {
            boolean x_set = false;
            Iterator j = x_components.iterator();
            while (j.hasNext()) {
                BMSCComponent x_comp = (BMSCComponent)j.next();
                if (x_comp.getTimeIndex() != i || i <= x_current) continue;
                if (x_comp instanceof Link) {
                    this.changeTimeIndex(((Link)x_comp).getId(), x_current + 1);
                } else {
                    x_comp.setTimeIndex(x_current + 1);
                }
                x_set = true;
            }
            if (x_set) {
                ++x_current;
            }
            ++i;
        }
    }

    public int getLastTimeIndex() {
        return this.getHighestTimeIndex(this.getLinks());
    }

    private int getHighestTimeIndex(List p_links) {
        int x_hi = 0;
        Iterator i = p_links.iterator();
        while (i.hasNext()) {
            int x_temp = ((BMSCComponent)i.next()).getTimeIndex();
            if (x_temp <= x_hi) continue;
            x_hi = x_temp;
        }
        return x_hi;
    }

    private void sortChronologically() {
        List x_instances = this.getInstances();
        Iterator i = x_instances.iterator();
        while (i.hasNext()) {
            Collections.sort(((Instance)i.next()).getInputsAndOutputs(), new Comparator(){

                public int compare(Object p_a, Object p_b) {
                    int x_time_b;
                    int x_time_a = ((InputOrOutput)p_a).getTimeIndex();
                    if (x_time_a > (x_time_b = ((InputOrOutput)p_b).getTimeIndex())) {
                        return 1;
                    }
                    if (x_time_a < x_time_b) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
    }

    public BMSC duplicate() {
        return new BMSC((Element)this.o_root.clone());
    }
}

