/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import mscedit.BMSC;
import mscedit.Divider;
import mscedit.DividerGraphic;
import mscedit.EditorCanvas;
import mscedit.Glyph;
import mscedit.Instance;
import mscedit.InstanceGraphic;
import mscedit.Link;
import mscedit.MessageGraphic;
import mscedit.NegativeMessageGraphic;
import mscedit.SelfTransitionGraphic;
import mscedit.XMLGui;

class BMSCEditorCanvas
extends EditorCanvas {
    private BMSC o_msc;
    private Vector o_instance_glyphs;
    private Vector o_message_glyphs;
    private Vector o_divider_glyphs;

    public BMSCEditorCanvas() {
    }

    public BMSCEditorCanvas(XMLGui p_gui, String p_name) {
        this.o_msc = new BMSC(p_name);
        this.o_gui = p_gui;
        this.rebuild();
        this.setBackground(Color.white);
    }

    public BMSCEditorCanvas(XMLGui p_gui, BMSC p_msc) {
        this.o_msc = p_msc;
        this.o_gui = p_gui;
        this.rebuild();
    }

    public Dimension getPreferredSize() {
        double x_scale = Glyph.getScale();
        return new Dimension((int)((double)(this.o_instance_glyphs.size() * 100) * x_scale), (int)((double)(this.o_msc.getLastTimeIndex() * 25 + 150) * x_scale));
    }

    public BMSC getBMSC() {
        return this.o_msc;
    }

    public void rebuild() {
        this.o_instance_glyphs = new Vector();
        this.o_message_glyphs = new Vector();
        this.o_divider_glyphs = new Vector();
        if (this.o_msc != null) {
            List x_dividers;
            List x_links;
            List x_insts = this.o_msc.getInstances();
            if (x_insts != null) {
                int i = 0;
                while (i < x_insts.size()) {
                    this.o_instance_glyphs.add(new InstanceGraphic(((Instance)x_insts.get(i)).getName(), i, this.o_msc.getLastTimeIndex()));
                    ++i;
                }
            }
            if ((x_links = this.o_msc.getLinks()) != null) {
                Iterator i = x_links.iterator();
                while (i.hasNext()) {
                    Link x_link = (Link)i.next();
                    if (x_link.isSelfTransition()) {
                        this.o_message_glyphs.add(new SelfTransitionGraphic(x_link.getName(), this.locate(x_link.getFrom()), this.locate(x_link.getTo()), x_link.getTimeIndex()));
                        continue;
                    }
                    if (x_link.isNegative()) {
                        this.o_message_glyphs.add(new NegativeMessageGraphic(x_link.getName(), this.locate(x_link.getFrom()), this.locate(x_link.getTo()), x_link.getTimeIndex()));
                        continue;
                    }
                    this.o_message_glyphs.add(new MessageGraphic(x_link.getName(), this.locate(x_link.getFrom()), this.locate(x_link.getTo()), x_link.getTimeIndex()));
                }
            }
            if ((x_dividers = this.o_msc.getDividers()) != null) {
                Iterator i = x_dividers.iterator();
                while (i.hasNext()) {
                    this.o_divider_glyphs.add(new DividerGraphic(((Divider)i.next()).getTimeIndex(), this.o_msc.getInstances().size()));
                }
            }
        }
        this.repaint();
    }

    void addInstance(String p_name) {
        this.o_msc.addInstance(p_name);
    }

    void addLink(String p_from, String p_to, int p_timeindex) {
        this.o_gui.addLink(p_from, p_to, (p_timeindex - 50) / 25);
    }

    void addNegativeLink(String p_from, String p_to, int p_timeindex) {
        this.o_gui.addNegativeLink(p_from, p_to, (p_timeindex - 50) / 25);
    }

    void addDivider(int p_timeindex) {
        this.o_msc.addDivider((p_timeindex - 50) / 25);
        this.o_gui.setAddDividerMode(false);
        this.setCursor(new Cursor(0));
        this.rebuild();
    }

    void moveMessage(String p_id, int p_timeindex) {
        this.o_msc.changeTimeIndex(p_id, p_timeindex);
    }

    void moveDivider(int p_oldtimeindex, int p_newtimeindex) {
        this.o_msc.moveDivider(p_oldtimeindex, p_newtimeindex);
    }

    void addLink(String p_from, String p_to, String p_name, int p_timeindex) {
        String x_name;
        if (p_name.startsWith("@@")) {
            x_name = p_name.substring(2, p_name.length());
        } else {
            String x_from_inst = p_from.indexOf(":") < 0 ? p_from.toLowerCase() : p_from.substring(0, p_from.indexOf(":"));
            String x_to_inst = p_to.indexOf(":") < 0 ? p_to.toLowerCase() : p_to.substring(0, p_to.indexOf(":"));
            x_name = String.valueOf(x_from_inst) + "," + x_to_inst + "," + p_name;
        }
        this.o_msc.addLink(p_from, p_to, x_name, p_timeindex);
        this.o_gui.addMessageToAlphabet(x_name);
    }

    void addNegativeLink(String p_from, String p_to, String p_name, int p_timeindex) {
        this.o_msc.addNegativeLink(p_from, p_to, p_name, p_timeindex);
    }

    void delete() {
        if (this.o_selected == null) {
            int x_sure = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this bMSC?", "Delete bMSC?", 0);
            if (x_sure == 0) {
                this.o_gui.deleteBMSC(this.o_msc.getName());
            }
            this.rebuild();
            return;
        }
        if (this.o_selected instanceof MessageGraphic) {
            String x_name = this.getSelectionName();
            this.o_msc.deleteLink(this.getSelectionId());
            List x_links = this.o_msc.getLinks();
            boolean x_found = false;
            Iterator i = x_links.iterator();
            while (i.hasNext()) {
                x_found |= ((Link)i.next()).getName().equals(x_name);
            }
            if (!x_found) {
                this.o_gui.removeFromMsgAlphabet(x_name);
            }
        } else if (this.o_selected instanceof DividerGraphic) {
            this.o_msc.deleteDivider(Integer.parseInt(this.o_selected.getId()));
        } else if (this.o_selected instanceof InstanceGraphic) {
            this.o_msc.deleteInstance(this.getSelectionId());
        }
    }

    void changeLinkName(String p_from, String p_to) {
        this.o_msc.changeLinkName(p_from, p_to);
    }

    void reverseSelectedLink() {
        this.o_msc.reverseLink(this.getSelectionId());
    }

    void negateSelectedLink() {
        this.o_msc.negateLink(this.getSelectionId());
    }

    void tidy() {
        this.o_msc.tidy();
    }

    boolean inAddLinkMode() {
        return this.o_gui.inAddLinkMode();
    }

    boolean inAddDividerMode() {
        return this.o_gui.inAddDividerMode();
    }

    boolean addPositive() {
        return this.o_gui.addPositive();
    }

    String getInstanceAt(int p_x, int p_y) {
        Iterator i = this.o_instance_glyphs.iterator();
        while (i.hasNext()) {
            InstanceGraphic x_inst_gr = (InstanceGraphic)i.next();
            if (!x_inst_gr.contains(p_x, p_y)) continue;
            return x_inst_gr.getName();
        }
        return null;
    }

    Glyph getMessageAt(int p_x, int p_y) {
        Iterator i = this.o_message_glyphs.iterator();
        while (i.hasNext()) {
            MessageGraphic x_mess_gr = (MessageGraphic)i.next();
            if (!x_mess_gr.contains(p_x, p_y)) continue;
            return x_mess_gr;
        }
        i = this.o_divider_glyphs.iterator();
        while (i.hasNext()) {
            DividerGraphic x_div_gr = (DividerGraphic)i.next();
            if (!x_div_gr.contains(p_x, p_y)) continue;
            return x_div_gr;
        }
        i = this.o_instance_glyphs.iterator();
        while (i.hasNext()) {
            InstanceGraphic x_inst_gr = (InstanceGraphic)i.next();
            if (!x_inst_gr.contains(p_x, p_y)) continue;
            return x_inst_gr;
        }
        return null;
    }

    private int locate(String p_name) {
        int i = 0;
        while (i < this.o_instance_glyphs.size()) {
            if (((InstanceGraphic)this.o_instance_glyphs.get(i)).getName().equals(p_name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void fileDraw(Graphics g) {
        this.paintComponent(g);
    }

    public void paintComponent(Graphics g) {
        Glyph x_glyph;
        Graphics2D x_g2d = (Graphics2D)g;
        x_g2d.setColor(Color.white);
        x_g2d.fillRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        x_g2d.setColor(Color.black);
        Iterator i = this.o_instance_glyphs.iterator();
        while (i.hasNext()) {
            x_glyph = (Glyph)i.next();
            if (x_glyph == this.o_selected) {
                g.setColor(Color.red);
                x_glyph.draw(g);
                g.setColor(Color.black);
                continue;
            }
            x_glyph.draw(g);
        }
        i = this.o_message_glyphs.iterator();
        while (i.hasNext()) {
            x_glyph = (Glyph)i.next();
            if (x_glyph == this.o_selected) {
                g.setColor(Color.red);
                x_glyph.draw(g);
                g.setColor(Color.black);
                continue;
            }
            x_glyph.draw(g);
        }
        i = this.o_divider_glyphs.iterator();
        while (i.hasNext()) {
            x_glyph = (Glyph)i.next();
            if (x_glyph == this.o_selected) {
                g.setColor(Color.red);
                x_glyph.draw(g);
                g.setColor(Color.black);
                continue;
            }
            x_glyph.draw(g);
        }
    }
}

