/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import mscedit.BMSCGraphic;
import mscedit.Glyph;
import mscedit.HMSCEditorCanvas;

class HMSCCanvasMouseListener
extends MouseInputAdapter {
    private HMSCEditorCanvas o_canvas;
    private int o_clicks = 0;
    private BMSCGraphic o_moving;

    public HMSCCanvasMouseListener(HMSCEditorCanvas p_canvas) {
        this.o_canvas = p_canvas;
        this.o_moving = null;
    }

    public void mouseClicked(MouseEvent p_me) {
        String x_bmsc_name;
        if (p_me.getButton() == 1) {
            if (this.o_canvas.inAddLinkMode()) {
                x_bmsc_name = this.o_canvas.getBMSCAt(p_me.getX(), p_me.getY());
                if (x_bmsc_name == null) {
                    return;
                }
                if (this.o_clicks == 0) {
                    this.o_canvas.setOldSelection(x_bmsc_name);
                    this.o_canvas.setSelection(this.o_canvas.getBMSCGraphicAt(p_me.getX(), p_me.getY()));
                } else {
                    this.o_canvas.addTransition(this.o_canvas.getOldSelection(), x_bmsc_name);
                    this.o_canvas.setAddLinkMode(false);
                }
                this.o_clicks = 1 - this.o_clicks;
            } else if (this.o_canvas.getTransitionAt(p_me.getX(), p_me.getY()) != null) {
                this.o_canvas.setSelection(this.o_canvas.getTransitionAt(p_me.getX(), p_me.getY()));
            } else {
                this.o_canvas.setSelection(this.o_canvas.getBMSCGraphicAt(p_me.getX(), p_me.getY()));
            }
        }
        if (p_me.getClickCount() > 1) {
            x_bmsc_name = this.o_canvas.getBMSCAt(p_me.getX(), p_me.getY());
            this.o_canvas.setSelection(null);
            this.o_canvas.swapToTab(x_bmsc_name);
        }
        if (p_me.getButton() == 3) {
            this.o_canvas.showPopup(p_me);
        }
    }

    public void mouseDragged(MouseEvent p_me) {
        if (this.o_moving == null) {
            this.o_moving = this.o_canvas.getBMSCGraphicAt(p_me.getX(), p_me.getY());
        } else {
            this.o_moving.moveTo(p_me.getX(), p_me.getY());
            this.o_canvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent p_me) {
        if (this.o_moving != null) {
            this.o_moving.moveTo(p_me.getX(), p_me.getY());
            double x_s = Glyph.getScale();
            this.o_canvas.moveBMSC(this.o_moving.getName(), (int)((double)p_me.getX() / x_s) / 120 * 120 + 50, (int)((double)p_me.getY() / x_s) / 100 * 100 + 30);
            this.o_moving = null;
            this.o_canvas.rebuild();
        }
    }
}

