/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import mscedit.Input;
import mscedit.InputOrOutput;
import mscedit.Output;
import mscedit.Visitor;
import org.jdom.Element;

public class Instance {
    private Element o_xml;
    private static Comparator s_sorter = new Comparator(){

        public int compare(Object p_a, Object p_b) {
            InputOrOutput a = (InputOrOutput)p_a;
            InputOrOutput b = (InputOrOutput)p_b;
            if (a.getTimeIndex() < b.getTimeIndex()) {
                return -1;
            }
            if (a.getTimeIndex() > b.getTimeIndex()) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object p_obj) {
            return false;
        }
    };

    public Instance() {
    }

    Instance(Element p_xml) {
        this.o_xml = p_xml;
    }

    public String getName() {
        return this.o_xml.getAttribute("name").getValue();
    }

    public void setName(String p_name) {
        this.o_xml.setAttribute("name", p_name);
    }

    public void add(Element p_elem) {
        this.o_xml.addContent(p_elem);
    }

    public void remove(Element p_elem) {
        this.o_xml.removeContent(p_elem);
    }

    public void remove(InputOrOutput p_ioo) {
        List x_xml_outs = this.o_xml.getChildren("output");
        Iterator i = x_xml_outs.iterator();
        while (i.hasNext()) {
            Element x_elem = (Element)i.next();
            if (!p_ioo.getId().equals(new Output(x_elem).getId())) continue;
            i.remove();
        }
        List x_xml_ins = this.o_xml.getChildren("input");
        Iterator i2 = x_xml_ins.iterator();
        while (i2.hasNext()) {
            Element x_elem = (Element)i2.next();
            if (!p_ioo.getId().equals(new Input(x_elem).getId())) continue;
            i2.remove();
        }
    }

    public List getOutputs() {
        ArrayList<Output> x_outs = new ArrayList<Output>();
        List x_xml_outs = this.o_xml.getChildren("output");
        Iterator i = x_xml_outs.iterator();
        while (i.hasNext()) {
            x_outs.add(new Output((Element)i.next()));
        }
        Collections.sort(x_outs, s_sorter);
        return x_outs;
    }

    public List getInputs() {
        ArrayList<Input> x_outs = new ArrayList<Input>();
        List x_xml_outs = this.o_xml.getChildren("input");
        Iterator i = x_xml_outs.iterator();
        while (i.hasNext()) {
            x_outs.add(new Input((Element)i.next()));
        }
        Collections.sort(x_outs, s_sorter);
        return x_outs;
    }

    public List getInputsAndOutputs() {
        List x_ins_outs = this.getInputs();
        x_ins_outs.addAll(this.getOutputs());
        Collections.sort(x_ins_outs, s_sorter);
        return x_ins_outs;
    }

    public void apply(Visitor v) {
        v.caseAInstance(this);
    }
}

