/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.MyHashStack;
import ic.doc.ltsa.lts.MyIntHash;
import ic.doc.ltsa.lts.MyList;
import ic.doc.ltsa.lts.StackCheck;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CompactState
implements Automata {
    public String name;
    public int maxStates;
    public String[] alphabet;
    public EventState[] states;
    int endseq = -9999;
    private boolean hasduplicates = false;
    private boolean prop = false;

    public CompactState() {
    }

    public CompactState(int n, String string, MyHashStack myHashStack, MyList myList, String[] stringArray, int n2) {
        this.alphabet = stringArray;
        this.name = string;
        this.maxStates = n;
        this.states = new EventState[this.maxStates];
        while (!myList.empty()) {
            int n3 = myList.getFrom();
            int n4 = myList.getTo() == null ? -1 : myHashStack.get(myList.getTo());
            this.states[n3] = EventState.add(this.states[n3], new EventState(myList.getAction(), n4));
            myList.next();
        }
        this.endseq = n2;
    }

    public void reachable() {
        MyIntHash myIntHash = EventState.reachable(this.states);
        EventState[] eventStateArray = this.states;
        this.maxStates = myIntHash.size();
        this.states = new EventState[this.maxStates];
        int n = 0;
        while (n < eventStateArray.length) {
            int n2 = myIntHash.get(n);
            if (n2 > -2) {
                this.states[n2] = EventState.renumberStates(eventStateArray[n], myIntHash);
            }
            ++n;
        }
        if (this.endseq > 0) {
            this.endseq = myIntHash.get(this.endseq);
        }
    }

    public void removeNonDetTau() {
        int n;
        if (!this.hasTau()) {
            return;
        }
        do {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.maxStates) {
                this.states[n2] = EventState.remove(this.states[n2], new EventState(0, n2));
                ++n2;
            }
            BitSet bitSet = new BitSet(this.maxStates);
            int n3 = 1;
            while (n3 < this.maxStates) {
                if (EventState.hasOnlyTauAndAccept(this.states[n3], this.alphabet)) {
                    bitSet.set(n3);
                    bl = true;
                }
                ++n3;
            }
            if (!bl) {
                return;
            }
            int n4 = 0;
            while (n4 < this.maxStates) {
                if (!bitSet.get(n4)) {
                    this.states[n4] = EventState.addNonDetTau(this.states[n4], this.states, bitSet);
                }
                ++n4;
            }
            n = this.maxStates;
            this.reachable();
        } while (n != this.maxStates);
    }

    public void removeDetCycles(String string) {
        int n = this.eventNo(string);
        if (n >= this.alphabet.length) {
            return;
        }
        int n2 = 0;
        while (n2 < this.states.length) {
            if (!EventState.hasNonDetEvent(this.states[n2], n)) {
                this.states[n2] = EventState.remove(this.states[n2], new EventState(n, n2));
            }
            ++n2;
        }
    }

    public boolean isSafetyOnly() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.maxStates) {
            if (EventState.isAccepting(this.states[n3], this.alphabet)) {
                ++n2;
                if (EventState.isTerminal(n3, this.states[n3])) {
                    ++n;
                }
            }
            ++n3;
        }
        return n == 1 && n2 == 1;
    }

    public void makeSafety() {
        int n = 0;
        while (n < this.maxStates) {
            if (EventState.isAccepting(this.states[n], this.alphabet)) {
                this.states[n] = new EventState(0, -1);
            }
            ++n;
        }
    }

    public void removeAcceptTau() {
        int n = 1;
        while (n < this.maxStates) {
            if (EventState.hasOnlyTauAndAccept(this.states[n], this.alphabet)) {
                this.states[n] = EventState.removeAccept(this.states[n]);
            }
            ++n;
        }
    }

    public boolean hasERROR() {
        int n = 0;
        while (n < this.maxStates) {
            if (EventState.hasState(this.states[n], -1)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void prefixLabels(String string) {
        this.name = string + ":" + this.name;
        int n = 1;
        while (n < this.alphabet.length) {
            String string2 = this.alphabet[n];
            this.alphabet[n] = string + "." + string2;
            ++n;
        }
    }

    public boolean relabelDuplicates() {
        return this.hasduplicates;
    }

    public void relabel(Relation relation) {
        this.hasduplicates = false;
        if (relation.isRelation()) {
            this.relational_relabel(relation);
        } else {
            this.functional_relabel(relation);
        }
    }

    private void relational_relabel(Relation relation) {
        Vector<String> vector = new Vector<String>();
        Relation relation2 = new Relation();
        vector.setSize(this.alphabet.length);
        int n = this.alphabet.length;
        vector.setElementAt(this.alphabet[0], 0);
        int n2 = 1;
        while (n2 < this.alphabet.length) {
            Object object;
            int n3 = -1;
            Object v = relation.get(this.alphabet[n2]);
            if (v != null) {
                if (v instanceof String) {
                    vector.setElementAt((String)v, n2);
                } else {
                    object = (Vector)v;
                    vector.setElementAt((String)((Vector)object).firstElement(), n2);
                    int n4 = 1;
                    while (n4 < ((Vector)object).size()) {
                        vector.addElement((String)((Vector)object).elementAt(n4));
                        relation2.put(new Integer(n2), new Integer(n));
                        ++n;
                        ++n4;
                    }
                }
            } else {
                n3 = this.maximalPrefix(this.alphabet[n2], relation);
                if (n3 >= 0) {
                    object = this.alphabet[n2].substring(0, n3);
                    v = relation.get(object);
                    if (v != null) {
                        if (v instanceof String) {
                            vector.setElementAt((String)v + this.alphabet[n2].substring(n3), n2);
                        } else {
                            Vector vector2 = (Vector)v;
                            vector.setElementAt((String)vector2.firstElement() + this.alphabet[n2].substring(n3), n2);
                            int n5 = 1;
                            while (n5 < vector2.size()) {
                                vector.addElement((String)vector2.elementAt(n5) + this.alphabet[n2].substring(n3));
                                relation2.put(new Integer(n2), new Integer(n));
                                ++n;
                                ++n5;
                            }
                        }
                    } else {
                        vector.setElementAt(this.alphabet[n2], n2);
                    }
                } else {
                    vector.setElementAt(this.alphabet[n2], n2);
                }
            }
            ++n2;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.alphabet = objectArray;
        this.addtransitions(relation2);
        this.checkDuplicates();
    }

    private void functional_relabel(Hashtable hashtable) {
        int n = 1;
        while (n < this.alphabet.length) {
            String string = (String)hashtable.get(this.alphabet[n]);
            this.alphabet[n] = string != null ? string : this.prefixLabelReplace(n, hashtable);
            ++n;
        }
        this.checkDuplicates();
    }

    private void checkDuplicates() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 1;
        while (n < this.alphabet.length) {
            if (hashtable.put(this.alphabet[n], this.alphabet[n]) != null) {
                this.hasduplicates = true;
                this.crunchDuplicates();
            }
            ++n;
        }
    }

    private void crunchDuplicates() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable hashtable2 = new Hashtable();
        int n = 0;
        int n2 = 0;
        while (n2 < this.alphabet.length) {
            if (hashtable.containsKey(this.alphabet[n2])) {
                hashtable2.put(new Integer(n2), hashtable.get(this.alphabet[n2]));
            } else {
                hashtable.put(this.alphabet[n2], new Integer(n));
                hashtable2.put(new Integer(n2), new Integer(n));
                ++n;
            }
            ++n2;
        }
        this.alphabet = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = (Integer)hashtable.get(string);
            this.alphabet[n3] = string;
        }
        int n4 = 0;
        while (n4 < this.states.length) {
            this.states[n4] = EventState.renumberEvents(this.states[n4], hashtable2);
            ++n4;
        }
    }

    public Vector hide(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        int n = 1;
        while (n < this.alphabet.length) {
            if (!CompactState.contains(this.alphabet[n], vector)) {
                vector2.addElement(this.alphabet[n]);
            }
            ++n;
        }
        return vector2;
    }

    public void expose(Vector vector) {
        BitSet bitSet = new BitSet(this.alphabet.length);
        int n = 1;
        while (n < this.alphabet.length) {
            if (CompactState.contains(this.alphabet[n], vector)) {
                bitSet.set(n);
            }
            ++n;
        }
        bitSet.set(0);
        this.dohiding(bitSet);
    }

    public void conceal(Vector vector) {
        BitSet bitSet = new BitSet(this.alphabet.length);
        int n = 1;
        while (n < this.alphabet.length) {
            if (!CompactState.contains(this.alphabet[n], vector)) {
                bitSet.set(n);
            }
            ++n;
        }
        bitSet.set(0);
        this.dohiding(bitSet);
    }

    private void dohiding(BitSet bitSet) {
        Integer n = new Integer(0);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.alphabet.length) {
            if (!bitSet.get(n3)) {
                hashtable.put(new Integer(n3), n);
            } else {
                vector.addElement(this.alphabet[n3]);
                hashtable.put(new Integer(n3), new Integer(n2));
                ++n2;
            }
            ++n3;
        }
        this.alphabet = new String[vector.size()];
        vector.copyInto(this.alphabet);
        int n4 = 0;
        while (n4 < this.states.length) {
            this.states[n4] = EventState.renumberEvents(this.states[n4], hashtable);
            ++n4;
        }
    }

    static boolean contains(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string) && !CompactState.isPrefix(string2, string)) continue;
            return true;
        }
        return false;
    }

    public boolean isProperty() {
        return this.prop;
    }

    public void makeProperty() {
        this.endseq = -9999;
        this.prop = true;
        int n = 0;
        while (n < this.maxStates) {
            this.states[n] = EventState.addTransToError(this.states[n], this.alphabet.length);
            ++n;
        }
    }

    public boolean isNonDeterministic() {
        int n = 0;
        while (n < this.maxStates) {
            if (EventState.hasNonDet(this.states[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void printAUT(PrintStream printStream) {
        printStream.print("des(0," + this.ntransitions() + "," + this.maxStates + ")\n");
        int n = 0;
        while (n < this.states.length) {
            EventState.printAUT(this.states[n], n, this.alphabet, printStream);
            ++n;
        }
    }

    public CompactState myclone() {
        CompactState compactState = new CompactState();
        compactState.name = this.name;
        compactState.endseq = this.endseq;
        compactState.prop = this.prop;
        compactState.alphabet = new String[this.alphabet.length];
        int n = 0;
        while (n < this.alphabet.length) {
            compactState.alphabet[n] = this.alphabet[n];
            ++n;
        }
        compactState.maxStates = this.maxStates;
        compactState.states = new EventState[this.maxStates];
        int n2 = 0;
        while (n2 < this.maxStates) {
            compactState.states[n2] = EventState.union(compactState.states[n2], this.states[n2]);
            ++n2;
        }
        return compactState;
    }

    public int ntransitions() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.states.length) {
            n += EventState.count(this.states[n2]);
            ++n2;
        }
        return n;
    }

    public boolean hasTau() {
        int n = 0;
        while (n < this.states.length) {
            if (EventState.hasTau(this.states[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String prefixLabelReplace(int n, Hashtable hashtable) {
        int n2 = this.maximalPrefix(this.alphabet[n], hashtable);
        if (n2 < 0) {
            return this.alphabet[n];
        }
        String string = this.alphabet[n].substring(0, n2);
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return this.alphabet[n];
        }
        return string2 + this.alphabet[n].substring(n2);
    }

    private int maximalPrefix(String string, Hashtable hashtable) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return n;
        }
        if (hashtable.containsKey(string.substring(0, n))) {
            return n;
        }
        return this.maximalPrefix(string.substring(0, n), hashtable);
    }

    private static boolean isPrefix(String string, String string2) {
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        if (string.equals(string2.substring(0, n))) {
            return true;
        }
        return CompactState.isPrefix(string, string2.substring(0, n));
    }

    public boolean isErrorTrace(Vector vector) {
        boolean bl = false;
        int n = 0;
        while (n < this.maxStates && !bl) {
            if (EventState.hasState(this.states[n], -1)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            return false;
        }
        return this.isTrace(vector, 0, 0);
    }

    private boolean isTrace(Vector vector, int n, int n2) {
        if (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            int n3 = this.eventNo(string);
            if (n3 < this.alphabet.length) {
                if (EventState.hasEvent(this.states[n2], n3)) {
                    int[] nArray = EventState.nextState(this.states[n2], n3);
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        if (this.isTrace(vector, n + 1, nArray[n4])) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                if (n3 != 0) {
                    return false;
                }
            }
            return this.isTrace(vector, n + 1, n2);
        }
        return n2 == -1;
    }

    private int eventNo(String string) {
        int n = 0;
        while (n < this.alphabet.length && !string.equals(this.alphabet[n])) {
            ++n;
        }
        return n;
    }

    public void addAccess(Vector vector) {
        int n;
        int n2 = vector.size();
        if (n2 == 0) {
            return;
        }
        String string = "{";
        CompactState[] compactStateArray = new CompactState[n2];
        Enumeration enumeration = vector.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2;
            compactStateArray[n3] = this.myclone();
            compactStateArray[n3].prefixLabels(string2);
            if (++n3 >= n2) continue;
            string = string + ",";
        }
        this.name = string + "}::" + this.name;
        int n4 = this.alphabet.length - 1;
        this.alphabet = new String[n4 * n2 + 1];
        this.alphabet[0] = "tau";
        int n5 = 0;
        while (n5 < n2) {
            n = 1;
            while (n < compactStateArray[n5].alphabet.length) {
                this.alphabet[n4 * n5 + n] = compactStateArray[n5].alphabet[n];
                ++n;
            }
            ++n5;
        }
        n = 1;
        while (n < n2) {
            int n6 = 0;
            while (n6 < this.maxStates) {
                EventState.offsetEvents(compactStateArray[n].states[n6], n4 * n);
                this.states[n6] = EventState.union(this.states[n6], compactStateArray[n].states[n6]);
                ++n6;
            }
            ++n;
        }
    }

    private void addtransitions(Relation relation) {
        int n = 0;
        while (n < this.states.length) {
            EventState eventState = EventState.newTransitions(this.states[n], relation);
            if (eventState != null) {
                this.states[n] = EventState.union(this.states[n], eventState);
            }
            ++n;
        }
    }

    public boolean hasLabel(String string) {
        int n = 0;
        while (n < this.alphabet.length) {
            if (string.equals(this.alphabet[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean usesLabel(String string) {
        if (!this.hasLabel(string)) {
            return false;
        }
        int n = this.eventNo(string);
        int n2 = 0;
        while (n2 < this.states.length) {
            if (EventState.hasEvent(this.states[n2], n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSequential() {
        return this.endseq >= 0;
    }

    public boolean isEnd() {
        return this.maxStates == 1 && this.endseq == 0;
    }

    public static CompactState sequentialCompose(Vector vector) {
        if (vector == null) {
            return null;
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (CompactState)vector.elementAt(0);
        }
        CompactState[] compactStateArray = new CompactState[vector.size()];
        compactStateArray = vector.toArray(compactStateArray);
        CompactState compactState = new CompactState();
        compactState.alphabet = CompactState.sharedAlphabet(compactStateArray);
        compactState.maxStates = CompactState.seqSize(compactStateArray);
        compactState.states = new EventState[compactState.maxStates];
        int n = 0;
        int n2 = 0;
        while (n2 < compactStateArray.length) {
            boolean bl = n2 == compactStateArray.length - 1;
            CompactState.copyOffset(n, compactState.states, compactStateArray[n2], bl);
            if (bl) {
                compactState.endseq = compactStateArray[n2].endseq + n;
            }
            n += compactStateArray[n2].states.length;
            ++n2;
        }
        return compactState;
    }

    public void expandSequential(Hashtable hashtable) {
        int n = hashtable.size();
        CompactState[] compactStateArray = new CompactState[n + 1];
        int[] nArray = new int[n + 1];
        compactStateArray[0] = this;
        int n2 = 1;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            CompactState compactState;
            Integer n3 = (Integer)enumeration.nextElement();
            compactStateArray[n2] = compactState = (CompactState)hashtable.get(n3);
            nArray[n2] = n3;
            ++n2;
        }
        this.alphabet = CompactState.sharedAlphabet(compactStateArray);
        int n4 = 1;
        while (n4 < compactStateArray.length) {
            int n5 = nArray[n4];
            int n6 = 0;
            while (n6 < compactStateArray[n4].states.length) {
                this.states[n5 + n6] = compactStateArray[n4].states[n6];
                ++n6;
            }
            ++n4;
        }
    }

    private static int seqSize(CompactState[] compactStateArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < compactStateArray.length) {
            n += compactStateArray[n2].states.length;
            ++n2;
        }
        return n;
    }

    private static void copyOffset(int n, EventState[] eventStateArray, CompactState compactState, boolean bl) {
        int n2 = 0;
        while (n2 < compactState.states.length) {
            eventStateArray[n2 + n] = !bl ? EventState.offsetSeq(n, compactState.endseq, compactState.maxStates + n, compactState.states[n2]) : EventState.offsetSeq(n, compactState.endseq, compactState.endseq + n, compactState.states[n2]);
            ++n2;
        }
    }

    public void offsetSeq(int n, int n2) {
        int n3 = 0;
        while (n3 < this.states.length) {
            EventState.offsetSeq(n, this.endseq, n2, this.states[n3]);
            ++n3;
        }
    }

    private static String[] sharedAlphabet(CompactState[] compactStateArray) {
        int n;
        Counter counter = new Counter(0);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n2 = 0;
        while (n2 < compactStateArray.length) {
            int n3 = 0;
            while (n3 < compactStateArray[n2].alphabet.length) {
                if (!hashtable.containsKey(compactStateArray[n2].alphabet[n3])) {
                    hashtable.put(compactStateArray[n2].alphabet[n3], counter.label());
                }
                ++n3;
            }
            ++n2;
        }
        String[] stringArray = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n = (Integer)hashtable.get(string);
            stringArray[n] = string;
        }
        int n4 = 0;
        while (n4 < compactStateArray.length) {
            n = 0;
            while (n < compactStateArray[n4].maxStates) {
                EventState eventState = compactStateArray[n4].states[n];
                while (eventState != null) {
                    EventState eventState2 = eventState;
                    eventState2.event = (Integer)hashtable.get(compactStateArray[n4].alphabet[eventState2.event]);
                    while (eventState2.nondet != null) {
                        eventState2.nondet.event = eventState2.event;
                        eventState2 = eventState2.nondet;
                    }
                    eventState = eventState.list;
                }
                ++n;
            }
            ++n4;
        }
        return stringArray;
    }

    private byte[] encode(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] | (byte)n);
            n >>>= 8;
        }
        return byArray;
    }

    private int decode(byte[] byArray) {
        int n = 0;
        int n2 = 3;
        while (n2 >= 0) {
            n |= byArray[n2] & 0xFF;
            if (n2 > 0) {
                n <<= 8;
            }
            --n2;
        }
        return n;
    }

    public String[] getAlphabet() {
        return this.alphabet;
    }

    public Vector getAlphabetV() {
        Vector<String> vector = new Vector<String>(this.alphabet.length - 1);
        int n = 1;
        while (n < this.alphabet.length) {
            vector.add(this.alphabet[n]);
            ++n;
        }
        return vector;
    }

    public MyList getTransitions(byte[] byArray) {
        MyList myList = new MyList();
        int n = byArray == null ? -1 : this.decode(byArray);
        if (n < 0 || n >= this.maxStates) {
            return myList;
        }
        if (this.states[n] != null) {
            Enumeration enumeration = this.states[n].elements();
            while (enumeration.hasMoreElements()) {
                EventState eventState = (EventState)enumeration.nextElement();
                myList.add(n, this.encode(eventState.next), eventState.event);
            }
        }
        return myList;
    }

    public String getViolatedProperty() {
        return null;
    }

    public Vector getTraceToState(byte[] byArray, byte[] byArray2) {
        EventState eventState = new EventState(0, 0);
        int n = EventState.search(eventState, this.states, this.decode(byArray), this.decode(byArray2), -123456);
        return EventState.getPath(eventState.path, this.alphabet);
    }

    public boolean END(byte[] byArray) {
        return this.decode(byArray) == this.endseq;
    }

    public boolean isAccepting(byte[] byArray) {
        return this.isAccepting(this.decode(byArray));
    }

    public byte[] START() {
        return this.encode(0);
    }

    public void setStackChecker(StackCheck stackCheck) {
    }

    public boolean isPartialOrder() {
        return false;
    }

    public void disablePartialOrder() {
    }

    public void enablePartialOrder() {
    }

    public boolean isAccepting(int n) {
        if (n < 0 || n >= this.maxStates) {
            return false;
        }
        return EventState.isAccepting(this.states[n], this.alphabet);
    }

    public BitSet accepting() {
        BitSet bitSet = new BitSet();
        int n = 0;
        while (n < this.maxStates) {
            if (this.isAccepting(n)) {
                bitSet.set(n);
            }
            ++n;
        }
        return bitSet;
    }
}

