/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeBody;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CompositionExpression {
    Symbol name;
    CompositeBody body;
    Hashtable constants;
    Hashtable init_constants = new Hashtable();
    Vector parameters = new Vector();
    Hashtable processes;
    Hashtable compiledProcesses;
    Hashtable composites;
    LTSOutput output;
    boolean priorityIsLow = true;
    LabelSet priorityActions;
    LabelSet alphaHidden;
    boolean exposeNotHide = false;
    boolean makeDeterministic = false;
    boolean makeMinimal = false;
    boolean makeProperty = false;
    boolean makeCompose = false;

    CompositionExpression() {
    }

    CompositeState compose(Vector vector) {
        CompositeState compositeState;
        Object object;
        Vector vector2 = new Vector();
        Hashtable hashtable = new Hashtable();
        this.constants = (Hashtable)this.init_constants.clone();
        if (vector != null) {
            this.doParams(vector);
        }
        this.body.compose(this, vector2, hashtable);
        Vector vector3 = new Vector();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof CompactState) {
                vector3.addElement(object);
                continue;
            }
            compositeState = (CompositeState)object;
            Enumeration enumeration2 = compositeState.machines.elements();
            while (enumeration2.hasMoreElements()) {
                vector3.addElement(enumeration2.nextElement());
            }
        }
        object = vector == null ? this.name.toString() : this.name.toString() + StateMachine.paramString(vector);
        compositeState = new CompositeState((String)object, vector3);
        compositeState.priorityIsLow = this.priorityIsLow;
        compositeState.priorityLabels = this.computeAlphabet(this.priorityActions);
        compositeState.hidden = this.computeAlphabet(this.alphaHidden);
        compositeState.exposeNotHide = this.exposeNotHide;
        compositeState.makeDeterministic = this.makeDeterministic;
        compositeState.makeMinimal = this.makeMinimal;
        compositeState.makeCompose = this.makeCompose;
        if (this.makeProperty) {
            compositeState.makeDeterministic = true;
            compositeState.isProperty = true;
        }
        return compositeState;
    }

    private void doParams(Vector vector) {
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = this.parameters.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            this.constants.put(enumeration2.nextElement(), enumeration.nextElement());
        }
    }

    private Vector computeAlphabet(LabelSet labelSet) {
        if (labelSet == null) {
            return null;
        }
        return labelSet.getActions(this.constants);
    }
}

