/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Value;
import java.util.Hashtable;
import java.util.Stack;

public class Expression {
    static Hashtable constants;

    private static String labelVar(Stack stack, Hashtable hashtable, Hashtable hashtable2) {
        if (stack == null) {
            return null;
        }
        if (stack.empty()) {
            return null;
        }
        Symbol symbol = (Symbol)stack.peek();
        if (symbol.kind == 124) {
            Value value;
            if (hashtable != null && (value = (Value)hashtable.get(symbol.toString())) != null && value.isLabel()) {
                stack.pop();
                return value.toString();
            }
        } else if (symbol.kind == 123) {
            Value value = null;
            if (hashtable2 != null) {
                value = (Value)hashtable2.get(symbol.toString());
            }
            if (value == null) {
                value = (Value)constants.get(symbol.toString());
            }
            if (value != null && value.isLabel()) {
                stack.pop();
                return value.toString();
            }
        } else {
            if (symbol.kind == 98) {
                ActionLabels actionLabels = (ActionLabels)symbol.getAny();
                if (actionLabels.hasMultipleValues()) {
                    Diagnostics.fatal("label constants cannot be sets", symbol);
                }
                actionLabels.initContext(hashtable, hashtable2);
                stack.pop();
                return actionLabels.nextName();
            }
            if (symbol.kind == 68) {
                return Expression.indexSet(stack, hashtable, hashtable2);
            }
        }
        return null;
    }

    protected static int countSet(Symbol symbol, Hashtable hashtable, Hashtable hashtable2) {
        if (symbol.kind != 98) {
            Diagnostics.fatal("label set expected", symbol);
        }
        ActionLabels actionLabels = (ActionLabels)symbol.getAny();
        actionLabels.initContext(hashtable, hashtable2);
        int n = 0;
        while (actionLabels.hasMoreNames()) {
            ++n;
            actionLabels.nextName();
        }
        actionLabels.clearContext();
        return n;
    }

    protected static String indexSet(Stack stack, Hashtable hashtable, Hashtable hashtable2) {
        stack.pop();
        int n = Expression.eval(stack, hashtable, hashtable2);
        Symbol symbol = (Symbol)stack.pop();
        if (symbol.kind != 98) {
            Diagnostics.fatal("label set expected", symbol);
        }
        ActionLabels actionLabels = (ActionLabels)symbol.getAny();
        actionLabels.initContext(hashtable, hashtable2);
        int n2 = 0;
        String string = null;
        while (actionLabels.hasMoreNames()) {
            string = actionLabels.nextName();
            if (n2 == n) break;
            ++n2;
        }
        actionLabels.clearContext();
        if (n2 != n) {
            Diagnostics.fatal("label set index expression out of range", symbol);
        }
        return string;
    }

    public static int evaluate(Stack stack, Hashtable hashtable, Hashtable hashtable2) {
        Stack stack2 = (Stack)stack.clone();
        return Expression.eval(stack2, hashtable, hashtable2);
    }

    public static Value getValue(Stack stack, Hashtable hashtable, Hashtable hashtable2) {
        Stack stack2 = (Stack)stack.clone();
        return Expression.getVal(stack2, hashtable, hashtable2);
    }

    private static Value getVal(Stack stack, Hashtable hashtable, Hashtable hashtable2) {
        String string = Expression.labelVar(stack, hashtable, hashtable2);
        if (string != null) {
            return new Value(string);
        }
        return new Value(Expression.eval(stack, hashtable, hashtable2));
    }

    private static int eval(Stack stack, Hashtable hashtable, Hashtable hashtable2) {
        Symbol symbol = (Symbol)stack.pop();
        switch (symbol.kind) {
            case 125: {
                return symbol.intValue();
            }
            case 124: {
                Value value;
                if (hashtable == null) {
                    Diagnostics.fatal("no variables defined", symbol);
                }
                if ((value = (Value)hashtable.get(symbol.toString())) == null) {
                    Diagnostics.fatal("variable not defined- " + symbol, symbol);
                }
                if (value.isLabel()) {
                    Diagnostics.fatal("not integer variable- " + symbol, symbol);
                }
                return value.intValue();
            }
            case 123: {
                Value value = null;
                if (hashtable2 != null) {
                    value = (Value)hashtable2.get(symbol.toString());
                }
                if (value == null) {
                    value = (Value)constants.get(symbol.toString());
                }
                if (value == null) {
                    Diagnostics.fatal("constant or parameter not defined- " + symbol, symbol);
                }
                if (value.isLabel()) {
                    Diagnostics.fatal("not integer constant or parameter- " + symbol, symbol);
                }
                return value.intValue();
            }
            case 73: {
                return Expression.countSet((Symbol)stack.pop(), hashtable, hashtable2);
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                Value value = Expression.getVal(stack, hashtable, hashtable2);
                Value value2 = Expression.getVal(stack, hashtable, hashtable2);
                if (value.isInt() && value2.isInt()) {
                    return Expression.exec_op(symbol.kind, value2.intValue(), value.intValue());
                }
                if (symbol.kind == 52 || symbol.kind == 44) {
                    if (symbol.kind == 52) {
                        return value2.toString().equals(value.toString()) ? 1 : 0;
                    }
                    return value2.toString().equals(value.toString()) ? 0 : 1;
                }
                Diagnostics.fatal("invalid expression", symbol);
            }
            case 29: {
                return Expression.eval(stack, hashtable, hashtable2);
            }
            case 28: {
                return -Expression.eval(stack, hashtable, hashtable2);
            }
            case 45: {
                return Expression.eval(stack, hashtable, hashtable2) > 0 ? 0 : 1;
            }
        }
        Diagnostics.fatal("invalid expression", symbol);
        return 0;
    }

    private static int exec_op(int n, int n2, int n3) {
        switch (n) {
            case 30: {
                return n2 + n3;
            }
            case 31: {
                return n2 - n3;
            }
            case 32: {
                return n2 * n3;
            }
            case 33: {
                return n2 / n3;
            }
            case 34: {
                return n2 % n3;
            }
            case 35: {
                return n2 ^ n3;
            }
            case 43: {
                return n2 & n3;
            }
            case 41: {
                return n2 | n3;
            }
            case 48: {
                return n2 << n3;
            }
            case 51: {
                return n2 >> n3;
            }
            case 47: {
                return n2 < n3 ? 1 : 0;
            }
            case 46: {
                return n2 <= n3 ? 1 : 0;
            }
            case 50: {
                return n2 > n3 ? 1 : 0;
            }
            case 49: {
                return n2 >= n3 ? 1 : 0;
            }
            case 52: {
                return n2 == n3 ? 1 : 0;
            }
            case 44: {
                return n2 != n3 ? 1 : 0;
            }
            case 42: {
                return n2 != 0 && n3 != 0 ? 1 : 0;
            }
            case 40: {
                return n2 != 0 || n3 != 0 ? 1 : 0;
            }
        }
        return 0;
    }
}

