/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.StackChecker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class PartialOrder {
    private CompactState[] machines;
    private int[][] actionSharedBy;
    private StackChecker checker;
    private int[][] candidates;
    private int[][] partners;
    private int Nactions;
    private String[] names;
    private BitSet visible;
    private boolean preserveOE;
    private BitSet high;

    public PartialOrder(Hashtable hashtable, String[] stringArray, CompactState[] compactStateArray, StackChecker stackChecker, Vector vector, boolean bl, boolean bl2, BitSet bitSet) {
        this.machines = compactStateArray;
        this.names = stringArray;
        this.Nactions = stringArray.length;
        this.checker = stackChecker;
        this.preserveOE = bl2;
        this.high = bitSet;
        this.actionSharedBy = new int[this.Nactions][];
        int n = 1;
        while (n < stringArray.length) {
            BitSet bitSet2 = (BitSet)hashtable.get(stringArray[n]);
            this.actionSharedBy[n] = this.bitsToArray(bitSet2);
            ++n;
        }
        this.visible = new BitSet(this.Nactions);
        int n2 = 1;
        while (n2 < stringArray.length) {
            if (vector == null) {
                this.visible.set(n2);
            } else if (bl) {
                if (CompactState.contains(stringArray[n2], vector)) {
                    this.visible.set(n2);
                }
            } else if (!CompactState.contains(stringArray[n2], vector)) {
                this.visible.set(n2);
            }
            ++n2;
        }
        this.initPartners();
        this.candidates = this.computeCandidates();
    }

    public List transitions(int[] nArray) {
        int n;
        int n2 = 0;
        while (n2 < this.machines.length) {
            ArrayList arrayList;
            if (this.candidates[n2][nArray[n2]] == 1 && (n = this.getMachTransitions(arrayList = new ArrayList(8), n2, nArray, null)) != 0) {
                return arrayList;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.machines.length) {
            List list;
            if (this.candidates[n3][nArray[n3]] == 2 && n3 == this.partners[n = this.partners[n3][nArray[n3]]][nArray[n]] && (list = this.getPairTransitions(n3, n, nArray)) != null) {
                return list;
            }
            ++n3;
        }
        return null;
    }

    private boolean addTransitions(List list, int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        int n3 = this.actionSharedBy[n][n2];
        EventState eventState = this.machines[n3].states[nArray[n3]];
        if (eventState != null) {
            nArray2 = this.myclone(nArray, n);
        }
        eventState = EventState.firstCompState(eventState, n, nArray);
        if (n2 < this.actionSharedBy[n].length - 1) {
            if (!this.addTransitions(list, nArray, n, n2 + 1)) {
                return false;
            }
        } else {
            if (this.checker.onStack(nArray)) {
                return false;
            }
            list.add(nArray);
        }
        while (eventState != null) {
            int[] nArray3 = this.myclone(nArray2, n);
            eventState = EventState.moreCompState(eventState, nArray3);
            if (n2 < this.actionSharedBy[n].length - 1) {
                if (this.addTransitions(list, nArray3, n, n2 + 1)) continue;
                return false;
            }
            if (this.checker.onStack(nArray3)) {
                return false;
            }
            list.add(nArray3);
        }
        return true;
    }

    private List getPairTransitions(int n, int n2, int[] nArray) {
        BitSet bitSet;
        ArrayList arrayList = new ArrayList(8);
        boolean bl = true;
        if (!this.preserveOE) {
            bitSet = this.getUnshared(n, nArray);
            if (bitSet != null) {
                bl = this.getMachTransitions(arrayList, n, nArray, bitSet);
            }
            if (!bl) {
                return null;
            }
            bitSet = this.getUnshared(n2, nArray);
            if (bitSet != null) {
                bl = this.getMachTransitions(arrayList, n2, nArray, bitSet);
            }
            if (!bl) {
                return null;
            }
        }
        bitSet = new BitSet(this.Nactions);
        EventState.hasEvents(this.machines[n].states[nArray[n]], bitSet);
        BitSet bitSet2 = new BitSet(this.Nactions);
        EventState.hasEvents(this.machines[n2].states[nArray[n2]], bitSet2);
        bitSet.and(bitSet2);
        if (this.preserveOE && this.countSet(bitSet) != 1) {
            return null;
        }
        bitSet.clear(0);
        int[] nArray2 = this.bitsToArray(bitSet);
        int n3 = 0;
        while (n3 < nArray2.length) {
            bl = this.addTransitions(arrayList, this.myclone(nArray, nArray2[n3]), nArray2[n3], 0);
            if (!bl) {
                return null;
            }
            ++n3;
        }
        return arrayList;
    }

    private BitSet getUnshared(int n, int[] nArray) {
        BitSet bitSet = new BitSet(this.Nactions);
        Enumeration enumeration = this.machines[n].states[nArray[n]].elements();
        while (enumeration.hasMoreElements()) {
            EventState eventState = (EventState)enumeration.nextElement();
            if (eventState.event == 0) {
                bitSet.set(eventState.event);
                continue;
            }
            if (this.actionSharedBy[eventState.event].length != 1) continue;
            bitSet.set(eventState.event);
        }
        if (bitSet.length() == 0) {
            return null;
        }
        return bitSet;
    }

    private boolean getMachTransitions(List list, int n, int[] nArray, BitSet bitSet) {
        Enumeration enumeration = this.machines[n].states[nArray[n]].elements();
        while (enumeration.hasMoreElements()) {
            EventState eventState = (EventState)enumeration.nextElement();
            if (bitSet != null && !bitSet.get(eventState.event)) continue;
            int[] nArray2 = this.myclone(nArray, eventState.event);
            nArray2[n] = eventState.next;
            if (this.checker.onStack(nArray2)) {
                return false;
            }
            list.add(nArray2);
        }
        return true;
    }

    private int[] bitsToArray(BitSet bitSet) {
        int n = this.countSet(bitSet);
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = bitSet.length();
        int n4 = 0;
        while (n4 < n3) {
            if (bitSet.get(n4)) {
                nArray[n2] = n4;
                ++n2;
            }
            ++n4;
        }
        return nArray;
    }

    private int countSet(BitSet bitSet) {
        int n = 0;
        int n2 = bitSet.length();
        int n3 = 0;
        while (n3 < n2) {
            if (bitSet.get(n3)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    private int[] myclone(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length - 1) {
            nArray2[n2] = nArray[n2];
            ++n2;
        }
        nArray2[nArray.length - 1] = n;
        return nArray2;
    }

    private void printArray(String string, int[][] nArray) {
        System.out.println(string);
        int n = 0;
        while (n < nArray.length) {
            System.out.print("Mach " + n + " --");
            int n2 = 0;
            while (n2 < nArray[n].length) {
                System.out.print(" " + nArray[n][n2]);
                ++n2;
            }
            System.out.println(".");
            ++n;
        }
    }

    private void initPartners() {
        this.partners = new int[this.machines.length][];
        int n = 0;
        while (n < this.machines.length) {
            this.partners[n] = new int[this.machines[n].states.length];
            int n2 = 0;
            while (n2 < this.machines[n].states.length) {
                this.partners[n][n2] = -1;
                ++n2;
            }
            ++n;
        }
    }

    private int[][] computeCandidates() {
        int[][] nArrayArray = new int[this.machines.length][];
        int n = 0;
        while (n < this.machines.length) {
            nArrayArray[n] = new int[this.machines[n].states.length];
            int n2 = 0;
            while (n2 < this.machines[n].states.length) {
                int[] nArray = EventState.localEnabled(this.machines[n].states[n2]);
                nArrayArray[n][n2] = this.candidateNumber(n, n2, nArray);
                ++n2;
            }
            ++n;
        }
        return nArrayArray;
    }

    private int candidateNumber(int n, int n2, int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        if (this.preserveOE && EventState.hasNonDet(this.machines[n].states[n2])) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        while (n6 < nArray.length) {
            int n7 = 0;
            int n8 = nArray[n6];
            if (this.visible.get(n8)) {
                return 0;
            }
            if (this.high != null && !this.high.get(n8)) {
                return 0;
            }
            n7 = n8 == 0 ? 1 : this.actionSharedBy[n8].length;
            if (n7 == 1) {
                ++n4;
            }
            if (n7 > n3) {
                n3 = n7;
            }
            if (n3 > 2) {
                return 0;
            }
            if (n7 == 2) {
                if (n5 < 0) {
                    n5 = this.getPartner(n, n8);
                } else if (n5 != this.getPartner(n, n8)) {
                    return 0;
                }
            }
            ++n6;
        }
        if (this.preserveOE && (n4 > 1 || n3 == 2 && n4 > 0)) {
            return 0;
        }
        if (n3 == 2) {
            this.partners[n][n2] = n5;
        }
        return n3;
    }

    private int getPartner(int n, int n2) {
        if (this.actionSharedBy[n2][0] == n) {
            return this.actionSharedBy[n2][1];
        }
        return this.actionSharedBy[n2][0];
    }
}

