/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;

public class PrintTransitions {
    CompactState sm;

    public PrintTransitions(CompactState compactState) {
        this.sm = compactState;
    }

    public void print(LTSOutput lTSOutput, int n) {
        int n2 = 0;
        lTSOutput.outln("Process:");
        lTSOutput.outln("\t" + this.sm.name);
        lTSOutput.outln("States:");
        lTSOutput.outln("\t" + this.sm.maxStates);
        lTSOutput.outln("Transitions:");
        lTSOutput.outln("\t" + this.sm.name + " = Q0,");
        int n3 = 0;
        while (n3 < this.sm.maxStates) {
            lTSOutput.out("\tQ" + n3 + "\t= ");
            EventState eventState = EventState.transpose(this.sm.states[n3]);
            if (eventState == null) {
                if (n3 == this.sm.endseq) {
                    lTSOutput.out("END");
                } else {
                    lTSOutput.out("STOP");
                }
                if (n3 < this.sm.maxStates - 1) {
                    lTSOutput.outln(",");
                } else {
                    lTSOutput.outln(".");
                }
            } else {
                lTSOutput.out("(");
                while (eventState != null) {
                    if (++n2 > n) {
                        lTSOutput.outln("EXCEEDED MAXPRINT SETTING");
                        return;
                    }
                    String[] stringArray = EventState.eventsToNext(eventState, this.sm.alphabet);
                    Alphabet alphabet = new Alphabet(stringArray);
                    lTSOutput.out(alphabet.toString() + " -> ");
                    if (eventState.next < 0) {
                        lTSOutput.out("ERROR");
                    } else {
                        lTSOutput.out("Q" + eventState.next);
                    }
                    eventState = eventState.list;
                    if (eventState == null) {
                        if (n3 < this.sm.maxStates - 1) {
                            lTSOutput.outln("),");
                            continue;
                        }
                        lTSOutput.outln(").");
                        continue;
                    }
                    lTSOutput.out("\n\t\t  |");
                }
            }
            ++n3;
        }
    }
}

