/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Degeneralize;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.SCCReduction;
import gov.nasa.arc.ase.util.graph.SFSReduction;
import gov.nasa.arc.ase.util.graph.Simplify;
import gov.nasa.arc.ase.util.graph.SuperSetReduction;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.Minimiser;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.Converter;
import ic.doc.ltsa.lts.ltl.FluentTrace;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.FormulaSyntax;
import ic.doc.ltsa.lts.ltl.GeneralizedBuchiAutomata;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AssertDefinition {
    Symbol name;
    FormulaFactory fac;
    FormulaSyntax ltl_formula;
    CompositeState cached;
    LabelSet alphaExtension;
    static Hashtable definitions;

    private AssertDefinition(Symbol symbol, FormulaSyntax formulaSyntax, LabelSet labelSet) {
        this.name = symbol;
        this.ltl_formula = formulaSyntax;
        this.cached = null;
        this.alphaExtension = labelSet;
    }

    public static void put(Symbol symbol, FormulaSyntax formulaSyntax, LabelSet labelSet) {
        if (definitions == null) {
            definitions = new Hashtable();
        }
        if (definitions.put(symbol.toString(), new AssertDefinition(symbol, formulaSyntax, labelSet)) != null) {
            Diagnostics.fatal("duplicate LTL property definition: " + symbol, symbol);
        }
    }

    public static void init() {
        definitions = null;
    }

    public static String[] names() {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Enumeration enumeration = definitions.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static void compileAll(LTSOutput lTSOutput) {
        if (definitions == null) {
            return;
        }
        Enumeration enumeration = definitions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            AssertDefinition assertDefinition = (AssertDefinition)definitions.get(string);
            assertDefinition.fac = new FormulaFactory();
            assertDefinition.fac.setFormula(assertDefinition.ltl_formula.expand(assertDefinition.fac, new Hashtable()));
        }
    }

    public static CompositeState compile(LTSOutput lTSOutput, String string) {
        Vector<String> vector;
        if (definitions == null || string == null) {
            return null;
        }
        AssertDefinition assertDefinition = (AssertDefinition)definitions.get(string);
        if (assertDefinition == null) {
            return null;
        }
        if (assertDefinition.cached != null) {
            return assertDefinition.cached;
        }
        lTSOutput.outln("Formula !" + assertDefinition.name.toString() + " = " + assertDefinition.fac.getFormula());
        Vector<String> vector2 = vector = assertDefinition.alphaExtension != null ? assertDefinition.alphaExtension.getActions(null) : null;
        if (vector == null) {
            vector = new Vector<String>();
        }
        vector.add("*");
        GeneralizedBuchiAutomata generalizedBuchiAutomata = new GeneralizedBuchiAutomata(assertDefinition.name.toString(), assertDefinition.fac, vector);
        generalizedBuchiAutomata.translate();
        Graph graph = generalizedBuchiAutomata.Gmake();
        lTSOutput.outln("GBA " + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
        graph = SuperSetReduction.reduce((Graph)graph);
        Graph graph2 = Degeneralize.degeneralize((Graph)graph);
        graph2 = SCCReduction.reduce((Graph)graph2);
        graph2 = Simplify.simplify((Graph)graph2);
        graph2 = SFSReduction.reduce((Graph)graph2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Converter converter = new Converter(assertDefinition.name.toString(), graph2, generalizedBuchiAutomata.getLabelFactory());
        lTSOutput.outln("Buchi automata:");
        converter.printFSP(new PrintStream(byteArrayOutputStream));
        lTSOutput.out(byteArrayOutputStream.toString());
        Vector vector3 = generalizedBuchiAutomata.getLabelFactory().propProcs;
        vector3.add(converter);
        CompositeState compositeState = new CompositeState(converter.name, vector3);
        compositeState.hidden = generalizedBuchiAutomata.getLabelFactory().getPrefix();
        compositeState.setFluentTracer(new FluentTrace(generalizedBuchiAutomata.getLabelFactory().getFluents()));
        compositeState.compose(lTSOutput, true);
        compositeState.composition.removeNonDetTau();
        lTSOutput.outln("After Tau elimination = " + compositeState.composition.maxStates + " state");
        Minimiser minimiser = new Minimiser(compositeState.composition, lTSOutput);
        compositeState.composition = minimiser.minimise();
        if (compositeState.composition.isSafetyOnly()) {
            compositeState.composition.makeSafety();
            compositeState.determinise(lTSOutput);
        }
        compositeState.composition.removeDetCycles("*");
        assertDefinition.cached = compositeState;
        return compositeState;
    }
}

