/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.ltl.LabelFactory;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;

class Converter
extends CompactState {
    BitSet accepting;
    Graph g;
    int iacc = 0;

    Converter(String string, Graph graph, LabelFactory labelFactory) {
        this.name = string;
        this.g = graph;
        this.accepting = this.getAcceptance();
        this.alphabet = labelFactory.makeAlphabet();
        this.makeStates(labelFactory);
    }

    private void makeStates(LabelFactory labelFactory) {
        this.maxStates = this.g.getNodeCount() + this.iacc + 1;
        this.states = new EventState[this.maxStates];
        HashMap hashMap = labelFactory.getTransLabels();
        this.addTrueNode(this.maxStates - 1, hashMap);
        Iterator iterator = this.g.getNodes().iterator();
        while (iterator.hasNext()) {
            this.addNode((Node)iterator.next(), hashMap);
        }
        if (this.iacc == 1) {
            this.states[0] = EventState.union(this.states[0], this.states[1]);
        }
        this.addAccepting();
        this.reachable();
    }

    private void addAccepting() {
        int n = 0;
        while (n < this.maxStates - 1) {
            if (this.accepting.get(n)) {
                this.states[n + this.iacc] = EventState.add(this.states[n + this.iacc], new EventState(this.alphabet.length - 1, n + this.iacc));
            }
            ++n;
        }
    }

    void addNode(Node node, HashMap hashMap) {
        int n = node.getId();
        BitSet bitSet = new BitSet(this.alphabet.length - 2);
        Iterator iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            this.addEdge((Edge)iterator.next(), n, hashMap, bitSet);
        }
        this.complete(n, bitSet);
    }

    void addTrueNode(int n, HashMap hashMap) {
        BitSet bitSet = (BitSet)hashMap.get("true");
        int n2 = 0;
        while (n2 < bitSet.size()) {
            if (bitSet.get(n2)) {
                this.states[n] = EventState.add(this.states[n], new EventState(n2 + 1, n));
            }
            ++n2;
        }
    }

    void complete(int n, BitSet bitSet) {
        int n2 = 0;
        while (n2 < this.alphabet.length - 2) {
            if (!bitSet.get(n2)) {
                this.states[n + this.iacc] = EventState.add(this.states[n + this.iacc], new EventState(n2 + 1, this.maxStates - 1));
            }
            ++n2;
        }
    }

    void addEdge(Edge edge, int n, HashMap hashMap, BitSet bitSet) {
        String string = edge.getGuard().equals("-") ? "true" : edge.getGuard();
        BitSet bitSet2 = (BitSet)hashMap.get(string);
        bitSet.or(bitSet2);
        int n2 = 0;
        while (n2 < bitSet2.size()) {
            if (bitSet2.get(n2)) {
                this.states[n + this.iacc] = EventState.add(this.states[n + this.iacc], new EventState(n2 + 1, edge.getNext().getId() + this.iacc));
            }
            ++n2;
        }
    }

    public void printFSP(PrintStream printStream) {
        boolean bl = false;
        if (this.g.getInit() != null) {
            printStream.print(this.name + " = S" + this.g.getInit().getId());
        } else {
            printStream.print("Empty");
            bl = true;
        }
        Iterator iterator = this.g.getNodes().iterator();
        while (iterator.hasNext()) {
            printStream.println(",");
            Node node = (Node)iterator.next();
            this.printNode(node, printStream);
        }
        printStream.println(".");
        if (printStream != System.out) {
            printStream.close();
        }
    }

    protected BitSet getAcceptance() {
        BitSet bitSet = new BitSet();
        int n = this.g.getIntAttribute("nsets");
        if (n > 0) {
            Diagnostics.fatal("More than one acceptance set");
        }
        Iterator iterator = this.g.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.getBooleanAttribute("accepting")) continue;
            bitSet.set(node.getId());
        }
        return bitSet;
    }

    void printNode(Node node, PrintStream printStream) {
        String string = this.accepting.get(node.getId()) ? "@" : "";
        printStream.print("S" + node.getId() + string + " =(");
        Iterator iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            this.printEdge((Edge)iterator.next(), printStream);
            if (!iterator.hasNext()) continue;
            printStream.print(" |");
        }
        printStream.print(")");
    }

    void printEdge(Edge edge, PrintStream printStream) {
        String string = "";
        String string2 = edge.getGuard().equals("-") ? "true" : edge.getGuard();
        printStream.print(string2 + " -> S" + edge.getNext().getId());
    }
}

