/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.util.Iterator;
import java.util.List;

public class FluentTrace {
    PredicateDefinition[] fluents;
    int[] state;

    public FluentTrace(PredicateDefinition[] predicateDefinitionArray) {
        if (predicateDefinitionArray != null) {
            this.fluents = predicateDefinitionArray;
            this.state = new int[this.fluents.length];
        }
    }

    private void initialise() {
        if (this.state == null) {
            return;
        }
        int n = 0;
        while (n < this.state.length) {
            this.state[n] = this.fluents[n].initial();
            ++n;
        }
    }

    private void update(String string) {
        if (this.state == null) {
            return;
        }
        int n = 0;
        while (n < this.state.length) {
            int n2 = this.fluents[n].query(string);
            if (n2 != 0) {
                this.state[n] = n2;
            }
            ++n;
        }
    }

    private String fluentString() {
        if (this.state == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\t");
        boolean bl = true;
        int n = 0;
        while (n < this.state.length) {
            if (this.state[n] > 0) {
                if (!bl) {
                    stringBuffer.append(" && ");
                }
                stringBuffer.append(this.fluents[n].toString());
                bl = false;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void print(LTSOutput lTSOutput, List list) {
        if (list == null) {
            return;
        }
        this.initialise();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.update(string);
            lTSOutput.outln("\t" + string + this.fluentString());
        }
    }
}

