/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import mscedit.BMSCGraphic;
import mscedit.Glyph;
import mscedit.HMSCEditorCanvas;

class HMSCCanvasMouseListener
extends MouseInputAdapter {
    private HMSCEditorCanvas o_canvas;
    private int o_clicks = 0;
    private BMSCGraphic o_moving;

    public HMSCCanvasMouseListener(HMSCEditorCanvas hMSCEditorCanvas) {
        this.o_canvas = hMSCEditorCanvas;
        this.o_moving = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        String string;
        if (mouseEvent.getButton() == 1) {
            if (this.o_canvas.inAddLinkMode()) {
                string = this.o_canvas.getBMSCAt(mouseEvent.getX(), mouseEvent.getY());
                if (string == null) {
                    return;
                }
                if (this.o_clicks == 0) {
                    this.o_canvas.setOldSelection(string);
                    this.o_canvas.setSelection(this.o_canvas.getBMSCGraphicAt(mouseEvent.getX(), mouseEvent.getY()));
                } else {
                    this.o_canvas.addTransition(this.o_canvas.getOldSelection(), string);
                    this.o_canvas.setAddLinkMode(false);
                }
                this.o_clicks = 1 - this.o_clicks;
            } else if (this.o_canvas.getTransitionAt(mouseEvent.getX(), mouseEvent.getY()) != null) {
                this.o_canvas.setSelection(this.o_canvas.getTransitionAt(mouseEvent.getX(), mouseEvent.getY()));
            } else {
                this.o_canvas.setSelection(this.o_canvas.getBMSCGraphicAt(mouseEvent.getX(), mouseEvent.getY()));
            }
        }
        if (mouseEvent.getClickCount() > 1) {
            string = this.o_canvas.getBMSCAt(mouseEvent.getX(), mouseEvent.getY());
            this.o_canvas.setSelection(null);
            this.o_canvas.swapToTab(string);
        }
        if (mouseEvent.getButton() == 3) {
            // empty if block
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.o_moving == null) {
            this.o_moving = this.o_canvas.getBMSCGraphicAt(mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.o_moving.moveTo(mouseEvent.getX(), mouseEvent.getY());
            this.o_canvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.o_moving != null) {
            this.o_moving.moveTo(mouseEvent.getX(), mouseEvent.getY());
            double d = Glyph.getScale();
            this.o_canvas.moveBMSC(this.o_moving.getName(), (int)((double)mouseEvent.getX() / d) / 120 * 120 + 50, (int)((double)mouseEvent.getY() / d) / 100 * 100 + 30);
            this.o_moving = null;
            this.o_canvas.rebuild();
        }
    }
}

