/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.ComponentInstanceNotFound;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.InconsistentEvents;
import synthesis.InconsistentLabelUse;
import synthesis.InputEvent;
import synthesis.Instance;
import synthesis.MessageEvent;
import synthesis.MyOutput;
import synthesis.OutputEvent;
import synthesis.StringMap;
import synthesis.StringSet;
import synthesis.Trace;
import synthesis.loopBackMessage;

public class BasicMSC {
    static int counter = 0;
    static int limit = 0;
    static int counterlimit = 0;
    static boolean last = false;
    private HashMap instances = new HashMap();
    public String name;
    private Map SavedDependencies = null;
    private Map SavedLastDependencies = null;
    private Map SavedCanFinishBefore = null;

    public void addInstance(String string, Instance instance) {
        this.instances.put(string, instance);
    }

    public Set components() {
        return this.instances.keySet();
    }

    public Instance componentInstance(String string) throws ComponentInstanceNotFound {
        if (this.containsComponent(string)) {
            return (Instance)this.instances.get(string);
        }
        throw new ComponentInstanceNotFound();
    }

    public String getSource(String string) {
        Iterator iterator = this.components().iterator();
        boolean bl = false;
        String string2 = null;
        while (iterator.hasNext() && !bl) {
            Instance instance = null;
            string2 = (String)iterator.next();
            try {
                instance = this.componentInstance(string2);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            bl = instance.outputs(string);
        }
        if (!bl) {
            return null;
        }
        return string2;
    }

    public String getTarget(String string) {
        Iterator iterator = this.components().iterator();
        boolean bl = false;
        String string2 = null;
        while (iterator.hasNext() && !bl) {
            Instance instance = null;
            string2 = (String)iterator.next();
            try {
                instance = this.componentInstance(string2);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            bl = instance.inputs(string);
        }
        if (!bl) {
            return null;
        }
        return string2;
    }

    public boolean containsConditions() throws Exception {
        Iterator iterator = this.components().iterator();
        boolean bl = false;
        Instance instance = null;
        while (iterator.hasNext() && !bl) {
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (Exception exception) {
                throw new Exception("Internal Consistency Error");
            }
            bl = instance.containsConditions();
        }
        return bl;
    }

    public StringSet getAlphabet() {
        Iterator iterator = this.components().iterator();
        Instance instance = null;
        StringSet stringSet = new StringSet();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            stringSet.addAll(instance.getAlphabet());
        }
        return stringSet;
    }

    public boolean empty() throws Exception {
        Iterator iterator = this.components().iterator();
        Instance instance = null;
        boolean bl = true;
        while (iterator.hasNext() && bl) {
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (Exception exception) {
                throw new Exception("Internal Consistency Error");
            }
            boolean bl2 = bl = instance.size() == 0;
        }
        return bl;
    }

    public StringSet getParticipatingComponents() {
        Iterator iterator = this.components().iterator();
        Instance instance = null;
        StringSet stringSet = new StringSet();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (Exception exception) {
                throw new Error("Internal Consistency Error");
            }
            if (instance.isEmpty()) continue;
            stringSet.add(string);
        }
        return stringSet;
    }

    public void removeConditions() throws Exception {
        Iterator iterator = this.components().iterator();
        Instance instance = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (Exception exception) {
                throw new Exception("Internal Consistency Error");
            }
            instance.removeConditions();
        }
    }

    public void append(BasicMSC basicMSC) {
        Iterator iterator = basicMSC.components().iterator();
        this.name = this.name + "_" + basicMSC.name;
        try {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Instance instance = basicMSC.componentInstance(string);
                Instance instance2 = this.componentInstance(string);
                instance2.append(instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void appendAndMap(BasicMSC basicMSC, Map map) {
        Iterator iterator = basicMSC.components().iterator();
        this.name = this.name + "_" + basicMSC.name;
        try {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Instance instance = basicMSC.componentInstance(string);
                Instance instance2 = this.componentInstance(string);
                instance2.appendAndMap(instance, map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void appendMessage(String string, String string2, String string3) {
        Instance instance = this.getInstance(string);
        Instance instance2 = this.getInstance(string3);
        OutputEvent outputEvent = new OutputEvent(string2);
        outputEvent.setTo(string3);
        instance.appendEvent(outputEvent);
        InputEvent inputEvent = new InputEvent(string2);
        inputEvent.setFrom(string);
        instance2.appendEvent(inputEvent);
    }

    public void addMessage(String string, String string2, String string3, int n, int n2) {
        Instance instance = this.getInstance(string);
        Instance instance2 = this.getInstance(string3);
        OutputEvent outputEvent = new OutputEvent(string2);
        outputEvent.setTo(string3);
        outputEvent.Id = n;
        instance.addEvent(outputEvent);
        InputEvent inputEvent = new InputEvent(string2);
        inputEvent.setFrom(string);
        inputEvent.Id = n2;
        instance2.addEvent(inputEvent);
    }

    public void addMessage(String string, String string2, String string3) {
        Instance instance = this.getInstance(string);
        Instance instance2 = this.getInstance(string3);
        OutputEvent outputEvent = new OutputEvent(string2);
        outputEvent.setTo(string3);
        instance.addEvent(outputEvent);
        InputEvent inputEvent = new InputEvent(string2);
        inputEvent.setFrom(string);
        instance2.addEvent(inputEvent);
    }

    public void addToAlphabet(StringSet stringSet) {
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Instance instance = null;
            try {
                instance = (Instance)this.instances.get(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            instance.addToAlphabet(stringSet);
        }
    }

    public void hasAllComponentsIn(BasicMSC basicMSC) throws ComponentInstanceNotFound {
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (basicMSC.containsComponent(string)) continue;
            throw new ComponentInstanceNotFound(string);
        }
    }

    public boolean containsComponent(String string) {
        return this.instances.containsKey(string);
    }

    public void copyComponents(BasicMSC basicMSC) {
        Iterator iterator = basicMSC.components().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addInstance(string, new Instance());
        }
    }

    public Object clone() {
        BasicMSC basicMSC = new BasicMSC();
        basicMSC.name = this.name;
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                basicMSC.addInstance(string, (Instance)this.componentInstance(string).clone());
            }
            catch (Exception exception) {
                System.out.println("Error");
            }
        }
        return basicMSC;
    }

    public Object cloneAndMap(Map map) {
        BasicMSC basicMSC = new BasicMSC();
        basicMSC.name = this.name;
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Instance instance = this.componentInstance(string);
                Instance instance2 = (Instance)instance.clone();
                basicMSC.addInstance(string, instance2);
                int n = 0;
                while (n < instance.size()) {
                    map.put(instance2.get(n), instance.get(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("Error");
            }
        }
        return basicMSC;
    }

    public void consistentLabels(HashMap hashMap) throws Exception {
        Iterator iterator = this.components().iterator();
        String string = null;
        while (iterator.hasNext()) {
            Instance instance;
            String string2 = (String)iterator.next();
            try {
                instance = this.componentInstance(string2);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            ListIterator listIterator = instance.iterator();
            while (listIterator.hasNext()) {
                Vector vector;
                Event event = (Event)listIterator.next();
                if (event instanceof ConditionEvent) continue;
                Iterator iterator2 = hashMap.keySet().iterator();
                boolean bl = false;
                while (iterator2.hasNext() && !bl) {
                    string = (String)iterator2.next();
                    bl = event.getLabel().equals(string);
                }
                if (!bl) {
                    vector = new Vector(3);
                    vector.add(0, this.name);
                    if (event instanceof InputEvent) {
                        vector.add(1, string2);
                        vector.add(2, ((InputEvent)event).getFrom());
                    } else {
                        vector.add(1, ((OutputEvent)event).getTo());
                        vector.add(2, string2);
                    }
                    hashMap.put(event.getLabel(), vector);
                    if (!vector.get(1).equals(vector.get(2))) continue;
                    throw new loopBackMessage("Label " + event.getLabel() + " used as input and output in instance of component " + vector.get(2) + " in bMSC " + this.name);
                }
                vector = (Vector)hashMap.get(string);
                if (event instanceof InputEvent) {
                    if (!vector.get(1).equals(string2)) {
                        if (this.name.equals(vector.get(0))) {
                            throw new InconsistentLabelUse("Label " + string + " used inconsistently in bMSC " + this.name);
                        }
                        throw new InconsistentLabelUse("Label " + string + " used inconsistently in bMSCs " + this.name + " and " + vector.get(0));
                    }
                    if (((InputEvent)event).getFrom().equals(vector.get(2))) continue;
                    throw new InconsistentLabelUse("Label " + string + " is declared to be received from component " + ((InputEvent)event).getFrom() + " but is being received from component " + vector.get(2) + " in bMSC " + this.name);
                }
                if (!vector.get(2).equals(string2)) {
                    if (this.name.equals(vector.get(0))) {
                        throw new InconsistentLabelUse("Label " + string + " used inconsistently in bMSC " + this.name);
                    }
                    throw new InconsistentLabelUse("Label " + string + " used inconsistently in bMSCs " + this.name + " and " + vector.get(0));
                }
                if (((OutputEvent)event).getTo().equals(vector.get(1))) continue;
                throw new InconsistentLabelUse("Label " + string + " is declared to be sent to component " + ((OutputEvent)event).getTo() + " but is being sent to component " + vector.get(1) + " in bMSC " + this.name);
            }
        }
    }

    public void consistentEvents() throws Exception {
        ListIterator listIterator;
        int n = this.components().size();
        Vector<ListIterator> vector = new Vector<ListIterator>(n);
        Vector<Event> vector2 = new Vector<Event>(n);
        int n2 = 0;
        int n3 = 0;
        Event event = null;
        Event event2 = null;
        Iterator iterator = this.components().iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            Instance instance;
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            vector.add(n4++, instance.iterator());
        }
        n4 = 0;
        while (n4 < n) {
            listIterator = (ListIterator)vector.get(n4);
            event = null;
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                event = null;
            }
            vector2.add(n4, event);
            if (event == null) {
                ++n3;
            }
            ++n4;
        }
        while (n3 < n) {
            boolean bl = false;
            n4 = 0;
            while (n4 < n && !bl) {
                event = (Event)vector2.get(n4);
                if (event != null) {
                    n2 = n4 + 1;
                    while (n2 < n && !bl) {
                        event2 = (Event)vector2.get(n2);
                        if (event2 != null) {
                            bl = event.getLabel().equals(event2.getLabel());
                        }
                        ++n2;
                    }
                }
                ++n4;
            }
            if (bl) {
                event = null;
                listIterator = (ListIterator)vector.get(n4 - 1);
                while (listIterator.hasNext() && event == null) {
                    event = (Event)listIterator.next();
                    if (!(event instanceof ConditionEvent)) continue;
                    event = null;
                }
                vector2.set(n4 - 1, event);
                if (event == null) {
                    ++n3;
                }
                event = null;
                listIterator = (ListIterator)vector.get(n2 - 1);
                while (listIterator.hasNext() && event == null) {
                    event = (Event)listIterator.next();
                    if (!(event instanceof ConditionEvent)) continue;
                    event = null;
                }
                vector2.set(n2 - 1, event);
                if (event != null) continue;
                ++n3;
                continue;
            }
            String string = "";
            n4 = 0;
            while (n4 < n) {
                string = (Event)vector2.get(n4) != null ? string + ((Event)vector2.get(n4)).getLabel() : string + "-";
                if (n4 + 1 < n) {
                    string = string + ", ";
                }
                ++n4;
            }
            throw new InconsistentEvents("Inconsistent events in bMSC " + this.name + ". Impossible to pair one of the following event labels " + string);
        }
    }

    public void print(MyOutput myOutput) {
        myOutput.println("msc " + this.name + ";");
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            myOutput.println("inst " + string + ";");
            try {
                ((Instance)this.instances.get(string)).print(myOutput);
            }
            catch (Exception exception) {
                myOutput.println("Error in instance.print");
            }
            myOutput.println("endinst");
        }
        myOutput.println("endmsc ");
    }

    public void print(LTSOutput lTSOutput) {
        lTSOutput.outln("msc " + this.name + ";");
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            lTSOutput.outln("inst " + string + ";");
            try {
                ((Instance)this.instances.get(string)).print(lTSOutput);
            }
            catch (Exception exception) {
                lTSOutput.outln("Error in instance.print");
            }
            lTSOutput.outln("endinst");
        }
        lTSOutput.outln("endmsc ");
    }

    public boolean isPrefixOf(Set set) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            if (basicMSC == this) continue;
            Iterator iterator2 = this.instances.keySet().iterator();
            boolean bl2 = false;
            while (iterator2.hasNext() && !bl2) {
                Instance instance;
                String string = (String)iterator2.next();
                Instance instance2 = (Instance)this.instances.get(string);
                bl2 = instance2.isPrefixOf(instance = basicMSC.getInstance(string));
                if (!bl2) continue;
                System.out.println(string + ":" + this.name + " is a prefix of " + string + ":" + basicMSC.name);
            }
            if (!bl2) continue;
            bl = true;
        }
        return bl;
    }

    public StringMap BuildPrefixRelation(Set set) {
        StringMap stringMap = new StringMap();
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Instance instance = (Instance)this.instances.get(string);
            if (instance.isEmpty()) {
                stringMap.put(string, "E");
                continue;
            }
            Iterator iterator2 = set.iterator();
            boolean bl = false;
            while (iterator2.hasNext() && !bl) {
                Instance instance2;
                BasicMSC basicMSC = (BasicMSC)iterator2.next();
                if (basicMSC == this || !instance.isPrefixOf(instance2 = basicMSC.getInstance(string))) continue;
                bl = true;
                stringMap.put(string, "P");
            }
            if (bl) continue;
            stringMap.put(string, "N");
        }
        return stringMap;
    }

    public Instance getInstance(String string) {
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string)) continue;
            return (Instance)this.instances.get(string2);
        }
        return null;
    }

    public void printLatex(MyOutput myOutput) {
        myOutput.println("\\begin{msc}{" + this.name.replace('_', '.') + "}");
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            myOutput.println("\\declinst{" + string.replace('_', '.') + "}{}{" + string.replace('_', '.') + "}");
        }
        this.printLatexInstances(myOutput);
        myOutput.println("\\end{msc}");
        myOutput.println("");
        myOutput.println("");
        myOutput.println("");
        myOutput.println("");
    }

    public void printLatexInstances(MyOutput myOutput) {
        ListIterator listIterator;
        int n = this.components().size();
        Vector<ListIterator> vector = new Vector<ListIterator>(n);
        Vector<String> vector2 = new Vector<String>(n);
        Vector<Event> vector3 = new Vector<Event>(n);
        int n2 = 0;
        Instance instance = new Instance();
        int n3 = 0;
        Event event = null;
        Event event2 = null;
        Iterator iterator = this.components().iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                // empty catch block
            }
            vector2.add(n4, string);
            vector.add(n4++, instance.iterator());
        }
        n4 = 0;
        while (n4 < n) {
            listIterator = (ListIterator)vector.get(n4);
            event = null;
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                event = null;
            }
            vector3.add(n4, event);
            if (event == null) {
                ++n3;
            }
            ++n4;
        }
        HashSet hashSet = new HashSet();
        while (n3 < n) {
            boolean bl = false;
            n4 = 0;
            while (n4 < n && !bl) {
                event = (Event)vector3.get(n4);
                if (event != null) {
                    n2 = n4 + 1;
                    while (n2 < n && !bl) {
                        event2 = (Event)vector3.get(n2);
                        if (event2 != null && (bl = event.getLabel().equals(event2.getLabel()))) {
                            String string;
                            String string2;
                            if (event2 instanceof OutputEvent) {
                                string2 = ((OutputEvent)event2).getTo();
                                string = ((InputEvent)event).getFrom();
                            } else {
                                string2 = ((OutputEvent)event).getTo();
                                string = ((InputEvent)event2).getFrom();
                            }
                            myOutput.println("\\mess{" + event2.getLabel().replace('_', '.') + "}{" + string.replace('_', '.') + "}{" + string2.replace('_', '.') + "}");
                            myOutput.println("\\nextlevel");
                        }
                        ++n2;
                    }
                }
                ++n4;
            }
            event = null;
            listIterator = (ListIterator)vector.get(n4 - 1);
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                myOutput.println("\\condition{" + event.getLabel().replace('_', '.') + "}{" + ((String)vector2.get(n4 - 1)).replace('_', '.') + "}");
                myOutput.println("\\nextlevel[2]");
                event = null;
            }
            vector3.set(n4 - 1, event);
            if (event == null) {
                ++n3;
            }
            event = null;
            listIterator = (ListIterator)vector.get(n2 - 1);
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                myOutput.println("\\condition{" + event.getLabel().replace('_', '.') + "}{" + ((String)vector2.get(n2 - 1)).replace('_', '.') + "}");
                myOutput.println("\\nextlevel[2]");
                event = null;
            }
            vector3.set(n2 - 1, event);
            if (event != null) continue;
            ++n3;
        }
    }

    public BasicMSC FindCutAndSplit(LTSOutput lTSOutput, boolean bl) throws Exception {
        Instance instance;
        last = bl;
        int n = this.components().size();
        Vector<Instance> vector = new Vector<Instance>(n);
        Vector<Event> vector2 = new Vector<Event>(n);
        Vector<String> vector3 = new Vector<String>(n);
        Vector<Integer> vector4 = new Vector<Integer>(n);
        int n2 = 0;
        int n3 = 0;
        BasicMSC basicMSC = null;
        Iterator iterator = this.components().iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            vector3.add(n2, string);
            vector4.add(n2, new Integer(0));
            vector.add(n2++, instance);
        }
        n2 = 0;
        while (n2 < n) {
            Event event;
            instance = (Instance)vector.get(n2);
            int n4 = (Integer)vector4.get(n2);
            if (n4 < instance.size()) {
                event = instance.get(n4);
                vector4.set(n2, new Integer(n4 + 1));
            } else {
                event = null;
            }
            vector2.add(n2, event);
            if (event == null) {
                ++n3;
            }
            ++n2;
        }
        if (this.FindNextCut(vector, vector2, vector3, vector4, lTSOutput)) {
            basicMSC = new BasicMSC();
            basicMSC.name = this.name + "_P";
            this.Split(basicMSC, vector, vector3, vector4, vector2, lTSOutput);
        }
        return basicMSC;
    }

    private boolean FindNextCut(Vector vector, Vector vector2, Vector vector3, Vector vector4, LTSOutput lTSOutput) throws Exception {
        int n = 0;
        int n2 = this.components().size();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        while (!bl) {
            Object object;
            Object object2;
            boolean bl5;
            if (bl4) {
                lTSOutput.outln("About to move forward");
            }
            if (this.MoveForwardUntilBlock(vector, vector2, vector4, lTSOutput) || !bl3) {
                bl3 = false;
                if (bl4) {
                    lTSOutput.outln("Cut, end state, locked");
                }
                n = 0;
                while (n < n2 && vector2.get(n) != null) {
                    ++n;
                }
                if (n < n2) {
                    if (bl4) {
                        lTSOutput.outln("Some instance is at its end.");
                    }
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (bl4) {
                    lTSOutput.outln("Cut, locked");
                }
                bl5 = true;
                object2 = null;
                n = 0;
                while (n < n2 && bl5) {
                    object2 = (Event)vector2.get(n);
                    bl5 = object2 != null ? object2 instanceof ConditionEvent : false;
                    ++n;
                }
                if (!bl5) {
                    if (bl4) {
                        lTSOutput.outln("locked");
                    }
                    if (object2 == null) {
                        if (bl4) {
                            lTSOutput.outln(vector3.get(n) + " is at the end. No cut is possible");
                        }
                        bl = true;
                        bl2 = false;
                        continue;
                    }
                    --n;
                    boolean bl6 = false;
                    object = null;
                    int n3 = 0;
                    while (!bl6) {
                        if (object != null) {
                            n = n3;
                            object2 = object;
                        }
                        if (bl4) {
                            lTSOutput.outln(vector3.get(n) + " has event " + ((Event)object2).getLabel() + " enabled");
                        }
                        String string = object2 instanceof OutputEvent ? ((OutputEvent)object2).getTo() : ((InputEvent)object2).getFrom();
                        n3 = 0;
                        while (!vector3.get(n3).equals(string) && n3 < n2) {
                            ++n3;
                        }
                        if (n3 == n2) {
                            throw new InconsistentEvents("Inconsistency!");
                        }
                        if (bl4) {
                            lTSOutput.outln("Event needs instance " + vector3.get(n3) + " unblocked");
                        }
                        if ((object = (Event)vector2.get(n3)) != null) {
                            bl6 = object instanceof ConditionEvent;
                            continue;
                        }
                        throw new InconsistentEvents("Inconsistency1!");
                    }
                    if (bl4) {
                        lTSOutput.outln("Unblocking instance " + n3);
                    }
                    if (this.MoveForward(vector, vector4, vector2, n3, lTSOutput)) continue;
                    throw new InconsistentEvents("Inconsistency4!");
                }
                if (bl4) {
                    lTSOutput.outln("Cut!");
                }
                bl = true;
                bl2 = true;
                continue;
            }
            if (bl4) {
                lTSOutput.outln("Initial State is a cut");
            }
            bl3 = false;
            bl5 = false;
            object2 = this.GetAllPairsThatCanBeUnblocked(vector, vector4, vector2, lTSOutput);
            n = 0;
            while (n * 2 < ((Vector)object2).size()) {
                Vector vector5 = (Vector)vector2.clone();
                object = (Vector)vector4.clone();
                if (!this.MoveForward(vector, (Vector)object, vector5, (Integer)((Vector)object2).get(2 * n), lTSOutput) || !this.MoveForward(vector, (Vector)object, vector5, (Integer)((Vector)object2).get(2 * n + 1), lTSOutput)) {
                    throw new InconsistentEvents("Inconsistency4!");
                }
                if (this.FindNextCut(vector, vector5, vector3, (Vector)object, lTSOutput)) {
                    bl5 = true;
                    this.MoveForward(vector, vector4, vector2, (Integer)((Vector)object2).get(2 * n), lTSOutput);
                    this.MoveForward(vector, vector4, vector2, (Integer)((Vector)object2).get(2 * n + 1), lTSOutput);
                }
                ++n;
            }
            if (bl5) continue;
            bl = true;
            bl2 = false;
        }
        return bl2;
    }

    private Vector GetAllPairsThatCanBeUnblocked(Vector vector, Vector vector2, Vector vector3, LTSOutput lTSOutput) {
        Vector<Integer> vector4 = new Vector<Integer>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.components().size()) {
            Event event;
            Instance instance;
            int n3 = (Integer)vector2.get(n2);
            if (n3 < (instance = (Instance)vector.get(n2)).size() && !((event = instance.get(n3)) instanceof ConditionEvent)) {
                int n4 = n2 + 1;
                while (n4 < this.components().size()) {
                    Event event2;
                    n3 = (Integer)vector2.get(n4);
                    if (n3 < (instance = (Instance)vector.get(n4)).size() && !((event2 = instance.get(n3)) instanceof ConditionEvent) && event.getLabel().equals(event2.getLabel())) {
                        vector4.add(n++, new Integer(n2));
                        vector4.add(n++, new Integer(n4));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return vector4;
    }

    public boolean MoveForwardUntilBlock(Vector vector, Vector vector2, Vector vector3, LTSOutput lTSOutput) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        while (bl) {
            Vector vector4 = this.FindMatch(this.components().size(), vector2, lTSOutput);
            int n = (Integer)vector4.get(0);
            int n2 = (Integer)vector4.get(1);
            boolean bl4 = bl = (Integer)vector4.get(2) == 1;
            if (!bl) continue;
            bl2 = true;
            this.MoveForward(vector, vector3, vector2, n, lTSOutput);
            this.MoveForward(vector, vector3, vector2, n2, lTSOutput);
        }
        return bl2;
    }

    private Vector FindMatch(int n, Vector vector, LTSOutput lTSOutput) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        n2 = 0;
        while (n2 < n && !bl2) {
            object = (Event)vector.get(n2);
            if (object != null && !(object instanceof ConditionEvent)) {
                n3 = n2 + 1;
                while (n3 < n && !bl2) {
                    Event event = (Event)vector.get(n3);
                    if (event != null && !(event instanceof ConditionEvent)) {
                        bl2 = ((Event)object).getLabel().equals(event.getLabel());
                        if (bl && bl2) {
                            lTSOutput.outln("Found match: " + n2 + " and " + n3 + " on label " + ((Event)object).getLabel());
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        object = new Vector<Integer>();
        ((Vector)object).add(0, new Integer(n2 - 1));
        ((Vector)object).add(1, new Integer(n3 - 1));
        if (bl2) {
            ((Vector)object).add(2, new Integer(1));
        } else {
            ((Vector)object).add(2, new Integer(0));
        }
        return object;
    }

    private boolean MoveForward(Vector vector, Vector vector2, Vector vector3, int n, LTSOutput lTSOutput) {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("Moving Forward. Index = " + n + ". Instaces.size = " + vector.size());
        }
        Event event = null;
        Instance instance = (Instance)vector.get(n);
        int n2 = (Integer)vector2.get(n);
        if (n2 < instance.size()) {
            event = instance.get(n2);
            vector2.set(n, new Integer(n2 + 1));
        } else {
            event = null;
        }
        vector3.set(n, event);
        return event != null;
    }

    private void Split(BasicMSC basicMSC, Vector vector, Vector vector2, Vector vector3, Vector vector4, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        int n = 0;
        while (n < this.components().size()) {
            Instance instance;
            Instance instance2 = new Instance();
            basicMSC.addInstance((String)vector2.get(n), instance2);
            Instance instance3 = (Instance)vector.get(n);
            int n2 = (Integer)vector3.get(n);
            if (vector4.get(n) != null) {
                instance2.appendEvent((Event)vector4.get(n));
            }
            int n3 = 0;
            while (n2 < instance3.size()) {
                ++n3;
                bl = true;
                instance2.appendEvent(instance3.get(n2));
                ++n2;
            }
            try {
                instance = this.componentInstance((String)vector2.get(n));
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            instance.deleteLast(n3);
            ++n;
        }
    }

    public boolean TrivialCut() throws Exception {
        boolean bl = true;
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext() && bl) {
            Instance instance;
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            bl = false;
            if (instance.size() != 1 || !(instance.get(0) instanceof ConditionEvent)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isTheSameAs(BasicMSC basicMSC, LTSOutput lTSOutput) throws Exception {
        Instance instance = null;
        Instance instance2 = null;
        boolean bl = true;
        boolean bl2 = false;
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext() && bl) {
            String string = (String)iterator.next();
            if (bl2) {
                lTSOutput.outln("Checking component " + string);
            }
            try {
                instance = this.componentInstance(string);
                instance2 = basicMSC.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            if (bl2 && instance == null) {
                lTSOutput.outln(this.name + " does not have an Instance for that componment!");
            }
            if (bl2 && instance2 == null) {
                lTSOutput.outln(basicMSC.name + "does not have an Instance for that componment!");
            }
            bl = instance.isTheSameAs(instance2, lTSOutput);
        }
        return bl;
    }

    public void AddScenarioEvents() {
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Instance instance = (Instance)this.instances.get(string);
            OutputEvent outputEvent = new OutputEvent("s_" + string + "_" + this.name);
            outputEvent.setTo("Environment");
            instance.insertEvent(outputEvent, 0);
        }
    }

    public void RemoveScenarioEvents(Set set) {
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)this.instances.get((String)iterator.next());
            int n = 0;
            while (n < instance.size()) {
                Event event = instance.get(n);
                if (event instanceof OutputEvent && ((OutputEvent)event).getTo().equals("Environment") && event.getLabel().substring(0, 2).equals("s_")) {
                    set.add(event.getLabel());
                    instance.removeEvent(n);
                    --n;
                }
                ++n;
            }
        }
    }

    public void getScenarioEvents(Set set) {
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)this.instances.get((String)iterator.next());
            int n = 0;
            while (n < instance.size()) {
                Event event = instance.get(n);
                if (event instanceof OutputEvent && ((OutputEvent)event).getTo().equals("Environment") && event.getLabel().substring(0, 2).equals("s_")) {
                    set.add(event.getLabel());
                }
                ++n;
            }
        }
    }

    public void RemoveLabelsNotIn(StringSet stringSet) {
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)this.instances.get((String)iterator.next());
            int n = 0;
            while (n < instance.size()) {
                Event event = instance.get(n);
                if (event instanceof ConditionEvent && !stringSet.contains(event.getLabel())) {
                    instance.removeEvent(n);
                    --n;
                }
                ++n;
            }
        }
    }

    public String showSequence() {
        ListIterator listIterator;
        String string = "";
        int n = this.components().size();
        Vector<ListIterator> vector = new Vector<ListIterator>(n);
        Vector<String> vector2 = new Vector<String>(n);
        Vector<Event> vector3 = new Vector<Event>(n);
        int n2 = 0;
        Instance instance = new Instance();
        int n3 = 0;
        Event event = null;
        Event event2 = null;
        Iterator iterator = this.components().iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                instance = this.componentInstance(string2);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                // empty catch block
            }
            vector2.add(n4, string2);
            vector.add(n4++, instance.iterator());
        }
        n4 = 0;
        while (n4 < n) {
            listIterator = (ListIterator)vector.get(n4);
            event = null;
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                event = null;
            }
            vector3.add(n4, event);
            if (event == null) {
                ++n3;
            }
            ++n4;
        }
        HashSet hashSet = new HashSet();
        while (n3 < n) {
            boolean bl = false;
            n4 = 0;
            while (n4 < n && !bl) {
                event = (Event)vector3.get(n4);
                if (event != null) {
                    n2 = n4 + 1;
                    while (n2 < n && !bl) {
                        event2 = (Event)vector3.get(n2);
                        if (event2 != null && (bl = event.getLabel().equals(event2.getLabel()))) {
                            String string3;
                            String string4;
                            if (event2 instanceof OutputEvent) {
                                string4 = ((OutputEvent)event2).getTo();
                                string3 = ((InputEvent)event).getFrom();
                            } else {
                                string4 = ((OutputEvent)event).getTo();
                                string3 = ((InputEvent)event2).getFrom();
                            }
                            string = string + event2.getLabel() + ", ";
                        }
                        ++n2;
                    }
                }
                ++n4;
            }
            event = null;
            listIterator = (ListIterator)vector.get(n4 - 1);
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                event = null;
            }
            vector3.set(n4 - 1, event);
            if (event == null) {
                ++n3;
            }
            event = null;
            listIterator = (ListIterator)vector.get(n2 - 1);
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                event = null;
            }
            vector3.set(n2 - 1, event);
            if (event != null) continue;
            ++n3;
        }
        return string;
    }

    public Set getAllTraces(LTSOutput lTSOutput) throws Exception {
        Object object;
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("Getting traces");
        }
        HashSet hashSet = new HashSet();
        int n = this.components().size();
        Vector<Object> vector = new Vector<Object>(n);
        Vector<Event> vector2 = new Vector<Event>(n);
        Vector<String> vector3 = new Vector<String>(n);
        Vector<Integer> vector4 = new Vector<Integer>(n);
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.components().iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                object = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            vector3.add(n2, string);
            vector4.add(n2, new Integer(0));
            vector.add(n2++, object);
        }
        n2 = 0;
        while (n2 < n) {
            Event event;
            object = (Instance)vector.get(n2);
            int n4 = (Integer)vector4.get(n2);
            if (n4 < ((Instance)object).size()) {
                event = ((Instance)object).get(n4);
                vector4.set(n2, new Integer(n4 + 1));
            } else {
                event = null;
            }
            vector2.add(n2, event);
            if (event == null) {
                ++n3;
            }
            ++n2;
        }
        object = new Trace();
        HashMap hashMap = new HashMap();
        this.getTrace(hashSet, (Trace)object, vector, vector2, vector3, vector4, lTSOutput);
        return hashSet;
    }

    private boolean getTrace(Set set, Trace trace, Vector vector, Vector vector2, Vector vector3, Vector vector4, LTSOutput lTSOutput) throws Exception {
        Vector vector5;
        int n = 0;
        int n2 = this.components().size();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        if (bl4) {
            lTSOutput.outln("Printing Trace");
        }
        if ((vector5 = this.GetAllPairsThatCanBeMoved(n2, vector2, lTSOutput)).size() == 0) {
            set.add(trace);
        } else {
            n = 0;
            while (n * 2 < vector5.size()) {
                Vector vector6 = (Vector)vector2.clone();
                Vector vector7 = (Vector)vector4.clone();
                Event event = (Event)vector6.get((Integer)vector5.get(2 * n));
                Event event2 = (Event)vector6.get((Integer)vector5.get(2 * n + 1));
                if (bl4) {
                    lTSOutput.outln("About to move forward Indexes " + (Integer)vector5.get(2 * n) + ", " + (Integer)vector5.get(2 * n + 1) + ". Label " + event.getLabel() + event2.getLabel());
                }
                this.MoveForward(vector, vector7, vector6, (Integer)vector5.get(2 * n), lTSOutput);
                this.MoveForward(vector, vector7, vector6, (Integer)vector5.get(2 * n + 1), lTSOutput);
                if (bl4) {
                    lTSOutput.outln("Moved forward...");
                }
                Trace trace2 = trace.myClone();
                if (bl4) {
                    lTSOutput.outln("cloned...");
                }
                if (event instanceof OutputEvent) {
                    trace2.add(event.getLabel());
                } else {
                    trace2.add(event2.getLabel());
                }
                if (bl4) {
                    lTSOutput.outln("recursive call...");
                }
                this.getTrace(set, trace2, vector, vector6, vector3, vector7, lTSOutput);
                ++n;
            }
        }
        return bl2;
    }

    private Vector GetAllPairsThatCanBeMoved(int n, Vector vector, LTSOutput lTSOutput) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Vector<Integer> vector2 = new Vector<Integer>();
        boolean bl = false;
        n2 = 0;
        while (n2 < n) {
            Event event = (Event)vector.get(n2);
            if (event != null && !(event instanceof ConditionEvent)) {
                n3 = n2 + 1;
                while (n3 < n) {
                    Event event2 = (Event)vector.get(n3);
                    if (event2 != null && !(event2 instanceof ConditionEvent) && event.getLabel().equals(event2.getLabel())) {
                        if (bl) {
                            lTSOutput.outln("Indexes " + n2 + ", " + n3 + ". Label " + event.getLabel());
                        }
                        vector2.add(n4++, new Integer(n2));
                        vector2.add(n4++, new Integer(n3));
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return vector2;
    }

    public Set getFirstMoves(LTSOutput lTSOutput) throws Exception {
        Object object;
        Object object2;
        boolean bl = false;
        StringSet stringSet = new StringSet();
        HashSet hashSet = new HashSet();
        int n = this.components().size();
        Vector<Object> vector = new Vector<Object>(n);
        Vector<Event> vector2 = new Vector<Event>(n);
        Vector<String> vector3 = new Vector<String>(n);
        Vector<Integer> vector4 = new Vector<Integer>(n);
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.components().iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                object2 = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            vector3.add(n2, string);
            vector4.add(n2, new Integer(0));
            vector.add(n2++, object2);
        }
        n2 = 0;
        while (n2 < n) {
            object2 = (Instance)vector.get(n2);
            int n4 = (Integer)vector4.get(n2);
            if (n4 < ((Instance)object2).size()) {
                object = ((Instance)object2).get(n4);
                vector4.set(n2, new Integer(n4 + 1));
            } else {
                object = null;
            }
            vector2.add(n2, (Event)object);
            if (object == null) {
                ++n3;
            }
            ++n2;
        }
        object2 = this.GetAllPairsThatCanBeMoved(n, vector2, lTSOutput);
        n2 = 0;
        while (n2 * 2 < ((Vector)object2).size()) {
            Integer n5 = (Integer)((Vector)object2).get(2 * n2);
            object = (Integer)((Vector)object2).get(2 * n2 + 1);
            Event event = (Event)vector2.get(n5);
            String string = event.getLabel();
            if (bl) {
                lTSOutput.outln("Adding vector " + n5 + ", " + string + ", " + (Integer)object);
            }
            if (!stringSet.contains(string)) {
                stringSet.add(string);
                Vector<String> vector5 = new Vector<String>(3);
                if (event instanceof OutputEvent) {
                    vector5.add(0, (String)vector3.get(n5));
                    vector5.add(1, string);
                    vector5.add(2, (String)vector3.get((Integer)object));
                } else {
                    vector5.add(0, (String)vector3.get((Integer)object));
                    vector5.add(1, string);
                    vector5.add(2, (String)vector3.get(n5));
                }
                hashSet.add(vector5);
            }
            ++n2;
        }
        return hashSet;
    }

    public boolean hasCommonFirstMoves(BasicMSC basicMSC, LTSOutput lTSOutput) throws Exception {
        Set set = this.getFirstMoves(lTSOutput);
        Set set2 = basicMSC.getFirstMoves(lTSOutput);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            String string = (String)vector.get(1);
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                Vector vector2 = (Vector)iterator2.next();
                String string2 = (String)vector2.get(1);
                if (!string.equals(string2)) continue;
                lTSOutput.outln("Common intial message found: " + string);
                return true;
            }
        }
        return false;
    }

    public Set getLastMoves(LTSOutput lTSOutput) throws Exception {
        Object object;
        Object object2;
        boolean bl = false;
        StringSet stringSet = new StringSet();
        HashSet hashSet = new HashSet();
        int n = this.components().size();
        Vector<Object> vector = new Vector<Object>(n);
        Vector<Event> vector2 = new Vector<Event>(n);
        Vector<String> vector3 = new Vector<String>(n);
        Vector<Integer> vector4 = new Vector<Integer>(n);
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            lTSOutput.outln("Fill vectors: Names, Pos, Instances");
        }
        Iterator iterator = this.components().iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                object2 = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            vector3.add(n2, string);
            vector4.add(n2, new Integer(((Instance)object2).size() - 1));
            vector.add(n2++, object2);
        }
        if (bl) {
            lTSOutput.outln("Create enabledEvents and update InstancesFinished");
        }
        n2 = 0;
        while (n2 < n) {
            object2 = (Instance)vector.get(n2);
            int n4 = (Integer)vector4.get(n2);
            if (n4 >= 0) {
                object = ((Instance)object2).get(n4);
                vector4.set(n2, new Integer(n4 - 1));
            } else {
                object = null;
            }
            vector2.add(n2, (Event)object);
            if (object == null) {
                ++n3;
            }
            ++n2;
        }
        if (bl) {
            lTSOutput.outln("GetAllPairsThatCanBeMoved");
        }
        object2 = this.GetAllPairsThatCanBeMoved(n, vector2, lTSOutput);
        n2 = 0;
        while (n2 * 2 < ((Vector)object2).size()) {
            Integer n5 = (Integer)((Vector)object2).get(2 * n2);
            object = (Integer)((Vector)object2).get(2 * n2 + 1);
            Event event = (Event)vector2.get(n5);
            String string = event.getLabel();
            if (bl) {
                lTSOutput.outln("Adding vector " + n5 + ", " + string + ", " + (Integer)object);
            }
            if (!stringSet.contains(string)) {
                stringSet.add(string);
                Vector<String> vector5 = new Vector<String>(3);
                if (event instanceof OutputEvent) {
                    vector5.add(0, (String)vector3.get(n5));
                    vector5.add(1, string);
                    vector5.add(2, (String)vector3.get((Integer)object));
                } else {
                    vector5.add(0, (String)vector3.get((Integer)object));
                    vector5.add(1, string);
                    vector5.add(2, (String)vector3.get(n5));
                }
                hashSet.add(vector5);
            }
            ++n2;
        }
        return hashSet;
    }

    public boolean hasPostponableMessage(BasicMSC basicMSC, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("hasPostponableMessages?");
        }
        Set set = this.getLastMoves(lTSOutput);
        if (bl) {
            lTSOutput.outln("Got Last moves:" + set.size());
        }
        Set set2 = basicMSC.getFirstMoves(lTSOutput);
        if (bl) {
            lTSOutput.outln("Got First moves:" + set2.size());
        }
        Iterator iterator = set.iterator();
        boolean bl2 = false;
        while (iterator.hasNext() && !bl2) {
            Vector vector = (Vector)iterator.next();
            String string = (String)vector.get(0);
            String string2 = (String)vector.get(1);
            String string3 = (String)vector.get(2);
            Iterator iterator2 = set2.iterator();
            if (bl) {
                lTSOutput.outln("Got " + string2 + ", comparing");
            }
            while (iterator2.hasNext() && !bl2) {
                Vector vector2 = (Vector)iterator2.next();
                if (bl) {
                    lTSOutput.outln("Got " + (String)vector2.get(1));
                }
                if (string.equals((String)vector2.get(0)) || string.equals((String)vector2.get(2)) || string3.equals((String)vector2.get(0)) || string3.equals((String)vector2.get(2))) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    public Vector getIdOfLastMessage(String string, String string2, String string3) {
        Instance instance = this.getInstance(string);
        Instance instance2 = this.getInstance(string3);
        Vector<Integer> vector = new Vector<Integer>(2);
        vector.add(0, new Integer(instance.getIdOfLast()));
        vector.add(1, new Integer(instance2.getIdOfLast()));
        return vector;
    }

    public void removeLastMessage(String string, String string2, String string3) {
        Instance instance = this.getInstance(string);
        Instance instance2 = this.getInstance(string3);
        instance.deleteLast(1);
        instance2.deleteLast(1);
    }

    public boolean PartitionVerticaly(Set set, LTSOutput lTSOutput) {
        Object object;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add((String)iterator.next());
        }
        while (hashSet.size() != 0) {
            Iterator iterator2 = hashSet.iterator();
            object = (String)iterator2.next();
            StringSet stringSet = new StringSet();
            set.add(stringSet);
            stringSet.add(object);
            hashSet.remove(object);
            if (bl) {
                lTSOutput.outln("New Partition, added " + (String)object);
            }
            boolean bl2 = true;
            while (bl2) {
                bl2 = false;
                Iterator iterator3 = stringSet.iterator();
                while (iterator3.hasNext() && !bl2) {
                    Instance instance = this.getInstance((String)iterator3.next());
                    int n = 0;
                    while (n < instance.size()) {
                        String string = ((MessageEvent)instance.get(n)).getToFrom();
                        if (!stringSet.contains(string)) {
                            bl2 = true;
                            stringSet.add(string);
                            hashSet.remove(string);
                            if (bl) {
                                lTSOutput.outln("added " + string);
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        int n = 0;
        object = set.iterator();
        while (object.hasNext()) {
            if (((Set)object.next()).size() <= 1) continue;
            ++n;
        }
        return n > 1;
    }

    boolean OverlapsPartition(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Instance instance = this.getInstance(string);
            if (instance.size() <= 0) continue;
            return true;
        }
        return false;
    }

    boolean IndependentMessage(Set set) {
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set.contains(string)) continue;
            Instance instance = this.getInstance(string);
            int n = 0;
            while (n < instance.size()) {
                String string2 = ((MessageEvent)instance.get(n)).getToFrom();
                if (!set.contains(string2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean IsIndependent(BasicMSC basicMSC, LTSOutput lTSOutput) {
        lTSOutput.outln("C1");
        StringSet stringSet = this.getActiveComponents(lTSOutput);
        lTSOutput.outln("C2");
        StringSet stringSet2 = basicMSC.getActiveComponents(lTSOutput);
        return stringSet.intersection(stringSet2).size() == 0;
    }

    public StringSet getActiveComponents(LTSOutput lTSOutput) {
        StringSet stringSet = new StringSet();
        Iterator iterator = this.instances.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.getInstance(string).size() <= 0) continue;
            lTSOutput.outln(string);
            stringSet.add(string);
        }
        return stringSet;
    }

    BasicMSC getPostponables(BasicMSC basicMSC, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        BasicMSC basicMSC2 = (BasicMSC)basicMSC.clone();
        BasicMSC basicMSC3 = (BasicMSC)this.clone();
        BasicMSC basicMSC4 = new BasicMSC();
        basicMSC4.copyComponents(basicMSC);
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            Set set = basicMSC3.getLastMoves(lTSOutput);
            Set set2 = basicMSC2.getFirstMoves(lTSOutput);
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && !bl2) {
                Vector vector = (Vector)iterator.next();
                String string = (String)vector.get(0);
                String string2 = (String)vector.get(1);
                String string3 = (String)vector.get(2);
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext() && !bl2) {
                    Vector vector2 = (Vector)iterator2.next();
                    if (string.equals((String)vector2.get(0)) || string.equals((String)vector2.get(2)) || string3.equals((String)vector2.get(0)) || string3.equals((String)vector2.get(2))) continue;
                    if (bl) {
                        lTSOutput.outln("Found postponable action " + string2);
                    }
                    basicMSC3.removeLastMessage(string, string2, string3);
                    basicMSC2.addMessage(string, string2, string3);
                    basicMSC4.addMessage(string, string2, string3);
                    bl2 = true;
                }
            }
        }
        return basicMSC4;
    }

    public boolean hasEventId(int n) {
        Iterator iterator = this.components().iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)this.instances.get((String)iterator.next());
            int n2 = 0;
            while (n2 < instance.size()) {
                Event event = instance.get(n2);
                if (event.Id == n) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Map getDependencies(LTSOutput lTSOutput) {
        ListIterator listIterator;
        Object object;
        if (this.SavedDependencies != null) {
            return this.SavedDependencies;
        }
        boolean bl = false;
        int n = this.components().size();
        Vector<ListIterator> vector = new Vector<ListIterator>(n);
        Vector<Object> vector2 = new Vector<Object>(n);
        Vector<String> vector3 = new Vector<String>(n);
        Vector<Event> vector4 = new Vector<Event>(n);
        int n2 = 0;
        int n3 = 0;
        Event event = null;
        Event event2 = null;
        if (bl) {
            lTSOutput.outln("//Create Listiterators for instances");
        }
        Iterator iterator = this.components().iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            Instance instance;
            String string = (String)iterator.next();
            try {
                instance = this.componentInstance(string);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Error("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            vector3.add(n4, string);
            object = new StringSet();
            ((StringSet)object).add(string);
            vector2.add(n4, object);
            vector.add(n4++, instance.iterator());
        }
        if (bl) {
            lTSOutput.outln("//Create enabledEvents");
        }
        n4 = 0;
        while (n4 < n) {
            listIterator = (ListIterator)vector.get(n4);
            event = null;
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                event = null;
            }
            vector4.add(n4, event);
            if (event == null) {
                ++n3;
            }
            ++n4;
        }
        while (n3 < n) {
            boolean bl2 = false;
            n4 = 0;
            while (n4 < n && !bl2) {
                event = (Event)vector4.get(n4);
                if (event != null) {
                    n2 = n4 + 1;
                    while (n2 < n && !bl2) {
                        event2 = (Event)vector4.get(n2);
                        if (event2 != null) {
                            bl2 = event.getLabel().equals(event2.getLabel());
                        }
                        ++n2;
                    }
                }
                ++n4;
            }
            if (bl2) {
                if (bl) {
                    lTSOutput.outln("1");
                }
                ((Set)vector2.get(n4 - 1)).add(vector3.get(n2 - 1));
                ((Set)vector2.get(n2 - 1)).add(vector3.get(n4 - 1));
                if (bl) {
                    lTSOutput.outln("2");
                }
                ((Set)vector2.get(n4 - 1)).addAll((Set)vector2.get(n2 - 1));
                ((Set)vector2.get(n2 - 1)).addAll((Set)vector2.get(n4 - 1));
                if (bl) {
                    lTSOutput.outln("3");
                }
                event = null;
                listIterator = (ListIterator)vector.get(n4 - 1);
                while (listIterator.hasNext() && event == null) {
                    event = (Event)listIterator.next();
                    if (!(event instanceof ConditionEvent)) continue;
                    event = null;
                }
                vector4.set(n4 - 1, event);
                if (event == null) {
                    ++n3;
                }
                event = null;
                listIterator = (ListIterator)vector.get(n2 - 1);
                while (listIterator.hasNext() && event == null) {
                    event = (Event)listIterator.next();
                    if (!(event instanceof ConditionEvent)) continue;
                    event = null;
                }
                vector4.set(n2 - 1, event);
                if (event != null) continue;
                ++n3;
                continue;
            }
            object = "";
            n4 = 0;
            while (n4 < n) {
                object = (Event)vector4.get(n4) != null ? (String)object + ((Event)vector4.get(n4)).getLabel() : (String)object + "-";
                if (n4 + 1 < n) {
                    object = (String)object + ", ";
                }
                ++n4;
            }
            throw new Error("Inconsistent events in bMSC " + this.name + ". Impossible to pair one of the following event labels " + (String)object);
        }
        if (bl) {
            lTSOutput.outln("5");
        }
        object = new HashMap();
        int n5 = 0;
        while (n5 < n) {
            object.put(vector3.get(n5), vector2.get(n5));
            ++n5;
        }
        this.SavedDependencies = object;
        return this.SavedDependencies;
    }

    public Map getCanFinishBefore(LTSOutput lTSOutput) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        if (bl) {
            lTSOutput.outln("//getCanfinishBefore");
        }
        if (this.SavedCanFinishBefore != null) {
            return this.SavedCanFinishBefore;
        }
        int n = this.components().size();
        Vector<Object> vector = new Vector<Object>(n);
        Vector<String> vector2 = new Vector<String>(n);
        if (bl) {
            lTSOutput.outln("//Create Listiterators for instances");
        }
        Iterator iterator = this.components().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            vector2.add(n2, string);
            object = new StringSet();
            vector.add(n2++, object);
        }
        int n3 = 0;
        while (n3 < n) {
            object = (String)vector2.get(n3);
            StringSet stringSet = (StringSet)vector.get(n3);
            boolean bl3 = true;
            while (bl3) {
                stringSet.add(object);
                object = this.getLastDependency((String)object, lTSOutput);
                if (object == null) {
                    bl3 = false;
                    continue;
                }
                if (!stringSet.contains(object)) continue;
                bl3 = false;
            }
            if (stringSet.size() == 1) {
                stringSet.addAll((Collection)this.components());
            }
            ++n3;
        }
        object = new HashMap();
        int n4 = 0;
        while (n4 < n) {
            object.put(vector2.get(n4), vector.get(n4));
            if (bl2) {
                lTSOutput.outln("Canfinishbefore for " + vector2.get(n4) + " in " + this.name);
            }
            if (bl2) {
                ((StringSet)vector.get(n4)).print(lTSOutput);
            }
            ++n4;
        }
        this.SavedCanFinishBefore = object;
        return this.SavedCanFinishBefore;
    }

    public String getLastDependency(String string, LTSOutput lTSOutput) {
        ListIterator listIterator;
        boolean bl = false;
        boolean bl2 = false;
        if (bl2) {
            lTSOutput.outln("Get Last Dependency for " + string + " in " + this.name);
        }
        if (this.SavedLastDependencies != null) {
            return (String)this.SavedLastDependencies.get(string);
        }
        int n = this.components().size();
        int n2 = -1;
        Vector<ListIterator> vector = new Vector<ListIterator>(n);
        Vector<String> vector2 = new Vector<String>(n);
        Vector<String> vector3 = new Vector<String>(n);
        Vector<Event> vector4 = new Vector<Event>(n);
        int n3 = 0;
        int n4 = 0;
        Event event = null;
        Event event2 = null;
        if (bl) {
            lTSOutput.outln("//Create Listiterators for instances");
        }
        Iterator iterator = this.components().iterator();
        int n5 = 0;
        while (iterator.hasNext()) {
            Instance instance;
            String string2 = (String)iterator.next();
            try {
                instance = this.componentInstance(string2);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Error("Internal Consistency Error:" + componentInstanceNotFound.getMessage());
            }
            vector3.add(n5, string2);
            vector2.add(n5, null);
            if (string.equals(string2)) {
                n2 = n5;
            }
            vector.add(n5++, instance.iterator());
        }
        if (bl) {
            lTSOutput.outln("//Create enabledEvents");
        }
        n5 = 0;
        while (n5 < n) {
            listIterator = (ListIterator)vector.get(n5);
            event = null;
            while (listIterator.hasNext() && event == null) {
                event = (Event)listIterator.next();
                if (!(event instanceof ConditionEvent)) continue;
                event = null;
            }
            vector4.add(n5, event);
            if (event == null) {
                ++n4;
            }
            ++n5;
        }
        while (n4 < n) {
            boolean bl3 = false;
            n5 = 0;
            while (n5 < n && !bl3) {
                event = (Event)vector4.get(n5);
                if (event != null) {
                    n3 = n5 + 1;
                    while (n3 < n && !bl3) {
                        event2 = (Event)vector4.get(n3);
                        if (event2 != null) {
                            bl3 = event.getLabel().equals(event2.getLabel());
                        }
                        ++n3;
                    }
                }
                ++n5;
            }
            if (bl3) {
                vector2.set(n5 - 1, (String)vector3.get(n3 - 1));
                vector2.set(n3 - 1, (String)vector3.get(n5 - 1));
                event = null;
                listIterator = (ListIterator)vector.get(n5 - 1);
                while (listIterator.hasNext() && event == null) {
                    event = (Event)listIterator.next();
                    if (!(event instanceof ConditionEvent)) continue;
                    event = null;
                }
                vector4.set(n5 - 1, event);
                if (event == null) {
                    ++n4;
                }
                event = null;
                listIterator = (ListIterator)vector.get(n3 - 1);
                while (listIterator.hasNext() && event == null) {
                    event = (Event)listIterator.next();
                    if (!(event instanceof ConditionEvent)) continue;
                    event = null;
                }
                vector4.set(n3 - 1, event);
                if (event != null) continue;
                ++n4;
                continue;
            }
            String string3 = "";
            n5 = 0;
            while (n5 < n) {
                string3 = (Event)vector4.get(n5) != null ? string3 + ((Event)vector4.get(n5)).getLabel() : string3 + "-";
                if (n5 + 1 < n) {
                    string3 = string3 + ", ";
                }
                ++n5;
            }
            throw new Error("Inconsistent events in bMSC " + this.name + ". Impossible to pair one of the following event labels " + string3);
        }
        if (bl) {
            lTSOutput.outln("5");
        }
        HashMap hashMap = new HashMap();
        int n6 = 0;
        while (n6 < n) {
            hashMap.put(vector3.get(n6), vector2.get(n6));
            if (bl2) {
                lTSOutput.outln(vector3.get(n6) + " depends on " + vector2.get(n6));
            }
            ++n6;
        }
        this.SavedLastDependencies = hashMap;
        return (String)this.SavedLastDependencies.get(string);
    }
}

