/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.AbstractNegScenario;
import synthesis.AfterUntilNegScenario;
import synthesis.BasicMSC;
import synthesis.BasicNegScenario;
import synthesis.MyOutput;
import synthesis.NegScenario;
import synthesis.Pair;
import synthesis.Specification;
import synthesis.StringSet;
import synthesis.Trace;

public class ConstraintSynthesiser {
    public boolean printConstraints(MyOutput myOutput, Specification specification, String string, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("PrintConstraints");
        }
        if (specification.getNegbMSCs().size() > 0) {
            String string2 = "";
            boolean bl2 = true;
            Iterator iterator = specification.getNegbMSCs().iterator();
            while (iterator.hasNext()) {
                NegScenario negScenario;
                String string3 = (String)iterator.next();
                if (bl) {
                    lTSOutput.outln("Processing " + string3);
                }
                if ((negScenario = specification.getNegbMSC(string3)) instanceof AfterUntilNegScenario) {
                    this.PrintConstraint(specification.alphabet(), (AfterUntilNegScenario)negScenario, myOutput, lTSOutput);
                } else if (negScenario instanceof AbstractNegScenario) {
                    this.PrintConstraint(specification.alphabet(), (AbstractNegScenario)negScenario, myOutput, lTSOutput);
                } else if (negScenario instanceof BasicNegScenario) {
                    this.PrintConstraint(specification.alphabet(), (BasicNegScenario)negScenario, myOutput, lTSOutput);
                }
                if (bl2) {
                    bl2 = false;
                } else {
                    string2 = string2 + " || ";
                }
                string2 = string2 + string3;
            }
            string2 = "||" + string + " = (" + string2 + ").";
            myOutput.println(string2);
        } else {
            myOutput.println(string + " = STOP.");
        }
        return specification.getNegbMSCs().size() > 0;
    }

    private void PrintConstraint(StringSet stringSet, BasicNegScenario basicNegScenario, MyOutput myOutput, LTSOutput lTSOutput) throws Exception {
        HashMap hashMap;
        Trace trace;
        boolean bl = false;
        String string = basicNegScenario.name();
        String string2 = basicNegScenario.disallowed();
        BasicMSC basicMSC = basicNegScenario.precondition();
        if (bl) {
            lTSOutput.outln("Printing Constraint " + string);
        }
        basicMSC.name = string + "_Precondition";
        if (bl) {
            lTSOutput.outln("Building Complete Alphabet ");
        }
        if (!basicMSC.empty()) {
            if (bl) {
                lTSOutput.outln("Precondition is not empty.");
            }
            if (bl) {
                lTSOutput.outln("Building Prefixes.");
            }
            Set set = basicMSC.getAllTraces(lTSOutput);
            HashSet<Trace> hashSet = new HashSet<Trace>();
            HashSet hashSet2 = new HashSet();
            trace = this.getPrefixes(set, hashSet2, hashSet, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding prefix extending transitions.");
            }
            hashMap = new HashMap();
            this.PrefixExtendingTransitions(hashSet, hashMap, lTSOutput);
            if (bl) {
                lTSOutput.outln("Create Final State");
            }
            Iterator iterator = hashSet2.iterator();
            Trace trace2 = ((Trace)iterator.next()).myClone();
            trace2.add("ThisIsFinal");
            hashSet.add(trace2);
            if (bl) {
                lTSOutput.outln("Adding undefined transitions to Final state");
            }
            this.AddUndefinedTransitions(hashSet, hashMap, stringSet, trace2, lTSOutput);
            if (bl) {
                lTSOutput.outln("Removing constrained transition");
            }
            Iterator iterator2 = hashSet2.iterator();
            while (iterator2.hasNext()) {
                Trace trace3 = (Trace)iterator2.next();
                this.removeTransition(hashMap, trace3, string2, trace2, lTSOutput);
            }
        } else {
            lTSOutput.outln("Empty Precondition is not allowed in " + string);
            throw new Error();
        }
        this.printLTS(trace, basicMSC.name, hashMap.keySet(), hashMap, myOutput, lTSOutput);
        myOutput.println("||" + string + " = " + basicMSC.name + ".");
    }

    private void PrintConstraint(StringSet stringSet, AbstractNegScenario abstractNegScenario, MyOutput myOutput, LTSOutput lTSOutput) throws Exception {
        HashMap hashMap;
        Trace trace;
        HashSet hashSet;
        boolean bl = false;
        String string = abstractNegScenario.name();
        String string2 = abstractNegScenario.disallowed();
        BasicMSC basicMSC = abstractNegScenario.precondition();
        StringSet stringSet2 = abstractNegScenario.Alphabet();
        if (stringSet2 == null) {
            stringSet2 = new StringSet();
            stringSet2.addAll(stringSet);
        }
        if (bl) {
            lTSOutput.outln("Building Ignore");
        }
        StringSet stringSet3 = new StringSet();
        if (!stringSet2.contains(string2)) {
            stringSet3.add(string2);
        }
        if (bl) {
            stringSet3.print(lTSOutput);
        }
        if (bl) {
            lTSOutput.outln("Printing Constraint " + string);
        }
        basicMSC.name = string + "_Precondition";
        if (!basicMSC.empty()) {
            if (bl) {
                lTSOutput.outln("a");
            }
            Set set = basicMSC.getAllTraces(lTSOutput);
            HashSet hashSet2 = new HashSet();
            hashSet = new HashSet();
            trace = this.getPrefixes(set, hashSet, hashSet2, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding prefix extending transitions.");
            }
            hashMap = new HashMap();
            this.PrefixExtendingTransitions(hashSet2, hashMap, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding undefined transitions to suffixes");
            }
            this.AddUndefinedTransitionsToSuffixes(hashSet2, hashMap, stringSet2, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding undefined transitions as loops ");
            }
            this.AddUndefinedTransitionsToSelf(hashSet2, hashMap, stringSet3, lTSOutput);
            if (bl) {
                lTSOutput.outln("Removing disallowed transitions from Ending states");
            }
        } else {
            lTSOutput.outln("Empty Precondition is not allowed in " + string);
            throw new Error();
        }
        this.RemoveTransitionsStartingAt_andLabelledWith_(hashMap, hashSet, string2, lTSOutput);
        this.printLTS(trace, basicMSC.name, hashMap.keySet(), hashMap, myOutput, lTSOutput);
        myOutput.println("||" + string + " = " + basicMSC.name + ".");
    }

    private void PrintConstraint(StringSet stringSet, AfterUntilNegScenario afterUntilNegScenario, MyOutput myOutput, LTSOutput lTSOutput) throws Exception {
        HashMap hashMap;
        Trace trace;
        StringSet stringSet2;
        boolean bl = false;
        boolean bl2 = false;
        String string = afterUntilNegScenario.name();
        BasicMSC basicMSC = afterUntilNegScenario.after();
        String string2 = afterUntilNegScenario.disallowed();
        BasicMSC basicMSC2 = afterUntilNegScenario.until();
        StringSet stringSet3 = afterUntilNegScenario.afterAlphabet();
        if (stringSet3 == null) {
            stringSet3 = new StringSet();
            stringSet3.addAll(stringSet);
        }
        if ((stringSet2 = afterUntilNegScenario.untilAlphabet()) == null) {
            stringSet2 = new StringSet();
            stringSet2.addAll(stringSet);
        } else if (stringSet2.contains(string2)) {
            lTSOutput.outln("Disallowed action '" + string2 + "' included in until condition");
            throw new Error();
        }
        if (bl) {
            lTSOutput.outln("Printing Constraint " + string);
        }
        basicMSC.name = string + "_After";
        basicMSC2.name = string + "_Until";
        if (bl) {
            lTSOutput.outln("Building Complete Alphabet ");
        }
        StringSet stringSet4 = new StringSet();
        stringSet4.addAll(stringSet3);
        stringSet4.addAll(stringSet2);
        stringSet4.add(string2);
        if (bl) {
            stringSet4.print(lTSOutput);
        }
        if (bl) {
            lTSOutput.outln("Building AIgnore");
        }
        StringSet stringSet5 = new StringSet();
        stringSet5.addAll(stringSet4);
        stringSet5.removeAll(stringSet3);
        if (bl) {
            stringSet5.print(lTSOutput);
        }
        if (bl) {
            lTSOutput.outln("Building UIgnore ");
        }
        StringSet stringSet6 = new StringSet();
        stringSet6.addAll(stringSet4);
        stringSet6.removeAll(stringSet2);
        stringSet6.remove(string2);
        if (bl) {
            stringSet6.print(lTSOutput);
        }
        if (bl) {
            lTSOutput.outln("Removing " + string2 + " from UAlphabet");
        }
        if (bl) {
            stringSet2.print(lTSOutput);
        }
        if (stringSet2.contains(string2)) {
            stringSet2.remove(string2);
            if (bl) {
                stringSet2.print(lTSOutput);
            }
        } else if (bl) {
            lTSOutput.outln("not found");
        }
        if (!basicMSC.empty() && !basicMSC2.empty()) {
            if (bl) {
                lTSOutput.outln("a");
            }
            Set set = basicMSC.getAllTraces(lTSOutput);
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            trace = this.getPrefixes(set, hashSet2, hashSet, lTSOutput);
            Set set2 = basicMSC2.getAllTraces(lTSOutput);
            HashSet hashSet3 = new HashSet();
            HashSet hashSet4 = new HashSet();
            Trace trace2 = this.getPrefixes(set2, hashSet4, hashSet3, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding prefix extending transitions.");
            }
            HashMap hashMap2 = new HashMap();
            this.PrefixExtendingTransitions(hashSet, hashMap2, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding undefined transitions to Final state");
            }
            this.AddUndefinedTransitionsToSuffixes(hashSet, hashMap2, stringSet3, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding undefined transitions as loops ");
            }
            this.AddUndefinedTransitionsToSelf(hashSet, hashMap2, stringSet5, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding prefix extending transitions.");
            }
            HashMap hashMap3 = new HashMap();
            this.PrefixExtendingTransitions(hashSet3, hashMap3, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding undefined transitions to Final state");
            }
            this.AddUndefinedTransitionsToSuffixes(hashSet3, hashMap3, stringSet2, lTSOutput);
            if (bl) {
                lTSOutput.outln("Adding undefined transitions as loops ");
            }
            this.AddUndefinedTransitionsToSelf(hashSet3, hashMap3, stringSet6, lTSOutput);
            if (bl2) {
                this.printLTS(trace, "AfterLTS", hashMap2.keySet(), hashMap2, myOutput, lTSOutput);
            }
            if (bl2) {
                this.printLTS(trace2, "UntilLTS", hashMap3.keySet(), hashMap3, myOutput, lTSOutput);
            }
            HashMap hashMap4 = new HashMap();
            Pair pair = this.CrossProduct(hashSet, hashMap2, hashSet3, hashMap3, hashMap4, lTSOutput);
            if (bl2) {
                this.printLTS(pair, "CrossLTS", hashMap4.keySet(), hashMap4, myOutput, lTSOutput);
            }
            this.LinkUntilWithAfter(hashSet2, hashMap2, stringSet3, trace2, hashSet4, hashMap3, hashMap4, lTSOutput);
            this.LinkAfterWithUntil(hashSet2, hashMap2, trace2, hashMap4.keySet(), lTSOutput);
            hashMap = hashMap4;
            hashMap.putAll(hashMap2);
            if (bl2) {
                this.printLTS(trace, "WithUnreachable", hashMap.keySet(), hashMap, myOutput, lTSOutput);
            }
        } else {
            lTSOutput.outln("Empty After or Until is not allowed in " + string);
            throw new Error();
        }
        this.printLTS(trace, basicMSC.name, this.Reachable(hashMap, trace, lTSOutput), hashMap, myOutput, lTSOutput);
        myOutput.println("||" + string + " = " + basicMSC.name + ".");
    }

    private void LinkUntilWithAfter(Set set, Map map, Set set2, Trace trace, Set set3, Map map2, Map map3, LTSOutput lTSOutput) throws Exception {
        Object object;
        Iterator iterator;
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("LinkUntilWithAfter");
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Iterator iterator2 = map3.keySet().iterator();
        while (iterator2.hasNext()) {
            iterator = (Pair)iterator2.next();
            if (bl) {
                lTSOutput.outln("CombFrom: A:" + ((Pair)((Object)iterator)).After.getString() + " B:" + ((Pair)((Object)iterator)).Until.getString());
            }
            if (set3.contains(((Pair)((Object)iterator)).Until)) {
                hashSet2.add(iterator);
                if (!bl) continue;
                lTSOutput.outln("Removed");
                continue;
            }
            object = ((Set)map3.get(iterator)).iterator();
            while (object.hasNext()) {
                Object object2;
                Vector vector = (Vector)object.next();
                Pair pair = (Pair)vector.get(0);
                String string = (String)vector.get(1);
                Vector<Object> vector2 = new Vector<Object>();
                vector2.add(0, iterator);
                vector2.add(1, string);
                if (bl) {
                    lTSOutput.outln("lbl " + string);
                }
                if (bl) {
                    lTSOutput.outln("CombTo: A:" + pair.After.getString() + " B:" + pair.Until.getString());
                }
                if (set.contains(pair.After) && set3.contains(pair.Until)) {
                    if (bl) {
                        lTSOutput.outln("CombTo.A is END!! and CombTo.B is END!!");
                    }
                    if (!set2.contains(string)) {
                        if (bl) {
                            lTSOutput.outln("Send CombFrom to state in After which is maximal proper suffix of CombTo.A");
                        }
                        object2 = this.getMaximalSuffixOf(pair.After, map.keySet(), lTSOutput);
                        if (bl) {
                            lTSOutput.outln("BestTo: A:" + ((Trace)object2).getString());
                        }
                        vector2.add(2, object2);
                        hashSet.add(vector2);
                        continue;
                    }
                    if (bl) {
                        lTSOutput.outln("Force CombTo.B to reset: Send it to Init");
                    }
                    object2 = new Pair();
                    ((Pair)object2).After = pair.After;
                    ((Pair)object2).Until = trace;
                    vector2.add(2, this.getPair((Pair)object2, map3.keySet(), lTSOutput));
                    hashSet.add(vector2);
                    continue;
                }
                if (!set.contains(pair.After) && set3.contains(pair.Until)) {
                    if (bl) {
                        lTSOutput.outln("CombTo.A is not End!! and CombTo.B is END!!");
                    }
                    if (bl) {
                        lTSOutput.outln("Take CombFrom to state CombTo.A in A");
                    }
                    vector2.add(2, pair.After);
                    hashSet.add(vector2);
                    continue;
                }
                if (set.contains(pair.After) && !set3.contains(pair.Until)) {
                    if (bl) {
                        lTSOutput.outln("CombTo.A is END!! and CombTo.B is not END!!");
                    }
                    if (bl) {
                        lTSOutput.outln("Force CombTo.B to reset: Send it to Init");
                    }
                    object2 = new Pair();
                    ((Pair)object2).After = pair.After;
                    ((Pair)object2).Until = trace;
                    vector2.add(2, this.getPair((Pair)object2, map3.keySet(), lTSOutput));
                    hashSet.add(vector2);
                    continue;
                }
                if (!bl) continue;
                lTSOutput.outln("CombTo.A is not END!! and CombTo.B is not END!!");
            }
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Vector)iterator.next();
            this.addTransitions(map3, (Pair)((Vector)object).get(0), (String)((Vector)object).get(1), ((Vector)object).get(2), "Override", lTSOutput);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            map3.remove(iterator.next());
        }
    }

    private void LinkAfterWithUntil(Set set, Map map, Trace trace, Set set2, LTSOutput lTSOutput) throws Exception {
        Object object;
        Iterator iterator;
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("LinkAfterWithUntil");
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Iterator iterator2 = map.keySet().iterator();
        while (iterator2.hasNext()) {
            iterator = (Trace)iterator2.next();
            if (bl) {
                lTSOutput.outln("From: " + ((Trace)((Object)iterator)).getString() + "------------------");
            }
            if (set.contains(iterator)) {
                hashSet2.add(iterator);
                continue;
            }
            object = ((Set)map.get(iterator)).iterator();
            while (object.hasNext()) {
                Vector vector = (Vector)object.next();
                Trace trace2 = (Trace)vector.get(0);
                String string = (String)vector.get(1);
                if (bl) {
                    lTSOutput.outln("To: " + trace2.getString());
                }
                if (bl) {
                    lTSOutput.outln("Lbl: " + string);
                }
                if (set.contains(trace2)) {
                    if (bl) {
                        lTSOutput.outln("To is an ending trace");
                    }
                    Pair pair = new Pair();
                    pair.After = trace2;
                    pair.Until = trace;
                    Vector<Object> vector2 = new Vector<Object>();
                    vector2.add(0, iterator);
                    vector2.add(1, string);
                    vector2.add(2, this.getPair(pair, set2, lTSOutput));
                    hashSet.add(vector2);
                    continue;
                }
                if (!bl) continue;
                lTSOutput.outln("To is not an ending trace");
            }
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Vector)iterator.next();
            this.addTransitions(map, (Trace)((Vector)object).get(0), (String)((Vector)object).get(1), (Pair)((Vector)object).get(2), "Override", lTSOutput);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            map.remove(iterator.next());
        }
    }

    private Pair GetCombStateWithFixedUntilAndAfterIsAProperPrefixOf(Trace trace, Set set, Trace trace2, Set set2, LTSOutput lTSOutput) {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("Search for pair in CombStates that has B =" + trace2.getString());
        }
        if (bl) {
            lTSOutput.outln("           A is maximal proper suffix og =" + trace.getString());
        }
        Pair pair = new Pair();
        pair.After = this.getMaximalSuffixOf(trace, set, lTSOutput);
        pair.Until = trace2;
        return this.getPair(pair, set2, lTSOutput);
    }

    private Trace getMaximalSuffixOf(Trace trace, Set set, LTSOutput lTSOutput) {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("Looking for maximal suffix of " + trace.getString() + " in set of " + set.size() + " States");
        }
        Iterator iterator = set.iterator();
        Trace trace2 = null;
        int n = -1;
        while (iterator.hasNext()) {
            Trace trace3 = (Trace)iterator.next();
            if (bl) {
                lTSOutput.outln("We have a candidate " + trace3.getString());
            }
            if (trace.size() > trace3.size()) {
                if (bl) {
                    lTSOutput.outln("Could be a proper suffix");
                }
                if (trace3.size() > n) {
                    if (bl) {
                        lTSOutput.outln("And could be a longer suffix than previous");
                    }
                    if (trace3.equals(trace.subtrace(trace.size() - trace3.size()))) {
                        if (bl) {
                            lTSOutput.outln("Equal!");
                        }
                        trace2 = trace3;
                        n = trace3.size();
                        continue;
                    }
                    if (!bl) continue;
                    lTSOutput.outln("NotEqual!");
                    continue;
                }
                if (!bl) continue;
                lTSOutput.outln("Can't improve previous suffix");
                continue;
            }
            if (!bl) continue;
            lTSOutput.outln("Can't be PROPER suffix");
        }
        return trace2;
    }

    private Pair CrossProduct(Set set, Map map, Set set2, Map map2, Map map3, LTSOutput lTSOutput) {
        Pair pair;
        boolean bl = false;
        boolean bl2 = false;
        if (bl) {
            lTSOutput.outln("Get Initial states of When and Until Constraints");
        }
        Trace trace = this.getInit(set);
        Trace trace2 = this.getInit(set2);
        Pair pair2 = null;
        if (bl) {
            lTSOutput.outln("Initialise recursion");
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            pair = new Pair();
            pair.After = (Trace)iterator.next();
            pair.Until = trace2;
            hashSet.add(pair);
            if (pair.After != trace) continue;
            pair2 = pair;
        }
        if (bl2) {
            lTSOutput.outln("Building cross product");
        }
        while (hashSet.size() != 0) {
            pair = null;
            if (bl2) {
                lTSOutput.outln("Get a state to process");
            }
            Object object = hashSet.iterator();
            pair = (Pair)object.next();
            map3.put(pair, new HashSet());
            object = pair.Until;
            if (bl2) {
                lTSOutput.outln("U in state " + ((Trace)object).getString());
            }
            Trace trace3 = pair.After;
            if (bl2) {
                lTSOutput.outln("A is in state " + trace3.getString());
            }
            if (bl) {
                lTSOutput.outln("Get possible moves from A State...");
            }
            Iterator iterator2 = ((Set)map.get(trace3)).iterator();
            while (iterator2.hasNext()) {
                Object object2;
                Vector vector = (Vector)iterator2.next();
                String string = (String)vector.get(1);
                Trace trace4 = (Trace)vector.get(0);
                if (bl2) {
                    lTSOutput.outln("Got ToA " + trace4.getString());
                }
                if (bl2) {
                    lTSOutput.outln("Get move for " + string + " from U state");
                }
                Iterator iterator3 = ((Set)map2.get(object)).iterator();
                boolean bl3 = false;
                Trace trace5 = null;
                while (iterator3.hasNext() && !bl3) {
                    object2 = (Vector)iterator3.next();
                    bl3 = string.equals((String)((Vector)object2).get(1));
                    trace5 = (Trace)((Vector)object2).get(0);
                }
                if (!bl3) {
                    if (bl2) {
                        lTSOutput.outln("U state has not move for label " + string);
                    }
                    if (!bl2) continue;
                    lTSOutput.outln("It should be the disallowed, thus no transition should be created");
                    continue;
                }
                if (bl2) {
                    lTSOutput.outln("Found ToU " + trace5.getString());
                }
                if (set.contains(trace4) && set2.contains(trace5)) {
                    Pair pair3;
                    if (bl2) {
                        lTSOutput.outln("New state: ToA: " + trace4.getString() + " ToU: " + trace5.getString());
                    }
                    object2 = new Pair(trace4, trace5);
                    if (bl) {
                        lTSOutput.outln("getting equiv object if new state has already been reached...");
                    }
                    if ((pair3 = this.getPair((Pair)object2, map3.keySet(), lTSOutput)) == null) {
                        pair3 = this.getPair((Pair)object2, hashSet, lTSOutput);
                        if (pair3 == null) {
                            if (bl2) {
                                lTSOutput.outln("Its a new node...");
                            }
                            hashSet.add(object2);
                        } else {
                            object2 = pair3;
                        }
                    } else {
                        if (bl2) {
                            lTSOutput.outln("Its an old node...");
                        }
                        object2 = pair3;
                    }
                    if (bl2) {
                        lTSOutput.outln("adding transition...");
                    }
                    Vector<Object> vector2 = new Vector<Object>();
                    vector2.add(0, object2);
                    vector2.add(1, string);
                    ((Set)map3.get(pair)).add(vector2);
                    continue;
                }
                if (!bl) continue;
                lTSOutput.outln("Pair does not belong to the corss product");
            }
            if (bl) {
                lTSOutput.outln("removing processed state");
            }
            hashSet.remove(pair);
            if (!bl) continue;
            lTSOutput.outln("removed");
        }
        if (bl) {
            lTSOutput.outln("Finished");
        }
        return pair2;
    }

    private Set Reachable(Map map, Object object, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("Initialise recursion");
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        HashSet hashSet2 = new HashSet();
        while (hashSet.size() != 0) {
            Object e = null;
            if (bl) {
                lTSOutput.outln("Get a state to process");
            }
            Iterator iterator = hashSet.iterator();
            e = iterator.next();
            if (!map.keySet().contains(e)) {
                if (e instanceof Trace) {
                    throw new Exception("Found Deadlock state!" + ((Trace)e).getString());
                }
                if (e instanceof Pair) {
                    throw new Exception("Found Deadlock state! a:" + ((Pair)e).After.getString() + " b:" + ((Pair)e).Until.getString());
                }
                throw new Exception("Found Deadlock state! And cant figure out the type!");
            }
            iterator = ((Set)map.get(e)).iterator();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                String string = (String)vector.get(1);
                Object e2 = vector.get(0);
                if (hashSet2.contains(e2)) continue;
                hashSet.add(e2);
            }
            hashSet2.add(e);
            hashSet.remove(e);
        }
        return hashSet2;
    }

    private Trace getInit(Set set) {
        Trace trace = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && trace == null) {
            Trace trace2 = (Trace)iterator.next();
            if (trace2.size() != 0) continue;
            trace = trace2;
        }
        return trace;
    }

    private void PrefixExtendingTransitions(Set set, Map map, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("PrefixExtendingTransitions");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Trace trace = (Trace)iterator.next();
            if (bl) {
                lTSOutput.outln("Analysing From state:");
                trace.print(lTSOutput);
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Trace trace2 = (Trace)iterator2.next();
                if (bl) {
                    lTSOutput.outln("Looking at possible To state:");
                    trace2.print(lTSOutput);
                }
                if (trace2.size() != trace.size() + 1 || !trace.isPrefixOf(trace2)) continue;
                String string = trace2.get(trace2.size() - 1);
                if (bl) {
                    lTSOutput.outln("This pair requires a transition labelled: " + string);
                }
                this.addTransitions(map, trace, string, trace2, "Determinisitic", lTSOutput);
            }
        }
    }

    private void AddUndefinedTransitions(Set set, Map map, StringSet stringSet, Trace trace, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("AddUndefinedTransitions");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Trace trace2 = (Trace)iterator.next();
            if (bl) {
                lTSOutput.outln("Analysing From state:");
                trace2.print(lTSOutput);
            }
            Iterator iterator2 = stringSet.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (bl) {
                    lTSOutput.outln("Looking at label :" + string);
                }
                if (this.existsTransition(map, trace2, string, lTSOutput)) continue;
                if (bl) {
                    lTSOutput.outln("Found undefined label");
                }
                this.addTransitions(map, trace2, string, trace, "Determinisitic", lTSOutput);
            }
        }
    }

    private void AddUndefinedTransitionsToSuffixes(Set set, Map map, StringSet stringSet, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("AddUndefinedTransitionsToSuffixes");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Trace trace = (Trace)iterator.next();
            if (bl) {
                lTSOutput.outln("Analysing From state:");
                trace.print(lTSOutput);
            }
            Iterator iterator2 = stringSet.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (bl) {
                    lTSOutput.outln("Looking at label :" + string);
                }
                if (this.existsTransition(map, trace, string, lTSOutput)) continue;
                Trace trace2 = trace.myClone();
                trace2.add(string);
                if (bl) {
                    lTSOutput.outln("From_lbl:");
                    trace2.print(lTSOutput);
                }
                Trace trace3 = null;
                int n = -1;
                Iterator iterator3 = set.iterator();
                while (iterator3.hasNext()) {
                    Trace trace4 = (Trace)iterator3.next();
                    if (bl) {
                        lTSOutput.outln("Analysing To state:");
                        trace4.print(lTSOutput);
                    }
                    if (bl) {
                        lTSOutput.outln("From_lbl size = " + trace2.size() + ", To size =" + trace4.size());
                    }
                    if (trace2.size() <= trace4.size() || trace4.size() <= n) continue;
                    if (bl) {
                        lTSOutput.outln("Comparing with:");
                        trace2.subtrace(trace2.size() - trace4.size()).print(lTSOutput);
                    }
                    if (trace4.equals(trace2.subtrace(trace2.size() - trace4.size()))) {
                        if (bl) {
                            lTSOutput.outln("Equal!");
                        }
                        trace3 = trace4;
                        n = trace4.size();
                        continue;
                    }
                    if (!bl) continue;
                    lTSOutput.outln("NotEqual!");
                }
                if (trace3 == null) {
                    if (!bl) continue;
                    lTSOutput.outln("No Suffix:");
                    continue;
                }
                if (bl) {
                    lTSOutput.outln("Found Suffix:");
                    trace3.print(lTSOutput);
                }
                this.addTransitions(map, trace, string, trace3, "Determinisitic", lTSOutput);
            }
        }
    }

    private void AddUndefinedTransitionsToSelf(Set set, Map map, StringSet stringSet, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("AddUndefinedTransitionsToSelf");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Trace trace = (Trace)iterator.next();
            if (bl) {
                lTSOutput.outln("Analysing From state:");
                trace.print(lTSOutput);
            }
            Iterator iterator2 = stringSet.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (bl) {
                    lTSOutput.outln("Looking at label :" + string);
                }
                if (this.existsTransition(map, trace, string, lTSOutput)) continue;
                if (bl) {
                    lTSOutput.outln("Found undefined label");
                }
                this.addTransitions(map, trace, string, trace, "Determinisitic", lTSOutput);
            }
        }
    }

    private boolean existsTransition(Map map, Trace trace, String string, LTSOutput lTSOutput) {
        boolean bl = false;
        if (!map.keySet().contains(trace)) {
            return false;
        }
        Set set = (Set)map.get(trace);
        if (bl) {
            lTSOutput.outln("Check if there is a transition From---" + string + "--->");
        }
        boolean bl2 = false;
        Iterator iterator = set.iterator();
        Vector vector = null;
        while (iterator.hasNext() && !bl2) {
            vector = (Vector)iterator.next();
            if (bl) {
                lTSOutput.outln("Comparing with -" + (String)vector.get(1) + "-");
            }
            bl2 = string.equals((String)vector.get(1));
        }
        return bl2;
    }

    private boolean removeTransition(Map map, Trace trace, String string, Trace trace2, LTSOutput lTSOutput) {
        boolean bl = false;
        if (!map.keySet().contains(trace)) {
            return false;
        }
        Set set = (Set)map.get(trace);
        if (bl) {
            lTSOutput.outln("Check if there is a transition From---" + string + "--->");
        }
        boolean bl2 = false;
        Iterator iterator = set.iterator();
        Vector vector = null;
        while (iterator.hasNext()) {
            vector = (Vector)iterator.next();
            if (bl) {
                lTSOutput.outln("Comparing with " + (String)vector.get(1));
            }
            if (!string.equals((String)vector.get(1)) || !trace2.equals((Trace)vector.get(0))) continue;
            set.remove(vector);
            iterator = set.iterator();
            bl2 = true;
        }
        return bl2;
    }

    private boolean removeTransition(Map map, Trace trace, String string, LTSOutput lTSOutput) {
        boolean bl = false;
        if (!map.keySet().contains(trace)) {
            return false;
        }
        Set set = (Set)map.get(trace);
        if (bl) {
            lTSOutput.outln("Check if there is a transition From---" + string + "--->");
        }
        boolean bl2 = false;
        Iterator iterator = set.iterator();
        Vector vector = null;
        while (iterator.hasNext()) {
            vector = (Vector)iterator.next();
            if (bl) {
                lTSOutput.outln("Comparing with " + (String)vector.get(1));
            }
            if (!string.equals((String)vector.get(1))) continue;
            set.remove(vector);
            iterator = set.iterator();
            bl2 = true;
        }
        return bl2;
    }

    private void RemoveTransitionsStartingAt_andLabelledWith_(Map map, Set set, String string, LTSOutput lTSOutput) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Trace trace = (Trace)iterator.next();
            this.removeTransition(map, trace, string, lTSOutput);
        }
    }

    private void addTransitions(Map map, Object object, String string, Object object2, String string2, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (!map.keySet().contains(object)) {
            map.put(object, new HashSet());
        }
        Set set = (Set)map.get(object);
        if (bl) {
            lTSOutput.outln("Check if there is a transition From---" + string + "--->");
        }
        boolean bl2 = false;
        Iterator iterator = set.iterator();
        Vector vector = null;
        while (iterator.hasNext() && !bl2) {
            vector = (Vector)iterator.next();
            if (bl) {
                lTSOutput.outln("Comparing with " + (String)vector.get(1));
            }
            bl2 = string.equals((String)vector.get(1));
        }
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(0, object2);
        vector2.add(1, string);
        if (string2 == "Determinisitic") {
            if (bl2) {
                throw new Exception("Mode is determinisitic but there is a transition already!");
            }
            if (bl) {
                lTSOutput.outln("Add new transition");
            }
            set.add(vector2);
        } else if (string2 == "Override") {
            if (bl2) {
                if (bl) {
                    lTSOutput.outln("Delete existing and add current");
                }
                set.remove(vector);
                set.add(vector2);
            } else {
                if (bl) {
                    lTSOutput.outln("Add new transition");
                }
                set.add(vector2);
            }
        } else {
            throw new Exception("Unknown mode!");
        }
    }

    private Trace getPrefixes(Set set, Set set2, Set set3, LTSOutput lTSOutput) {
        Trace trace;
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("getPrefixes");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                lTSOutput.outln("gettingTrace");
            }
            trace = (Trace)iterator.next();
            if (bl) {
                lTSOutput.outln("gotTrace");
            }
            this.addPrefexis(set3, trace, set2, lTSOutput);
        }
        trace = new Trace();
        set3.add(trace);
        return trace;
    }

    private void addPrefexis(Set set, Trace trace, Set set2, LTSOutput lTSOutput) {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("addPrefexis");
        }
        Object var6_6 = null;
        boolean bl2 = false;
        int n = trace.size() - 1;
        while (n >= 0 && !bl2) {
            Trace trace2 = trace.subtrace(0, n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && !bl2) {
                Trace trace3 = (Trace)iterator.next();
                bl2 = trace2.equals(trace3);
            }
            if (!bl2) {
                set.add(trace2);
            }
            if (n == trace.size() - 1) {
                set2.add(trace2);
            }
            --n;
        }
    }

    private void printLTS(Object object, String string, Set set, Map map, MyOutput myOutput, LTSOutput lTSOutput) throws Exception {
        Object object2;
        boolean bl = false;
        boolean bl2 = true;
        HashMap hashMap = new HashMap();
        if (bl) {
            lTSOutput.outln("BuildMapping");
        }
        if (bl2) {
            myOutput.println("/*");
        }
        Iterator iterator = set.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 != object) {
                hashMap.put(object2, new Integer(n));
                if (bl2) {
                    if (object2 instanceof Trace) {
                        myOutput.println(n + "->" + ((Trace)object2).getString());
                    } else if (object2 instanceof Pair) {
                        myOutput.println(n + "-> (A:" + ((Pair)object2).After.getString() + ", B:" + ((Pair)object2).Until.getString() + ")");
                    }
                }
                ++n;
                continue;
            }
            hashMap.put(object2, new Integer(0));
            if (!bl2) continue;
            if (object2 instanceof Trace) {
                myOutput.println("0->" + ((Trace)object2).getString());
                continue;
            }
            if (!(object2 instanceof Pair)) continue;
            myOutput.println("0-> (A:" + ((Pair)object2).After.getString() + ", B:" + ((Pair)object2).Until.getString() + ")");
        }
        if (bl2) {
            myOutput.println("*/");
        }
        if (bl) {
            lTSOutput.outln("Initial declaration for When");
        }
        myOutput.println("" + string + " = N0,");
        if (bl) {
            lTSOutput.outln("Other declarations for When ");
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            object2 = (Integer)hashMap.get(e);
            myOutput.print("N" + object2 + "=");
            Iterator iterator2 = ((Set)map.get(e)).iterator();
            boolean bl3 = true;
            boolean bl4 = false;
            while (iterator2.hasNext()) {
                Vector vector = (Vector)iterator2.next();
                String string2 = (String)vector.get(1);
                Object e2 = vector.get(0);
                Integer n2 = (Integer)hashMap.get(e2);
                if (n2 == null) {
                    lTSOutput.outln("Node not found:");
                }
                if (bl3) {
                    myOutput.print("(");
                    bl3 = false;
                } else {
                    myOutput.print(" | ");
                }
                myOutput.print(string2 + " -> N" + n2);
            }
            if (!bl4) {
                myOutput.print(")");
            }
            if (iterator.hasNext()) {
                myOutput.println(",");
                continue;
            }
            myOutput.println(".");
        }
        if (bl) {
            lTSOutput.outln("Finished");
        }
    }

    private Trace getLoop(Map map, LTSOutput lTSOutput) {
        Trace trace = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext() && trace == null) {
            Trace trace2 = (Trace)iterator.next();
            if (!this.isEnd(trace2, map, lTSOutput)) continue;
            Set set = (Set)map.get(trace2);
            Iterator iterator2 = set.iterator();
            Vector vector = (Vector)iterator2.next();
            trace = (Trace)vector.get(2);
        }
        return trace;
    }

    private boolean isEnd(Trace trace, Map map, LTSOutput lTSOutput) {
        Iterator iterator;
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("In isEnd");
        }
        if ((iterator = ((Set)map.get(trace)).iterator()).hasNext()) {
            Vector vector = (Vector)iterator.next();
            String string = (String)vector.get(1);
            if (bl) {
                lTSOutput.outln("Out isEnd");
            }
            return string.equals("END");
        }
        if (bl) {
            lTSOutput.outln("Out isEnd");
        }
        return false;
    }

    private Pair getPair(Pair pair, Set set, LTSOutput lTSOutput) {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("In pairIn");
        }
        Iterator iterator = set.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Pair pair2 = (Pair)iterator.next();
            if (pair2.After != pair.After || pair2.Until != pair.Until) continue;
            return pair2;
        }
        if (bl) {
            lTSOutput.outln("out pairIn");
        }
        return null;
    }
}

