/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.InputEvent;
import synthesis.MessageEvent;
import synthesis.MyOutput;
import synthesis.OutputEvent;
import synthesis.StringSet;

public class Instance {
    private LinkedList list = new LinkedList();

    public void appendEvent(Event event) {
        this.list.add(event);
    }

    public void addEvent(Event event) {
        this.insertEvent(event, 0);
    }

    public ListIterator iterator() {
        return this.list.listIterator(0);
    }

    public int size() {
        return this.list.size();
    }

    public Event get(int n) {
        return (Event)this.list.get(n);
    }

    public void append(Instance instance) {
        ListIterator listIterator = instance.iterator();
        while (listIterator.hasNext()) {
            this.appendEvent((Event)listIterator.next());
        }
    }

    public void appendAndMap(Instance instance, Map map) {
        ListIterator listIterator = instance.iterator();
        while (listIterator.hasNext()) {
            MessageEvent messageEvent;
            Event event = (Event)listIterator.next();
            Event event2 = null;
            if (event instanceof ConditionEvent) {
                event2 = new ConditionEvent(event.getLabel());
            } else if (event instanceof OutputEvent) {
                messageEvent = new OutputEvent(event.getLabel());
                ((OutputEvent)messageEvent).setTo(new String(((OutputEvent)event).getTo()));
                event2 = messageEvent;
            } else {
                messageEvent = new InputEvent(event.getLabel());
                ((InputEvent)messageEvent).setFrom(new String(((InputEvent)event).getFrom()));
                event2 = messageEvent;
            }
            this.appendEvent(event2);
            map.put(event2, event);
        }
    }

    public int getFirstMessageEvent() {
        boolean bl = false;
        int n = 0;
        while (n < this.size() && !bl) {
            Event event = this.get(n);
            bl = !(event instanceof ConditionEvent);
            ++n;
        }
        if (bl) {
            return n - 1;
        }
        return -1;
    }

    public void removeConditions() {
        int n = 0;
        while (n < this.list.size()) {
            Event event = (Event)this.list.get(n);
            if (event instanceof ConditionEvent) {
                this.list.remove(n);
                --n;
            }
            ++n;
        }
    }

    public boolean containsConditions() {
        boolean bl = false;
        int n = 0;
        while (n < this.list.size() && !bl) {
            Event event = (Event)this.list.get(n);
            bl = event instanceof ConditionEvent;
            ++n;
        }
        return bl;
    }

    public void deleteCondition(String string) {
        int n = 0;
        while (n < this.list.size()) {
            Event event = (Event)this.list.get(n);
            if (event instanceof ConditionEvent && event.getLabel().equals(string)) {
                this.list.remove(n);
                --n;
            }
            ++n;
        }
    }

    public void addToAlphabet(StringSet stringSet) {
        int n = 0;
        while (n < this.list.size()) {
            Event event = (Event)this.list.get(n);
            if (!(event instanceof ConditionEvent)) {
                stringSet.add(event.getLabel());
            }
            ++n;
        }
    }

    public void insertEvent(Event event, int n) {
        this.list.add(n, event);
    }

    public void removeEvent(int n) {
        this.list.remove(n);
    }

    public void print(MyOutput myOutput) {
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            Event event = (Event)listIterator.next();
            if (event == null) {
                myOutput.println("////IS NULL");
                continue;
            }
            if (event instanceof ConditionEvent) {
                myOutput.println("   local " + event.getLabel() + ";");
                continue;
            }
            if (event instanceof OutputEvent) {
                myOutput.println("   out " + event.getLabel() + " to " + ((OutputEvent)event).getTo() + ";");
                continue;
            }
            myOutput.println("   in " + event.getLabel() + " from " + ((InputEvent)event).getFrom() + ";");
        }
    }

    public void print(LTSOutput lTSOutput) {
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            Event event = (Event)listIterator.next();
            if (event == null) {
                lTSOutput.outln("////IS NULL");
                continue;
            }
            if (event instanceof ConditionEvent) {
                lTSOutput.outln("   local " + event.getLabel() + ";");
                continue;
            }
            if (event instanceof OutputEvent) {
                lTSOutput.outln("   out " + event.getLabel() + " to " + ((OutputEvent)event).getTo() + ";");
                continue;
            }
            lTSOutput.outln("   in " + event.getLabel() + " from " + ((InputEvent)event).getFrom() + ";");
        }
    }

    public Object clone() {
        Instance instance = new Instance();
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            Event event;
            Event event2 = (Event)listIterator.next();
            if (event2 instanceof ConditionEvent) {
                event = new ConditionEvent(event2.getLabel());
                event.Id = event2.Id;
                instance.appendEvent(event);
                continue;
            }
            if (event2 instanceof OutputEvent) {
                event = new OutputEvent(event2.getLabel());
                ((OutputEvent)event).setTo(new String(((OutputEvent)event2).getTo()));
                ((OutputEvent)event).Id = event2.Id;
                instance.appendEvent(event);
                continue;
            }
            event = new InputEvent(event2.getLabel());
            ((InputEvent)event).setFrom(new String(((InputEvent)event2).getFrom()));
            ((InputEvent)event).Id = event2.Id;
            instance.appendEvent(event);
        }
        return instance;
    }

    public boolean isPrefixOf(Instance instance) {
        Event event = null;
        Event event2 = null;
        ListIterator listIterator = this.iterator();
        ListIterator listIterator2 = instance.iterator();
        boolean bl = true;
        while (bl && listIterator.hasNext()) {
            event = (Event)listIterator.next();
            if (event instanceof ConditionEvent) continue;
            boolean bl2 = false;
            while (!bl2 && listIterator2.hasNext()) {
                event2 = (Event)listIterator2.next();
                if (event2 instanceof ConditionEvent) continue;
                bl2 = true;
            }
            bl = bl2 ? event2.getLabel().equals(event.getLabel()) : false;
        }
        return bl;
    }

    public boolean isEmpty() {
        ListIterator listIterator = this.iterator();
        boolean bl = false;
        while (!bl && listIterator.hasNext()) {
            Event event = (Event)listIterator.next();
            boolean bl2 = bl = !(event instanceof ConditionEvent);
        }
        return !bl;
    }

    public void deleteLast(int n) {
        while (this.size() > 0 && n > 0) {
            this.list.remove(this.size() - 1);
            --n;
        }
    }

    public int getIdOfLast() {
        return ((Event)this.list.get((int)(this.size() - 1))).Id;
    }

    public boolean isTheSameAs(Instance instance, LTSOutput lTSOutput) {
        boolean bl = true;
        boolean bl2 = false;
        if (bl2) {
            lTSOutput.outln("Comparing instance: " + instance.size() + ", " + this.size());
        }
        if (instance.size() != this.size()) {
            return false;
        }
        if (bl2) {
            lTSOutput.outln("SameSize");
        }
        ListIterator listIterator = this.iterator();
        ListIterator listIterator2 = instance.iterator();
        while (listIterator.hasNext() && listIterator2.hasNext() && bl) {
            Event event = (Event)listIterator.next();
            Event event2 = (Event)listIterator2.next();
            if (bl2) {
                lTSOutput.outln("Checking evets " + event.getLabel() + " and " + event2.getLabel());
            }
            boolean bl3 = bl = event instanceof ConditionEvent && event2 instanceof ConditionEvent || event instanceof InputEvent && event2 instanceof InputEvent || event instanceof OutputEvent && event2 instanceof OutputEvent;
            if (!bl) continue;
            bl = event.getLabel().equals(event2.getLabel());
        }
        return bl;
    }

    public boolean outputs(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.size() && !bl) {
            Event event = this.get(n);
            if (event instanceof OutputEvent) {
                bl = event.getLabel().equals(string);
            }
            ++n;
        }
        return bl;
    }

    public boolean inputs(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.size() && !bl) {
            Event event = this.get(n);
            if (event instanceof InputEvent) {
                bl = event.getLabel().equals(string);
            }
            ++n;
        }
        return bl;
    }

    public StringSet getAlphabet() {
        StringSet stringSet = new StringSet();
        int n = 0;
        while (n < this.size()) {
            Event event = this.get(n);
            stringSet.add(event.getLabel());
            ++n;
        }
        return stringSet;
    }
}

