/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import synthesis.BasicMSC;
import synthesis.StringSet;

public class Node {
    public int Id;
    private ArrayList History;
    private Vector Positions;
    private int first;
    private int size;
    private Vector bMSCPositions;

    private Node() {
    }

    private void setLocation(int n, BasicMSC basicMSC) {
        this.bMSCPositions.set(n, basicMSC);
    }

    private void setPosition(int n, int n2) {
        this.Positions.set(n, new Integer(n2));
    }

    public BasicMSC getLocation(int n) {
        return (BasicMSC)this.bMSCPositions.get(n);
    }

    private int getPosition(int n) {
        return (Integer)this.Positions.get(n);
    }

    public int SizeOfDestiny() {
        return 1 + this.first;
    }

    public Node(int n, BasicMSC basicMSC) {
        this.size = n;
        this.History = new ArrayList();
        this.Positions = new Vector(this.size);
        this.bMSCPositions = new Vector(this.size);
        this.first = 0;
        this.History.add(this.first, basicMSC);
        int n2 = 0;
        while (n2 < this.size) {
            this.Positions.add(n2, new Integer(0));
            this.bMSCPositions.add(n2, basicMSC);
            ++n2;
        }
    }

    public void print(LTSOutput lTSOutput) {
        String string = "";
        String string2 = "Node : " + this.Id + " History : ";
        int n = 0;
        while (n < this.History.size()) {
            string2 = string2 + ((BasicMSC)this.History.get((int)n)).name + ", ";
            ++n;
        }
        lTSOutput.outln(string2);
        string2 = "";
        int n2 = 0;
        while (n2 < this.size) {
            string2 = string2 + this.getPosition(n2) + ", ";
            ++n2;
        }
        lTSOutput.outln(string2);
        string2 = "";
        int n3 = 0;
        while (n3 < this.size) {
            string2 = string2 + this.getLocation((int)n3).name + ", ";
            ++n3;
        }
        lTSOutput.outln(string2);
    }

    public boolean Move(int n, Map map, PrintStream printStream, LTSOutput lTSOutput) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = this.getPosition(n);
        BasicMSC basicMSC = (BasicMSC)this.History.get(n3 + 1);
        if (this.isFirst(n)) {
            throw new Error();
        }
        if (bl) {
            lTSOutput.outln("Checking if valid");
        }
        bl2 = this.validMove(n, basicMSC, map, printStream, lTSOutput);
        if (bl) {
            lTSOutput.outln("Valid");
        }
        boolean bl3 = false;
        if (n3 == 0) {
            n2 = 0;
            while (n2 < this.size && !bl3) {
                if (n2 != n) {
                    bl3 = this.getPosition(n2) == 0;
                }
                ++n2;
            }
        }
        if (n3 == 0 && !bl3) {
            n2 = 0;
            while (n2 < this.size) {
                if (n2 != n) {
                    this.setPosition(n2, this.getPosition(n2) - 1);
                }
                ++n2;
            }
            this.History.remove(0);
            this.setLocation(n, (BasicMSC)this.History.get(0));
            --this.first;
        } else {
            this.setPosition(n, ++n3);
            this.setLocation(n, basicMSC);
        }
        return bl2;
    }

    public boolean Move(int n, BasicMSC basicMSC, Map map, PrintStream printStream, LTSOutput lTSOutput) {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isFirst(n)) {
            throw new Error();
        }
        if (bl) {
            lTSOutput.outln("Checking if valid " + n + " - " + basicMSC.name);
        }
        bl2 = this.validMove(n, basicMSC, map, printStream, lTSOutput);
        if (bl) {
            lTSOutput.outln("Valid");
        }
        ++this.first;
        this.History.add(this.first, basicMSC);
        this.setPosition(n, this.first);
        this.setLocation(n, basicMSC);
        return bl2;
    }

    public boolean isFirst(int n) {
        return this.getPosition(n) == this.first;
    }

    public Node Clone() {
        Node node = new Node();
        node.first = this.first;
        node.size = this.size;
        node.Positions = (Vector)this.Positions.clone();
        node.bMSCPositions = (Vector)this.bMSCPositions.clone();
        node.History = (ArrayList)this.History.clone();
        return node;
    }

    private boolean equalLocations(Node node) {
        boolean bl = true;
        int n = 0;
        while (n < this.size && bl) {
            bl = this.getLocation(n) == node.getLocation(n);
            ++n;
        }
        return bl;
    }

    private boolean equalPositions(Node node) {
        boolean bl = true;
        int n = 0;
        while (n < this.size && bl) {
            bl = this.getPosition(n) == node.getPosition(n);
            ++n;
        }
        return bl;
    }

    private boolean equalHistory(Node node) {
        boolean bl = true;
        if (this.History.size() != node.History.size()) {
            return false;
        }
        int n = 0;
        while (n < this.History.size() && bl) {
            bl = this.History.get(n) == node.History.get(n);
            ++n;
        }
        return bl;
    }

    public boolean Equals(Node node) {
        boolean bl = true;
        if (!this.equalLocations(node)) {
            return false;
        }
        if (!this.equalPositions(node)) {
            return false;
        }
        if (!this.equalHistory(node)) {
            return false;
        }
        return this.first == node.first && this.size == node.size;
    }

    public Node eliminateLoop(LTSOutput lTSOutput) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n <= this.first) {
            BasicMSC basicMSC = (BasicMSC)this.History.get(n);
            int n2 = n + 1;
            while (n2 <= this.first) {
                if ((BasicMSC)this.History.get(n2) == basicMSC) {
                    boolean bl3 = true;
                    int n3 = 0;
                    while (n3 < this.size && bl3) {
                        bl3 = this.getPosition(n3) < n || this.getPosition(n3) >= n2;
                        ++n3;
                    }
                    if (bl3) {
                        Node node;
                        int n4;
                        Node node2 = this.Clone();
                        int n5 = n2 - n;
                        int n6 = 0;
                        while (n6 < this.size) {
                            if (this.getPosition(n6) >= n2) {
                                n4 = this.getPosition(n6) - n5;
                                node2.setPosition(n6, n4);
                            }
                            ++n6;
                        }
                        node2.first = this.first - n5;
                        n4 = 0;
                        while (n4 < n5) {
                            node2.History.remove(n);
                            ++n4;
                        }
                        if (bl) {
                            lTSOutput.outln("Eliminated loop!!");
                        }
                        if (bl) {
                            this.print(lTSOutput);
                        }
                        if (bl) {
                            node2.print(lTSOutput);
                        }
                        if ((node = node2.eliminateLoop(lTSOutput)) == null) {
                            return node2;
                        }
                        return node;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private boolean validMove(int n, BasicMSC basicMSC, Map map, PrintStream printStream, LTSOutput lTSOutput) {
        boolean bl = false;
        boolean bl2 = printStream != null;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = true;
        if (bl2) {
            boolean bl9 = this.validMove1(n, map, lTSOutput);
            boolean bl10 = this.validMove2(n, map, lTSOutput);
            boolean bl11 = true;
            boolean bl12 = this.validMove4(n, map, lTSOutput);
            boolean bl13 = this.validMove5(n, map, lTSOutput);
            boolean bl14 = this.validMove6(n, map, lTSOutput);
            printStream.println(bl9 + "," + bl10 + "," + bl11 + "," + bl12 + "," + bl13 + "," + bl13);
            return bl9 && bl10 && bl11 && bl12 && bl13 && bl14;
        }
        if (!bl3 || this.validMove1(n, map, lTSOutput)) {
            if (!bl4 || this.validMove2(n, map, lTSOutput)) {
                if (!bl5 || this.validMove3(n, map, lTSOutput)) {
                    if (!bl6 || this.validMove4(n, map, lTSOutput)) {
                        if (!bl7 || this.validMove5(n, map, lTSOutput)) {
                            if (!bl8 || this.validMove6(n, map, lTSOutput)) {
                                return true;
                            }
                            if (bl) {
                                lTSOutput.outln("Node " + this.Id + ": " + n + " - " + basicMSC.name + " violates Rule 6");
                            }
                        } else if (bl) {
                            lTSOutput.outln("Node " + this.Id + ": " + n + " - " + basicMSC.name + " violates Rule 5");
                        }
                    } else if (bl) {
                        lTSOutput.outln("Node " + this.Id + ": " + n + " - " + basicMSC.name + " violates Rule 4");
                    }
                } else if (bl) {
                    lTSOutput.outln("Node " + this.Id + ": " + n + " - " + basicMSC.name + " violates Rule 3");
                }
            } else if (bl) {
                lTSOutput.outln("Node " + this.Id + ": " + n + " - " + basicMSC.name + " violates Rule 2");
            }
        } else if (bl) {
            lTSOutput.outln("Node " + this.Id + ": " + n + " - " + basicMSC.name + " violates Rule 1");
        }
        return false;
    }

    private boolean validMove5(int n, Map map, LTSOutput lTSOutput) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isFirst(n)) {
            int n2 = this.getPosition(n);
            int n3 = 0;
            while (n3 < this.size && !bl2) {
                bl2 = n3 != n && n2 == this.getPosition(n3);
                ++n3;
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }

    private boolean validMove6(int n, Map map, LTSOutput lTSOutput) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getPosition(n);
        if (n4 == 1) {
            int n5 = 0;
            while (n5 < this.size && n2 + n3 <= 2) {
                if (this.getPosition(n5) == 1) {
                    ++n3;
                }
                if (this.getPosition(n5) == 0) {
                    ++n2;
                }
                ++n5;
            }
            if (n2 + n3 <= 2) {
                return false;
            }
        }
        return true;
    }

    private boolean validMove3(int n, Map map, LTSOutput lTSOutput) {
        boolean bl = false;
        BasicMSC basicMSC = this.getLocation(n);
        if (bl) {
            this.print(lTSOutput);
        }
        int n2 = this.getPosition(n);
        int n3 = 0;
        while (n3 < this.size) {
            if (n2 > this.getPosition(n3) && this.getLocation(n3) == basicMSC) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean validMove1(int n, Map map, LTSOutput lTSOutput) {
        boolean bl = false;
        BasicMSC basicMSC = this.getLocation(n);
        if (bl) {
            this.print(lTSOutput);
        }
        if (bl) {
            lTSOutput.outln("Get components needed in " + basicMSC.name + " so " + map.get(new Integer(n)) + "can move to next.");
        }
        StringSet stringSet = (StringSet)basicMSC.getDependencies(lTSOutput).get((String)map.get(new Integer(n)));
        if (bl) {
            lTSOutput.outln("Check if they are any components that haven't reached current and which c depends on.");
        }
        int n2 = this.getPosition(n);
        int n3 = 0;
        while (n3 < this.size) {
            if (n2 > this.getPosition(n3)) {
                if (bl) {
                    lTSOutput.outln(map.get(new Integer(n3)) + "is needed");
                }
                if (stringSet.contains(map.get(new Integer(n3)))) {
                    if (bl) {
                        lTSOutput.outln("AND IS NOT AVAILABLE");
                    }
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    private boolean validMove2(int n, Map map, LTSOutput lTSOutput) {
        boolean bl = false;
        boolean bl2 = false;
        BasicMSC basicMSC = this.getLocation(n);
        Map map2 = basicMSC.getCanFinishBefore(lTSOutput);
        String string = (String)map.get(new Integer(n));
        StringSet stringSet = (StringSet)map2.get(string);
        int n2 = 0;
        while (n2 < map.keySet().size()) {
            if (n2 != n && this.getPosition(n2) == this.getPosition(n)) {
                String string2 = (String)map.get(new Integer(n2));
                StringSet stringSet2 = (StringSet)map2.get(string2);
                if (!stringSet.contains(string2) && stringSet2.contains(string)) {
                    if (bl) {
                        lTSOutput.outln("ValidMove2: C = " + n);
                    }
                    if (bl) {
                        this.print(lTSOutput);
                    }
                    if (bl) {
                        lTSOutput.outln("Component " + string + ". Dependencies");
                    }
                    if (bl) {
                        stringSet.print(lTSOutput);
                    }
                    if (bl) {
                        lTSOutput.outln("Against Component " + string2 + ". Dependencies");
                    }
                    if (bl) {
                        stringSet2.print(lTSOutput);
                    }
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean validMove4(int n, Map map, LTSOutput lTSOutput) {
        boolean bl = false;
        BasicMSC basicMSC = this.getLocation(n);
        String string = (String)map.get(new Integer(n));
        int n2 = 0;
        while (n2 < map.keySet().size()) {
            String string2;
            String string3;
            if (n2 != n && this.getPosition(n2) > this.getPosition(n) && (string3 = basicMSC.getLastDependency(string2 = (String)map.get(new Integer(n2)), lTSOutput)) != null && string2.equals(basicMSC.getLastDependency(string3, lTSOutput)) && !string3.equals(string)) {
                int n3 = 0;
                while (n3 < map.keySet().size()) {
                    if (((String)map.get(new Integer(n3))).equals(string3) && this.getPosition(n3) <= this.getPosition(n)) {
                        if (bl) {
                            lTSOutput.outln("Moving " + string);
                        }
                        if (bl) {
                            this.print(lTSOutput);
                        }
                        if (bl) {
                            lTSOutput.outln("Found someone (" + string2 + ") who is more advanced and whose last partner (" + string3 + ") has not moved on");
                        }
                        return false;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return true;
    }
}

