/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.AbstractNegScenario;
import synthesis.AfterUntilNegScenario;
import synthesis.BasicMSC;
import synthesis.BasicNegScenario;
import synthesis.ComponentInstanceNotFound;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.NegScenario;
import synthesis.StringSet;

public class Specification {
    private HashSet Final = new HashSet();
    private HashSet Initial = new HashSet();
    private HashMap H = new HashMap();
    private HashMap NegScenarios = new HashMap();

    public void addbMSC(BasicMSC basicMSC) {
        if (!this.H.keySet().contains(basicMSC)) {
            this.H.put(basicMSC, new HashSet());
        }
    }

    public void addNegbMSC(String string, BasicMSC basicMSC, StringSet stringSet, String string2, BasicMSC basicMSC2, StringSet stringSet2) {
        NegScenario negScenario = basicMSC2 == null ? new AbstractNegScenario(string, basicMSC, stringSet, string2) : new AfterUntilNegScenario(string, basicMSC, stringSet, string2, basicMSC2, stringSet2);
        this.NegScenarios.put(string, negScenario);
    }

    public void addBasicNegbMSC(String string, BasicMSC basicMSC, String string2) {
        BasicNegScenario basicNegScenario = new BasicNegScenario(string, basicMSC, string2);
        this.NegScenarios.put(string, basicNegScenario);
    }

    public void addRelation(BasicMSC basicMSC, BasicMSC basicMSC2) {
        if (!((Set)this.H.get(basicMSC)).contains(basicMSC2)) {
            ((Set)this.H.get(basicMSC)).add(basicMSC2);
        }
    }

    public void addRelationInit(BasicMSC basicMSC) {
        if (!this.Initial.contains(basicMSC)) {
            this.Initial.add(basicMSC);
        }
    }

    public void addRelationFinal(BasicMSC basicMSC) {
        if (!this.Final.contains(basicMSC)) {
            this.Final.add(basicMSC);
        }
    }

    public Set getbMSCs() {
        return this.H.keySet();
    }

    public Set getNegbMSCs() {
        return this.NegScenarios.keySet();
    }

    public NegScenario getNegbMSC(String string) {
        return (NegScenario)this.NegScenarios.get(string);
    }

    public void removebMSC(BasicMSC basicMSC) {
        this.H.remove(basicMSC);
    }

    public Set getContinuationsInit() {
        return this.Initial;
    }

    public Set getContinuationsFinal() {
        return this.Final;
    }

    public Set getContinuations(BasicMSC basicMSC) {
        return (Set)this.H.get(basicMSC);
    }

    public BasicMSC getBMsc(String string) throws Exception {
        BasicMSC basicMSC = new BasicMSC();
        boolean bl = false;
        Iterator iterator = this.H.keySet().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            if (!basicMSC.name.equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return basicMSC;
        }
        throw new Exception("BMSc Not Found");
    }

    public boolean containsBMsc(String string) {
        boolean bl = false;
        Iterator iterator = this.H.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            bl = basicMSC.name.equals(string);
        }
        if (!bl) {
            iterator = this.NegScenarios.keySet().iterator();
            while (iterator.hasNext() && !bl) {
                bl = ((String)iterator.next()).equals(string);
            }
        }
        return bl;
    }

    public boolean hasSamePositiveBehaviour(Specification specification, LTSOutput lTSOutput) {
        try {
            Object object;
            Iterator iterator;
            Object object2;
            Object object3;
            boolean bl = true;
            bl = this.getbMSCs().size() == specification.getbMSCs().size();
            Iterator iterator2 = this.getbMSCs().iterator();
            while (iterator2.hasNext() && bl) {
                object3 = (BasicMSC)iterator2.next();
                if (specification.containsBMsc(((BasicMSC)object3).name)) {
                    object2 = specification.getBMsc(((BasicMSC)object3).name);
                    bl = ((BasicMSC)object3).isTheSameAs((BasicMSC)object2, lTSOutput);
                    if (bl) {
                        bl = this.getContinuations((BasicMSC)object3).size() == specification.getContinuations((BasicMSC)object2).size();
                    }
                    iterator = this.getContinuations((BasicMSC)object3).iterator();
                    while (iterator.hasNext() && bl) {
                        String string = ((BasicMSC)iterator.next()).name;
                        object = specification.getContinuations((BasicMSC)object2).iterator();
                        boolean bl2 = false;
                        while (object.hasNext() && !bl2) {
                            String string2 = ((BasicMSC)object.next()).name;
                            bl2 = string.equals(string2);
                        }
                        bl = bl2;
                    }
                    continue;
                }
                bl = false;
            }
            object3 = this.getContinuationsInit().iterator();
            while (object3.hasNext() && bl) {
                object2 = ((BasicMSC)object3.next()).name;
                iterator = specification.getContinuationsInit().iterator();
                boolean bl3 = false;
                while (iterator.hasNext() && !bl3) {
                    object = ((BasicMSC)iterator.next()).name;
                    bl3 = ((String)object2).equals(object);
                }
                bl = bl3;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new Error();
        }
    }

    public Set components() {
        Iterator iterator = this.H.keySet().iterator();
        if (iterator.hasNext()) {
            return ((BasicMSC)iterator.next()).components();
        }
        return new HashSet();
    }

    public Map getComponentInstances(String string) throws Exception {
        HashMap<String, Instance> hashMap = new HashMap<String, Instance>();
        Iterator iterator = this.H.keySet().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            try {
                hashMap.put(basicMSC.name, basicMSC.componentInstance(string));
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new Exception("Component instance '" + string + "' cannot be found in bMSC '" + basicMSC.name + "'.");
            }
        }
        return hashMap;
    }

    public boolean containsConditions() throws Exception {
        boolean bl = false;
        Iterator iterator = this.H.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            bl = basicMSC.containsConditions();
        }
        return bl;
    }

    public void removeConditions() throws Exception {
        Iterator iterator = this.H.keySet().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            basicMSC.removeConditions();
        }
    }

    public void checkConsistency() throws Exception {
        boolean bl = true;
        this.consistentLabels();
        this.consistentEvents();
        this.bMSCLabels();
    }

    private Map consistentLabels() throws Exception {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            ((BasicMSC)iterator.next()).consistentLabels(hashMap);
        }
        iterator = this.getNegbMSCs().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NegScenario negScenario = this.getNegbMSC(string);
            if (negScenario instanceof BasicNegScenario) {
                ((BasicNegScenario)negScenario).precondition().consistentLabels(hashMap);
                continue;
            }
            if (negScenario instanceof AbstractNegScenario) {
                ((AbstractNegScenario)negScenario).precondition().consistentLabels(hashMap);
                continue;
            }
            if (negScenario instanceof AfterUntilNegScenario) {
                ((AfterUntilNegScenario)negScenario).after().consistentLabels(hashMap);
                ((AfterUntilNegScenario)negScenario).until().consistentLabels(hashMap);
                continue;
            }
            throw new Exception("Unknown negative scenario");
        }
        return hashMap;
    }

    private void bMSCLabels() throws Exception {
        Iterator iterator = this.getbMSCs().iterator();
        if (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            Iterator iterator2 = basicMSC.components().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (!this.containsBMsc(string)) continue;
                throw new Exception("Label " + string + " is used for a bMSC and a message");
            }
        }
    }

    public Map getLabelMap() {
        try {
            Map map = this.consistentLabels();
            return map;
        }
        catch (Exception exception) {
            return new HashMap();
        }
    }

    public StringSet alphabet() {
        StringSet stringSet = new StringSet();
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            ((BasicMSC)iterator.next()).addToAlphabet(stringSet);
        }
        return stringSet;
    }

    private void consistentEvents() throws Exception {
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            ((BasicMSC)iterator.next()).consistentEvents();
        }
    }

    private void sameComponents() throws ComponentInstanceNotFound {
        BasicMSC basicMSC = null;
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            if (basicMSC == null) {
                basicMSC = (BasicMSC)iterator.next();
                continue;
            }
            BasicMSC basicMSC2 = (BasicMSC)iterator.next();
            try {
                basicMSC.hasAllComponentsIn(basicMSC2);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new ComponentInstanceNotFound("bMSC" + basicMSC2.name + " does not contain an instance for " + componentInstanceNotFound.getMessage());
            }
            try {
                basicMSC2.hasAllComponentsIn(basicMSC);
            }
            catch (ComponentInstanceNotFound componentInstanceNotFound) {
                throw new ComponentInstanceNotFound("bMSC" + basicMSC.name + " does not contain an instance for " + componentInstanceNotFound.getMessage());
            }
        }
    }

    public void print(MyOutput myOutput) {
        BasicMSC basicMSC;
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            basicMSC.print(myOutput);
        }
        myOutput.println("hmsc;");
        iterator = this.getContinuationsInit().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            myOutput.println("Init -> " + basicMSC.name + ";");
        }
        iterator = this.getContinuationsFinal().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            myOutput.println(basicMSC.name + " -> Stop;");
        }
        Iterator iterator2 = this.getbMSCs().iterator();
        while (iterator2.hasNext()) {
            BasicMSC basicMSC2 = (BasicMSC)iterator2.next();
            iterator = this.getContinuations(basicMSC2).iterator();
            while (iterator.hasNext()) {
                basicMSC = (BasicMSC)iterator.next();
                myOutput.println(basicMSC2.name + " -> " + basicMSC.name + ";");
            }
        }
        myOutput.println("endhmsc");
    }

    public void printLatex(StringBuffer stringBuffer) {
        BasicMSC basicMSC;
        MyOutput myOutput = new MyOutput(stringBuffer);
        myOutput.println("\\documentclass{article}");
        myOutput.println("\\usepackage{msc}");
        myOutput.println("\\begin{document}");
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            basicMSC.printLatex(myOutput);
        }
        myOutput.println("hmsc;");
        myOutput.println("");
        myOutput.println("");
        iterator = this.getContinuationsInit().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            myOutput.println("Init $\\Rightarrow$ " + basicMSC.name.replace('_', '.') + ";");
            myOutput.println("");
            myOutput.println("");
        }
        Iterator iterator2 = this.getbMSCs().iterator();
        while (iterator2.hasNext()) {
            BasicMSC basicMSC2 = (BasicMSC)iterator2.next();
            iterator = this.getContinuations(basicMSC2).iterator();
            while (iterator.hasNext()) {
                basicMSC = (BasicMSC)iterator.next();
                myOutput.println(basicMSC2.name.replace('_', '.') + " $\\Rightarrow$ " + basicMSC.name.replace('_', '.') + ";");
                myOutput.println("");
                myOutput.println("");
            }
        }
        iterator = this.getContinuationsFinal().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            myOutput.println(basicMSC.name.replace('_', '.') + " $\\Rightarrow$ Stop;");
            myOutput.println("");
            myOutput.println("");
        }
        myOutput.println("endhmsc");
        myOutput.println("");
        myOutput.println("");
        myOutput.println("\\end{document}");
    }

    public boolean identicalbMSCs(BasicMSC basicMSC, BasicMSC basicMSC2, LTSOutput lTSOutput) throws Exception {
        boolean bl = true;
        bl = basicMSC.isTheSameAs(basicMSC2, lTSOutput);
        return bl;
    }

    public void replaceAndDelete(BasicMSC basicMSC, BasicMSC basicMSC2, LTSOutput lTSOutput) {
        if (this.Initial.contains(basicMSC)) {
            this.addRelationInit(basicMSC2);
            this.Initial.remove(basicMSC);
        }
        if (this.Final.contains(basicMSC)) {
            this.addRelationInit(basicMSC2);
            this.Final.remove(basicMSC);
        }
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC3 = (BasicMSC)iterator.next();
            Set set = (Set)this.H.get(basicMSC3);
            if (!set.contains(basicMSC)) continue;
            set.add(basicMSC2);
            set.remove(basicMSC);
        }
        this.H.remove(basicMSC);
    }

    public void AddScenarioMessages() {
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            basicMSC.AddScenarioEvents();
        }
    }

    public Set RemoveScenarioMessages() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            basicMSC.RemoveScenarioEvents(hashSet);
        }
        return hashSet;
    }

    public Set getScenarioMessages() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            basicMSC.getScenarioEvents(hashSet);
        }
        return hashSet;
    }

    public void RemoveLabelsNotIn(StringSet stringSet) {
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            basicMSC.RemoveLabelsNotIn(stringSet);
        }
    }

    public boolean Normalised(LTSOutput lTSOutput) throws Exception {
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            Set set = this.getContinuations(basicMSC);
            if (set.size() <= 1) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                BasicMSC basicMSC2 = (BasicMSC)iterator2.next();
                Iterator iterator3 = set.iterator();
                while (iterator3.hasNext()) {
                    BasicMSC basicMSC3 = (BasicMSC)iterator3.next();
                    if (basicMSC2 == basicMSC3 || !basicMSC2.hasCommonFirstMoves(basicMSC3, lTSOutput)) continue;
                    lTSOutput.outln(basicMSC2.name + " and " + basicMSC3.name + " have common initial messages.");
                    return false;
                }
            }
        }
        return true;
    }

    public void eliminateEmptyScenarios(LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("eliminating");
        }
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            if (bl) {
                lTSOutput.outln("got " + basicMSC.name);
            }
            boolean bl2 = false;
            if (basicMSC.empty()) {
                Object object;
                bl2 = true;
                if (bl) {
                    lTSOutput.outln("its empty!");
                }
                Set set = this.getContinuations(basicMSC);
                Iterator iterator2 = this.getbMSCs().iterator();
                while (iterator2.hasNext()) {
                    object = (BasicMSC)iterator2.next();
                    if (bl) {
                        lTSOutput.outln("looking at " + ((BasicMSC)object).name);
                    }
                    if (!this.getContinuations((BasicMSC)object).contains(basicMSC)) continue;
                    if (bl) {
                        lTSOutput.outln("adding  continuations");
                    }
                    Iterator iterator3 = set.iterator();
                    while (iterator3.hasNext()) {
                        this.getContinuations((BasicMSC)object).add(iterator3.next());
                    }
                    if (bl) {
                        lTSOutput.outln("removing continuations");
                    }
                    this.getContinuations((BasicMSC)object).remove(basicMSC);
                }
                if (this.getContinuationsInit().contains(basicMSC)) {
                    if (bl) {
                        lTSOutput.outln("adding from Init");
                    }
                    object = set.iterator();
                    while (object.hasNext()) {
                        this.getContinuationsInit().add(object.next());
                    }
                    if (bl) {
                        lTSOutput.outln("removing continuations");
                    }
                    this.getContinuationsInit().remove(basicMSC);
                }
            }
            if (!bl2) continue;
            this.removebMSC(basicMSC);
            iterator = this.getbMSCs().iterator();
        }
    }

    private boolean DetectCycle(BasicMSC basicMSC, Set set, LTSOutput lTSOutput) {
        Iterator iterator = this.getContinuations(basicMSC).iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            bl = this.DetectCycleRec(basicMSC, (BasicMSC)iterator.next(), set, lTSOutput);
        }
        return bl;
    }

    private boolean DetectCycleRec(BasicMSC basicMSC, BasicMSC basicMSC2, Set set, LTSOutput lTSOutput) {
        if (basicMSC == basicMSC2) {
            return true;
        }
        if (basicMSC2.OverlapsPartition(set)) {
            return false;
        }
        Iterator iterator = this.getContinuations(basicMSC2).iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            bl = this.DetectCycleRec(basicMSC, (BasicMSC)iterator.next(), set, lTSOutput);
        }
        return bl;
    }

    private void CheckRegularLanguage(BasicMSC basicMSC, Set set, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln(basicMSC.name + "can be partitionedVerticaly in a non-trivial way");
        }
        Iterator iterator = set.iterator();
        boolean bl2 = false;
        while (iterator.hasNext() && !bl2) {
            Set set2 = (Set)iterator.next();
            if (set2.size() <= 1) continue;
            if (bl) {
                lTSOutput.outln("Checking cycle for a partition");
            }
            bl2 = this.DetectCycle(basicMSC, set2, lTSOutput);
        }
        if (bl2) {
            throw new Exception("Non regular language: Loop from bMSC " + basicMSC.name);
        }
    }

    private void CheckRegularLanguage(LTSOutput lTSOutput) throws Exception {
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet;
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            if (!basicMSC.PartitionVerticaly(hashSet = new HashSet(), lTSOutput)) continue;
            this.CheckRegularLanguage(basicMSC, hashSet, lTSOutput);
        }
    }

    public void Interleave(LTSOutput lTSOutput) throws Exception {
        this.CheckRegularLanguage(lTSOutput);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        int n = 0;
        while (this.FindAndApplyRules(hashMap, hashMap2, hashMap3, n++, lTSOutput)) {
        }
    }

    private boolean FindAndApplyRules(Map map, Map map2, Map map3, int n, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("Finding and Applying rules");
        }
        boolean bl2 = true;
        boolean bl3 = false;
        Iterator iterator = this.getbMSCs().iterator();
        bl2 = false;
        if (bl) {
            lTSOutput.outln("Starting cylce I");
        }
        while (iterator.hasNext() && !bl2) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            Set set = this.getContinuations(basicMSC);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && !bl2) {
                BasicMSC basicMSC2;
                if (bl) {
                    lTSOutput.outln("About to apply rule");
                }
                if (basicMSC != (basicMSC2 = (BasicMSC)iterator2.next())) {
                    if (this.PreConditionSequence(basicMSC, basicMSC2, map)) {
                        bl2 = this.ApplySequenceRules(basicMSC, basicMSC2, map, map2, map3, n, lTSOutput);
                    }
                } else {
                    bl2 = this.ApplyRuleLoop(basicMSC, map, map2, map3, n, lTSOutput);
                }
                if (!bl) continue;
                lTSOutput.outln("Finished applying rule");
            }
            if (!bl) continue;
            lTSOutput.outln("Finished cylce J1");
        }
        if (bl) {
            lTSOutput.outln("Finished cylce I");
        }
        return bl2;
    }

    private boolean PreConditionSequence(BasicMSC basicMSC, BasicMSC basicMSC2, Map map) {
        if (this.getContinuations(basicMSC).contains(basicMSC) && map.keySet().contains(basicMSC) && !((Set)map.get(basicMSC)).contains(basicMSC)) {
            return false;
        }
        return !this.getContinuations(basicMSC2).contains(basicMSC2) || !map.keySet().contains(basicMSC2) || ((Set)map.get(basicMSC2)).contains(basicMSC2);
    }

    private boolean ApplyRuleLoop(BasicMSC basicMSC, Map map, Map map2, Map map3, int n, LTSOutput lTSOutput) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = true;
        boolean bl2 = true;
        if (!map.keySet().contains(basicMSC)) {
            map.put(basicMSC, new HashSet());
        }
        if (((Set)map.get(basicMSC)).contains(basicMSC)) {
            return false;
        }
        if (bl) {
            lTSOutput.outln("");
        }
        if (bl) {
            lTSOutput.outln("ApplyRuleLoop" + basicMSC.name + ", " + basicMSC.name);
        }
        StringSet stringSet = new StringSet();
        BasicMSC basicMSC2 = (BasicMSC)basicMSC.clone();
        basicMSC2.name = "" + basicMSC.name + "_P" + n;
        BasicMSC basicMSC3 = (BasicMSC)basicMSC.clone();
        basicMSC3.name = "P_" + basicMSC.name + "" + n;
        BasicMSC basicMSC4 = new BasicMSC();
        basicMSC4.copyComponents(basicMSC);
        basicMSC4.name = "P" + n;
        boolean bl3 = true;
        while (bl3) {
            bl3 = false;
            object4 = basicMSC3.getFirstMoves(lTSOutput);
            object3 = basicMSC2.getLastMoves(lTSOutput);
            object2 = object3.iterator();
            while (object2.hasNext() && !bl3) {
                object = (Vector)object2.next();
                String string = (String)((Vector)object).get(0);
                String string2 = (String)((Vector)object).get(1);
                String string3 = (String)((Vector)object).get(2);
                Iterator iterator = object4.iterator();
                while (iterator.hasNext() && !bl3) {
                    Vector vector = (Vector)iterator.next();
                    if (string.equals((String)vector.get(0)) || string.equals((String)vector.get(2)) || string3.equals((String)vector.get(0)) || string3.equals((String)vector.get(2))) continue;
                    if (bl) {
                        lTSOutput.outln("Found postponable action " + string2);
                    }
                    basicMSC2.removeLastMessage(string, string2, string3);
                    basicMSC3.addMessage(string, string2, string3);
                    basicMSC4.addMessage(string, string2, string3);
                    stringSet.add(string2);
                    bl3 = true;
                }
            }
        }
        if (stringSet.size() == 0) {
            ((Set)map.get(basicMSC)).add(basicMSC);
            return true;
        }
        if (basicMSC2.getFirstMoves(lTSOutput).size() == 0) {
            if (basicMSC.getFirstMoves(lTSOutput).size() == 1) {
                this.MarkAsPostponed(map, basicMSC, basicMSC, lTSOutput);
                return true;
            }
            throw new Exception("Non regular language: Loop in bMSC " + basicMSC.name);
        }
        object4 = (BasicMSC)basicMSC4.clone();
        ((BasicMSC)object4).append(basicMSC2);
        ((BasicMSC)object4).name = "P_" + basicMSC.name + "_P" + n;
        object3 = this.getbMSCs().iterator();
        while (object3.hasNext()) {
            object2 = (BasicMSC)object3.next();
            if (object2 == basicMSC || !this.getContinuations((BasicMSC)object2).contains(basicMSC)) continue;
            if (bl) {
                lTSOutput.outln("// Adding (1)" + ((BasicMSC)object2).name + " -> " + basicMSC2.name);
            }
            this.addRelation((BasicMSC)object2, basicMSC2);
        }
        if (this.getContinuationsInit().contains(basicMSC)) {
            if (bl) {
                lTSOutput.outln("// Adding Init -> " + basicMSC2.name);
            }
            this.addRelationInit(basicMSC2);
        }
        if (bl) {
            lTSOutput.outln("// Adding bMSCs " + ((BasicMSC)object4).name + ", " + basicMSC2.name + ", " + basicMSC3.name + ", " + basicMSC4.name);
        }
        this.addbMSC((BasicMSC)object4);
        this.addbMSC(basicMSC2);
        this.addbMSC(basicMSC3);
        this.addbMSC(basicMSC4);
        object2 = this.getContinuations(basicMSC).iterator();
        while (object2.hasNext()) {
            object = (BasicMSC)object2.next();
            if (object == basicMSC) continue;
            if (bl) {
                lTSOutput.outln("// Adding " + basicMSC3.name + " -> " + ((BasicMSC)object).name);
            }
            this.addRelation(basicMSC3, (BasicMSC)object);
            if (bl) {
                lTSOutput.outln("// Adding " + basicMSC4.name + " -> " + ((BasicMSC)object).name);
            }
            this.addRelation(basicMSC4, (BasicMSC)object);
        }
        if (bl) {
            lTSOutput.outln("// Adding " + basicMSC4.name + " -> " + basicMSC.name);
        }
        this.addRelation(basicMSC4, basicMSC);
        if (bl) {
            lTSOutput.outln("// Adding " + basicMSC.name + " -> " + basicMSC2.name);
        }
        this.addRelation(basicMSC, basicMSC2);
        if (bl) {
            lTSOutput.outln("// Adding " + basicMSC2.name + " -> " + basicMSC3.name);
        }
        this.addRelation(basicMSC2, basicMSC3);
        if (bl) {
            lTSOutput.outln("// Adding " + basicMSC3.name + " -> " + basicMSC.name);
        }
        this.addRelation(basicMSC3, basicMSC);
        if (bl) {
            lTSOutput.outln("// Adding " + basicMSC2.name + " -> " + ((BasicMSC)object4).name);
        }
        this.addRelation(basicMSC2, (BasicMSC)object4);
        if (bl) {
            lTSOutput.outln("// Adding " + ((BasicMSC)object4).name + " -> " + ((BasicMSC)object4).name);
        }
        this.addRelation((BasicMSC)object4, (BasicMSC)object4);
        if (bl) {
            lTSOutput.outln("// Adding " + ((BasicMSC)object4).name + " -> " + basicMSC4.name);
        }
        this.addRelation((BasicMSC)object4, basicMSC4);
        if (bl) {
            lTSOutput.outln("// Adding " + ((BasicMSC)object4).name + " -> " + basicMSC3.name);
        }
        this.addRelation((BasicMSC)object4, basicMSC3);
        if (bl) {
            lTSOutput.outln("// Adding " + basicMSC3.name + " -> " + basicMSC2.name);
        }
        this.addRelation(basicMSC3, basicMSC2);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + basicMSC.name + "," + basicMSC.name + ")");
        }
        ((Set)map.get(basicMSC)).add(basicMSC);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + basicMSC.name + "," + basicMSC2.name + ")");
        }
        ((Set)map.get(basicMSC)).add(basicMSC2);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + basicMSC4.name + "," + basicMSC.name + ")");
        }
        map.put(basicMSC4, new HashSet());
        ((Set)map.get(basicMSC4)).add(basicMSC);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + basicMSC3.name + "," + basicMSC.name + ")");
        }
        map.put(basicMSC3, new HashSet());
        ((Set)map.get(basicMSC3)).add(basicMSC);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + basicMSC2.name + "," + basicMSC3.name + ")");
        }
        map.put(basicMSC2, new HashSet());
        ((Set)map.get(basicMSC2)).add(basicMSC3);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + basicMSC2.name + "," + ((BasicMSC)object4).name + ")");
        }
        ((Set)map.get(basicMSC2)).add(object4);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + ((BasicMSC)object4).name + "," + ((BasicMSC)object4).name + ")");
        }
        map.put(object4, new HashSet());
        ((Set)map.get(object4)).add(object4);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + ((BasicMSC)object4).name + "," + basicMSC4.name + ")");
        }
        ((Set)map.get(object4)).add(basicMSC4);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + ((BasicMSC)object4).name + "," + basicMSC3.name + ")");
        }
        ((Set)map.get(object4)).add(basicMSC3);
        if (bl) {
            lTSOutput.outln("Updating postponed map (" + basicMSC3.name + "," + basicMSC2.name + ")");
        }
        ((Set)map.get(basicMSC3)).add(basicMSC2);
        if (bl) {
            lTSOutput.outln("Register that " + basicMSC.name + " has been visited as B that the result is " + basicMSC3.name + ".");
        }
        object = new Vector<Object>(2);
        ((Vector)object).add(0, stringSet);
        ((Vector)object).add(1, basicMSC3);
        if (!map3.keySet().contains(basicMSC)) {
            map3.put(basicMSC, new HashSet());
        }
        ((Set)map3.get(basicMSC)).add(object);
        if (bl) {
            lTSOutput.outln("Register that " + basicMSC.name + " has been visited as A and that the resutl is " + basicMSC2.name);
        }
        object = new Vector(2);
        ((Vector)object).add(0, stringSet);
        ((Vector)object).add(1, basicMSC2);
        if (!map2.keySet().contains(basicMSC)) {
            map2.put(basicMSC, new HashSet());
        }
        ((Set)map2.get(basicMSC)).add(object);
        if (bl2) {
            lTSOutput.outln("AppliedLoopRule (" + n + ") to " + basicMSC.name);
        }
        return true;
    }

    private void MarkAsPostponed(Map map, BasicMSC basicMSC, BasicMSC basicMSC2, LTSOutput lTSOutput) {
        boolean bl = true;
        if (bl) {
            lTSOutput.outln("Marked as postponed (" + basicMSC.name + " -> " + basicMSC2.name + ")");
        }
        if (!map.keySet().contains(basicMSC)) {
            map.put(basicMSC, new HashSet());
        }
        ((Set)map.get(basicMSC)).add(basicMSC2);
    }

    private boolean HasBeenPostponed(Map map, BasicMSC basicMSC, BasicMSC basicMSC2) {
        if (!map.keySet().contains(basicMSC)) {
            return false;
        }
        return ((Set)map.get(basicMSC)).contains(basicMSC2);
    }

    private boolean ApplySequenceRules(BasicMSC basicMSC, BasicMSC basicMSC2, Map map, Map map2, Map map3, int n, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("1");
        }
        if (this.HasBeenPostponed(map, basicMSC, basicMSC2)) {
            return false;
        }
        if (bl) {
            lTSOutput.outln("2");
        }
        if (this.getContinuations(basicMSC2).contains(basicMSC)) {
            return this.ApplyRuleSequenceAndBack(basicMSC, basicMSC2, map, map2, map3, n, lTSOutput);
        }
        return this.ApplyRuleSequence(basicMSC, basicMSC2, map, map2, map3, n, lTSOutput);
    }

    private boolean ApplyRuleSequence(BasicMSC basicMSC, BasicMSC basicMSC2, Map map, Map map2, Map map3, int n, LTSOutput lTSOutput) throws Exception {
        Iterator iterator;
        Object object;
        Iterator iterator2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        boolean bl = true;
        boolean bl2 = true;
        if (bl) {
            lTSOutput.outln("");
        }
        if (bl) {
            lTSOutput.outln("ApplyRuleSequence " + basicMSC.name + ", " + basicMSC2.name);
        }
        StringSet stringSet = new StringSet();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        BasicMSC basicMSC3 = (BasicMSC)basicMSC.clone();
        basicMSC3.name = "" + basicMSC.name + "_P" + n;
        BasicMSC basicMSC4 = new BasicMSC();
        basicMSC4.copyComponents(basicMSC);
        basicMSC4.name = "P" + n;
        BasicMSC basicMSC5 = (BasicMSC)basicMSC2.clone();
        basicMSC5.name = "P_" + basicMSC2.name + "" + n;
        boolean bl3 = true;
        while (bl3) {
            bl3 = false;
            object6 = basicMSC5.getFirstMoves(lTSOutput);
            object5 = basicMSC3.getLastMoves(lTSOutput);
            Iterator iterator3 = object5.iterator();
            while (iterator3.hasNext() && !bl3) {
                object4 = (Vector)iterator3.next();
                object3 = (String)((Vector)object4).get(0);
                object2 = (String)((Vector)object4).get(1);
                iterator2 = (String)((Vector)object4).get(2);
                object = object6.iterator();
                while (object.hasNext() && !bl3) {
                    Vector vector = (Vector)object.next();
                    if (((String)object3).equals((String)vector.get(0)) || ((String)object3).equals((String)vector.get(2)) || ((String)((Object)iterator2)).equals((String)vector.get(0)) || ((String)((Object)iterator2)).equals((String)vector.get(2))) continue;
                    Vector vector2 = basicMSC3.getIdOfLastMessage((String)object3, (String)object2, (String)((Object)iterator2));
                    int n2 = (Integer)vector2.get(0);
                    int n3 = (Integer)vector2.get(1);
                    if (basicMSC2.hasEventId(n2) || basicMSC2.hasEventId(n3)) continue;
                    if (bl) {
                        lTSOutput.outln("Found postponable action " + (String)object2);
                    }
                    basicMSC3.removeLastMessage((String)object3, (String)object2, (String)((Object)iterator2));
                    basicMSC5.addMessage((String)object3, (String)object2, (String)((Object)iterator2), n2, n3);
                    basicMSC4.addMessage((String)object3, (String)object2, (String)((Object)iterator2), n2, n3);
                    bl3 = true;
                }
            }
        }
        if (basicMSC4.empty()) {
            this.MarkAsPostponed(map, basicMSC, basicMSC2, lTSOutput);
            return true;
        }
        if (!map2.keySet().contains(basicMSC)) {
            map2.put(basicMSC, new HashSet());
        }
        object6 = ((Set)map2.get(basicMSC)).iterator();
        while (object6.hasNext()) {
            object5 = (Vector)object6.next();
            if (!basicMSC4.isTheSameAs((BasicMSC)((Vector)object5).get(0), lTSOutput)) continue;
            basicMSC3 = (BasicMSC)((Vector)object5).get(1);
            if (bl) {
                lTSOutput.outln("Found that " + basicMSC.name + " has been used as A with P, so now using " + basicMSC3.name + " as A_P");
            }
            if (((Vector)object5).size() != 3) continue;
            hashSet.add(((Vector)object5).get(2));
            if (!bl) continue;
            lTSOutput.outln(" PREV In addition will remember to link Prev_P_A_P=" + ((BasicMSC)((Vector)object5).get((int)2)).name + " to link with anything A_P is linked with");
        }
        if (!map3.keySet().contains(basicMSC2)) {
            map3.put(basicMSC2, new HashSet());
        }
        object5 = ((Set)map3.get(basicMSC2)).iterator();
        boolean bl4 = false;
        while (object5.hasNext()) {
            object4 = (Vector)object5.next();
            if (!basicMSC4.isTheSameAs((BasicMSC)((Vector)object4).get(0), lTSOutput)) continue;
            bl4 = true;
            basicMSC5 = (BasicMSC)((Vector)object4).get(1);
            if (bl) {
                lTSOutput.outln("Found that " + basicMSC2.name + " has been visited as B with exactly P, so now using " + basicMSC5.name + " as previous P_B");
            }
            if (((Vector)object4).size() != 3) continue;
            hashSet2.add(((Vector)object4).get(2));
            if (!bl) continue;
            lTSOutput.outln(" PREV In addition will remember to link Prev_P_B_P=" + ((BasicMSC)((Vector)object4).get((int)2)).name + " FROM anything that is liked to P_B");
        }
        if (bl) {
            lTSOutput.outln("Add transitions '3'");
        }
        object4 = this.getbMSCs().iterator();
        while (object4.hasNext()) {
            object3 = (BasicMSC)object4.next();
            if (object3 == basicMSC2 || object3 == basicMSC || object3 == basicMSC3 || object3 == basicMSC5 || !this.getContinuations((BasicMSC)object3).contains(basicMSC)) continue;
            if (bl) {
                lTSOutput.outln("// Adding " + ((BasicMSC)object3).name + " -> " + basicMSC3.name);
            }
            this.addRelation((BasicMSC)object3, basicMSC3);
            if (!this.HasBeenPostponed(map, (BasicMSC)object3, basicMSC)) continue;
            this.MarkAsPostponed(map, (BasicMSC)object3, basicMSC3, lTSOutput);
        }
        if (this.getContinuationsInit().contains(basicMSC)) {
            if (bl) {
                lTSOutput.outln("// Adding Init -> " + basicMSC3.name);
            }
            this.addRelationInit(basicMSC3);
        }
        if (bl) {
            lTSOutput.outln("// Adding bMSC " + basicMSC3.name);
        }
        this.addbMSC(basicMSC3);
        if (bl) {
            lTSOutput.outln("// Adding bMSCs " + basicMSC5.name);
        }
        this.addbMSC(basicMSC5);
        if (bl) {
            lTSOutput.outln("Add transitions '1'");
        }
        if (this.getContinuations(basicMSC).contains(basicMSC)) {
            if (bl) {
                lTSOutput.outln("// Add relation " + basicMSC.name + " -> " + basicMSC3.name);
            }
            this.addRelation(basicMSC, basicMSC3);
            this.MarkAsPostponed(map, basicMSC, basicMSC3, lTSOutput);
        }
        if (bl) {
            lTSOutput.outln("Add transitions '2'");
        }
        if (!bl4) {
            if (this.getContinuations(basicMSC2).contains(basicMSC2)) {
                if (bl) {
                    lTSOutput.outln("// Add relation " + basicMSC5.name + " -> " + basicMSC2.name);
                }
                this.addRelation(basicMSC5, basicMSC2);
            }
            if (bl) {
                lTSOutput.outln("// Add transitions '6'");
            }
            object3 = this.getContinuations(basicMSC2).iterator();
            while (object3.hasNext()) {
                object2 = (BasicMSC)object3.next();
                if (object2 == basicMSC2 || object2 == basicMSC || object2 == basicMSC3 || object2 == basicMSC5) continue;
                if (bl) {
                    lTSOutput.outln("// Add relation " + basicMSC5.name + " -> " + ((BasicMSC)object2).name);
                }
                this.addRelation(basicMSC5, (BasicMSC)object2);
                if (!this.HasBeenPostponed(map, basicMSC2, (BasicMSC)object2)) continue;
                this.MarkAsPostponed(map, basicMSC5, (BasicMSC)object2, lTSOutput);
            }
        }
        if (bl4) {
            if (map2.keySet().contains(basicMSC5)) {
                if (bl) {
                    lTSOutput.outln(basicMSC5.name + " has been visited as A...so will add A_P to P_B-X and Prev_P_A_P to P_B-X");
                }
                object3 = ((Set)map2.get(basicMSC5)).iterator();
                while (object3.hasNext()) {
                    object2 = (Vector)object3.next();
                    if (bl) {
                        lTSOutput.outln("Adding relation " + basicMSC3.name + " to " + ((BasicMSC)((Vector)object2).get((int)1)).name);
                    }
                    this.addRelation(basicMSC3, (BasicMSC)((Vector)object2).get(1));
                    this.MarkAsPostponed(map, basicMSC3, (BasicMSC)((Vector)object2).get(1), lTSOutput);
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        iterator2 = (BasicMSC)iterator.next();
                        if (bl) {
                            lTSOutput.outln("PREV Adding relation " + ((BasicMSC)((Object)iterator2)).name + " to " + ((BasicMSC)((Vector)object2).get((int)1)).name);
                        }
                        this.addRelation((BasicMSC)((Object)iterator2), (BasicMSC)((Vector)object2).get(1));
                        this.MarkAsPostponed(map, (BasicMSC)((Object)iterator2), (BasicMSC)((Vector)object2).get(1), lTSOutput);
                    }
                }
            } else if (bl) {
                lTSOutput.outln(basicMSC5.name + " has not been visited as A ");
            }
        }
        if (bl4 && basicMSC == basicMSC5) {
            if (bl) {
                lTSOutput.outln("Because Circular and A=P_B, adding relation " + basicMSC3.name + " to " + basicMSC3.name);
            }
            this.addRelation(basicMSC3, basicMSC3);
            throw new Exception("Case that should never happen");
        }
        if (bl) {
            lTSOutput.outln("Adding relation " + basicMSC3.name + " to " + basicMSC5.name);
        }
        this.addRelation(basicMSC3, basicMSC5);
        this.MarkAsPostponed(map, basicMSC3, basicMSC5, lTSOutput);
        Iterator iterator4 = hashSet2.iterator();
        while (iterator4.hasNext()) {
            object3 = (BasicMSC)iterator4.next();
            if (bl) {
                lTSOutput.outln("Adding PREV relation " + basicMSC3.name + " to " + ((BasicMSC)object3).name);
            }
            this.addRelation(basicMSC3, (BasicMSC)object3);
            this.MarkAsPostponed(map, basicMSC3, (BasicMSC)object3, lTSOutput);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object3 = (BasicMSC)iterator.next();
            if (bl) {
                lTSOutput.outln("Adding PREV relation " + ((BasicMSC)object3).name + " to " + basicMSC5.name);
            }
            this.addRelation((BasicMSC)object3, basicMSC5);
            this.MarkAsPostponed(map, (BasicMSC)object3, basicMSC5, lTSOutput);
            iterator4 = hashSet2.iterator();
            while (iterator4.hasNext()) {
                object2 = (BasicMSC)iterator4.next();
                if (bl) {
                    lTSOutput.outln("Adding PREV relation " + ((BasicMSC)object3).name + " to " + ((BasicMSC)object2).name);
                }
                this.addRelation((BasicMSC)object3, (BasicMSC)object2);
                this.MarkAsPostponed(map, (BasicMSC)object3, (BasicMSC)object2, lTSOutput);
            }
        }
        this.MarkAsPostponed(map, basicMSC, basicMSC2, lTSOutput);
        if (!bl4) {
            if (bl) {
                lTSOutput.outln("Register that " + basicMSC2.name + " has been visited as B that the result is " + basicMSC5.name + ".");
            }
            object3 = new Vector<BasicMSC>(2);
            ((Vector)object3).add(0, basicMSC4);
            ((Vector)object3).add(1, basicMSC5);
            ((Set)map3.get(basicMSC2)).add(object3);
        }
        if (bl) {
            lTSOutput.outln("Register that " + basicMSC.name + " has been visited as A that the result is " + basicMSC3.name + ".");
        }
        object3 = new Vector(2);
        ((Vector)object3).add(0, basicMSC4);
        ((Vector)object3).add(1, basicMSC3);
        if (!map2.keySet().contains(basicMSC)) {
            map2.put(basicMSC, new HashSet());
        }
        ((Set)map2.get(basicMSC)).add(object3);
        if (bl2) {
            lTSOutput.outln("AppliedRuleSequence (" + n + ") " + basicMSC.name + ", " + basicMSC2.name);
        }
        if (basicMSC5.getPostponables(basicMSC5, lTSOutput).isTheSameAs(basicMSC4, lTSOutput)) {
            if (bl) {
                lTSOutput.outln("Independent!");
            }
            this.MarkAsPostponed(map, basicMSC5, basicMSC2, lTSOutput);
            object2 = (BasicMSC)basicMSC2.clone();
            ((BasicMSC)object2).name = basicMSC2.name + "clone" + n;
            this.addbMSC((BasicMSC)object2);
            this.addbMSC(basicMSC4);
            this.addRelation(basicMSC3, (BasicMSC)object2);
            this.MarkAsPostponed(map, basicMSC3, (BasicMSC)object2, lTSOutput);
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                iterator2 = (BasicMSC)iterator.next();
                if (bl) {
                    lTSOutput.outln("PREV ! ");
                }
                this.addRelation((BasicMSC)((Object)iterator2), (BasicMSC)object2);
                this.MarkAsPostponed(map, (BasicMSC)((Object)iterator2), (BasicMSC)object2, lTSOutput);
            }
            this.addRelation((BasicMSC)object2, (BasicMSC)object2);
            this.MarkAsPostponed(map, (BasicMSC)object2, (BasicMSC)object2, lTSOutput);
            this.addRelation((BasicMSC)object2, basicMSC4);
            this.MarkAsPostponed(map, (BasicMSC)object2, basicMSC4, lTSOutput);
            this.addRelation(basicMSC4, basicMSC2);
            this.MarkAsPostponed(map, basicMSC4, basicMSC2, lTSOutput);
            if (bl) {
                lTSOutput.outln("// Add transitions '6'");
            }
            iterator2 = this.getContinuations(basicMSC2).iterator();
            while (iterator2.hasNext()) {
                object = (BasicMSC)iterator2.next();
                if (object == basicMSC2 || object == basicMSC || object == basicMSC3 || object == basicMSC5 || object == basicMSC4 || object == object2) continue;
                if (bl) {
                    lTSOutput.outln("// Add relation " + basicMSC4.name + " -> " + ((BasicMSC)object).name);
                }
                this.addRelation(basicMSC4, (BasicMSC)object);
            }
        } else if (bl) {
            lTSOutput.outln("Not Independent!");
        }
        return true;
    }

    private boolean ApplyRuleSequenceAndBack(BasicMSC basicMSC, BasicMSC basicMSC2, Map map, Map map2, Map map3, int n, LTSOutput lTSOutput) throws Exception {
        Iterator iterator;
        Iterator iterator2;
        Iterator iterator3;
        Iterator iterator4;
        Object object;
        Object object2;
        Object object3;
        Vector vector;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        boolean bl = true;
        boolean bl2 = true;
        if (bl) {
            lTSOutput.outln("");
        }
        if (bl) {
            lTSOutput.outln("ApplyRuleSequenceAndBack " + basicMSC.name + ", " + basicMSC2.name);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        StringSet stringSet = new StringSet();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        BasicMSC basicMSC3 = (BasicMSC)basicMSC.clone();
        basicMSC3.name = "" + basicMSC.name + "_P" + n;
        BasicMSC basicMSC4 = (BasicMSC)basicMSC2.clone();
        basicMSC4.name = "P_" + basicMSC2.name + "" + n;
        BasicMSC basicMSC5 = new BasicMSC();
        basicMSC5.copyComponents(basicMSC2);
        BasicMSC basicMSC6 = new BasicMSC();
        basicMSC6.copyComponents(basicMSC);
        boolean bl5 = true;
        while (bl5) {
            bl5 = false;
            object8 = basicMSC4.getFirstMoves(lTSOutput);
            object7 = basicMSC3.getLastMoves(lTSOutput);
            object6 = object7.iterator();
            while (object6.hasNext() && !bl5) {
                object5 = (Vector)object6.next();
                String string = (String)((Vector)object5).get(0);
                object4 = (String)((Vector)object5).get(1);
                vector = (String)((Vector)object5).get(2);
                object3 = object8.iterator();
                while (object3.hasNext() && !bl5) {
                    object2 = (Vector)object3.next();
                    if (string.equals((String)((Vector)object2).get(0)) || string.equals((String)((Vector)object2).get(2)) || ((String)((Object)vector)).equals((String)((Vector)object2).get(0)) || ((String)((Object)vector)).equals((String)((Vector)object2).get(2))) continue;
                    if (bl) {
                        lTSOutput.outln("1-Found postponableA action " + (String)object4);
                    }
                    object = basicMSC3.getIdOfLastMessage(string, (String)object4, (String)((Object)vector));
                    int n2 = (Integer)((Vector)object).get(0);
                    int n3 = (Integer)((Vector)object).get(1);
                    if (basicMSC2.hasEventId(n2) || basicMSC2.hasEventId(n3)) continue;
                    basicMSC3.removeLastMessage(string, (String)object4, (String)((Object)vector));
                    basicMSC4.addMessage(string, (String)object4, (String)((Object)vector), n2, n3);
                    basicMSC5.addMessage(string, (String)object4, (String)((Object)vector), n2, n3);
                    basicMSC6.addMessage(string, (String)object4, (String)((Object)vector), n2, n3);
                    stringSet.add(object4);
                    bl5 = true;
                }
            }
        }
        StringSet stringSet2 = new StringSet();
        object8 = (BasicMSC)basicMSC2.clone();
        ((BasicMSC)object8).name = "" + basicMSC2.name + "_P" + n;
        object7 = (BasicMSC)basicMSC.clone();
        ((BasicMSC)object7).name = "P_" + basicMSC.name + "" + n;
        object6 = new BasicMSC();
        ((BasicMSC)object6).copyComponents(basicMSC);
        object5 = new BasicMSC();
        ((BasicMSC)object5).copyComponents(basicMSC2);
        boolean bl6 = true;
        while (bl6) {
            bl6 = false;
            object4 = ((BasicMSC)object7).getFirstMoves(lTSOutput);
            vector = ((BasicMSC)object8).getLastMoves(lTSOutput);
            object3 = vector.iterator();
            while (object3.hasNext() && !bl6) {
                object2 = (Vector)object3.next();
                object = (String)((Vector)object2).get(0);
                String string = (String)((Vector)object2).get(1);
                String string2 = (String)((Vector)object2).get(2);
                Iterator iterator5 = object4.iterator();
                while (iterator5.hasNext() && !bl6) {
                    Vector vector2 = (Vector)iterator5.next();
                    if (((String)object).equals((String)vector2.get(0)) || ((String)object).equals((String)vector2.get(2)) || string2.equals((String)vector2.get(0)) || string2.equals((String)vector2.get(2))) continue;
                    if (bl) {
                        lTSOutput.outln("2-Found postponableB action " + string);
                    }
                    Vector vector3 = ((BasicMSC)object8).getIdOfLastMessage((String)object, string, string2);
                    int n4 = (Integer)vector3.get(0);
                    int n5 = (Integer)vector3.get(1);
                    if (basicMSC.hasEventId(n4) || basicMSC.hasEventId(n5)) continue;
                    ((BasicMSC)object8).removeLastMessage((String)object, string, string2);
                    ((BasicMSC)object7).addMessage((String)object, string, string2, n4, n5);
                    ((BasicMSC)object6).addMessage((String)object, string, string2, n4, n5);
                    ((BasicMSC)object5).addMessage((String)object, string, string2, n4, n5);
                    stringSet2.add(string);
                    bl6 = true;
                }
            }
        }
        if (stringSet2.size() == 0 && stringSet.size() == 0) {
            this.MarkAsPostponed(map, basicMSC, basicMSC2, lTSOutput);
            this.MarkAsPostponed(map, basicMSC2, basicMSC, lTSOutput);
            return true;
        }
        if (!map2.keySet().contains(basicMSC)) {
            map2.put(basicMSC, new HashSet());
        }
        Iterator iterator6 = ((Set)map2.get(basicMSC)).iterator();
        while (iterator6.hasNext()) {
            object4 = (Vector)iterator6.next();
            if (!basicMSC6.isTheSameAs((BasicMSC)((Vector)object4).get(0), lTSOutput)) continue;
            basicMSC3 = (BasicMSC)((Vector)object4).get(1);
            if (bl) {
                lTSOutput.outln("Found that " + basicMSC.name + " has been used as A with P, so using " + basicMSC3.name + " as A_P. Size(" + ((Vector)object4).size() + ")");
            }
            if (((Vector)object4).size() != 3) continue;
            hashSet.add(((Vector)object4).get(2));
            if (!bl) continue;
            lTSOutput.outln("PREV remembering Prev_P_A_P=" + ((BasicMSC)((Vector)object4).get((int)2)).name + " in order to link with all things A_P is linked with");
        }
        if (!map2.keySet().contains(basicMSC2)) {
            map2.put(basicMSC2, new HashSet());
        }
        object4 = ((Set)map2.get(basicMSC2)).iterator();
        while (object4.hasNext()) {
            vector = (Vector)object4.next();
            if (!((BasicMSC)object5).isTheSameAs((BasicMSC)vector.get(0), lTSOutput)) continue;
            object8 = (BasicMSC)vector.get(1);
            if (bl) {
                lTSOutput.outln("Found that " + basicMSC2.name + " has been used as A with exactly P, so using " + ((BasicMSC)object8).name + " as B_P. Size(" + vector.size() + ")");
            }
            if (vector.size() != 3) continue;
            hashSet2.add(vector.get(2));
            if (!bl) continue;
            lTSOutput.outln("PREV remembering Prev_P_B_P=" + ((BasicMSC)vector.get((int)2)).name + " in order to link with all the things B_P is linked with");
        }
        if (stringSet.size() != 0) {
            if (bl) {
                lTSOutput.outln("3-PostponablesA is not empty");
            }
            if (!map3.keySet().contains(basicMSC2)) {
                map3.put(basicMSC2, new HashSet());
            }
            vector = ((Set)map3.get(basicMSC2)).iterator();
            bl4 = false;
            while (vector.hasNext() && !bl4) {
                object3 = (Vector)vector.next();
                if (!basicMSC6.isTheSameAs((BasicMSC)((Vector)object3).get(0), lTSOutput)) continue;
                if (bl) {
                    lTSOutput.outln("4-Circular!!");
                }
                basicMSC4 = (BasicMSC)((Vector)object3).get(1);
                bl4 = true;
                if (bl) {
                    lTSOutput.outln("Found that " + basicMSC2.name + " has been visited as B with exactly P, so now using " + basicMSC4.name + " as previous P_B");
                }
                if (((Vector)object3).size() != 3) continue;
                hashSet4.add(((Vector)object3).get(2));
                if (!bl) continue;
                lTSOutput.outln(" PREV In addition will remember to link PrevB_P_B_P=" + ((BasicMSC)((Vector)object3).get((int)2)).name + " FROM anything that is liked to P_B");
            }
            if (bl) {
                lTSOutput.outln("5-Add transitions '3'");
            }
            object3 = this.getbMSCs().iterator();
            while (object3.hasNext()) {
                object2 = (BasicMSC)object3.next();
                if (object2 == basicMSC2 || object2 == basicMSC || object2 == basicMSC3 || object2 == object8 || object2 == basicMSC4 || object2 == object7 || !this.getContinuations((BasicMSC)object2).contains(basicMSC)) continue;
                if (bl) {
                    lTSOutput.outln("6-Adding " + ((BasicMSC)object2).name + " -> " + basicMSC3.name);
                }
                this.addRelation((BasicMSC)object2, basicMSC3);
                if (!this.HasBeenPostponed(map, (BasicMSC)object2, basicMSC)) continue;
                this.MarkAsPostponed(map, (BasicMSC)object2, basicMSC3, lTSOutput);
            }
            if (this.getContinuationsInit().contains(basicMSC)) {
                if (bl) {
                    lTSOutput.outln("7-Adding Init -> " + basicMSC3.name);
                }
                this.addRelationInit(basicMSC3);
            }
            if (bl) {
                lTSOutput.outln("8-Adding bMSC " + basicMSC3.name);
            }
            this.addbMSC(basicMSC3);
            if (!bl4) {
                if (bl) {
                    lTSOutput.outln("9-Adding bMSC " + basicMSC4.name);
                }
                this.addbMSC(basicMSC4);
            }
            if (bl) {
                lTSOutput.outln("10-Add relation " + basicMSC2.name + " -> " + basicMSC3.name);
            }
            this.addRelation(basicMSC2, basicMSC3);
            this.MarkAsPostponed(map, basicMSC2, basicMSC3, lTSOutput);
            if (this.getContinuations(basicMSC).contains(basicMSC)) {
                if (bl) {
                    lTSOutput.outln("11-Add relation " + basicMSC.name + " -> " + basicMSC3.name);
                }
                this.addRelation(basicMSC, basicMSC3);
                this.MarkAsPostponed(map, basicMSC, basicMSC3, lTSOutput);
            }
            if (this.getContinuations(basicMSC2).contains(basicMSC2)) {
                if (bl) {
                    lTSOutput.outln("12-Add relation " + basicMSC4.name + " -> " + basicMSC2.name);
                }
                this.addRelation(basicMSC4, basicMSC2);
            }
            if (bl) {
                lTSOutput.outln("13-Add relation " + basicMSC4.name + " -> " + basicMSC.name);
            }
            this.addRelation(basicMSC4, basicMSC);
            if (!bl4) {
                this.MarkAsPostponed(map, basicMSC4, basicMSC, lTSOutput);
            }
            if (!bl4) {
                if (bl) {
                    lTSOutput.outln("14-Add transitions '6'");
                }
                object2 = this.getContinuations(basicMSC2).iterator();
                while (object2.hasNext()) {
                    object = (BasicMSC)object2.next();
                    if (object == basicMSC2 || object == basicMSC || object == basicMSC3 || object == object8 || object == basicMSC4 || object == object7) continue;
                    if (bl) {
                        lTSOutput.outln("15-Add relation " + basicMSC4.name + " -> " + ((BasicMSC)object).name);
                    }
                    this.addRelation(basicMSC4, (BasicMSC)object);
                    if (!this.HasBeenPostponed(map, basicMSC2, (BasicMSC)object)) continue;
                    this.MarkAsPostponed(map, basicMSC4, (BasicMSC)object, lTSOutput);
                }
            }
            if (bl4 && map2.keySet().contains(basicMSC4)) {
                object2 = ((Set)map2.get(basicMSC4)).iterator();
                while (object2.hasNext()) {
                    object = (Vector)object2.next();
                    if (bl) {
                        lTSOutput.outln("16-Adding relation " + basicMSC3.name + " to " + ((BasicMSC)((Vector)object).get((int)1)).name);
                    }
                    this.addRelation(basicMSC3, (BasicMSC)((Vector)object).get(1));
                    this.MarkAsPostponed(map, basicMSC3, (BasicMSC)((Vector)object).get(1), lTSOutput);
                    iterator4 = hashSet.iterator();
                    while (iterator4.hasNext()) {
                        BasicMSC basicMSC7 = (BasicMSC)iterator4.next();
                        if (bl) {
                            lTSOutput.outln("16,5-Adding PREV relation " + basicMSC7.name + " to " + ((BasicMSC)((Vector)object).get((int)1)).name);
                        }
                        this.addRelation(basicMSC7, (BasicMSC)((Vector)object).get(1));
                        this.MarkAsPostponed(map, basicMSC7, (BasicMSC)((Vector)object).get(1), lTSOutput);
                    }
                }
            }
            if (bl) {
                lTSOutput.outln("17-Adding relation " + basicMSC3.name + " to " + basicMSC4.name);
            }
            this.addRelation(basicMSC3, basicMSC4);
            iterator3 = hashSet4.iterator();
            while (iterator3.hasNext()) {
                object2 = (BasicMSC)iterator3.next();
                if (bl) {
                    lTSOutput.outln("Adding PREV relation " + basicMSC3.name + " to " + ((BasicMSC)object2).name);
                }
                this.addRelation(basicMSC3, (BasicMSC)object2);
                this.MarkAsPostponed(map, basicMSC3, (BasicMSC)object2, lTSOutput);
            }
            this.MarkAsPostponed(map, basicMSC3, basicMSC4, lTSOutput);
            iterator4 = hashSet.iterator();
            while (iterator4.hasNext()) {
                object2 = (BasicMSC)iterator4.next();
                if (bl) {
                    lTSOutput.outln("17,5-Adding PREV relation " + ((BasicMSC)object2).name + " to " + basicMSC4.name);
                }
                this.addRelation((BasicMSC)object2, basicMSC4);
                this.MarkAsPostponed(map, (BasicMSC)object2, basicMSC4, lTSOutput);
                iterator3 = hashSet4.iterator();
                while (iterator3.hasNext()) {
                    object = (BasicMSC)iterator3.next();
                    if (bl) {
                        lTSOutput.outln("Adding PREV relation " + ((BasicMSC)object2).name + " to " + ((BasicMSC)object).name);
                    }
                    this.addRelation((BasicMSC)object2, (BasicMSC)object);
                    this.MarkAsPostponed(map, (BasicMSC)object2, (BasicMSC)object, lTSOutput);
                }
            }
            if (bl) {
                lTSOutput.outln("18-Adding relation " + basicMSC4.name + " to " + basicMSC3.name);
            }
            this.addRelation(basicMSC4, basicMSC3);
            this.MarkAsPostponed(map, basicMSC4, basicMSC3, lTSOutput);
        }
        if (stringSet2.size() != 0) {
            if (bl) {
                lTSOutput.outln("21-PostponablesB is not empty");
            }
            if (!map3.keySet().contains(basicMSC)) {
                map3.put(basicMSC, new HashSet());
            }
            vector = ((Set)map3.get(basicMSC)).iterator();
            bl3 = false;
            while (vector.hasNext() && !bl3) {
                object3 = (Vector)vector.next();
                if (!((BasicMSC)object5).isTheSameAs((BasicMSC)((Vector)object3).get(0), lTSOutput)) continue;
                object7 = (BasicMSC)((Vector)object3).get(1);
                bl3 = true;
                if (bl) {
                    lTSOutput.outln("22-Circular!!");
                }
                if (bl) {
                    lTSOutput.outln("Found that " + basicMSC.name + " has been visited as B with exactly P, so now using " + ((BasicMSC)object7).name + " as previous P_A");
                }
                if (((Vector)object3).size() != 3) continue;
                hashSet3.add(((Vector)object3).get(2));
                if (!bl) continue;
                lTSOutput.outln(" PREV In addition will remember to link PrevB_P_A_P=" + ((BasicMSC)((Vector)object3).get((int)2)).name + " FROM anything that is liked to P_A");
            }
            object3 = this.getbMSCs().iterator();
            while (object3.hasNext()) {
                object2 = (BasicMSC)object3.next();
                if (object2 == basicMSC2 || object2 == basicMSC || object2 == basicMSC3 || object2 == object8 || object2 == basicMSC4 || object2 == object7 || !this.getContinuations((BasicMSC)object2).contains(basicMSC2)) continue;
                if (bl) {
                    lTSOutput.outln("23-Adding " + ((BasicMSC)object2).name + " -> " + ((BasicMSC)object8).name);
                }
                this.addRelation((BasicMSC)object2, (BasicMSC)object8);
                if (!this.HasBeenPostponed(map, (BasicMSC)object2, basicMSC2)) continue;
                this.MarkAsPostponed(map, (BasicMSC)object2, (BasicMSC)object8, lTSOutput);
            }
            if (this.getContinuationsInit().contains(basicMSC2)) {
                if (bl) {
                    lTSOutput.outln("24-Adding Init -> " + ((BasicMSC)object8).name);
                }
                this.addRelationInit((BasicMSC)object8);
            }
            if (bl) {
                lTSOutput.outln("25-Adding bMSC " + ((BasicMSC)object8).name);
            }
            this.addbMSC((BasicMSC)object8);
            if (!bl3) {
                if (bl) {
                    lTSOutput.outln("26-Adding bMSC " + ((BasicMSC)object7).name);
                }
                this.addbMSC((BasicMSC)object7);
            }
            if (bl) {
                lTSOutput.outln("27- Add relation " + basicMSC.name + " -> " + ((BasicMSC)object8).name);
            }
            this.addRelation(basicMSC, (BasicMSC)object8);
            this.MarkAsPostponed(map, basicMSC, (BasicMSC)object8, lTSOutput);
            if (this.getContinuations(basicMSC2).contains(basicMSC2)) {
                if (bl) {
                    lTSOutput.outln("28- Add relation " + basicMSC2.name + " -> " + ((BasicMSC)object8).name);
                }
                this.addRelation(basicMSC2, (BasicMSC)object8);
                this.MarkAsPostponed(map, basicMSC2, (BasicMSC)object8, lTSOutput);
            }
            if (this.getContinuations(basicMSC).contains(basicMSC)) {
                if (bl) {
                    lTSOutput.outln("29- Add relation " + ((BasicMSC)object7).name + " -> " + basicMSC.name);
                }
                this.addRelation((BasicMSC)object7, basicMSC);
            }
            if (bl) {
                lTSOutput.outln("30- Add relation " + ((BasicMSC)object7).name + " -> " + basicMSC2.name);
            }
            this.addRelation((BasicMSC)object7, basicMSC2);
            if (!bl3) {
                this.MarkAsPostponed(map, (BasicMSC)object7, basicMSC2, lTSOutput);
            }
            if (!bl3) {
                if (bl) {
                    lTSOutput.outln("31- Add transitions '4'");
                }
                object2 = this.getContinuations(basicMSC).iterator();
                while (object2.hasNext()) {
                    object = (BasicMSC)object2.next();
                    if (object == basicMSC2 || object == basicMSC || object == basicMSC3 || object == object8 || object == basicMSC4 || object == object7) continue;
                    if (bl) {
                        lTSOutput.outln("32- Add relation " + ((BasicMSC)object7).name + " -> " + ((BasicMSC)object).name);
                    }
                    this.addRelation((BasicMSC)object7, (BasicMSC)object);
                }
            }
            if (bl3 && map2.keySet().contains(object7)) {
                object2 = ((Set)map2.get(object7)).iterator();
                while (object2.hasNext()) {
                    object = (Vector)object2.next();
                    if (bl) {
                        lTSOutput.outln("33-Adding relation " + ((BasicMSC)object8).name + " to " + ((BasicMSC)((Vector)object).get((int)1)).name);
                    }
                    this.addRelation((BasicMSC)object8, (BasicMSC)((Vector)object).get(1));
                    this.MarkAsPostponed(map, (BasicMSC)object8, (BasicMSC)((Vector)object).get(1), lTSOutput);
                    iterator2 = hashSet2.iterator();
                    while (iterator2.hasNext()) {
                        BasicMSC basicMSC8 = (BasicMSC)iterator2.next();
                        if (bl) {
                            lTSOutput.outln("33,5-Adding PREV relation " + basicMSC8.name + " to " + ((BasicMSC)((Vector)object).get((int)1)).name);
                        }
                        this.addRelation(basicMSC8, (BasicMSC)((Vector)object).get(1));
                        this.MarkAsPostponed(map, basicMSC8, (BasicMSC)((Vector)object).get(1), lTSOutput);
                    }
                }
            }
            if (bl) {
                lTSOutput.outln("34-Adding relation " + ((BasicMSC)object8).name + " to " + ((BasicMSC)object7).name);
            }
            this.addRelation((BasicMSC)object8, (BasicMSC)object7);
            this.MarkAsPostponed(map, (BasicMSC)object8, (BasicMSC)object7, lTSOutput);
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                object2 = (BasicMSC)iterator.next();
                if (bl) {
                    lTSOutput.outln("Adding PREV relation " + ((BasicMSC)object8).name + " to " + ((BasicMSC)object2).name);
                }
                this.addRelation((BasicMSC)object8, (BasicMSC)object2);
                this.MarkAsPostponed(map, (BasicMSC)object8, (BasicMSC)object2, lTSOutput);
            }
            iterator2 = hashSet2.iterator();
            while (iterator2.hasNext()) {
                object2 = (BasicMSC)iterator2.next();
                if (bl) {
                    lTSOutput.outln("34-Adding PREV relation " + ((BasicMSC)object2).name + " to " + ((BasicMSC)object7).name);
                }
                this.addRelation((BasicMSC)object2, (BasicMSC)object7);
                this.MarkAsPostponed(map, (BasicMSC)object2, (BasicMSC)object7, lTSOutput);
                iterator = hashSet3.iterator();
                while (iterator.hasNext()) {
                    object = (BasicMSC)iterator.next();
                    if (bl) {
                        lTSOutput.outln("Adding PREV relation " + ((BasicMSC)object2).name + " to " + ((BasicMSC)object).name);
                    }
                    this.addRelation((BasicMSC)object2, (BasicMSC)object);
                    this.MarkAsPostponed(map, (BasicMSC)object2, (BasicMSC)object, lTSOutput);
                }
            }
            if (bl) {
                lTSOutput.outln("35-Adding relation " + ((BasicMSC)object7).name + " to " + ((BasicMSC)object8).name);
            }
            this.addRelation((BasicMSC)object7, (BasicMSC)object8);
            this.MarkAsPostponed(map, (BasicMSC)object7, (BasicMSC)object8, lTSOutput);
        }
        if (bl) {
            lTSOutput.outln("36-Register that " + basicMSC.name + " has been visited as B that the result is " + ((BasicMSC)object7).name + ".");
        }
        vector = new Vector<Object>(2);
        vector.add(0, object5);
        vector.add(1, (Object)object7);
        if (stringSet2.size() != 0 && stringSet.size() != 0) {
            vector.ensureCapacity(3);
            vector.add(2, (Object)object6);
            if (bl) {
                lTSOutput.outln("Adding PREV not null !!! Name :" + ((BasicMSC)object6).name);
            }
        }
        if (!map3.keySet().contains(basicMSC)) {
            map3.put(basicMSC, new HashSet());
        }
        ((Set)map3.get(basicMSC)).add(vector);
        if (bl) {
            lTSOutput.outln("19-Register that " + basicMSC2.name + " has been visited as B that the result is " + basicMSC4.name + ".");
        }
        vector = new Vector(2);
        vector.add(0, basicMSC6);
        vector.add(1, basicMSC4);
        if (stringSet2.size() != 0 && stringSet.size() != 0) {
            vector.ensureCapacity(3);
            vector.add(2, basicMSC5);
            if (bl) {
                lTSOutput.outln("Adding PREV not null !!! Name :" + basicMSC5.name);
            }
        }
        if (!map3.keySet().contains(basicMSC2)) {
            map3.put(basicMSC2, new HashSet());
        }
        ((Set)map3.get(basicMSC2)).add(vector);
        if (bl) {
            lTSOutput.outln("37-Register that " + basicMSC2.name + " has been visited as A that the result is " + ((BasicMSC)object8).name + ".");
        }
        vector = new Vector(2);
        vector.add(0, object5);
        vector.add(1, object8);
        if (stringSet2.size() != 0 && stringSet.size() != 0) {
            vector.ensureCapacity(3);
            vector.add(2, basicMSC5);
            if (bl && basicMSC5 == null) {
                lTSOutput.outln("Adding PREV null !!!");
            }
            if (bl) {
                lTSOutput.outln("Adding PREV not null !!! Name :" + basicMSC5.name);
            }
        }
        if (!map2.keySet().contains(basicMSC2)) {
            map2.put(basicMSC2, new HashSet());
        }
        ((Set)map2.get(basicMSC2)).add(vector);
        if (bl) {
            lTSOutput.outln("20-Register that " + basicMSC.name + " has been visited as A that the result is " + basicMSC3.name + ".");
        }
        vector = new Vector(2);
        vector.add(0, basicMSC6);
        vector.add(1, basicMSC3);
        if (stringSet2.size() != 0 && stringSet.size() != 0) {
            vector.ensureCapacity(3);
            vector.add(2, object6);
            if (bl && object6 == null) {
                lTSOutput.outln("Adding PREV null !!!");
            }
            if (bl) {
                lTSOutput.outln("Adding PREV not null !!! Name: " + ((BasicMSC)object6).name);
            }
        }
        if (!map2.keySet().contains(basicMSC)) {
            map2.put(basicMSC, new HashSet());
        }
        ((Set)map2.get(basicMSC)).add(vector);
        if (stringSet2.size() != 0 && stringSet.size() != 0) {
            ((BasicMSC)object6).append(basicMSC3);
            ((BasicMSC)object6).name = "P_" + basicMSC.name + "_P" + n;
            basicMSC5.append((BasicMSC)object8);
            basicMSC5.name = "P_" + basicMSC2.name + "_P" + n;
            if (bl) {
                lTSOutput.outln("38- Adding bMSC " + ((BasicMSC)object6).name);
            }
            this.addbMSC((BasicMSC)object6);
            if (bl) {
                lTSOutput.outln("39- Adding bMSC " + basicMSC5.name);
            }
            this.addbMSC(basicMSC5);
            if (bl) {
                lTSOutput.outln("40- Add relation " + basicMSC3.name + " -> " + basicMSC5.name);
            }
            this.addRelation(basicMSC3, basicMSC5);
            this.MarkAsPostponed(map, basicMSC3, basicMSC5, lTSOutput);
            iterator4 = hashSet.iterator();
            while (iterator4.hasNext()) {
                object3 = (BasicMSC)iterator4.next();
                if (bl) {
                    lTSOutput.outln("40- Add PREV relation " + ((BasicMSC)object3).name + " -> " + basicMSC5.name);
                }
                this.addRelation((BasicMSC)object3, basicMSC5);
                this.MarkAsPostponed(map, (BasicMSC)object3, basicMSC5, lTSOutput);
                object2 = this.getContinuations((BasicMSC)object3).iterator();
                while (object2.hasNext()) {
                    object = (BasicMSC)object2.next();
                    if (bl) {
                        lTSOutput.outln("40,5- Add PREV relation " + ((BasicMSC)object6).name + " -> " + ((BasicMSC)object).name);
                    }
                    this.addRelation((BasicMSC)object6, (BasicMSC)object);
                    this.MarkAsPostponed(map, (BasicMSC)object6, (BasicMSC)object, lTSOutput);
                }
            }
            if (bl) {
                lTSOutput.outln("41- Add relation " + ((BasicMSC)object8).name + " -> " + ((BasicMSC)object6).name);
            }
            this.addRelation((BasicMSC)object8, (BasicMSC)object6);
            this.MarkAsPostponed(map, (BasicMSC)object8, (BasicMSC)object6, lTSOutput);
            iterator2 = hashSet2.iterator();
            while (iterator2.hasNext()) {
                object3 = (BasicMSC)iterator2.next();
                if (bl) {
                    lTSOutput.outln("41- Add PREV relation " + ((BasicMSC)object3).name + " -> " + ((BasicMSC)object6).name);
                }
                this.addRelation((BasicMSC)object3, (BasicMSC)object6);
                this.MarkAsPostponed(map, (BasicMSC)object3, (BasicMSC)object6, lTSOutput);
                object2 = this.getContinuations((BasicMSC)object3).iterator();
                while (object2.hasNext()) {
                    object = (BasicMSC)object2.next();
                    if (bl) {
                        lTSOutput.outln("41,5- Add PREV relation " + basicMSC5.name + " -> " + ((BasicMSC)object).name);
                    }
                    this.addRelation(basicMSC5, (BasicMSC)object);
                    this.MarkAsPostponed(map, basicMSC5, (BasicMSC)object, lTSOutput);
                }
            }
            if (bl) {
                lTSOutput.outln("42-Adding relation " + ((BasicMSC)object6).name + " to " + basicMSC5.name);
            }
            this.addRelation((BasicMSC)object6, basicMSC5);
            if (bl) {
                lTSOutput.outln("43-Adding relation " + ((BasicMSC)object6).name + " to " + basicMSC4.name);
            }
            this.addRelation((BasicMSC)object6, basicMSC4);
            iterator3 = hashSet4.iterator();
            while (iterator3.hasNext()) {
                object3 = (BasicMSC)iterator3.next();
                if (bl) {
                    lTSOutput.outln("Adding PREV relation " + ((BasicMSC)object6).name + " to " + ((BasicMSC)object3).name);
                }
                this.addRelation((BasicMSC)object6, (BasicMSC)object3);
                this.MarkAsPostponed(map, (BasicMSC)object6, (BasicMSC)object3, lTSOutput);
            }
            if (bl) {
                lTSOutput.outln("44-Adding relation " + basicMSC5.name + " to " + ((BasicMSC)object6).name);
            }
            this.addRelation(basicMSC5, (BasicMSC)object6);
            if (bl) {
                lTSOutput.outln("45-Adding relation " + basicMSC5.name + " to " + ((BasicMSC)object7).name);
            }
            this.addRelation(basicMSC5, (BasicMSC)object7);
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                object3 = (BasicMSC)iterator.next();
                if (bl) {
                    lTSOutput.outln("Adding PREV relation " + basicMSC5.name + " to " + ((BasicMSC)object3).name);
                }
                this.addRelation(basicMSC5, (BasicMSC)object3);
                this.MarkAsPostponed(map, basicMSC5, (BasicMSC)object3, lTSOutput);
            }
            this.MarkAsPostponed(map, (BasicMSC)object6, basicMSC5, lTSOutput);
            this.MarkAsPostponed(map, (BasicMSC)object6, basicMSC4, lTSOutput);
            this.MarkAsPostponed(map, basicMSC5, (BasicMSC)object6, lTSOutput);
            this.MarkAsPostponed(map, basicMSC5, (BasicMSC)object7, lTSOutput);
        }
        if (bl3 && basicMSC2 == object7) {
            if (bl) {
                lTSOutput.outln("46-Adding relation " + ((BasicMSC)object8).name + " to " + ((BasicMSC)object8).name);
            }
            this.addRelation((BasicMSC)object8, (BasicMSC)object8);
        }
        if (bl4 && basicMSC == basicMSC4) {
            if (bl) {
                lTSOutput.outln("47-Adding relation " + basicMSC3.name + " to " + basicMSC3.name);
            }
            this.addRelation(basicMSC3, basicMSC3);
        }
        this.MarkAsPostponed(map, basicMSC, basicMSC2, lTSOutput);
        this.MarkAsPostponed(map, basicMSC2, basicMSC, lTSOutput);
        if (bl2) {
            lTSOutput.outln("48-AppliedRuleSequenceAndBack (" + n + ") " + basicMSC.name + ", " + basicMSC2.name);
        }
        return true;
    }

    public BasicMSC createbMSC(Vector vector, LTSOutput lTSOutput) {
        boolean bl = false;
        BasicMSC basicMSC = new BasicMSC();
        if (bl) {
            lTSOutput.outln("createBMSC...");
        }
        basicMSC.copyComponents((BasicMSC)this.getbMSCs().iterator().next());
        if (bl) {
            lTSOutput.outln("copied components");
        }
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.add(n, (String)enumeration.nextElement());
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (bl) {
                lTSOutput.outln("got element");
            }
            String string = (String)vector2.get(n2);
            basicMSC.addMessage(this.getSource(string, lTSOutput), string, this.getTarget(string, lTSOutput));
            if (bl) {
                lTSOutput.outln("added");
            }
            --n2;
        }
        if (bl) {
            lTSOutput.outln("Finished trace");
        }
        return basicMSC;
    }

    public String getSource(String string, LTSOutput lTSOutput) {
        Iterator iterator = this.getbMSCs().iterator();
        BasicMSC basicMSC = null;
        String string2 = null;
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            basicMSC = (BasicMSC)iterator.next();
            string2 = basicMSC.getSource(string);
            boolean bl2 = bl = string2 != null;
        }
        if (!bl) {
            lTSOutput.outln("No component that can output " + string);
            throw new Error("No component that can output " + string);
        }
        return string2;
    }

    public String getTarget(String string, LTSOutput lTSOutput) {
        Iterator iterator = this.getbMSCs().iterator();
        BasicMSC basicMSC = null;
        String string2 = null;
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            basicMSC = (BasicMSC)iterator.next();
            string2 = basicMSC.getTarget(string);
            boolean bl2 = bl = string2 != null;
        }
        if (!bl) {
            lTSOutput.outln("No component that can input " + string);
            throw new Error("No component that can input " + string);
        }
        return string2;
    }

    public void addMissingComponents() {
        String string;
        Iterator iterator;
        BasicMSC basicMSC;
        StringSet stringSet = new StringSet();
        Iterator iterator2 = this.getbMSCs().iterator();
        while (iterator2.hasNext()) {
            basicMSC = (BasicMSC)iterator2.next();
            iterator = basicMSC.components().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringSet.add(string);
            }
        }
        iterator2 = this.getbMSCs().iterator();
        while (iterator2.hasNext()) {
            basicMSC = (BasicMSC)iterator2.next();
            iterator = stringSet.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (basicMSC.getInstance(string) != null) continue;
                basicMSC.addInstance(string, new Instance());
            }
        }
    }

    public void print(LTSOutput lTSOutput) {
        BasicMSC basicMSC;
        Iterator iterator = this.getbMSCs().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            basicMSC.print(lTSOutput);
        }
        lTSOutput.outln("hmsc;");
        iterator = this.getContinuationsInit().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            lTSOutput.outln("Init -> " + basicMSC.name + ";");
        }
        iterator = this.getContinuationsFinal().iterator();
        while (iterator.hasNext()) {
            basicMSC = (BasicMSC)iterator.next();
            lTSOutput.outln(basicMSC.name + " -> Stop;");
        }
        Iterator iterator2 = this.getbMSCs().iterator();
        while (iterator2.hasNext()) {
            BasicMSC basicMSC2 = (BasicMSC)iterator2.next();
            iterator = this.getContinuations(basicMSC2).iterator();
            while (iterator.hasNext()) {
                basicMSC = (BasicMSC)iterator.next();
                lTSOutput.outln(basicMSC2.name + " -> " + basicMSC.name + ";");
            }
        }
        lTSOutput.outln("endhmsc");
    }
}

