/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.compiler;

import com.ibm.cs.bpws.compiler.LinkInfo;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.Condition;
import java.util.HashMap;

public class LinkTable {
    private HashMap linkInfoMap = new HashMap();
    private LinkTable parentTable;

    public LinkTable(LinkTable parentTable) {
        this.parentTable = parentTable;
    }

    public void defineLink(String linkName) {
        this.linkInfoMap.put(linkName, new LinkInfo(null, null, null));
    }

    public LinkInfo getLinkInfo(String linkName) {
        return (LinkInfo)this.linkInfoMap.get(linkName);
    }

    public void setLinkSourceInfo(String linkName, ActivityRT source, Condition condition) throws BPWSRuntimeException {
        LinkInfo linkInfo = (LinkInfo)this.linkInfoMap.get(linkName);
        if (linkInfo != null) {
            if (linkInfo.source != null) {
                throw new BPWSRuntimeException("Trying to more than one source on the same link");
            }
            linkInfo.source = source;
            linkInfo.condition = condition;
        } else if (this.parentTable != null) {
            this.parentTable.setLinkSourceInfo(linkName, source, condition);
        } else {
            throw new BPWSRuntimeException("trying to set a source for an undefined link" + linkName);
        }
    }

    public void setLinkTargetInfo(String linkName, ActivityRT target) throws BPWSRuntimeException {
        LinkInfo linkInfo = (LinkInfo)this.linkInfoMap.get(linkName);
        if (linkInfo != null) {
            if (linkInfo.target != null) {
                throw new BPWSRuntimeException("Trying to add more than one target on the same link" + linkName);
            }
            linkInfo.target = target;
        } else if (this.parentTable != null) {
            this.parentTable.setLinkTargetInfo(linkName, target);
        } else {
            throw new BPWSRuntimeException("trying to set a source for an undefined link " + linkName);
        }
    }
}

