/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import com.ibm.cs.bpws.runtime.events.LifecycleListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class CompoundActivityRT
extends ActivityRT
implements LifecycleListener,
Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    protected boolean childrenDead = false;
    protected LinkedList children = new LinkedList();

    public CompoundActivityRT(String name, ScopeRT scope, ActivityRT parentActivity) {
        super(name, scope, parentActivity);
    }

    public void activityActivated(LifecycleEvent event) {
    }

    public abstract void activityCompleted(LifecycleEvent var1) throws BPWSRuntimeException;

    public void activityDisabled(LifecycleEvent event) {
    }

    public abstract void activityEnabled(LifecycleEvent var1) throws BPWSRuntimeException;

    public void activityRevived(LifecycleEvent event) throws BPWSRuntimeException {
    }

    public void activityRunning(LifecycleEvent event) {
    }

    protected void complete() throws BPWSRuntimeException {
        if (this.status != 4) {
            throw new BPWSRuntimeException("trying to complete an activity that is not running");
        }
        this.disableUncompletedChildren();
        this.resetState();
        this.fireLifecycleEvent(5);
        this.fireLinks(true);
    }

    public void disable() throws BPWSRuntimeException {
        this.disableUncompletedChildren();
        this.resetState();
        this.fireLifecycleEvent(1);
        this.fireLinks(false);
    }

    public void disableUncompletedChildren() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)(String.valueOf(this.name) + " is disabling uncompleted children"));
        LinkedList<ActivityRT> theNonScopes = new LinkedList<ActivityRT>();
        Iterator childIterator = this.children.iterator();
        while (childIterator.hasNext()) {
            ActivityRT activity = (ActivityRT)childIterator.next();
            if (activity.getStatus() == 5 || activity.getStatus() == 1) continue;
            runtimeLogger.debug((Object)("uncompleted child being disabled " + activity));
            if (activity.getType() == 11) {
                ScopeRT s = (ScopeRT)activity;
                if (s.isCompensationHandlerShield && (s.scope == null || !s.scope.isExiting())) continue;
                s.disable();
                continue;
            }
            theNonScopes.add(activity);
        }
        Iterator nonScopesIter = theNonScopes.iterator();
        while (nonScopesIter.hasNext()) {
            ActivityRT activity = (ActivityRT)nonScopesIter.next();
            if (activity.getStatus() == 5 || activity.getStatus() == 1) continue;
            activity.disable();
        }
    }

    public List getChildren() {
        return this.children;
    }

    public void revive() throws BPWSRuntimeException {
        super.revive();
        Iterator childIterator = this.children.iterator();
        while (childIterator.hasNext()) {
            ActivityRT activity = (ActivityRT)childIterator.next();
            runtimeLogger.debug((Object)("child being revived " + activity.name));
            activity.revive();
        }
    }
}

