/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.CompoundActivityRT;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FlowRT
extends CompoundActivityRT
implements Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    private int numCompletedChildren = 0;

    public FlowRT(String name, ScopeRT scope, ActivityRT parentActivity) {
        super(name, scope, parentActivity);
    }

    public void activate() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Starting flow " + this.name + " Activity "));
        super.activate();
    }

    public void activityCompleted(LifecycleEvent e) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Flow " + this.name + " heard of end of " + e.getSource().name));
        if (this.status != 1 && this.children.contains(e.getSource())) {
            ++this.numCompletedChildren;
            if (this.children.size() == this.numCompletedChildren) {
                runtimeLogger.debug((Object)("Flow " + this.name + " done"));
                this.complete();
            }
        } else {
            runtimeLogger.debug((Object)("flow " + this.name + " received a lifecycle completed activity from a non-child!! "));
        }
    }

    public void activityEnabled(LifecycleEvent e) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Flow " + this.name + " about to run " + e.getSource().name));
        if (this.status != 1 && this.children.contains(e.getSource())) {
            e.getSource().go();
        }
    }

    public void addActivity(ActivityRT activity) {
        this.children.add(activity);
        activity.addLifecycleListener(this);
    }

    public int getType() {
        return 5;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Flow " + this.name + " is running"));
        Iterator iter = this.children.iterator();
        while (iter.hasNext() && this.status != 1) {
            ((ActivityRT)iter.next()).activate();
        }
    }

    public void resetState() {
        super.resetState();
        this.numCompletedChildren = 0;
    }
}

