/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.ContainerRT;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.util.IntTuple;
import com.ibm.wsif.WSIFMessage;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class InvokeRT
extends ActivityRT
implements Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    private int myID = -1;
    private int numIterations = 0;
    private IntTuple invokeCorrelationInfo = new IntTuple(0, 0);
    String inputContainerName;
    String outputContainerName;
    String partnerName;
    QName portTypeName;
    String operationName;
    BPWSProcessRT bpwsProcessRT;

    public InvokeRT(String name, ScopeRT scope, ActivityRT parentActivity, BPWSProcessRT bpwsProcessRT, String partnerName, QName portTypeName, String operationName) {
        super(name, scope, parentActivity);
        this.partnerName = partnerName;
        this.portTypeName = portTypeName;
        this.operationName = operationName;
        this.bpwsProcessRT = bpwsProcessRT;
    }

    public int getID() {
        if (this.myID != -1) {
            this.myID = this.hashCode();
        }
        return this.myID;
    }

    public int getType() {
        return 6;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Invoke " + this.name + " is running"));
        ++this.numIterations;
        ContainerRT inputContainer = this.getContainer(this.inputContainerName);
        this.bpwsProcessRT.registerCorrelationInformation(this.activityModel, inputContainer.getMessage(), false);
        this.invokeCorrelationInfo.id1 = this.getID();
        this.invokeCorrelationInfo.id2 = this.numIterations;
        this.bpwsProcessRT.invoke(this.invokeCorrelationInfo, this, this.partnerName, this.portTypeName, this.operationName, inputContainer.getMessage());
    }

    public void invocationReturned(WSIFMessage output, boolean isFault, Object clientData) throws BPWSRuntimeException {
        if (this.status != 4 || !this.invokeCorrelationInfo.equals(clientData)) {
            return;
        }
        runtimeLogger.debug((Object)("Invocation " + this.name + " returned"));
        if (!isFault) {
            this.bpwsProcessRT.registerCorrelationInformation(this.activityModel, output, true);
            this.getContainer(this.outputContainerName).setMessage(output);
            this.complete();
        } else {
            QName faultQName = QName.valueOf(output.getName());
            this.fireFaultEvent(new FaultEvent(this, faultQName, output));
        }
    }

    public void setInputContainerName(String containerName) {
        this.inputContainerName = containerName;
    }

    public void setOutputContainerName(String containerName) {
        this.outputContainerName = containerName;
    }
}

