/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime.container;

import com.ibm.bpws.model.Activity;
import com.ibm.bpws.model.BPWSProcess;
import com.ibm.bpws.model.CaseClause;
import com.ibm.bpws.model.CatchAll;
import com.ibm.bpws.model.CatchFault;
import com.ibm.bpws.model.CompensationHandler;
import com.ibm.bpws.model.Correlation;
import com.ibm.bpws.model.CorrelationSet;
import com.ibm.bpws.model.CorrelationSets;
import com.ibm.bpws.model.Correlations;
import com.ibm.bpws.model.FaultHandlers;
import com.ibm.bpws.model.Flow;
import com.ibm.bpws.model.Invoke;
import com.ibm.bpws.model.OnAlarm;
import com.ibm.bpws.model.OnMessage;
import com.ibm.bpws.model.Pick;
import com.ibm.bpws.model.Receive;
import com.ibm.bpws.model.Reply;
import com.ibm.bpws.model.Scope;
import com.ibm.bpws.model.Sequence;
import com.ibm.bpws.model.SwitchBlock;
import com.ibm.bpws.model.While;
import com.ibm.cs.bpws.compiler.BPWSCompiler;
import com.ibm.cs.bpws.parser.BPWSParser;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.container.BPWSManager;
import com.ibm.cs.bpws.runtime.events.ReceiveEvent;
import com.ibm.cs.bpws.util.xpath.XPathFunctions;
import com.ibm.jrom.JROMValue;
import com.ibm.wsdl.extensions.messageproperties.MessagePropertiesExtensionRegistry;
import com.ibm.wsdl.extensions.messageproperties.PropertyAlias;
import com.ibm.wsgw.WSGWException;
import com.ibm.wsgw.WSGWService;
import com.ibm.wsgw.WSGateway;
import com.ibm.wsif.WSIFDynamicPortFactory;
import com.ibm.wsif.WSIFMessage;
import com.ibm.wsif.WSIFPart;
import com.ibm.wsif.WSIFRequest;
import com.ibm.wsif.WSIFResponse;
import com.ibm.wsif.stub.WSIFUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.wsdl.Operation;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import samples.apachesoap.JROMDOMConvertor;

public class BPWSContainerProcessService
extends WSGWService
implements Serializable {
    static Logger processLogger = Logger.getLogger((String)"bpws.runtime.process");
    static Logger correlationLogger = Logger.getLogger((String)"bpws.runtime.process.correlation");
    transient WSGateway gateway;
    transient BPWSManager flowMgr;
    BPWSProcess processModel;
    transient BPWSProcessRT compiledModel = null;
    HashMap partners = new HashMap();
    transient LinkedList receptionPointList = null;
    transient LinkedList pickList = null;
    transient HashSet invocationPartnerSet = null;
    transient Hashtable correlationInstanceMap = new Hashtable();
    transient Hashtable instanceCorrelationMap = new Hashtable();

    public BPWSContainerProcessService(WSGateway gateway, BPWSManager flowMgr, InputStream wsdlFile, InputStream bpwsFile) throws WSGWException {
        try {
            WSIFDynamicPortFactory.addExtensionRegistry((ExtensionRegistry)new MessagePropertiesExtensionRegistry());
            this.wsdlDefinition = WSIFUtils.readWSDL(null, (Reader)new InputStreamReader(wsdlFile));
        }
        catch (WSDLException e) {
            throw new WSGWException("Error loading WSDL: " + e.getMessage(), (Throwable)e);
        }
        this.wsdlLoaded = true;
        Iterator services = this.wsdlDefinition.getServices().values().iterator();
        if (!services.hasNext()) {
            throw new WSGWException("WSDL Document must have one 'service' element - none found.");
        }
        Service service = (Service)services.next();
        if (services.hasNext()) {
            throw new WSGWException("WSDL Document has more than one 'service' element - currently unsupported.");
        }
        this.serviceQName = service.getQName();
        this.id = new QName(service.getQName().getNamespaceURI(), service.getQName().getLocalPart());
        this.gateway = gateway;
        this.flowMgr = flowMgr;
        boolean status = false;
        try {
            this.processModel = BPWSParser.readBPWS(bpwsFile);
            status = true;
            this.getCompiledModel();
        }
        catch (BPWSRuntimeException e) {
            String msg = !status ? "exception while reading BPWS file: " : "exception while compiling BPWS file: ";
            throw new WSGWException("BPWSContainerProcessService: " + msg + e.getMessage(), (Throwable)e);
        }
    }

    public BPWSContainerProcessService(WSGateway gateway, BPWSManager flowMgr, URL wsdlURL, URL bpwsURL) throws WSGWException {
        this.wsdlURL = wsdlURL;
        try {
            WSIFDynamicPortFactory.addExtensionRegistry((ExtensionRegistry)new MessagePropertiesExtensionRegistry());
            this.wsdlDefinition = WSIFUtils.readWSDL(null, (String)wsdlURL.toString());
        }
        catch (WSDLException e) {
            throw new WSGWException("Error loading WSDL: " + e.getMessage(), (Throwable)e);
        }
        this.wsdlLoaded = true;
        Iterator services = this.wsdlDefinition.getServices().values().iterator();
        if (!services.hasNext()) {
            throw new WSGWException("WSDL Document must have one 'service' element - none found.");
        }
        Service service = (Service)services.next();
        if (services.hasNext()) {
            throw new WSGWException("WSDL Document has more than one 'service' element - currently unsupported.");
        }
        this.serviceQName = service.getQName();
        this.id = new QName(service.getQName().getNamespaceURI(), service.getQName().getLocalPart());
        this.gateway = gateway;
        this.flowMgr = flowMgr;
        boolean status = false;
        try {
            this.processModel = BPWSParser.readBPWS(null, bpwsURL);
            status = true;
            this.getCompiledModel();
        }
        catch (BPWSRuntimeException e) {
            String msg = !status ? "exception while reading BPWS file: " : "exception while compiling BPWS file: ";
            throw new WSGWException("BPWSContainerProcessService: " + msg + e.getMessage(), (Throwable)e);
        }
    }

    private BPWSProcessRT createInstance() throws BPWSRuntimeException {
        this.compiledModel = null;
        this.compiledModel = this.getCompiledModel();
        this.instanceCorrelationMap.put(this.compiledModel, new Vector());
        return this.compiledModel;
    }

    public void executeServiceRequest(WSIFRequest request, WSIFResponse response) throws WSGWException {
        processLogger.info((Object)"Executing Process");
        Iterator receptionPointIterator = this.getReceptionPoints();
        Serializable matchingInitializer = null;
        LinkedList<Serializable> matchingReceptionPoints = new LinkedList<Serializable>();
        WSIFMessage contextMsg = request.getContextMessage();
        WSIFPart partnerNamePart = contextMsg.getPart("bpws.partner");
        WSIFPart portTypePart = contextMsg.getPart("bpws.portType");
        String partnerName = (String)partnerNamePart.getJavaValue();
        QName portTypeName = (QName)portTypePart.getJavaValue();
        String operationName = request.getOperationName();
        if (processLogger.isDebugEnabled()) {
            processLogger.debug((Object)("Trying to match an entrypoint with a signature of partnername: " + partnerName + " operation: " + operationName + " and porttype: " + portTypeName));
        }
        while (receptionPointIterator.hasNext()) {
            Object receptionObj = receptionPointIterator.next();
            if (receptionObj instanceof Receive) {
                Receive recv = (Receive)receptionObj;
                if (processLogger.isDebugEnabled()) {
                    processLogger.debug((Object)("Testing against a receive, " + recv.getName() + ", with a signature of partnername: " + recv.getPartner().getName() + " operation: " + recv.getOperation() + " and porttype: " + recv.getPortType()));
                }
                if (!recv.getPartner().getName().equals(partnerName) || !recv.getOperation().equals(operationName) || !recv.getPortType().equals(portTypeName)) continue;
                processLogger.debug((Object)("We will examine this receive, " + recv.getName() + ", for correlation"));
                Boolean ci = recv.getCreateInstance();
                if (ci != null && ci.booleanValue()) {
                    processLogger.debug((Object)("We will use this receive, " + recv.getName() + " if no instance is found"));
                    matchingInitializer = recv;
                }
                matchingReceptionPoints.add(recv);
                continue;
            }
            OnMessage onmsg = (OnMessage)receptionObj;
            if (processLogger.isDebugEnabled()) {
                processLogger.debug((Object)("Testing against an onMsg with a signature of partnername: " + onmsg.getPartner().getName() + " operation: " + onmsg.getOperation() + " and porttype: " + onmsg.getPortType()));
            }
            if (!onmsg.getPartner().getName().equals(partnerName) || !onmsg.getOperation().equals(operationName) || !onmsg.getPortType().equals(portTypeName)) continue;
            Activity parentPick = null;
            Iterator pickIterator = this.pickList.iterator();
            while (pickIterator.hasNext()) {
                Pick tmpPick = (Pick)pickIterator.next();
                List tmpList = tmpPick.getOnMessages();
                if (tmpList == null || !tmpList.contains(onmsg)) continue;
                parentPick = tmpPick;
                break;
            }
            processLogger.debug((Object)("We will examine this onMessage, a child of " + parentPick.getName() + ", for correlation"));
            Boolean ci = parentPick.getCreateInstance();
            if (ci != null && ci.booleanValue()) {
                processLogger.debug((Object)("We will use this onMessage, a child of " + parentPick.getName() + " if no instance is found"));
                matchingInitializer = onmsg;
            }
            matchingReceptionPoints.add(onmsg);
        }
        BPWSProcessRT cg = null;
        processLogger.info((Object)"Looking for an existing process instance");
        ListIterator matchingReceptionPointsIterator = matchingReceptionPoints.listIterator();
        while (matchingReceptionPointsIterator.hasNext()) {
            QName messageType;
            Correlations correlations = null;
            Object matchingReceptionPoint = matchingReceptionPointsIterator.next();
            if (matchingReceptionPoint instanceof Receive) {
                correlations = ((Receive)matchingReceptionPoint).getCorrelations();
                messageType = ((Receive)matchingReceptionPoint).getContainer().getMessageType();
            } else {
                correlations = ((OnMessage)matchingReceptionPoint).getCorrelations();
                messageType = ((OnMessage)matchingReceptionPoint).getContainer().getMessageType();
            }
            if (correlations == null) continue;
            List correlationList = correlations.getCorrelations();
            ListIterator correlationListIterator = correlationList.listIterator();
            while (correlationListIterator.hasNext()) {
                Correlation correlation = (Correlation)correlationListIterator.next();
                String setName = correlation.getSet();
                Vector<Object> correlationVector = new Vector<Object>();
                correlationVector.add(setName);
                correlationLogger.debug((Object)("Testing correlation set: " + setName));
                CorrelationSets correlationSets = this.processModel.getCorrelationSets();
                List correlationSetList = correlationSets.getCorrelationSets();
                ListIterator correlationSetListIterator = correlationSetList.listIterator();
                while (correlationSetListIterator.hasNext()) {
                    CorrelationSet correlationSet = (CorrelationSet)correlationSetListIterator.next();
                    if (!setName.equals(correlationSet.getName())) continue;
                    Iterator propertyListIterator = correlationSet.getProperties().iterator();
                    while (propertyListIterator.hasNext()) {
                        QName propertyQName = (QName)propertyListIterator.next();
                        boolean foundAMatch = false;
                        ListIterator extElIterator = this.getWSDL().getExtensibilityElements().listIterator();
                        while (extElIterator.hasNext()) {
                            PropertyAlias propertyAlias;
                            ExtensibilityElement extEl = (ExtensibilityElement)extElIterator.next();
                            if (!(extEl instanceof PropertyAlias) || !(propertyAlias = (PropertyAlias)extEl).getPropertyName().equals(propertyQName) || !propertyAlias.getMessageType().equals(messageType)) continue;
                            WSIFMessage requestMsg = request.getIncomingMessage();
                            WSIFPart correlationPart = requestMsg.getPart(propertyAlias.getPart());
                            PropertyValue propValue = new PropertyValue();
                            propValue.name = propertyAlias.getPropertyName().toString();
                            String propQuery = propertyAlias.getQuery();
                            if (propQuery == null) {
                                propValue.value = (JROMValue)correlationPart.getJavaValue();
                            } else {
                                try {
                                    propValue.value = XPathFunctions.evaluateQuery((JROMValue)correlationPart.getJavaValue(), propQuery, new JROMDOMConvertor());
                                }
                                catch (Exception e) {
                                    throw new WSGWException("BPWS Runtime: Error while looking for instance: " + e.getMessage(), (Throwable)e);
                                }
                            }
                            propValue.value.setNameNamespace(propertyAlias.getPropertyName().getNamespaceURI());
                            propValue.value.setNameLocalPart(propertyAlias.getPropertyName().getLocalPart());
                            correlationLogger.debug((Object)("Testing correlation information: " + propValue));
                            correlationVector.add(propValue);
                            foundAMatch = true;
                        }
                        if (foundAMatch) continue;
                        correlationLogger.warn((Object)("Could not find a propertyAlias for " + propertyQName));
                        break;
                    }
                    cg = (BPWSProcessRT)this.correlationInstanceMap.get(correlationVector);
                    if (cg != null) {
                        correlationLogger.debug((Object)"Testing correlation information: Match found");
                        break;
                    }
                    correlationLogger.debug((Object)"Testing correlation information: Match not found");
                    break;
                }
                if (cg != null) break;
            }
            if (cg != null) break;
        }
        if (cg == null) {
            processLogger.info((Object)"An existing process instance was not found");
            if (matchingInitializer != null) {
                processLogger.info((Object)"Creating a new process instance");
                try {
                    cg = this.createInstance();
                }
                catch (BPWSRuntimeException e) {
                    processLogger.warn((Object)"Could not create the instance", (Throwable)e);
                    throw new WSGWException("BPWS Runtime: Error while creating instance: " + e.getMessage(), (Throwable)e);
                }
                this.flowMgr.registerFlowInstance(cg, this);
                cg.setBPWSManager(this.flowMgr);
                cg.start();
            } else {
                processLogger.warn((Object)"Neither a flow instance, nor a valid instance creation receive could be found");
                throw new WSGWException("BPWSContainerProcessService: Neither a flow instance, nor a valid instance creation receive could be found.");
            }
        }
        boolean waitForResponse = true;
        Iterator operationIterator = this.getWSDL().getPortType(portTypeName).getOperations().iterator();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            if (!operation.getName().equals(operationName)) continue;
            if (operation.getOutput() == null) {
                waitForResponse = false;
                break;
            }
            waitForResponse = true;
            break;
        }
        WSIFRequest clientData = request;
        cg.deliverEvent(new ReceiveEvent(clientData, request.getIncomingMessage(), request.getContextMessage(), partnerName, portTypeName, operationName));
        if (waitForResponse) {
            BPWSManager.ReplyDataStruct rds = this.flowMgr.waitForMessageFromProcess(request);
            response.setIsFault(rds.isFault);
            if (rds.isFault) {
                response.setFaultMessage(rds.replyMsg);
            } else {
                response.setOutgoingMessage(rds.replyMsg);
            }
            response.setContextMessage(rds.contextMsg);
        }
    }

    public QName findPartner(String partner) {
        return (QName)this.partners.get(partner);
    }

    private LinkedList findReceptionPoints(Activity activity) {
        if (activity instanceof Receive) {
            LinkedList<Activity> receptionPointList = new LinkedList<Activity>();
            receptionPointList.add(activity);
            return receptionPointList;
        }
        if (activity instanceof Sequence) {
            LinkedList receptionPointList = new LinkedList();
            LinkedList tmpList = null;
            Iterator activityIterator = ((Sequence)activity).getActivities().iterator();
            while (activityIterator.hasNext()) {
                tmpList = this.findReceptionPoints((Activity)activityIterator.next());
                if (tmpList == null) continue;
                receptionPointList.addAll(tmpList);
            }
            return receptionPointList;
        }
        if (activity instanceof Invoke) {
            LinkedList receptionPointList = new LinkedList();
            LinkedList tmpList = null;
            this.invocationPartnerSet.add(((Invoke)activity).getPartner());
            Iterator catchFaultsIterator = ((Invoke)activity).getCatchFaults().iterator();
            while (catchFaultsIterator.hasNext()) {
                tmpList = this.findReceptionPoints(((CatchFault)catchFaultsIterator.next()).getActivity());
                if (tmpList == null) continue;
                receptionPointList.addAll(tmpList);
            }
            if (((Invoke)activity).getCompensationHandler() != null && (tmpList = this.findReceptionPoints(((Invoke)activity).getCompensationHandler().getActivity())) != null) {
                receptionPointList.addAll(tmpList);
            }
            return receptionPointList;
        }
        if (activity instanceof SwitchBlock) {
            LinkedList receptionPointList = new LinkedList();
            LinkedList tmpList = null;
            Iterator caseClauseIterator = ((SwitchBlock)activity).getCaseClauses().iterator();
            while (caseClauseIterator.hasNext()) {
                tmpList = this.findReceptionPoints(((CaseClause)caseClauseIterator.next()).getActivity());
                if (tmpList == null) continue;
                receptionPointList.addAll(tmpList);
            }
            if (((SwitchBlock)activity).getOtherwise() != null && (tmpList = this.findReceptionPoints(((SwitchBlock)activity).getOtherwise().getActivity())) != null) {
                receptionPointList.addAll(tmpList);
            }
            return receptionPointList;
        }
        if (activity instanceof While) {
            return this.findReceptionPoints(((While)activity).getActivity());
        }
        if (activity instanceof Pick) {
            this.pickList.add(activity);
            LinkedList<OnMessage> receptionPointList = new LinkedList<OnMessage>();
            LinkedList tmpList = null;
            Iterator onMessageIterator = ((Pick)activity).getOnMessages().iterator();
            while (onMessageIterator.hasNext()) {
                OnMessage onMessage = (OnMessage)onMessageIterator.next();
                receptionPointList.add(onMessage);
                tmpList = this.findReceptionPoints(onMessage.getActivity());
                if (tmpList == null) continue;
                receptionPointList.addAll(tmpList);
            }
            Iterator onAlarmIterator = ((Pick)activity).getOnAlarms().iterator();
            while (onAlarmIterator.hasNext()) {
                tmpList = this.findReceptionPoints(((OnAlarm)onAlarmIterator.next()).getActivity());
                if (tmpList == null) continue;
                receptionPointList.addAll(tmpList);
            }
            return receptionPointList;
        }
        if (activity instanceof Flow) {
            LinkedList receptionPointList = new LinkedList();
            LinkedList tmpList = null;
            Iterator activityIterator = ((Flow)activity).getActivities().iterator();
            while (activityIterator.hasNext()) {
                tmpList = this.findReceptionPoints((Activity)activityIterator.next());
                if (tmpList == null) continue;
                receptionPointList.addAll(tmpList);
            }
            return receptionPointList;
        }
        if (activity instanceof Scope) {
            LinkedList receptionPointList = new LinkedList();
            LinkedList tmpList = null;
            tmpList = this.findReceptionPoints(((Scope)activity).getActivity());
            if (tmpList != null) {
                receptionPointList.addAll(tmpList);
            }
            return receptionPointList;
        }
        return null;
    }

    public BPWSProcess getBPWS() {
        return this.processModel;
    }

    public BPWSProcessRT getCompiledModel() throws BPWSRuntimeException {
        if (this.compiledModel == null) {
            BPWSCompiler cp = new BPWSCompiler();
            this.compiledModel = cp.compileBPWS(this.processModel);
        }
        return this.compiledModel;
    }

    public Iterator getInvocationPartners() {
        this.getReceptionPoints();
        return this.invocationPartnerSet.iterator();
    }

    public Iterator getReceptionPoints() {
        if (this.receptionPointList == null) {
            CompensationHandler compensationHandler;
            FaultHandlers faultHandlers;
            this.receptionPointList = new LinkedList();
            this.pickList = new LinkedList();
            this.invocationPartnerSet = new HashSet();
            LinkedList tmpList = null;
            tmpList = this.findReceptionPoints(this.processModel.getActivity());
            if (tmpList != null) {
                this.receptionPointList.addAll(tmpList);
            }
            if ((faultHandlers = this.processModel.getFaultHandlers()) != null) {
                Iterator catchIterator = faultHandlers.getCatchFaults().iterator();
                while (catchIterator.hasNext()) {
                    tmpList = this.findReceptionPoints(((CatchFault)catchIterator.next()).getActivity());
                    if (tmpList == null) continue;
                    this.receptionPointList.addAll(tmpList);
                }
                CatchAll ca = faultHandlers.getCatchAll();
                if (ca != null && (tmpList = this.findReceptionPoints(ca.getActivity())) != null) {
                    this.receptionPointList.addAll(tmpList);
                }
            }
            if ((compensationHandler = this.processModel.getCompensationHandler()) != null && (tmpList = this.findReceptionPoints(compensationHandler.getActivity())) != null) {
                this.receptionPointList.addAll(tmpList);
            }
        }
        return this.receptionPointList.listIterator(0);
    }

    public boolean hasPartnerMapping(String partner) {
        return this.partners.containsKey(partner);
    }

    public void initialize(WSGateway gateway) {
        this.gateway = gateway;
        this.flowMgr = gateway.getFlowManager();
        this.compiledModel = null;
        this.receptionPointList = null;
        this.correlationInstanceMap = new Hashtable();
        this.instanceCorrelationMap = new Hashtable();
    }

    /*
     * Unable to fully structure code
     */
    public void initializeCorrelationSets(BPWSProcessRT cg, Object modelObject, WSIFMessage wsifMsg, boolean in) throws BPWSRuntimeException {
        block18: {
            correlations = null;
            isForInvoke = false;
            if (modelObject instanceof Receive) {
                correlations = ((Receive)modelObject).getCorrelations();
                messageType = ((Receive)modelObject).getContainer().getMessageType();
            } else if (modelObject instanceof Reply) {
                correlations = ((Reply)modelObject).getCorrelations();
                messageType = ((Reply)modelObject).getContainer().getMessageType();
            } else if (modelObject instanceof Invoke) {
                correlations = ((Invoke)modelObject).getCorrelations();
                messageType = in != false ? ((Invoke)modelObject).getInputContainer().getMessageType() : ((Invoke)modelObject).getOutputContainer().getMessageType();
                isForInvoke = true;
            } else if (modelObject instanceof OnMessage) {
                correlations = ((OnMessage)modelObject).getCorrelations();
                messageType = ((OnMessage)modelObject).getContainer().getMessageType();
            } else {
                BPWSContainerProcessService.correlationLogger.warn((Object)("We don't support correlation sets on a " + modelObject.getClass().getName()));
                throw new BPWSRuntimeException("BPWS Runtime: We don't support correlation sets on a " + modelObject.getClass().getName());
            }
            if (correlations == null) break block18;
            correlationList = correlations.getCorrelations();
            correlationListIterator = correlationList.listIterator();
            block4: while (correlationListIterator.hasNext()) {
                correlation = (Correlation)correlationListIterator.next();
                if (!correlation.getInitiation().booleanValue() || isForInvoke && (!isForInvoke || (!correlation.getPattern().equals("in") || !in) && (!correlation.getPattern().equals("out") && !correlation.getPattern().equals("out-in") || in))) continue;
                setName = correlation.getSet();
                correlationVector = new Vector<Object>();
                correlationVector.add(setName);
                BPWSContainerProcessService.correlationLogger.debug((Object)("Adding correlation set: " + setName));
                correlationSets = this.processModel.getCorrelationSets();
                correlationSetList = correlationSets.getCorrelationSets();
                correlationSetListIterator = correlationSetList.listIterator();
                while (correlationSetListIterator.hasNext()) {
                    correlationSet = (CorrelationSet)correlationSetListIterator.next();
                    if (!setName.equals(correlationSet.getName())) continue;
                    propertyListIterator = correlationSet.getProperties().iterator();
                    while (propertyListIterator.hasNext()) {
                        propertyQName = (QName)propertyListIterator.next();
                        try {
                            extElIterator = this.getWSDL().getExtensibilityElements().listIterator();
                            if (true) ** GOTO lbl67
                        }
                        catch (WSGWException e) {
                            BPWSContainerProcessService.correlationLogger.warn((Object)"Error while getting extensibility elements from the WSDL document", (Throwable)e);
                            throw new BPWSRuntimeException("BPWS Runtime: Error while getting extensibility elements from the WSDL document: " + e.getMessage(), e);
                        }
                        do {
                            if (!((extEl = (ExtensibilityElement)extElIterator.next()) instanceof PropertyAlias) || !(propertyAlias = (PropertyAlias)extEl).getPropertyName().equals(propertyQName) || !propertyAlias.getMessageType().equals(messageType)) continue;
                            correlationPart = wsifMsg.getPart(propertyAlias.getPart());
                            propValue = new PropertyValue();
                            propValue.name = propertyAlias.getPropertyName().toString();
                            propQuery = propertyAlias.getQuery();
                            if (propQuery == null) {
                                propValue.value = (JROMValue)correlationPart.getJavaValue();
                            } else {
                                try {
                                    propValue.value = XPathFunctions.evaluateQuery((JROMValue)correlationPart.getJavaValue(), propQuery, new JROMDOMConvertor());
                                }
                                catch (Exception e) {
                                    throw new BPWSRuntimeException("BPWS Runtime: Error while looking for instance: " + e.getMessage(), e);
                                }
                            }
                            propValue.value.setNameNamespace(propertyAlias.getPropertyName().getNamespaceURI());
                            propValue.value.setNameLocalPart(propertyAlias.getPropertyName().getLocalPart());
                            correlationVector.add(propValue);
                            BPWSContainerProcessService.correlationLogger.debug((Object)("Added correlation information: " + propValue));
lbl67:
                            // 3 sources

                        } while (extElIterator.hasNext());
                    }
                    this.correlationInstanceMap.put(correlationVector, cg);
                    icmvec = (Vector)this.instanceCorrelationMap.get(cg);
                    icmvec.add(correlationVector);
                    continue block4;
                }
            }
        }
    }

    public void mapPartner(String partner, QName serviceid) {
        this.partners.put(partner, serviceid);
    }

    public void removeFlowInstance(BPWSProcessRT cg) {
        Iterator correlationInformationIterator = ((AbstractList)((Vector)this.instanceCorrelationMap.get(cg))).iterator();
        while (correlationInformationIterator.hasNext()) {
            this.correlationInstanceMap.remove((Vector)correlationInformationIterator.next());
        }
        this.instanceCorrelationMap.remove(cg);
        this.flowMgr.deregisterFlowInstance(cg);
    }

    class PropertyValue {
        String name;
        JROMValue value;

        PropertyValue() {
        }

        public boolean equals(Object arg) {
            if (arg != null && arg instanceof PropertyValue) {
                return this.name.equals(((PropertyValue)arg).name) && this.value.equals(((PropertyValue)arg).value);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.value.hashCode();
        }

        public String toString() {
            return "PropertyValue[name:" + this.name.toString() + " value:" + this.value.toString() + "]";
        }
    }
}

