/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime.events;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.Monitor;
import com.ibm.cs.bpws.runtime.events.AlarmEvent;
import com.ibm.cs.bpws.runtime.events.AlarmListener;
import com.ibm.cs.bpws.runtime.events.AnyEvent;
import com.ibm.cs.bpws.runtime.events.BPWSEvent;
import com.ibm.cs.bpws.runtime.events.BPWSEventListener;
import com.ibm.cs.bpws.runtime.events.BPWSEventType;
import com.ibm.cs.bpws.runtime.events.CompensationHandledEvent;
import com.ibm.cs.bpws.runtime.events.CompensationHandledListener;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.runtime.events.FaultListener;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import com.ibm.cs.bpws.runtime.events.LifecycleListener;
import com.ibm.cs.bpws.runtime.events.LinkEvent;
import com.ibm.cs.bpws.runtime.events.LinkListener;
import com.ibm.cs.bpws.runtime.events.ReceiveEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class EventChannel
implements Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    private HashMap listeners;
    private LinkedList pendingReceiveEvents = new LinkedList();
    private LinkedList consumedReceiveEvents = new LinkedList();

    public EventChannel() {
        this.listeners = new HashMap();
        this.listeners.put(BPWSEventType.LIFECYCLE_EVENT_TYPE, new LinkedList());
        this.listeners.put(BPWSEventType.RECEIVE_EVENT_TYPE, new LinkedList());
        this.listeners.put(BPWSEventType.LINK_EVENT_TYPE, new LinkedList());
        this.listeners.put(BPWSEventType.ALARM_EVENT_TYPE, new LinkedList());
        this.listeners.put(BPWSEventType.REPLY_EVENT_TYPE, new LinkedList());
        this.listeners.put(BPWSEventType.COMPENSATE_EVENT_TYPE, new LinkedList());
        this.listeners.put(BPWSEventType.FAULT_EVENT_TYPE, new LinkedList());
    }

    public void addListener(BPWSEventListener listener) throws BPWSRuntimeException {
        this.addListener(listener, new AnyEvent(), false);
    }

    public void addListener(BPWSEventListener listener, BPWSEvent eventTemplate) throws BPWSRuntimeException {
        this.addListener(listener, eventTemplate, false);
    }

    public void addListener(BPWSEventListener listener, BPWSEvent eventTemplate, boolean highPriority) throws BPWSRuntimeException {
        if (this.listenerAlreadyRegistered(listener, eventTemplate)) {
            runtimeLogger.warn((Object)("Will not register previously registered listener " + listener));
            return;
        }
        ChoosyListener choosyListener = new ChoosyListener(listener, eventTemplate);
        BPWSEventType eventType = eventTemplate.getType();
        if (eventType != null && eventType.equals(BPWSEventType.RECEIVE_EVENT_TYPE) && listener instanceof ActivityRT) {
            ReceiveListener listenerRcv = (ReceiveListener)listener;
            ReceiveEvent template = (ReceiveEvent)eventTemplate;
            ReceiveEvent pendingReceive = this.checkPendingReceives(choosyListener);
            if (pendingReceive != null) {
                runtimeLogger.debug((Object)("found pending receive for listener" + listener));
                ReceiveEvent conflictingRequest = this.firstMatchingReceive(false, this.consumedReceiveEvents, template.getPartnerName(), template.getPortTypeName(), template.getOperationName());
                if (conflictingRequest == null) {
                    this.consumedReceiveEvents.add(pendingReceive);
                    ((ReceiveListener)listener).messageReceived(pendingReceive);
                } else {
                    listenerRcv.fireConflictingRequestFault();
                }
            } else {
                List listenersForType = (List)this.listeners.get(eventType);
                ReceiveEvent conflictingReceive = this.firstMatchingReceive(false, listenersForType, template.getPartnerName(), template.getPortTypeName(), template.getOperationName());
                runtimeLogger.debug((Object)("adding receive listener " + listener));
                if (conflictingReceive == null) {
                    listenersForType.add(choosyListener);
                } else {
                    listenerRcv.fireConflictingReceiveFault();
                }
            }
        } else if (eventType != null && !eventType.equals(BPWSEventType.ANY_EVENT_TYPE)) {
            List listenersForType = (List)this.listeners.get(eventType);
            if (highPriority) {
                listenersForType.add(0, choosyListener);
            } else {
                listenersForType.add(choosyListener);
            }
        } else {
            ChoosyListener alwaysHappyListener = new ChoosyListener(this, listener, eventTemplate){

                public boolean isHappyWith(BPWSEvent event) {
                    return true;
                }
            };
            Iterator eventTypes = this.listeners.keySet().iterator();
            while (eventTypes.hasNext()) {
                BPWSEventType currentEventType = (BPWSEventType)eventTypes.next();
                if (currentEventType.equals(BPWSEventType.RECEIVE_EVENT_TYPE)) continue;
                List listenersForType = (List)this.listeners.get(currentEventType);
                if (highPriority) {
                    listenersForType.add(0, alwaysHappyListener);
                    continue;
                }
                listenersForType.add(alwaysHappyListener);
            }
        }
    }

    public void addMonitor(Monitor monitor) {
        try {
            this.addListener(monitor, new AnyEvent(), true);
        }
        catch (BPWSRuntimeException bPWSRuntimeException) {}
    }

    private ReceiveEvent checkPendingReceives(ChoosyListener listener) {
        Iterator pendingReceiveEventsIter = this.pendingReceiveEvents.iterator();
        while (pendingReceiveEventsIter.hasNext()) {
            ReceiveEvent event = (ReceiveEvent)pendingReceiveEventsIter.next();
            if (!listener.isHappyWith(event)) continue;
            pendingReceiveEventsIter.remove();
            return event;
        }
        return null;
    }

    private void fireAlarmEvent(AlarmEvent event) {
        List alarmListeners = (List)this.listeners.get(BPWSEventType.ALARM_EVENT_TYPE);
        Iterator listenerList = alarmListeners.iterator();
        while (listenerList.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenerList.next();
            if (!choosyListener.isHappyWith(event)) continue;
            AlarmListener listener = (AlarmListener)choosyListener.getListener();
            listener.alarmWentOff(event);
        }
    }

    private void fireCompensationHandledEvent(CompensationHandledEvent event) throws BPWSRuntimeException {
        CompensationHandledListener listener = null;
        List cListeners = (List)this.listeners.get(BPWSEventType.COMPENSATE_EVENT_TYPE);
        Iterator listenerList = cListeners.iterator();
        while (listenerList.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenerList.next();
            if (!choosyListener.isHappyWith(event)) continue;
            listener = (CompensationHandledListener)choosyListener.getListener();
            break;
        }
        if (listener != null) {
            listener.compensationHandled(event);
        }
    }

    private void fireFaultEvent(FaultEvent event) throws BPWSRuntimeException {
        List faultListeners = (List)this.listeners.get(BPWSEventType.FAULT_EVENT_TYPE);
        Iterator listenerList = faultListeners.iterator();
        while (listenerList.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenerList.next();
            if (!choosyListener.isHappyWith(event)) continue;
            FaultListener listener = (FaultListener)choosyListener.getListener();
            listener.faultThrown(event);
        }
    }

    public void fireLifecycleEvent(LifecycleEvent event) throws BPWSRuntimeException {
        int status = event.getStatus();
        List lifecycleListeners = (List)this.listeners.get(BPWSEventType.LIFECYCLE_EVENT_TYPE);
        Iterator listenerList = lifecycleListeners.iterator();
        while (listenerList.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenerList.next();
            if (!choosyListener.isHappyWith(event)) continue;
            LifecycleListener listener = (LifecycleListener)choosyListener.getListener();
            switch (status) {
                case 1: {
                    listener.activityDisabled(event);
                    break;
                }
                case 3: {
                    listener.activityEnabled(event);
                    break;
                }
                case 2: {
                    listener.activityActivated(event);
                    break;
                }
                case 4: {
                    listener.activityRunning(event);
                    break;
                }
                case 5: {
                    listener.activityCompleted(event);
                    break;
                }
            }
        }
    }

    private void fireLinkEvent(LinkEvent event) throws BPWSRuntimeException {
        List linkListeners = (List)this.listeners.get(BPWSEventType.LINK_EVENT_TYPE);
        Iterator listenerList = linkListeners.iterator();
        while (listenerList.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenerList.next();
            if (!choosyListener.isHappyWith(event)) continue;
            LinkListener listener = (LinkListener)choosyListener.getListener();
            if (event.linkWasActivated()) {
                listener.linkActivated(event);
                continue;
            }
            listener.linkDeactivated(event);
        }
    }

    private void fireReceiveEvent(ReceiveEvent event) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)"Firing receive event");
        ChoosyListener cListener = this.getReceiveListener(event);
        if (cListener == null) {
            this.pendingReceiveEvents.addLast(event);
        } else {
            ReceiveListener listener = (ReceiveListener)cListener.getListener();
            ReceiveEvent template = (ReceiveEvent)cListener.getEventTemplate();
            runtimeLogger.debug((Object)("sending message to listener " + listener));
            if (listener instanceof ActivityRT) {
                this.consumedReceiveEvents.add(event);
                listener.messageReceived(event);
            }
        }
    }

    private ReceiveEvent firstMatchingReceive(boolean remove, List receiveList, String partnerName, QName portTypeName, String operationName) {
        ReceiveEvent receive = null;
        Iterator receiveListIter = receiveList.iterator();
        while (receiveListIter.hasNext()) {
            Object obj = receiveListIter.next();
            receive = obj instanceof ChoosyListener ? (ReceiveEvent)((ChoosyListener)obj).getEventTemplate() : (ReceiveEvent)obj;
            if (!receive.getPartnerName().equals(partnerName) || !receive.getPortTypeName().equals(portTypeName) || !receive.getOperationName().equals(operationName)) continue;
            if (remove) {
                receiveListIter.remove();
            }
            return receive;
        }
        return null;
    }

    public Iterator getConsumedReceiveEvents() {
        return this.consumedReceiveEvents.iterator();
    }

    public Iterator getPendingReceiveEvents() {
        return this.pendingReceiveEvents.iterator();
    }

    private ChoosyListener getReceiveListener(ReceiveEvent event) {
        boolean foundListener = false;
        ChoosyListener choosyListener = null;
        List receiveListeners = (List)this.listeners.get(BPWSEventType.RECEIVE_EVENT_TYPE);
        Iterator listenerList = receiveListeners.iterator();
        while (listenerList.hasNext()) {
            choosyListener = (ChoosyListener)listenerList.next();
            runtimeLogger.debug((Object)("Checking against listener " + choosyListener.listener));
            if (!choosyListener.isHappyWith(event)) continue;
            foundListener = true;
            break;
        }
        if (foundListener) {
            return choosyListener;
        }
        return null;
    }

    public ReceiveEvent getWaitingReceive(String partnerName, QName portTypeName, String operationName) {
        return this.firstMatchingReceive(true, this.consumedReceiveEvents, partnerName, portTypeName, operationName);
    }

    private boolean listenerAlreadyRegistered(BPWSEventListener listener, BPWSEvent eventTemplate) {
        BPWSEventType type = eventTemplate.getType();
        if (type.equals(BPWSEventType.ANY_EVENT_TYPE)) {
            return false;
        }
        List listenerList = (List)this.listeners.get(eventTemplate.getType());
        Iterator listenersIt = listenerList.iterator();
        while (listenersIt.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenersIt.next();
            if (!choosyListener.getListener().equals(listener) || !choosyListener.isHappyWith(eventTemplate)) continue;
            return true;
        }
        return false;
    }

    public void processEvent(BPWSEvent event) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Event channel " + this + " is processing event " + event));
        BPWSEventType eventType = event.getType();
        if (eventType.equals(BPWSEventType.LIFECYCLE_EVENT_TYPE)) {
            this.fireLifecycleEvent((LifecycleEvent)event);
        } else if (eventType.equals(BPWSEventType.RECEIVE_EVENT_TYPE)) {
            this.fireReceiveEvent((ReceiveEvent)event);
        } else if (eventType.equals(BPWSEventType.LINK_EVENT_TYPE)) {
            this.fireLinkEvent((LinkEvent)event);
        } else if (eventType.equals(BPWSEventType.ALARM_EVENT_TYPE)) {
            this.fireAlarmEvent((AlarmEvent)event);
        } else if (eventType.equals(BPWSEventType.FAULT_EVENT_TYPE)) {
            this.fireFaultEvent((FaultEvent)event);
        } else if (eventType.equals(BPWSEventType.COMPENSATE_EVENT_TYPE)) {
            this.fireCompensationHandledEvent((CompensationHandledEvent)event);
        } else {
            runtimeLogger.error((Object)("Unknown event sent to event channel: " + event));
        }
    }

    public void removeCompensationHandledListener(CompensationHandledListener listener) {
        runtimeLogger.debug((Object)("removing listener " + listener));
        List cListeners = (List)this.listeners.get(BPWSEventType.COMPENSATE_EVENT_TYPE);
        Iterator listenerList = cListeners.iterator();
        while (listenerList.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenerList.next();
            if (!choosyListener.getListener().equals(listener)) continue;
            listenerList.remove();
        }
    }

    public void removeReceiveListener(ReceiveListener listener) {
        runtimeLogger.debug((Object)("removing listener " + listener));
        List receiveListeners = (List)this.listeners.get(BPWSEventType.RECEIVE_EVENT_TYPE);
        Iterator listenerList = receiveListeners.iterator();
        while (listenerList.hasNext()) {
            ChoosyListener choosyListener = (ChoosyListener)listenerList.next();
            if (!choosyListener.getListener().equals(listener)) continue;
            listenerList.remove();
        }
    }

    public class ChoosyListener
    implements Serializable {
        private BPWSEventListener listener;
        private BPWSEvent eventTemplate;

        public ChoosyListener(BPWSEventListener listener, BPWSEvent eventTemplate) {
            this.listener = listener;
            this.eventTemplate = eventTemplate;
        }

        public BPWSEvent getEventTemplate() {
            return this.eventTemplate;
        }

        public BPWSEventListener getListener() {
            return this.listener;
        }

        public boolean isHappyWith(BPWSEvent event) {
            return event.matchesTemplate(this.eventTemplate);
        }
    }
}

