/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.util.mime;

import com.ibm.cs.util.mime.MultipartFileFormPart;
import com.ibm.cs.util.mime.MultipartGenericFormPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletRequest;
import org.apache.soap.util.mime.ByteArrayDataSource;

public class ServletMultipartProcessor {
    protected Hashtable parameters = new Hashtable();

    public ServletMultipartProcessor(ServletRequest request) throws IOException {
        ByteArrayDataSource bads = new ByteArrayDataSource((InputStream)request.getInputStream(), request.getContentType());
        try {
            MimeMultipart parts = new MimeMultipart((DataSource)bads);
            int numParts = parts.getCount();
            int cnt = 0;
            while (cnt < numParts) {
                int nameLoc;
                MimeBodyPart part = (MimeBodyPart)parts.getBodyPart(cnt);
                String contentType = part.getContentType();
                if (contentType == null) {
                    contentType = "text/plain";
                }
                String header = part.getHeader("Content-Disposition", ";");
                int fileNameLoc = header.indexOf("filename=");
                String fileName = null;
                if (fileNameLoc != -1) {
                    fileName = header.substring(fileNameLoc + 10, header.indexOf("\"", fileNameLoc + 10));
                }
                if ((nameLoc = header.indexOf("name=")) == -1) {
                    throw new IOException("Unable to find name for MIME part; Here's what we got for a header: " + header);
                }
                if (fileNameLoc != -1 && nameLoc == fileNameLoc + 4 && (nameLoc = header.indexOf("name=", nameLoc + 1)) == -1) {
                    throw new IOException("Unable to find name for MIME part; Here's what we got for a header: " + header);
                }
                String name = header.substring(nameLoc + 6, header.indexOf("\"", nameLoc + 6));
                if (fileName != null) {
                    this.parameters.put(name, new MultipartFileFormPart(name, fileName, contentType, part.getContent()));
                } else {
                    this.parameters.put(name, new MultipartGenericFormPart(name, contentType, part.getContent()));
                }
                ++cnt;
            }
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public MultipartGenericFormPart getParameter(String name) {
        return (MultipartGenericFormPart)this.parameters.get(name);
    }
}

