/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.extension;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResources {
    public boolean debugOn = false;
    private Hashtable htSizes = new Hashtable();
    private Hashtable htJarContents = new Hashtable();
    private String jarFileName;

    public JarResources(String string) {
        this.jarFileName = string;
        this.init();
    }

    public Enumeration enumerateResources() {
        return this.htJarContents.keys();
    }

    public byte[] getResource(String string) {
        return (byte[])this.htJarContents.get(string);
    }

    private void init() {
        try {
            Object object;
            ZipFile zipFile = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (this.debugOn) {
                    System.out.println(this.dumpZipEntry((ZipEntry)object));
                }
                this.htSizes.put(((ZipEntry)object).getName(), new Integer((int)((ZipEntry)object).getSize()));
            }
            zipFile.close();
            object = new FileInputStream(this.jarFileName);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (zipEntry.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + zipEntry.getName() + "," + "getSize()=" + zipEntry.getSize());
                }
                if ((n = (int)zipEntry.getSize()) == -1) {
                    n = (Integer)this.htSizes.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0) {
                    n3 = zipInputStream.read(byArray, n2, n - n2);
                    if (n3 == -1) break;
                    n2 += n3;
                }
                this.htJarContents.put(zipEntry.getName(), byArray);
                if (!this.debugOn) continue;
                System.out.println(zipEntry.getName() + "  rb=" + n2 + ",size=" + n + ",csize=" + zipEntry.getCompressedSize());
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("done.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String dumpZipEntry(ZipEntry zipEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        if (zipEntry.isDirectory()) {
            stringBuffer.append("d ");
        } else {
            stringBuffer.append("f ");
        }
        if (zipEntry.getMethod() == 0) {
            stringBuffer.append("stored   ");
        } else {
            stringBuffer.append("defalted ");
        }
        stringBuffer.append(zipEntry.getName());
        stringBuffer.append("\t");
        stringBuffer.append("" + zipEntry.getSize());
        if (zipEntry.getMethod() == 8) {
            stringBuffer.append("/" + zipEntry.getCompressedSize());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        JarResources jarResources;
        byte[] byArray;
        if (stringArray.length != 2) {
            System.err.println("usage: java JarResources <jar file name> <resource name>");
            System.exit(1);
        }
        if ((byArray = (jarResources = new JarResources(stringArray[0])).getResource(stringArray[1])) == null) {
            System.out.println("Could not find " + stringArray[1] + ".");
        } else {
            System.out.println("Found " + stringArray[1] + " (length=" + byArray.length + ").");
        }
    }
}

