/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import ic.doc.extension.Animator;
import ic.doc.ltsa.lts.RunMenu;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class AnimWindow
extends JFrame {
    public static boolean fontFlag = false;
    JTextArea output;
    Animator animator;
    JCheckBox[] choices;
    Font f1;
    BitSet actions;
    Color priority;
    BitSet pactions;
    String[] modelAlphabet;
    JButton step;
    JButton run;
    public boolean autoRun = false;
    private static final int STEPLIMIT = 64;
    protected boolean traceMode = false;

    AnimWindow(Animator animator, RunMenu runMenu, boolean bl, boolean bl2) {
        this.autoRun = bl;
        this.traceMode = bl2;
        this.f1 = fontFlag ? new Font("SansSerif", 1, 16) : new Font("SansSerif", 1, 12);
        this.animator = animator;
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.white);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.output = new JTextArea("", 15, 15);
        this.output.setEditable(false);
        this.output.setFont(this.f1);
        this.output.setBackground(Color.white);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.output, 22, 30);
        this.getContentPane().add(jScrollPane);
        this.actions = runMenu == null ? animator.initialise(null) : animator.initialise(runMenu.alphabet);
        if (this.traceMode) {
            this.setTitle("Replay Animator");
        } else {
            this.setTitle("Animator");
        }
        this.step = new JButton("Step");
        this.step.setFont(this.f1);
        this.step.addActionListener(new AnimAction(this.traceMode ? -3 : -1));
        this.run = new JButton("Run");
        this.run.addActionListener(new AnimAction(this.traceMode ? -4 : -2));
        this.run.setFont(this.f1);
        Box box = Box.createHorizontalBox();
        box.add(this.run);
        box.add(this.step);
        String[] stringArray = animator.getMenuNames();
        this.modelAlphabet = animator.getAllNames();
        this.priority = animator.getPriority() ? Color.cyan : Color.pink;
        this.pactions = animator.getPriorityActions();
        this.choices = new JCheckBox[stringArray.length];
        Box box2 = Box.createVerticalBox();
        int n = 1;
        while (n < stringArray.length) {
            this.choices[n] = new JCheckBox(stringArray[n], null, this.actions.get(n));
            box2.add(this.choices[n]);
            this.choices[n].setFont(this.f1);
            this.choices[n].addActionListener(new AnimAction(n));
            if (this.traceMode) {
                this.choices[n].setEnabled(false);
            }
            if (this.pactions != null && this.pactions.get(n)) {
                this.choices[n].setBackground(this.priority);
            }
            ++n;
        }
        box2.add(Box.createHorizontalStrut(10));
        boolean bl3 = animator.nonMenuChoice() || this.traceMode;
        this.step.setEnabled(bl3);
        this.run.setEnabled(bl3);
        if (this.empty(this.actions) && !bl3) {
            this.outln("STOP");
        }
        JScrollPane jScrollPane2 = new JScrollPane(box2, 20, 31);
        jScrollPane2.setBorder(new EmptyBorder(0, 0, 0, 0));
        Box box3 = Box.createVerticalBox();
        box3.add(box);
        box3.add(jScrollPane2);
        this.getContentPane().add(box3);
        box2.setBackground(Color.white);
        this.validate();
        if (this.autoRun) {
            this.dostep(-2);
        }
    }

    private void dostep(int n) {
        if (this.animator.isError()) {
            return;
        }
        if (n == -1) {
            this.actions = this.animator.singleStep();
            this.outAction();
        } else if (n == -2) {
            this.actions = this.multiStep(null);
        } else if (n == -3) {
            this.actions = this.animator.traceStep();
            this.outAction();
        } else if (n == -4) {
            this.actions = this.multiTraceStep(null);
        } else if (!this.choices[n].isSelected()) {
            this.actions = this.animator.menuStep(n);
            this.outAction();
        }
        if (this.actions == null) {
            return;
        }
        if (this.autoRun && !this.traceMode) {
            this.actions = this.multiStep(this.actions);
        }
        int n2 = 1;
        while (n2 < this.choices.length) {
            this.choices[n2].setSelected(this.actions.get(n2));
            ++n2;
        }
        if (!this.traceMode) {
            boolean bl = this.animator.nonMenuChoice();
            this.step.setEnabled(bl);
            this.run.setEnabled(bl);
            if (this.empty(this.actions) && !bl && !this.animator.isError()) {
                if (this.animator.isEnd()) {
                    this.outln("END");
                } else {
                    this.outln("STOP");
                }
            }
        } else {
            boolean bl = this.animator.traceChoice();
            this.step.setEnabled(bl);
            this.run.setEnabled(bl);
            if (!bl && !this.animator.isError()) {
                if (this.empty(this.actions)) {
                    if (this.animator.isEnd()) {
                        this.outln("END");
                    } else {
                        this.outln("STOP");
                    }
                } else {
                    this.outln("DIVERGED FROM TRACE");
                }
            }
        }
        this.repaint();
    }

    private BitSet multiStep(BitSet bitSet) {
        int n = 0;
        while (this.animator.nonMenuChoice()) {
            bitSet = this.animator.singleStep();
            this.outAction();
            if (++n <= 64) continue;
            this.outln("LOOP");
            return bitSet;
        }
        return bitSet;
    }

    private BitSet multiTraceStep(BitSet bitSet) {
        while (this.animator.traceChoice()) {
            bitSet = this.animator.traceStep();
            this.outAction();
        }
        return bitSet;
    }

    public void out(String string) {
        this.output.append(string);
    }

    public void outln(String string) {
        this.output.append(string + "\n");
    }

    public void clearOutput() {
        this.output.setText("");
    }

    private boolean empty(BitSet bitSet) {
        int n = 0;
        while (n < bitSet.size()) {
            if (bitSet.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void outAction() {
        this.outln(" " + this.modelAlphabet[this.animator.actionChosen()]);
        if (this.animator.isError()) {
            this.outln("ERROR");
        }
    }

    class AnimAction
    implements ActionListener {
        int choice;

        AnimAction(int n) {
            this.choice = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnimWindow.this.dostep(this.choice);
        }
    }
}

