/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.EventClient;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSEvent;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.PrintTransitions;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PrintWindow
extends JSplitPane
implements LTSOutput,
EventClient {
    public static boolean fontFlag = false;
    JTextArea output;
    JList list;
    JScrollPane left;
    JScrollPane right;
    EventManager eman;
    int Nmach;
    int selectedMachine = 0;
    CompactState[] sm;
    Font f1 = new Font("Monospaced", 0, 12);
    Font f2 = new Font("Monospaced", 1, 18);
    Font f3 = new Font("SansSerif", 0, 12);
    Font f4 = new Font("SansSerif", 1, 18);
    PrintWindow thisWindow;
    private static final int MAXPRINT = 400;

    public PrintWindow(CompositeState compositeState, EventManager eventManager) {
        this.eman = eventManager;
        this.thisWindow = this;
        this.output = new JTextArea(23, 50);
        this.output.setEditable(false);
        this.right = new JScrollPane(this.output, 20, 30);
        this.output.setBackground(Color.white);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new PrintAction());
        this.left = new JScrollPane(this.list, 20, 30);
        if (eventManager != null) {
            eventManager.addClient(this);
        }
        this.new_machines(compositeState);
        this.setLeftComponent(this.left);
        this.setRightComponent(this.right);
        this.setDividerLocation(200);
        this.setBigFont(fontFlag);
        this.validate();
    }

    public void ltsAction(LTSEvent lTSEvent) {
        switch (lTSEvent.kind) {
            case 0: {
                break;
            }
            case 1: {
                this.new_machines((CompositeState)lTSEvent.info);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void out(String string) {
        this.output.append(string);
    }

    public void outln(String string) {
        this.output.append(string + "\n");
    }

    public void clearOutput() {
        this.output.setText("");
    }

    private void new_machines(CompositeState compositeState) {
        int n;
        Object object;
        int n2;
        int n3 = n2 = compositeState != null && compositeState.composition != null ? 1 : 0;
        if (compositeState != null && compositeState.machines != null && compositeState.machines.size() > 0) {
            this.sm = new CompactState[compositeState.machines.size() + n2];
            object = compositeState.machines.elements();
            n = 0;
            while (object.hasMoreElements()) {
                this.sm[n] = (CompactState)object.nextElement();
                ++n;
            }
            this.Nmach = this.sm.length;
            if (n2 == 1) {
                this.sm[this.Nmach - 1] = compositeState.composition;
            }
        } else {
            this.Nmach = 0;
        }
        object = new DefaultListModel<String>();
        n = 0;
        while (n < this.Nmach) {
            if (n2 == 1 && n == this.Nmach - 1) {
                ((DefaultListModel)object).addElement("||" + this.sm[n].name);
            } else {
                ((DefaultListModel)object).addElement(this.sm[n].name);
            }
            ++n;
        }
        this.list.setModel(object);
        if (this.selectedMachine >= this.Nmach) {
            this.selectedMachine = 0;
        }
        this.clearOutput();
    }

    public void setBigFont(boolean bl) {
        fontFlag = bl;
        if (fontFlag) {
            this.output.setFont(this.f2);
            this.list.setFont(this.f4);
        } else {
            this.output.setFont(this.f1);
            this.list.setFont(this.f3);
        }
    }

    public void removeClient() {
        if (this.eman != null) {
            this.eman.removeClient(this);
        }
    }

    public void copy() {
        this.output.copy();
    }

    public void saveFile(String string, String string2) {
        int n;
        String string3;
        String string4 = string2.equals(".txt") ? "Save text in:" : "Save as Aldebaran format (.aut) in:";
        FileDialog fileDialog = new FileDialog((Frame)this.getTopLevelAncestor(), string4, 1);
        if (this.Nmach > 0) {
            string3 = this.sm[this.selectedMachine].name;
            n = string3.indexOf(58, 0);
            if (n > 0) {
                string3 = string3.substring(0, n);
            }
            fileDialog.setFile(string3 + string2);
            fileDialog.setDirectory(string);
        }
        fileDialog.show();
        string3 = fileDialog.getFile();
        if (string3 != null) {
            try {
                n = string3.indexOf(46, 0);
                string3 = string3.substring(0, n) + string2;
                File file = new File(fileDialog.getDirectory(), string3);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintStream printStream = new PrintStream(fileOutputStream);
                if (string2.equals(".txt")) {
                    String string5 = this.output.getText();
                    printStream.print(string5);
                } else if (this.Nmach > 0) {
                    this.sm[this.selectedMachine].printAUT(printStream);
                }
                printStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.outln("Error saving file: " + iOException);
            }
        }
    }

    class PrintAction
    implements ListSelectionListener {
        PrintAction() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = PrintWindow.this.list.getSelectedIndex();
            if (n < 0 || n >= PrintWindow.this.Nmach) {
                return;
            }
            PrintWindow.this.selectedMachine = n;
            PrintWindow.this.clearOutput();
            PrintTransitions printTransitions = new PrintTransitions(PrintWindow.this.sm[PrintWindow.this.selectedMachine]);
            printTransitions.print(PrintWindow.this.thisWindow, 400);
        }
    }
}

