/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.editor;

import ic.doc.ltsa.editor.ColoredDocument;
import ic.doc.ltsa.editor.ColoredScanner;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ColoredContext
extends StyleContext
implements ViewFactory {
    public View create(Element element) {
        return new ColoredView(element);
    }

    class ColoredView
    extends PlainView {
        private ColoredScanner lexer;
        private boolean lexerValid;

        ColoredView(Element element) {
            super(element);
            ColoredDocument coloredDocument = (ColoredDocument)this.getDocument();
            this.lexer = coloredDocument.getScanner();
            this.lexerValid = false;
        }

        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
            this.lexerValid = false;
        }

        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Segment segment;
            Document document = this.getDocument();
            Color color = null;
            int n5 = n3;
            while (n3 < n4) {
                this.updateScanner(n3);
                int n6 = Math.min(this.lexer.getEndOffset(), n4);
                n6 = n6 <= n3 ? n4 : n6;
                Color color2 = this.lexer.getColor();
                if (color2 != color && color != null) {
                    graphics.setColor(color);
                    segment = this.getLineBuffer();
                    document.getText(n5, n3 - n5, segment);
                    n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
                    n5 = n3;
                }
                color = color2;
                n3 = n6;
            }
            graphics.setColor(color);
            segment = this.getLineBuffer();
            document.getText(n5, n4 - n5, segment);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
            return n;
        }

        void updateScanner(int n) {
            try {
                if (!this.lexerValid) {
                    ColoredDocument coloredDocument = (ColoredDocument)this.getDocument();
                    this.lexer.setRange(coloredDocument.getScannerStart(n), coloredDocument.getLength());
                    this.lexerValid = true;
                }
                while (this.lexer.getEndOffset() <= n) {
                    this.lexer.next();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

