/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.Analyser;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CounterExample;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.Minimiser;
import ic.doc.ltsa.lts.ProgressCheck;
import ic.doc.ltsa.lts.ltl.FluentTrace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class CompositeState {
    public static boolean reduceFlag = true;
    public String name;
    public Vector machines;
    public CompactState composition;
    public Vector hidden;
    public boolean exposeNotHide = false;
    public boolean priorityIsLow = true;
    public boolean makeDeterministic = false;
    public boolean makeMinimal = false;
    public boolean makeCompose = false;
    public boolean isProperty = false;
    public Vector priorityLabels;
    public CompactState alphaStop;
    protected Vector errorTrace = null;
    private CompactState saved = null;
    private FluentTrace tracer;

    public CompositeState(Vector vector) {
        this.name = "DEFAULT";
        this.machines = vector;
    }

    public CompositeState(String string, Vector vector) {
        this.name = string;
        this.machines = vector;
        this.initAlphaStop();
    }

    public Vector getErrorTrace() {
        return this.errorTrace;
    }

    public void setErrorTrace(List list) {
        if (list != null) {
            this.errorTrace = new Vector();
            this.errorTrace.addAll(list);
        }
    }

    public void compose(LTSOutput lTSOutput, boolean bl) {
        if (this.machines != null && this.machines.size() > 0) {
            Analyser analyser = new Analyser(this, lTSOutput, null, bl);
            this.composition = analyser.composeNoHide();
            if (this.makeDeterministic) {
                this.applyHiding();
                this.determinise(lTSOutput);
            } else if (this.makeMinimal) {
                this.applyHiding();
                this.minimise(lTSOutput);
            } else {
                this.applyHiding();
            }
        }
    }

    public void compose(LTSOutput lTSOutput) {
        this.compose(lTSOutput, false);
    }

    private void applyHiding() {
        if (this.composition == null) {
            return;
        }
        if (this.hidden != null) {
            if (!this.exposeNotHide) {
                this.composition.conceal(this.hidden);
            } else {
                this.composition.expose(this.hidden);
            }
        }
    }

    public void analyse(LTSOutput lTSOutput) {
        this.analyse(lTSOutput, true);
    }

    public void analyse(LTSOutput lTSOutput, boolean bl) {
        if (this.saved != null) {
            this.machines.remove(this.saved);
            this.saved = null;
        }
        if (this.composition != null) {
            CounterExample counterExample = new CounterExample(this);
            counterExample.print(lTSOutput, bl);
            this.errorTrace = counterExample.getErrorTrace();
        } else {
            Analyser analyser = new Analyser(this, lTSOutput, null);
            analyser.analyse();
            this.setErrorTrace(analyser.getErrorTrace());
        }
    }

    public void checkProgress(LTSOutput lTSOutput) {
        ProgressCheck progressCheck;
        if (this.saved != null) {
            this.machines.remove(this.saved);
            this.saved = null;
        }
        if (this.composition != null) {
            progressCheck = new ProgressCheck(this.composition, lTSOutput);
            progressCheck.doProgressCheck();
        } else {
            Analyser analyser = new Analyser(this, lTSOutput, null);
            progressCheck = new ProgressCheck(analyser, lTSOutput);
            progressCheck.doProgressCheck();
        }
        this.errorTrace = progressCheck.getErrorTrace();
    }

    public void checkLTL(LTSOutput lTSOutput, CompositeState compositeState) {
        CompactState compactState = compositeState.composition;
        if (this.name.equals("DEFAULT") && this.machines.size() == 0) {
            this.machines = compositeState.machines;
            this.composition = compositeState.composition;
        } else {
            if (this.saved != null) {
                this.machines.remove(this.saved);
            }
            Vector vector = this.hidden;
            boolean bl = this.exposeNotHide;
            this.hidden = compactState.getAlphabetV();
            this.exposeNotHide = true;
            this.saved = compactState;
            this.machines.add(this.saved);
            Analyser analyser = new Analyser(this, lTSOutput, null);
            if (!compositeState.composition.hasERROR()) {
                ProgressCheck progressCheck = new ProgressCheck(analyser, lTSOutput, compositeState.tracer);
                progressCheck.doLTLCheck();
                this.errorTrace = progressCheck.getErrorTrace();
            } else {
                analyser.analyse(compositeState.tracer);
                this.setErrorTrace(analyser.getErrorTrace());
            }
            this.hidden = vector;
            this.exposeNotHide = bl;
        }
    }

    public void minimise(LTSOutput lTSOutput) {
        if (this.composition != null) {
            if (reduceFlag) {
                this.composition.removeNonDetTau();
            }
            Minimiser minimiser = new Minimiser(this.composition, lTSOutput);
            this.composition = minimiser.minimise();
        }
    }

    public void determinise(LTSOutput lTSOutput) {
        if (this.composition != null) {
            Minimiser minimiser = new Minimiser(this.composition, lTSOutput);
            this.composition = minimiser.trace_minimise();
            if (this.isProperty) {
                this.composition.makeProperty();
            }
        }
    }

    public CompactState create(LTSOutput lTSOutput) {
        this.compose(lTSOutput);
        return this.composition;
    }

    public boolean needNotCreate() {
        return this.hidden == null && this.priorityLabels == null && !this.makeDeterministic && !this.makeMinimal && !this.makeCompose;
    }

    public void prefixLabels(String string) {
        this.name = string + ":" + this.name;
        this.alphaStop.prefixLabels(string);
        Enumeration enumeration = this.machines.elements();
        while (enumeration.hasMoreElements()) {
            CompactState compactState = (CompactState)enumeration.nextElement();
            compactState.prefixLabels(string);
        }
    }

    public void addAccess(Vector vector) {
        Object object;
        int n = vector.size();
        if (n == 0) {
            return;
        }
        String string = "{";
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = string + (String)object;
            if (++n2 >= n) continue;
            string = string + ",";
        }
        this.name = string + "}::" + this.name;
        this.alphaStop.addAccess(vector);
        object = this.machines.elements();
        while (object.hasMoreElements()) {
            CompactState compactState = (CompactState)object.nextElement();
            compactState.addAccess(vector);
        }
    }

    public CompactState relabel(Relation relation, LTSOutput lTSOutput) {
        this.alphaStop.relabel(relation);
        if (this.alphaStop.relabelDuplicates() && this.machines.size() > 1) {
            this.compose(lTSOutput);
            this.composition.relabel(relation);
            return this.composition;
        }
        Enumeration enumeration = this.machines.elements();
        while (enumeration.hasMoreElements()) {
            CompactState compactState = (CompactState)enumeration.nextElement();
            compactState.relabel(relation);
        }
        return null;
    }

    protected void initAlphaStop() {
        this.alphaStop = new CompactState();
        this.alphaStop.name = this.name;
        this.alphaStop.maxStates = 1;
        this.alphaStop.states = new EventState[this.alphaStop.maxStates];
        this.alphaStop.states[0] = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.machines.elements();
        while (enumeration.hasMoreElements()) {
            CompactState compactState = (CompactState)enumeration.nextElement();
            int n = 1;
            while (n < compactState.alphabet.length) {
                hashtable.put(compactState.alphabet[n], compactState.alphabet[n]);
                ++n;
            }
        }
        this.alphaStop.alphabet = new String[hashtable.size() + 1];
        this.alphaStop.alphabet[0] = "tau";
        int n = 1;
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            String string;
            this.alphaStop.alphabet[n] = string = (String)enumeration2.nextElement();
            ++n;
        }
    }

    public void setFluentTracer(FluentTrace fluentTrace) {
        this.tracer = fluentTrace;
    }

    public FluentTrace getFluentTracer() {
        return this.tracer;
    }
}

