/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.Determinizer;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import java.util.BitSet;
import java.util.Hashtable;

public class Minimiser {
    static final int TAU = 0;
    BitSet[] E;
    BitSet[] A;
    EventState[] T;
    CompactState machine;
    LTSOutput output;

    public Minimiser(CompactState compactState, LTSOutput lTSOutput) {
        this.machine = compactState;
        this.output = lTSOutput;
    }

    private void initTau() {
        this.T = new EventState[this.machine.states.length];
        int n = 0;
        while (n < this.T.length) {
            this.T[n] = EventState.reachableTau(this.machine.states, n);
            ++n;
        }
    }

    private CompactState machTau(CompactState compactState) {
        int n = 0;
        while (n < compactState.states.length) {
            compactState.states[n] = EventState.tauAdd(compactState.states[n], this.T);
            ++n;
        }
        int n2 = 0;
        while (n2 < compactState.states.length) {
            compactState.states[n2] = EventState.union(compactState.states[n2], this.T[n2]);
            compactState.states[n2] = EventState.actionAdd(compactState.states[n2], compactState.states);
            ++n2;
        }
        int n3 = 0;
        while (n3 < compactState.states.length) {
            compactState.states[n3] = EventState.add(compactState.states[n3], new EventState(0, n3));
            ++n3;
        }
        this.output.out(".");
        return compactState;
    }

    private CompactState removeTau(CompactState compactState) {
        int n = 0;
        while (n < compactState.states.length) {
            compactState.states[n] = EventState.removeTau(compactState.states[n]);
            ++n;
        }
        return compactState;
    }

    private void initialise() {
        this.A = new BitSet[this.machine.maxStates];
        int n = 0;
        while (n < this.A.length) {
            this.A[n] = new BitSet(this.machine.alphabet.length);
            EventState.setActions(this.machine.states[n], this.A[n]);
            ++n;
        }
        this.E = new BitSet[this.machine.maxStates];
        int n2 = 0;
        while (n2 < this.E.length) {
            this.E[n2] = new BitSet(this.E.length);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.E.length) {
            this.E[n3].set(n3);
            int n4 = 0;
            while (n4 < n3) {
                if (this.A[n3].equals(this.A[n4])) {
                    this.E[n3].set(n4);
                    this.E[n4].set(n3);
                }
                ++n4;
            }
            ++n3;
        }
        this.output.out(".");
    }

    private void dominimise() {
        boolean bl = true;
        while (bl) {
            this.output.out(".");
            bl = false;
            int n = 0;
            while (n < this.E.length) {
                Thread.yield();
                int n2 = 0;
                while (n2 < n) {
                    if (this.E[n].get(n2)) {
                        boolean bl2;
                        boolean bl3 = bl2 = this.is_equivalent(n, n2) && this.is_equivalent(n2, n);
                        if (!bl2) {
                            bl = true;
                            this.E[n].clear(n2);
                            this.E[n2].clear(n);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public CompactState minimise() {
        this.output.out(this.machine.name + " minimising");
        long l = System.currentTimeMillis();
        CompactState compactState = this.machine.myclone();
        if (this.machine.endseq >= 0) {
            int n = this.machine.endseq;
            this.machine.states[n] = EventState.add(this.machine.states[n], new EventState(this.machine.alphabet.length, n));
        }
        if (this.machine.hasTau()) {
            this.initTau();
            this.machine = this.machTau(this.machine);
            this.T = null;
        }
        this.initialise();
        this.dominimise();
        this.machine = compactState;
        CompactState compactState2 = this.makeNewMachine();
        long l2 = System.currentTimeMillis();
        this.output.outln("");
        this.output.outln("Minimised States: " + compactState2.maxStates + " in " + (l2 - l) + "ms");
        return compactState2;
    }

    public CompactState trace_minimise() {
        boolean bl = false;
        if (this.machine.hasTau()) {
            bl = true;
            this.output.out("Eliminating tau");
            this.initTau();
            this.machine = this.machTau(this.machine);
            this.machine = this.removeTau(this.machine);
            this.T = null;
        }
        if (bl || this.machine.isNonDeterministic()) {
            bl = true;
            Determinizer determinizer = new Determinizer(this.machine, this.output);
            this.machine = determinizer.determine();
        }
        if (bl) {
            return this.minimise();
        }
        return this.machine;
    }

    private boolean is_equivalent(int n, int n2) {
        EventState eventState = this.machine.states[n];
        while (eventState != null) {
            EventState eventState2 = eventState;
            while (eventState2 != null) {
                if (!this.findSuccessor(n2, eventState2)) {
                    return false;
                }
                eventState2 = eventState2.nondet;
            }
            eventState = eventState.list;
        }
        return true;
    }

    private boolean findSuccessor(int n, EventState eventState) {
        EventState eventState2 = this.machine.states[n];
        while (eventState2.event != eventState.event) {
            eventState2 = eventState2.list;
        }
        while (eventState2 != null) {
            if (eventState.next < 0 ? eventState2.next < 0 : eventState2.next >= 0 && this.E[eventState.next].get(eventState2.next)) {
                return true;
            }
            eventState2 = eventState2.nondet;
        }
        return false;
    }

    private CompactState makeNewMachine() {
        int n;
        Object object;
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>();
        Counter counter = new Counter(0);
        int n2 = 0;
        while (n2 < this.E.length) {
            object = new Integer(n2);
            Integer n3 = (Integer)hashtable.get(object);
            if (n3 == null) {
                n3 = counter.label();
                hashtable.put(object, n3);
                hashtable2.put(n3, object);
            }
            n = 0;
            while (n < this.E.length) {
                if (this.E[n2].get(n)) {
                    hashtable.put(new Integer(n), n3);
                }
                ++n;
            }
            ++n2;
        }
        object = new CompactState();
        ((CompactState)object).name = this.machine.name;
        ((CompactState)object).maxStates = hashtable2.size();
        ((CompactState)object).alphabet = this.machine.alphabet;
        ((CompactState)object).states = new EventState[((CompactState)object).maxStates];
        if (this.machine.endseq < 0) {
            ((CompactState)object).endseq = this.machine.endseq;
        } else {
            ((CompactState)object).endseq = (Integer)hashtable.get(new Integer(this.machine.endseq));
            ((CompactState)object).states[((CompactState)object).endseq] = EventState.remove(((CompactState)object).states[((CompactState)object).endseq], new EventState(((CompactState)object).alphabet.length, ((CompactState)object).endseq));
        }
        int n4 = 0;
        while (n4 < this.machine.maxStates) {
            n = (Integer)hashtable.get(new Integer(n4));
            EventState eventState = EventState.renumberStates(this.machine.states[n4], hashtable);
            ((CompactState)object).states[n] = EventState.union(((CompactState)object).states[n], eventState);
            ++n4;
        }
        n = 0;
        while (n < ((CompactState)object).maxStates) {
            ((CompactState)object).states[n] = EventState.remove(((CompactState)object).states[n], new EventState(0, n));
            ++n;
        }
        return object;
    }

    public void print(LTSOutput lTSOutput) {
        this.privPrint(lTSOutput, this.E);
    }

    private void privPrint(LTSOutput lTSOutput, BitSet[] bitSetArray) {
        if (bitSetArray.length > 20) {
            return;
        }
        char[] cArray = new char[bitSetArray.length * 2];
        int n = 0;
        while (n < bitSetArray.length * 2) {
            cArray[n] = 32;
            ++n;
        }
        lTSOutput.outln("E:");
        lTSOutput.out("       ");
        int n2 = 0;
        while (n2 < bitSetArray.length) {
            lTSOutput.out(" " + n2);
            ++n2;
        }
        lTSOutput.outln("");
        int n3 = 0;
        while (n3 < bitSetArray.length) {
            lTSOutput.out("State " + n3 + " ");
            int n4 = 0;
            while (n4 < bitSetArray.length) {
                cArray[n4 * 2] = bitSetArray[n3].get(n4) ? 49 : 32;
                ++n4;
            }
            lTSOutput.outln(new String(cArray));
            ++n3;
        }
    }
}

