/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.Declaration;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.RelabelDefn;
import ic.doc.ltsa.lts.StateDefn;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ProcessSpec
extends Declaration {
    Symbol name;
    Hashtable constants;
    Hashtable init_constants = new Hashtable();
    Vector parameters = new Vector();
    Vector stateDefns = new Vector();
    LabelSet alphaAdditions;
    LabelSet alphaHidden;
    Vector alphaRelabel;
    boolean isProperty = false;
    boolean isMinimal = false;
    boolean isDeterministic = false;
    boolean exposeNotHide = false;
    File importFile = null;

    ProcessSpec() {
    }

    public boolean imported() {
        return this.importFile != null;
    }

    public String getname() {
        this.constants = (Hashtable)this.init_constants.clone();
        StateDefn stateDefn = (StateDefn)this.stateDefns.firstElement();
        this.name = stateDefn.name;
        if (stateDefn.range != null) {
            Diagnostics.fatal("process name cannot be indexed", this.name);
        }
        return stateDefn.name.toString();
    }

    public void explicitStates(StateMachine stateMachine) {
        Enumeration enumeration = this.stateDefns.elements();
        while (enumeration.hasMoreElements()) {
            Declaration declaration = (Declaration)enumeration.nextElement();
            declaration.explicitStates(stateMachine);
        }
    }

    public void addAlphabet(StateMachine stateMachine) {
        if (this.alphaAdditions != null) {
            Vector vector = this.alphaAdditions.getActions(this.constants);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (stateMachine.alphabet.containsKey(string)) continue;
                stateMachine.alphabet.put(string, stateMachine.eventLabel.label());
            }
        }
    }

    public void hideAlphabet(StateMachine stateMachine) {
        if (this.alphaHidden == null) {
            return;
        }
        stateMachine.hidden = this.alphaHidden.getActions(this.constants);
    }

    public void relabelAlphabet(StateMachine stateMachine) {
        if (this.alphaRelabel == null) {
            return;
        }
        stateMachine.relabels = new Relation();
        Enumeration enumeration = this.alphaRelabel.elements();
        while (enumeration.hasMoreElements()) {
            RelabelDefn relabelDefn = (RelabelDefn)enumeration.nextElement();
            relabelDefn.makeRelabels(this.constants, stateMachine.relabels);
        }
    }

    public void crunch(StateMachine stateMachine) {
        Enumeration enumeration = this.stateDefns.elements();
        while (enumeration.hasMoreElements()) {
            Declaration declaration = (Declaration)enumeration.nextElement();
            declaration.crunch(stateMachine);
        }
    }

    public void transition(StateMachine stateMachine) {
        Enumeration enumeration = this.stateDefns.elements();
        while (enumeration.hasMoreElements()) {
            Declaration declaration = (Declaration)enumeration.nextElement();
            declaration.transition(stateMachine);
        }
    }

    public void doParams(Vector vector) {
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = this.parameters.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            this.constants.put(enumeration2.nextElement(), enumeration.nextElement());
        }
    }

    public ProcessSpec myclone() {
        ProcessSpec processSpec = new ProcessSpec();
        processSpec.name = this.name;
        processSpec.constants = (Hashtable)this.constants.clone();
        processSpec.init_constants = this.init_constants;
        processSpec.parameters = this.parameters;
        Enumeration enumeration = this.stateDefns.elements();
        while (enumeration.hasMoreElements()) {
            processSpec.stateDefns.addElement(((StateDefn)enumeration.nextElement()).myclone());
        }
        processSpec.alphaAdditions = this.alphaAdditions;
        processSpec.alphaHidden = this.alphaHidden;
        processSpec.alphaRelabel = this.alphaRelabel;
        processSpec.isProperty = this.isProperty;
        processSpec.isMinimal = this.isMinimal;
        processSpec.isDeterministic = this.isDeterministic;
        processSpec.exposeNotHide = this.exposeNotHide;
        processSpec.importFile = this.importFile;
        return processSpec;
    }
}

