/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ChoiceElement;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Declaration;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.SeqProcessRef;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Transition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class StateExpr
extends Declaration {
    Vector processes;
    Symbol name;
    Vector expr;
    Vector choices;
    Stack boolexpr;
    StateExpr thenpart;
    StateExpr elsepart;

    StateExpr() {
    }

    public void addSeqProcessRef(SeqProcessRef seqProcessRef) {
        if (this.processes == null) {
            this.processes = new Vector();
        }
        this.processes.addElement(seqProcessRef);
    }

    public CompactState makeInserts(Hashtable hashtable, StateMachine stateMachine) {
        Vector<CompactState> vector = new Vector<CompactState>();
        Enumeration enumeration = this.processes.elements();
        while (enumeration.hasMoreElements()) {
            SeqProcessRef seqProcessRef = (SeqProcessRef)enumeration.nextElement();
            CompactState compactState = seqProcessRef.instantiate(hashtable, stateMachine.constants);
            if (compactState.isEnd()) continue;
            vector.addElement(compactState);
        }
        if (vector.size() > 0) {
            return CompactState.sequentialCompose(vector);
        }
        return null;
    }

    public Integer instantiate(Integer n, Hashtable hashtable, StateMachine stateMachine) {
        if (this.processes == null) {
            return n;
        }
        CompactState compactState = this.makeInserts(hashtable, stateMachine);
        if (compactState == null) {
            return n;
        }
        Integer n2 = stateMachine.stateLabel.interval(compactState.maxStates);
        compactState.offsetSeq(n2, n);
        stateMachine.addSequential(n2, compactState);
        return n2;
    }

    public void firstTransition(int n, Hashtable hashtable, StateMachine stateMachine) {
        if (this.boolexpr != null) {
            if (Expression.evaluate(this.boolexpr, hashtable, stateMachine.constants) != 0) {
                if (this.thenpart.name == null) {
                    this.thenpart.firstTransition(n, hashtable, stateMachine);
                }
            } else if (this.elsepart.name == null) {
                this.elsepart.firstTransition(n, hashtable, stateMachine);
            }
        } else {
            this.addTransition(n, hashtable, stateMachine);
        }
    }

    public void addTransition(int n, Hashtable hashtable, StateMachine stateMachine) {
        Enumeration enumeration = this.choices.elements();
        while (enumeration.hasMoreElements()) {
            ChoiceElement choiceElement = (ChoiceElement)enumeration.nextElement();
            choiceElement.addTransition(n, hashtable, stateMachine);
        }
    }

    public void endTransition(int n, Symbol symbol, Hashtable hashtable, StateMachine stateMachine) {
        if (this.boolexpr != null) {
            if (Expression.evaluate(this.boolexpr, hashtable, stateMachine.constants) != 0) {
                this.thenpart.endTransition(n, symbol, hashtable, stateMachine);
            } else {
                this.elsepart.endTransition(n, symbol, hashtable, stateMachine);
            }
        } else if (this.name != null) {
            Integer n2 = (Integer)stateMachine.explicit_states.get(this.evalName(hashtable, stateMachine));
            if (n2 == null) {
                if (this.evalName(hashtable, stateMachine).equals("STOP")) {
                    n2 = stateMachine.stateLabel.label();
                    stateMachine.explicit_states.put("STOP", n2);
                } else if (this.evalName(hashtable, stateMachine).equals("ERROR")) {
                    n2 = new Integer(-1);
                    stateMachine.explicit_states.put("ERROR", n2);
                } else if (this.evalName(hashtable, stateMachine).equals("END")) {
                    n2 = stateMachine.stateLabel.label();
                    stateMachine.explicit_states.put("END", n2);
                } else {
                    n2 = new Integer(-1);
                    stateMachine.explicit_states.put(this.evalName(hashtable, stateMachine), n2);
                    Diagnostics.warning(this.evalName(hashtable, stateMachine) + " defined to be ERROR", "definition not found- " + this.evalName(hashtable, stateMachine), this.name);
                }
            }
            n2 = this.instantiate(n2, hashtable, stateMachine);
            stateMachine.transitions.addElement(new Transition(n, symbol, n2));
        } else {
            Integer n3 = stateMachine.stateLabel.label();
            stateMachine.transitions.addElement(new Transition(n, symbol, n3));
            this.addTransition(n3, hashtable, stateMachine);
        }
    }

    public String evalName(Hashtable hashtable, StateMachine stateMachine) {
        if (this.expr == null) {
            return this.name.toString();
        }
        Enumeration enumeration = this.expr.elements();
        String string = this.name.toString();
        while (enumeration.hasMoreElements()) {
            Stack stack = (Stack)enumeration.nextElement();
            string = string + "." + Expression.getValue(stack, hashtable, stateMachine.constants);
        }
        return string;
    }

    public StateExpr myclone() {
        StateExpr stateExpr = new StateExpr();
        stateExpr.processes = this.processes;
        stateExpr.name = this.name;
        stateExpr.expr = this.expr;
        if (this.choices != null) {
            stateExpr.choices = new Vector();
            Enumeration enumeration = this.choices.elements();
            while (enumeration.hasMoreElements()) {
                stateExpr.choices.addElement(((ChoiceElement)enumeration.nextElement()).myclone());
            }
        }
        stateExpr.boolexpr = this.boolexpr;
        if (this.thenpart != null) {
            stateExpr.thenpart = this.thenpart.myclone();
        }
        if (this.elsepart != null) {
            stateExpr.elsepart = this.elsepart.myclone();
        }
        return stateExpr;
    }
}

