/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MyHash;
import ic.doc.ltsa.lts.MyList;
import ic.doc.ltsa.lts.MyStack;
import ic.doc.ltsa.lts.StateCodec;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;

public class SuperTrace {
    BitSet table;
    MyStack stack;
    int nbits;
    Automata mach;
    LTSOutput output;
    LinkedList errorTrace;
    private static int DEPTHBOUND = 100000;
    private static int HASHSIZE = 8000;
    private static final int SUCCESS = 0;
    private static final int DEADLOCK = 1;
    private static final int ERROR = 2;
    int nstate = 0;
    int nTrans = 0;

    public static void setDepthBound(int n) {
        DEPTHBOUND = n;
    }

    public static int getDepthBound() {
        return DEPTHBOUND;
    }

    public static void setHashSize(int n) {
        HASHSIZE = n;
    }

    public static int getHashSize() {
        return HASHSIZE;
    }

    public SuperTrace(Automata automata, LTSOutput lTSOutput) {
        this.mach = automata;
        this.output = lTSOutput;
        this.nbits = HASHSIZE * 1024 * 8;
        this.table = new BitSet(this.nbits);
        this.stack = new MyStack();
        this.analyse();
    }

    public void analyse() {
        this.output.outln("Analysing using Supertrace (Depth bound " + DEPTHBOUND + " Hashtable size " + HASHSIZE + "K )...");
        System.gc();
        long l = System.currentTimeMillis();
        int n = this.search();
        long l2 = System.currentTimeMillis();
        this.outStatistics(this.stack.depth, this.nstate, this.nTrans);
        if (n == 1) {
            this.output.outln("Trace to DEADLOCK: (in superstrace)");
            this.errorTrace = this.computeTrace(false);
            if (this.errorTrace.size() <= 100) {
                this.printPath(this.errorTrace);
            } else {
                this.output.outln("Trace length " + this.errorTrace.size() + ", replay using Check/Run");
            }
        } else if (n == 2) {
            this.output.outln("Trace to property violation in " + this.mach.getViolatedProperty() + ":");
            this.errorTrace = this.computeTrace(true);
            if (this.errorTrace.size() <= 100) {
                this.printPath(this.errorTrace);
            } else {
                this.output.outln("Trace length " + this.errorTrace.size() + ", replay using Check/Run");
            }
        } else {
            this.output.outln("No deadlocks/errors");
        }
        this.output.outln("Analysed using Supertrace in: " + (l2 - l) + "ms");
    }

    private int hashOne(byte[] byArray) {
        return StateCodec.hash(byArray);
    }

    private int hashTwo(byte[] byArray) {
        long l = StateCodec.hashLong(byArray);
        int n = (int)((l += 1325656567898L) ^ l >>> 32);
        return n & Integer.MAX_VALUE;
    }

    private void put(byte[] byArray) {
        this.table.set(this.hashOne(byArray) % this.nbits);
        this.table.set(this.hashTwo(byArray) % this.nbits);
    }

    private boolean contains(byte[] byArray) {
        return this.table.get(this.hashOne(byArray) % this.nbits) && this.table.get(this.hashTwo(byArray) % this.nbits);
    }

    /*
     * Unable to fully structure code
     */
    private int search() {
        var1_1 = this.mach.START();
        var2_2 = null;
        if (this.mach.isPartialOrder()) {
            var2_2 = new MyHash(SuperTrace.DEPTHBOUND + 1);
            this.mach.setStackChecker(var2_2);
        }
        this.stack.push(var1_1);
        this.put(var1_1);
        while (!this.stack.empty()) {
            if (this.stack.marked()) {
                if (var2_2 != null) {
                    var2_2.remove(this.stack.peek());
                }
                this.stack.pop();
                continue;
            }
            ++this.nstate;
            if (this.nstate % 10000 == 0) {
                this.outStatistics(this.stack.getDepth(), this.nstate, this.nTrans);
            }
            var3_3 = this.stack.peek();
            this.stack.mark();
            if (var2_2 != null) {
                var2_2.put(var3_3);
            }
            if (!(var4_4 = this.mach.getTransitions(var3_3)).empty() || this.mach.END(var3_3)) ** GOTO lbl31
            return 1;
lbl-1000:
            // 1 sources

            {
                ++this.nTrans;
                if (var4_4.getTo() == null) {
                    return 2;
                }
                if (this.stack.getDepth() < SuperTrace.DEPTHBOUND && !this.contains(var4_4.getTo())) {
                    this.stack.push(var4_4.getTo());
                    this.put(var4_4.getTo());
                }
                var4_4.next();
lbl31:
                // 2 sources

                ** while (!var4_4.empty())
            }
lbl32:
            // 1 sources

        }
        return 0;
    }

    public LinkedList getErrorTrace() {
        return this.errorTrace;
    }

    private void outStatistics(int n, int n2, int n3) {
        this.output.out("-- Depth: " + n + " States: " + n2 + " Transitions: " + n3);
        Runtime runtime = Runtime.getRuntime();
        this.output.outln(" Memory used: " + (runtime.totalMemory() - runtime.freeMemory()) / 1000L + "K");
    }

    private void printPath(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.output.outln("\t" + (String)iterator.next());
        }
    }

    private LinkedList computeTrace(boolean bl) {
        this.mach.disablePartialOrder();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (bl) {
            while (!this.stack.marked()) {
                this.stack.pop();
            }
            linkedList.addFirst(this.findAction(this.stack.peek(), null));
        }
        byte[] byArray = this.stack.pop();
        while (!this.stack.empty()) {
            if (!this.stack.marked()) {
                this.stack.pop();
                continue;
            }
            linkedList.addFirst(this.findAction(this.stack.peek(), byArray));
            byArray = this.stack.pop();
        }
        return linkedList;
    }

    private String findAction(byte[] byArray, byte[] byArray2) {
        MyList myList = this.mach.getTransitions(byArray);
        while (!myList.empty()) {
            if (StateCodec.equals(myList.getTo(), byArray2)) {
                return this.mach.getAlphabet()[myList.getAction()];
            }
            myList.next();
        }
        return "ACTION NOT FOUND";
    }
}

