/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.AssertDefinition;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.util.Hashtable;

public class FormulaSyntax {
    FormulaSyntax left;
    FormulaSyntax right;
    Symbol operator;
    Symbol proposition;
    ActionLabels range;
    ActionLabels action;

    private FormulaSyntax(FormulaSyntax formulaSyntax, Symbol symbol, FormulaSyntax formulaSyntax2, Symbol symbol2, ActionLabels actionLabels, ActionLabels actionLabels2) {
        this.left = formulaSyntax;
        this.right = formulaSyntax2;
        this.operator = symbol;
        this.proposition = symbol2;
        this.range = actionLabels;
        this.action = actionLabels2;
    }

    public static FormulaSyntax make(FormulaSyntax formulaSyntax, Symbol symbol, FormulaSyntax formulaSyntax2) {
        return new FormulaSyntax(formulaSyntax, symbol, formulaSyntax2, null, null, null);
    }

    public static FormulaSyntax make(Symbol symbol) {
        return new FormulaSyntax(null, null, null, symbol, null, null);
    }

    public static FormulaSyntax make(Symbol symbol, ActionLabels actionLabels) {
        return new FormulaSyntax(null, null, null, symbol, actionLabels, null);
    }

    public static FormulaSyntax make(ActionLabels actionLabels) {
        return new FormulaSyntax(null, null, null, null, null, actionLabels);
    }

    public static FormulaSyntax make(Symbol symbol, ActionLabels actionLabels, FormulaSyntax formulaSyntax) {
        return new FormulaSyntax(null, symbol, formulaSyntax, null, actionLabels, null);
    }

    public Formula expand(FormulaFactory formulaFactory, Hashtable hashtable) {
        if (this.proposition != null) {
            if (this.range == null) {
                if (PredicateDefinition.definitions != null && PredicateDefinition.definitions.containsKey(this.proposition.toString())) {
                    return formulaFactory.make(this.proposition);
                }
                AssertDefinition assertDefinition = (AssertDefinition)AssertDefinition.definitions.get(this.proposition.toString());
                if (assertDefinition == null) {
                    Diagnostics.fatal("LTL fluent or assertion not defined: " + this.proposition, this.proposition);
                }
                return assertDefinition.ltl_formula.expand(formulaFactory, hashtable);
            }
            return formulaFactory.make(this.proposition, this.range, hashtable);
        }
        if (this.action != null) {
            return formulaFactory.make(this.action, hashtable);
        }
        if (this.operator != null && this.range == null) {
            if (this.left == null) {
                return formulaFactory.make(null, this.operator, this.right.expand(formulaFactory, hashtable));
            }
            return formulaFactory.make(this.left.expand(formulaFactory, hashtable), this.operator, this.right.expand(formulaFactory, hashtable));
        }
        if (this.range != null && this.right != null) {
            this.range.initContext(hashtable, null);
            Formula formula = null;
            while (this.range.hasMoreNames()) {
                this.range.nextName();
                formula = formula == null ? this.right.expand(formulaFactory, hashtable) : (this.operator.kind == 42 ? formulaFactory.makeAnd(formula, this.right.expand(formulaFactory, hashtable)) : formulaFactory.makeOr(formula, this.right.expand(formulaFactory, hashtable)));
            }
            this.range.clearContext();
            return formula;
        }
        return null;
    }
}

