/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Graph;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.LabelFactory;
import ic.doc.ltsa.lts.ltl.Node;
import ic.doc.ltsa.lts.ltl.State;
import ic.doc.ltsa.lts.ltl.Transition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GeneralizedBuchiAutomata {
    List nodes;
    Formula formula;
    FormulaFactory fac;
    List untils;
    int maxId = -1;
    Node[] equivClasses;
    State[] states;
    int naccept;
    String name;
    LabelFactory labelFac;

    public GeneralizedBuchiAutomata(String string, FormulaFactory formulaFactory, Vector vector) {
        this.fac = formulaFactory;
        this.name = string;
        this.formula = formulaFactory.getFormula();
        this.nodes = new ArrayList();
        this.labelFac = new LabelFactory(this.name, this.fac, vector);
    }

    public void translate() {
        Node.setAut(this);
        Node.setFactory(this.fac);
        Transition.setLabelFactory(this.labelFac);
        this.untils = new ArrayList();
        this.naccept = this.fac.processUntils(this.formula, this.untils);
        Node node = new Node(this.formula);
        this.nodes = node.expand(this.nodes);
        this.states = this.makeStates();
    }

    public LabelFactory getLabelFactory() {
        return this.labelFac;
    }

    public void printNodes(LTSOutput lTSOutput) {
        int n = 0;
        while (n < this.states.length) {
            if (this.states[n] != null && n == this.states[n].getId()) {
                this.states[n].print(lTSOutput, this.naccept);
            }
            ++n;
        }
    }

    public int indexEquivalence(Node node) {
        int n = 0;
        while (n < this.maxId) {
            if (this.equivClasses[n] == null) break;
            if (this.equivClasses[n].next.equals(node.next)) {
                return this.equivClasses[n].id;
            }
            ++n;
        }
        if (n == this.maxId) {
            Diagnostics.fatal("size of equivalence classes array was incorrect");
        }
        this.equivClasses[n] = node;
        return this.equivClasses[n].id;
    }

    public State[] makeStates() {
        State[] stateArray = new State[this.maxId];
        this.equivClasses = new Node[this.maxId];
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.equivId = this.indexEquivalence(node);
            node.makeTransitions(stateArray);
        }
        return stateArray;
    }

    int newId() {
        return ++this.maxId;
    }

    Graph Gmake() {
        Graph graph = new Graph();
        graph.setStringAttribute("type", "gba");
        graph.setStringAttribute("ac", "edges");
        if (this.states == null) {
            return graph;
        }
        int n = this.maxId;
        gov.nasa.arc.ase.util.graph.Node[] nodeArray = new gov.nasa.arc.ase.util.graph.Node[n];
        int n2 = 0;
        while (n2 < n) {
            if (this.states[n2] != null && n2 == this.states[n2].getId()) {
                nodeArray[n2] = new gov.nasa.arc.ase.util.graph.Node(graph);
                nodeArray[n2].setStringAttribute("label", "S" + this.states[n2].getId());
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (this.states[n3] != null && n3 == this.states[n3].getId()) {
                this.states[n3].Gmake(nodeArray, nodeArray[n3], this.naccept);
            }
            ++n3;
        }
        if (this.naccept == 0) {
            graph.setIntAttribute("nsets", 1);
        } else {
            graph.setIntAttribute("nsets", this.naccept);
        }
        return graph;
    }
}

