/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ltl.And;
import ic.doc.ltsa.lts.ltl.False;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.Next;
import ic.doc.ltsa.lts.ltl.Not;
import ic.doc.ltsa.lts.ltl.Or;
import ic.doc.ltsa.lts.ltl.Proposition;
import ic.doc.ltsa.lts.ltl.Release;
import ic.doc.ltsa.lts.ltl.True;
import ic.doc.ltsa.lts.ltl.Until;
import ic.doc.ltsa.lts.ltl.Visitor;

class NotVisitor
implements Visitor {
    private FormulaFactory fac;

    NotVisitor(FormulaFactory formulaFactory) {
        this.fac = formulaFactory;
    }

    public Formula visit(True true_) {
        return False.make();
    }

    public Formula visit(False false_) {
        return True.make();
    }

    public Formula visit(Proposition proposition) {
        return this.fac.makeNot(proposition);
    }

    public Formula visit(Not not) {
        return not.getNext();
    }

    public Formula visit(Next next) {
        return this.fac.makeNext(this.fac.makeNot(next.getNext()));
    }

    public Formula visit(And and) {
        return this.fac.makeOr(this.fac.makeNot(and.getLeft()), this.fac.makeNot(and.getRight()));
    }

    public Formula visit(Or or) {
        return this.fac.makeAnd(this.fac.makeNot(or.getLeft()), this.fac.makeNot(or.getRight()));
    }

    public Formula visit(Until until) {
        return this.fac.makeRelease(this.fac.makeNot(until.getLeft()), this.fac.makeNot(until.getRight()));
    }

    public Formula visit(Release release) {
        return this.fac.makeUntil(this.fac.makeNot(release.getLeft()), this.fac.makeNot(release.getRight()));
    }
}

