/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.Symbol;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;

public class PredicateDefinition {
    Symbol name;
    ActionLabels trueSet;
    ActionLabels falseSet;
    Vector trueActions;
    Vector falseActions;
    Stack expr;
    boolean initial;
    ActionLabels range;
    static Hashtable definitions;

    private PredicateDefinition(Symbol symbol, ActionLabels actionLabels, ActionLabels actionLabels2, ActionLabels actionLabels3, Stack stack) {
        this.name = symbol;
        this.range = actionLabels;
        this.trueSet = actionLabels2;
        this.falseSet = actionLabels3;
        this.expr = stack;
        this.initial = false;
    }

    PredicateDefinition(Symbol symbol, Vector vector, Vector vector2) {
        this.name = symbol;
        this.trueActions = vector;
        this.falseActions = vector2;
    }

    PredicateDefinition(String string, Vector vector, Vector vector2, boolean bl) {
        this.name = new Symbol(123, string);
        this.trueActions = vector;
        this.falseActions = vector2;
        this.initial = bl;
    }

    public static void put(Symbol symbol, ActionLabels actionLabels, ActionLabels actionLabels2, ActionLabels actionLabels3, Stack stack) {
        if (definitions == null) {
            definitions = new Hashtable();
        }
        if (definitions.put(symbol.toString(), new PredicateDefinition(symbol, actionLabels, actionLabels2, actionLabels3, stack)) != null) {
            Diagnostics.fatal("duplicate LTL predicate definition: " + symbol, symbol);
        }
    }

    public static boolean contains(Symbol symbol) {
        if (definitions == null) {
            return false;
        }
        return definitions.containsKey(symbol.toString());
    }

    public static void init() {
        definitions = null;
    }

    public static void compileAll() {
        if (definitions == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(definitions.values());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PredicateDefinition predicateDefinition = (PredicateDefinition)iterator.next();
            PredicateDefinition.compile(predicateDefinition);
        }
    }

    public static PredicateDefinition get(String string) {
        if (definitions == null) {
            return null;
        }
        PredicateDefinition predicateDefinition = (PredicateDefinition)definitions.get(string);
        if (predicateDefinition == null) {
            return null;
        }
        if (predicateDefinition.range != null) {
            return null;
        }
        return predicateDefinition;
    }

    public static void compile(PredicateDefinition predicateDefinition) {
        if (predicateDefinition == null) {
            return;
        }
        if (predicateDefinition.range == null) {
            predicateDefinition.trueActions = predicateDefinition.trueSet.getActions(null, null);
            predicateDefinition.falseActions = predicateDefinition.falseSet.getActions(null, null);
            PredicateDefinition.assertDisjoint(predicateDefinition.trueActions, predicateDefinition.falseActions, predicateDefinition);
            if (predicateDefinition.expr != null) {
                int n = Expression.evaluate(predicateDefinition.expr, null, null);
                predicateDefinition.initial = n > 0;
            }
        } else {
            Hashtable hashtable = new Hashtable();
            predicateDefinition.range.initContext(hashtable, null);
            while (predicateDefinition.range.hasMoreNames()) {
                String string = predicateDefinition.range.nextName();
                Vector vector = predicateDefinition.trueSet.getActions(hashtable, null);
                Vector vector2 = predicateDefinition.falseSet.getActions(hashtable, null);
                boolean bl = false;
                PredicateDefinition.assertDisjoint(vector, vector2, predicateDefinition);
                if (predicateDefinition.expr != null) {
                    int n = Expression.evaluate(predicateDefinition.expr, hashtable, null);
                    bl = n > 0;
                }
                String string2 = predicateDefinition.name + "." + string;
                definitions.put(string2, new PredicateDefinition(string2, vector, vector2, bl));
            }
            predicateDefinition.range.clearContext();
        }
    }

    private static void assertDisjoint(Vector vector, Vector vector2, PredicateDefinition predicateDefinition) {
        TreeSet treeSet = new TreeSet(vector);
        treeSet.retainAll(vector2);
        if (!treeSet.isEmpty()) {
            Diagnostics.fatal("Predicate " + predicateDefinition.name + " True & False sets must be disjoint", predicateDefinition.name);
        }
    }

    public int query(String string) {
        if (this.trueActions.contains(string)) {
            return 1;
        }
        if (this.falseActions.contains(string)) {
            return -1;
        }
        return 0;
    }

    public int initial() {
        return this.initial ? 1 : -1;
    }

    public String toString() {
        return this.name.toString();
    }
}

