/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.compiler;

import com.ibm.bpws.model.Activity;
import com.ibm.bpws.model.Assign;
import com.ibm.bpws.model.BPWSProcess;
import com.ibm.bpws.model.CaseClause;
import com.ibm.bpws.model.CatchAll;
import com.ibm.bpws.model.CatchFault;
import com.ibm.bpws.model.Compensate;
import com.ibm.bpws.model.Container;
import com.ibm.bpws.model.Empty;
import com.ibm.bpws.model.FaultHandlers;
import com.ibm.bpws.model.Flow;
import com.ibm.bpws.model.Invoke;
import com.ibm.bpws.model.Link;
import com.ibm.bpws.model.OnAlarm;
import com.ibm.bpws.model.OnMessage;
import com.ibm.bpws.model.Partner;
import com.ibm.bpws.model.Pick;
import com.ibm.bpws.model.Receive;
import com.ibm.bpws.model.Reply;
import com.ibm.bpws.model.Scope;
import com.ibm.bpws.model.Sequence;
import com.ibm.bpws.model.Source;
import com.ibm.bpws.model.SwitchBlock;
import com.ibm.bpws.model.Target;
import com.ibm.bpws.model.Terminate;
import com.ibm.bpws.model.Throw;
import com.ibm.bpws.model.Wait;
import com.ibm.bpws.model.While;
import com.ibm.cs.bpws.compiler.LinkInfo;
import com.ibm.cs.bpws.compiler.LinkTable;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.AssignRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.CompensateRT;
import com.ibm.cs.bpws.runtime.Condition;
import com.ibm.cs.bpws.runtime.Constants;
import com.ibm.cs.bpws.runtime.ContainerRT;
import com.ibm.cs.bpws.runtime.EmptyRT;
import com.ibm.cs.bpws.runtime.FlowRT;
import com.ibm.cs.bpws.runtime.InvokeRT;
import com.ibm.cs.bpws.runtime.PartnerRT;
import com.ibm.cs.bpws.runtime.PickRT;
import com.ibm.cs.bpws.runtime.ReceiveRT;
import com.ibm.cs.bpws.runtime.ReplyRT;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.SequenceRT;
import com.ibm.cs.bpws.runtime.SwitchRT;
import com.ibm.cs.bpws.runtime.TerminateRT;
import com.ibm.cs.bpws.runtime.ThrowRT;
import com.ibm.cs.bpws.runtime.WaitRT;
import com.ibm.cs.bpws.runtime.WhileRT;
import com.ibm.wsif.WSIFMessage;
import com.ibm.wsif.util.WSIFDefaultMessage;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class BPWSCompiler {
    private BPWSProcessRT process = null;
    private boolean suppressJoinFailure = false;
    static /* synthetic */ Class class$com$ibm$bpws$model$Invoke;
    static /* synthetic */ Class class$com$ibm$bpws$model$Flow;
    static /* synthetic */ Class class$com$ibm$bpws$model$Sequence;
    static /* synthetic */ Class class$com$ibm$bpws$model$Scope;
    static /* synthetic */ Class class$com$ibm$bpws$model$Reply;
    static /* synthetic */ Class class$com$ibm$bpws$model$Receive;
    static /* synthetic */ Class class$com$ibm$bpws$model$SwitchBlock;
    static /* synthetic */ Class class$com$ibm$bpws$model$Pick;
    static /* synthetic */ Class class$com$ibm$bpws$model$While;
    static /* synthetic */ Class class$com$ibm$bpws$model$Empty;
    static /* synthetic */ Class class$com$ibm$bpws$model$Terminate;
    static /* synthetic */ Class class$com$ibm$bpws$model$Throw;
    static /* synthetic */ Class class$com$ibm$bpws$model$Assign;
    static /* synthetic */ Class class$com$ibm$bpws$model$Compensate;
    static /* synthetic */ Class class$com$ibm$bpws$model$Wait;

    private void addFaultHandlersToScope(ScopeRT scope, FaultHandlers handlers, LinkTable linkTable) throws BPWSRuntimeException {
        CatchAll catchAll;
        if (handlers.getCatchFaults() != null) {
            Iterator catches = handlers.getCatchFaults().iterator();
            while (catches.hasNext()) {
                CatchFault catchFault = (CatchFault)catches.next();
                Activity faultAct = catchFault.getActivity();
                String faultContainerName = null;
                if (catchFault.getFaultContainer() != null) {
                    faultContainerName = catchFault.getFaultContainer().getName();
                }
                ScopeRT faultScope = this.wrapInScope(scope, faultAct, linkTable, true, false);
                scope.addFaultHandler(catchFault.getFaultName(), faultScope, faultContainerName);
            }
        }
        if ((catchAll = handlers.getCatchAll()) != null) {
            ScopeRT faultScope = this.wrapInScope(scope, catchAll.getActivity(), linkTable, true, false);
            scope.setCatchAllFaultHandler(faultScope);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private ActivityRT compileActivity(Activity act, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        if (act == null) {
            if (scope != null) {
                throw new BPWSRuntimeException("No activity was found for " + scope.getName());
            }
            throw new BPWSRuntimeException("No activity was found for Unknown Scope");
        }
        Class<?> activityClass = act.getClass();
        ActivityRT activity = null;
        if (!(class$com$ibm$bpws$model$Invoke != null ? class$com$ibm$bpws$model$Invoke : (class$com$ibm$bpws$model$Invoke = BPWSCompiler.class$("com.ibm.bpws.model.Invoke"))).isAssignableFrom(activityClass)) {
            boolean localSuppressJoin;
            Boolean localSuppressJoinB = act.getSuppressJoinFailure();
            boolean bl = localSuppressJoin = localSuppressJoinB == null ? false : localSuppressJoinB;
            if (this.suppressJoinFailure || localSuppressJoin) {
                scope = new ScopeRT(act.getName(), scope, parent, this.process);
                ScopeRT faultScope = new ScopeRT("empty_handler_wrapper_scope", scope, scope, this.process);
                EmptyRT joinHandler = new EmptyRT("", faultScope, faultScope);
                faultScope.setActivity(joinHandler);
                scope.addFaultHandler(Constants.JOIN_FAULT_QNAME, faultScope, null);
                parent = scope;
            }
            if ((class$com$ibm$bpws$model$Flow != null ? class$com$ibm$bpws$model$Flow : (class$com$ibm$bpws$model$Flow = BPWSCompiler.class$("com.ibm.bpws.model.Flow"))).isAssignableFrom(activityClass)) {
                activity = this.compileFlow((Flow)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Sequence != null ? class$com$ibm$bpws$model$Sequence : (class$com$ibm$bpws$model$Sequence = BPWSCompiler.class$("com.ibm.bpws.model.Sequence"))).isAssignableFrom(activityClass)) {
                activity = this.compileSequence((Sequence)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Scope != null ? class$com$ibm$bpws$model$Scope : (class$com$ibm$bpws$model$Scope = BPWSCompiler.class$("com.ibm.bpws.model.Scope"))).isAssignableFrom(activityClass)) {
                activity = this.compileScope((Scope)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Reply != null ? class$com$ibm$bpws$model$Reply : (class$com$ibm$bpws$model$Reply = BPWSCompiler.class$("com.ibm.bpws.model.Reply"))).isAssignableFrom(activityClass)) {
                activity = this.compileReply((Reply)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Receive != null ? class$com$ibm$bpws$model$Receive : (class$com$ibm$bpws$model$Receive = BPWSCompiler.class$("com.ibm.bpws.model.Receive"))).isAssignableFrom(activityClass)) {
                activity = this.compileReceive((Receive)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$SwitchBlock != null ? class$com$ibm$bpws$model$SwitchBlock : (class$com$ibm$bpws$model$SwitchBlock = BPWSCompiler.class$("com.ibm.bpws.model.SwitchBlock"))).isAssignableFrom(activityClass)) {
                activity = this.compileSwitch((SwitchBlock)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Pick != null ? class$com$ibm$bpws$model$Pick : (class$com$ibm$bpws$model$Pick = BPWSCompiler.class$("com.ibm.bpws.model.Pick"))).isAssignableFrom(activityClass)) {
                activity = this.compilePick((Pick)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$While != null ? class$com$ibm$bpws$model$While : (class$com$ibm$bpws$model$While = BPWSCompiler.class$("com.ibm.bpws.model.While"))).isAssignableFrom(activityClass)) {
                activity = this.compileWhile((While)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Empty != null ? class$com$ibm$bpws$model$Empty : (class$com$ibm$bpws$model$Empty = BPWSCompiler.class$("com.ibm.bpws.model.Empty"))).isAssignableFrom(activityClass)) {
                activity = this.compileEmpty((Empty)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Terminate != null ? class$com$ibm$bpws$model$Terminate : (class$com$ibm$bpws$model$Terminate = BPWSCompiler.class$("com.ibm.bpws.model.Terminate"))).isAssignableFrom(activityClass)) {
                activity = this.compileTerminate((Terminate)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Throw != null ? class$com$ibm$bpws$model$Throw : (class$com$ibm$bpws$model$Throw = BPWSCompiler.class$("com.ibm.bpws.model.Throw"))).isAssignableFrom(activityClass)) {
                activity = this.compileThrow((Throw)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Assign != null ? class$com$ibm$bpws$model$Assign : (class$com$ibm$bpws$model$Assign = BPWSCompiler.class$("com.ibm.bpws.model.Assign"))).isAssignableFrom(activityClass)) {
                activity = this.compileAssign((Assign)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Compensate != null ? class$com$ibm$bpws$model$Compensate : (class$com$ibm$bpws$model$Compensate = BPWSCompiler.class$("com.ibm.bpws.model.Compensate"))).isAssignableFrom(activityClass)) {
                activity = this.compileCompensate((Compensate)act, scope, parent, linkTable);
            } else if ((class$com$ibm$bpws$model$Wait != null ? class$com$ibm$bpws$model$Wait : (class$com$ibm$bpws$model$Wait = BPWSCompiler.class$("com.ibm.bpws.model.Wait"))).isAssignableFrom(activityClass)) {
                activity = this.compileWait((Wait)act, scope, parent, linkTable);
            } else {
                throw new BPWSRuntimeException("Activity type unsupported: " + activityClass);
            }
            activity.setActivityModel(act);
            if (this.suppressJoinFailure || localSuppressJoin) {
                scope.setActivity(activity);
                activity = scope;
            }
        } else {
            activity = this.compileInvoke((Invoke)act, scope, parent, linkTable);
        }
        return activity;
    }

    private AssignRT compileAssign(Assign assign, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        AssignRT myAssign = new AssignRT(assign.getName(), scope, parent, this.process);
        this.genericActivityWork(assign, myAssign, linkTable);
        return myAssign;
    }

    public BPWSProcessRT compileBPWS(BPWSProcess bpwsProc) throws BPWSRuntimeException {
        if (bpwsProc.getSuppressJoinFailure() != null) {
            this.suppressJoinFailure = bpwsProc.getSuppressJoinFailure();
        }
        this.process = new BPWSProcessRT(bpwsProc.getTargetNamespace(), bpwsProc.getName());
        this.process.setBPWSProcessModel(bpwsProc);
        if (bpwsProc.getPartners() != null) {
            Iterator partners = bpwsProc.getPartners().getPartners().iterator();
            while (partners.hasNext()) {
                Partner partner = (Partner)partners.next();
                PartnerRT bpwsPartner = new PartnerRT(partner.getName(), partner.getServiceLinkType(), null);
                this.process.addPartner(bpwsPartner);
            }
        }
        if (bpwsProc.getContainers() != null) {
            Iterator cont = bpwsProc.getContainers().getContainers().iterator();
            while (cont.hasNext()) {
                ContainerRT container = this.compileContainer((Container)cont.next());
                this.process.addContainer(container);
            }
        }
        if (bpwsProc.getActivity() == null) {
            throw new BPWSRuntimeException("No activity was found for the process.  Perhaps the namespace is incorrect.");
        }
        this.process.setActivity(this.compileActivity(bpwsProc.getActivity(), this.process, this.process, null));
        if (bpwsProc.getFaultHandlers() != null) {
            this.addFaultHandlersToScope(this.process, bpwsProc.getFaultHandlers(), null);
        }
        if (bpwsProc.getCompensationHandler() != null) {
            throw new BPWSRuntimeException("process level compensation not supported");
        }
        return this.process;
    }

    public void compileBPWS(String bpwsURI) throws BPWSRuntimeException {
    }

    private CompensateRT compileCompensate(Compensate compensate, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        CompensateRT myCompensate = new CompensateRT(compensate.getName(), scope, parent, this.process, compensate.getScope().getName());
        this.genericActivityWork(compensate, myCompensate, linkTable);
        return myCompensate;
    }

    private Condition compileCondition(ActivityRT activity, String condition) {
        if (condition != null) {
            return new Condition(activity, condition);
        }
        return new Condition(activity, "true()");
    }

    private ContainerRT compileContainer(Container container) throws BPWSRuntimeException {
        ContainerRT myContainer = null;
        if (container != null) {
            myContainer = new ContainerRT(container.getName());
            myContainer.setMessage((WSIFMessage)new WSIFDefaultMessage());
        }
        return myContainer;
    }

    private EmptyRT compileEmpty(Empty empty, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        EmptyRT myEmpty = new EmptyRT(empty.getName(), scope, parent);
        this.genericActivityWork(empty, myEmpty, linkTable);
        return myEmpty;
    }

    private FlowRT compileFlow(Flow flow, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        FlowRT myFlow = new FlowRT(flow.getName(), scope, parent);
        this.genericActivityWork(flow, myFlow, linkTable);
        LinkTable myLinkTable = new LinkTable(linkTable);
        List links = null;
        Iterator linksIter = null;
        if (flow.getLinks() != null) {
            links = flow.getLinks().getLinks();
            linksIter = links.iterator();
            while (linksIter.hasNext()) {
                Link myLink = (Link)linksIter.next();
                myLinkTable.defineLink(myLink.getName());
            }
        }
        Iterator activities = flow.getActivities().iterator();
        while (activities.hasNext()) {
            myFlow.addActivity(this.compileActivity((Activity)activities.next(), scope, myFlow, myLinkTable));
        }
        if (links != null) {
            linksIter = links.iterator();
            while (linksIter.hasNext()) {
                String linkName = ((Link)linksIter.next()).getName();
                LinkInfo linkInfo = myLinkTable.getLinkInfo(linkName);
                ActivityRT source = linkInfo.source;
                Condition condition = linkInfo.condition;
                ActivityRT target = linkInfo.target;
                if (source == null || target == null) {
                    throw new BPWSRuntimeException("The target and source of link " + linkName + " are not both visible to the flow in " + " which the link are defined");
                }
                source.addAsSourceForLink(linkName, condition);
                target.addAsTargetToLink(linkName, source);
            }
        }
        return myFlow;
    }

    private ActivityRT compileInvoke(Invoke invoke, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        ScopeRT faultScope;
        boolean localSuppressJoin;
        String partnerName = invoke.getPartner().getName();
        QName portTypeName = invoke.getPortType();
        String operationName = invoke.getOperation();
        InvokeRT myInvoke = null;
        ScopeRT faultHandlingScope = null;
        Boolean localSuppressJoinB = invoke.getSuppressJoinFailure();
        boolean bl = localSuppressJoin = localSuppressJoinB == null ? false : localSuppressJoinB;
        if (this.suppressJoinFailure || localSuppressJoin) {
            faultHandlingScope = new ScopeRT(invoke.getName(), scope, parent, this.process);
            faultScope = new ScopeRT("empty_handler_wrapper_scope", faultHandlingScope, faultHandlingScope, this.process);
            faultScope.isFaultHandlerShield = true;
            EmptyRT joinHandler = new EmptyRT("", faultScope, faultScope);
            faultScope.setActivity(joinHandler);
            faultHandlingScope.addFaultHandler(Constants.JOIN_FAULT_QNAME, faultScope, null);
        }
        if (invoke.getCatchFaults() != null && invoke.getCatchFaults().size() > 0) {
            Iterator catchFaults = invoke.getCatchFaults().iterator();
            if (faultHandlingScope == null) {
                faultHandlingScope = new ScopeRT(invoke.getName(), scope, parent, this.process);
            }
            while (catchFaults.hasNext()) {
                CatchFault catchFault = (CatchFault)catchFaults.next();
                String faultContainerName = null;
                if (catchFault.getFaultContainer() != null) {
                    faultContainerName = catchFault.getFaultContainer().getName();
                }
                ScopeRT handlerActivity = this.wrapInScope(faultHandlingScope, catchFault.getActivity(), linkTable, true, false);
                faultHandlingScope.addFaultHandler(catchFault.getFaultName(), handlerActivity, faultContainerName);
            }
        }
        if (invoke.getCatchAll() != null) {
            if (faultHandlingScope == null) {
                faultHandlingScope = new ScopeRT(invoke.getName(), scope, parent, this.process);
            }
            faultScope = this.wrapInScope(faultHandlingScope, invoke.getCatchAll().getActivity(), linkTable, true, false);
            faultHandlingScope.setCatchAllFaultHandler(faultScope);
        }
        if (invoke.getCompensationHandler() != null) {
            if (faultHandlingScope == null) {
                faultHandlingScope = new ScopeRT(invoke.getName(), scope, parent, this.process);
            }
            Activity handlerAct = invoke.getCompensationHandler().getActivity();
            ScopeRT myHandler = this.wrapInScope(faultHandlingScope, handlerAct, linkTable, false, true);
            faultHandlingScope.setCompensationHandler(myHandler);
            this.process.addScopeToMap(faultHandlingScope);
        }
        myInvoke = faultHandlingScope != null ? new InvokeRT(invoke.getName(), faultHandlingScope, faultHandlingScope, this.process, partnerName, portTypeName, operationName) : new InvokeRT(invoke.getName(), scope, parent, this.process, partnerName, portTypeName, operationName);
        myInvoke.setActivityModel(invoke);
        this.genericActivityWork(invoke, myInvoke, linkTable);
        if (invoke.getInputContainer() != null) {
            String inputContainerName = invoke.getInputContainer().getName();
            myInvoke.setInputContainerName(inputContainerName);
        }
        if (invoke.getOutputContainer() != null) {
            String outputContainerName = invoke.getOutputContainer().getName();
            myInvoke.setOutputContainerName(outputContainerName);
        }
        if (faultHandlingScope != null) {
            faultHandlingScope.setActivity(myInvoke);
            return faultHandlingScope;
        }
        return myInvoke;
    }

    private PickRT compilePick(Pick pick, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        List onAlarms;
        PickRT myPick = new PickRT(pick.getName(), scope, parent, this.process);
        List onMessages = pick.getOnMessages();
        if (onMessages != null) {
            Iterator iter = onMessages.iterator();
            while (iter.hasNext()) {
                OnMessage om = (OnMessage)iter.next();
                String handlerContainerName = null;
                if (om.getContainer() != null) {
                    handlerContainerName = om.getContainer().getName();
                }
                myPick.addMessageHandler(om.getPartner().getName(), om.getPortType(), om.getOperation(), om, this.compileActivity(om.getActivity(), scope, myPick, linkTable), handlerContainerName);
            }
        }
        if ((onAlarms = pick.getOnAlarms()) != null && onAlarms.size() == 1) {
            OnAlarm theAlarm = (OnAlarm)onAlarms.get(0);
            myPick.addAlarmHandler(theAlarm.getForExpr(), this.compileActivity(theAlarm.getActivity(), scope, myPick, linkTable));
        }
        return myPick;
    }

    private ReceiveRT compileReceive(Receive receive, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        String partnerName = receive.getPartner().getName();
        QName portTypeName = receive.getPortType();
        String operationName = receive.getOperation();
        ReceiveRT myReceive = new ReceiveRT(receive.getName(), scope, parent, this.process, partnerName, portTypeName, operationName);
        this.genericActivityWork(receive, myReceive, linkTable);
        if (receive.getContainer() != null) {
            String containerName = receive.getContainer().getName();
            myReceive.setContainerName(containerName);
        }
        return myReceive;
    }

    private ReplyRT compileReply(Reply reply, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        ReplyRT myReply = null;
        String partnerName = reply.getPartner().getName();
        QName portTypeName = reply.getPortType();
        String operationName = reply.getOperation();
        myReply = new ReplyRT(reply.getName(), scope, parent, this.process, partnerName, portTypeName, operationName);
        this.genericActivityWork(reply, myReply, linkTable);
        if (reply.getContainer() != null) {
            String containerName = reply.getContainer().getName();
            myReply.setContainerName(containerName);
        }
        return myReply;
    }

    private ScopeRT compileScope(Scope scopeAct, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        ScopeRT myScope = new ScopeRT(scopeAct.getName(), scope, parent, this.process);
        this.genericActivityWork(scopeAct, myScope, linkTable);
        if (scopeAct.getActivity() != null) {
            myScope.setActivity(this.compileActivity(scopeAct.getActivity(), myScope, myScope, linkTable));
        }
        if (scopeAct.getFaultHandlers() != null) {
            this.addFaultHandlersToScope(myScope, scopeAct.getFaultHandlers(), linkTable);
        }
        if (scopeAct.getCompensationHandler() != null) {
            Activity handlerAct = scopeAct.getCompensationHandler().getActivity();
            ScopeRT myHandler = this.wrapInScope(myScope, handlerAct, linkTable, false, true);
            myScope.setCompensationHandler(myHandler);
            this.process.addScopeToMap(myScope);
        }
        return myScope;
    }

    private SequenceRT compileSequence(Sequence sequence, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        SequenceRT mySequence = new SequenceRT(sequence.getName(), scope, parent);
        this.genericActivityWork(sequence, mySequence, linkTable);
        Iterator activities = sequence.getActivities().iterator();
        while (activities.hasNext()) {
            mySequence.addActivity(this.compileActivity((Activity)activities.next(), scope, mySequence, linkTable));
        }
        return mySequence;
    }

    private SwitchRT compileSwitch(SwitchBlock switchBlock, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        SwitchRT mySwitch = new SwitchRT(switchBlock.getName(), scope, parent);
        this.genericActivityWork(switchBlock, mySwitch, linkTable);
        Iterator caseClauses = switchBlock.getCaseClauses().iterator();
        while (caseClauses.hasNext()) {
            CaseClause clause = (CaseClause)caseClauses.next();
            mySwitch.addConditionAndActivity(this.compileCondition(mySwitch, clause.getCondition()), this.compileActivity(clause.getActivity(), scope, mySwitch, linkTable));
        }
        if (switchBlock.getOtherwise() != null) {
            Activity otherwiseAct = switchBlock.getOtherwise().getActivity();
            mySwitch.addOtherwiseActivity(this.compileActivity(otherwiseAct, scope, mySwitch, linkTable));
        }
        return mySwitch;
    }

    private TerminateRT compileTerminate(Terminate terminate, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        TerminateRT myTerminate = new TerminateRT(terminate.getName(), scope, parent, this.process);
        this.genericActivityWork(terminate, myTerminate, linkTable);
        return myTerminate;
    }

    private ThrowRT compileThrow(Throw throwAct, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        String containerName = null;
        if (throwAct.getFaultContainer() != null) {
            containerName = throwAct.getFaultContainer().getName();
        }
        ThrowRT myThrow = new ThrowRT(throwAct.getName(), scope, parent, throwAct.getFaultName(), containerName);
        this.genericActivityWork(throwAct, myThrow, linkTable);
        return myThrow;
    }

    private WaitRT compileWait(Wait wait, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        String forExpr = wait.getForExpr();
        if (forExpr == null) {
            throw new BPWSRuntimeException("Wait with an 'until' expression not supported");
        }
        WaitRT myWait = new WaitRT(wait.getName(), scope, parent, this.process, forExpr);
        this.genericActivityWork(wait, myWait, linkTable);
        return myWait;
    }

    private WhileRT compileWhile(While whileModel, ScopeRT scope, ActivityRT parent, LinkTable linkTable) throws BPWSRuntimeException {
        WhileRT whileAct = new WhileRT(whileModel.getName(), scope, parent);
        this.genericActivityWork(whileModel, whileAct, linkTable);
        Condition condition = this.compileCondition(whileAct, whileModel.getCondition());
        whileAct.setCondition(condition);
        whileAct.setActivity(this.compileActivity(whileModel.getActivity(), scope, whileAct, linkTable));
        return whileAct;
    }

    private void genericActivityWork(Activity activity, ActivityRT myActivity, LinkTable linkTable) throws BPWSRuntimeException {
        if (linkTable == null) {
            return;
        }
        Iterator sources = activity.getSources().iterator();
        while (sources.hasNext()) {
            Source source = (Source)sources.next();
            String condition = source.getTransitionCondition();
            linkTable.setLinkSourceInfo(source.getLink().getName(), myActivity, this.compileCondition(myActivity, condition));
        }
        Iterator targets = activity.getTargets().iterator();
        while (targets.hasNext()) {
            Target target = (Target)targets.next();
            linkTable.setLinkTargetInfo(target.getLink().getName(), myActivity);
        }
        if (activity.getJoinCondition() != null) {
            Condition join = this.compileCondition(myActivity, activity.getJoinCondition());
            myActivity.setJoinCondition(join);
        }
    }

    private ScopeRT wrapInScope(ScopeRT scope, Activity handlerAct, LinkTable linkTable, boolean isFaultHandlerShield, boolean isCompensationHandlerShield) throws BPWSRuntimeException {
        ScopeRT handlerScope = null;
        Boolean localSuppressJoinB = handlerAct.getSuppressJoinFailure();
        boolean localSuppressJoin = localSuppressJoinB == null ? false : localSuppressJoinB;
        if (!((class$com$ibm$bpws$model$Scope != null ? class$com$ibm$bpws$model$Scope : (class$com$ibm$bpws$model$Scope = BPWSCompiler.class$("com.ibm.bpws.model.Scope"))).isAssignableFrom(handlerAct.getClass()) || this.suppressJoinFailure || localSuppressJoin)) {
            handlerScope = new ScopeRT(String.valueOf(handlerAct.getName()) + "_wrapper_scope", scope, scope, this.process);
            handlerScope.setActivity(this.compileActivity(handlerAct, handlerScope, handlerScope, linkTable));
        } else {
            handlerScope = (ScopeRT)this.compileActivity(handlerAct, scope, scope, linkTable);
        }
        if (isFaultHandlerShield) {
            handlerScope.isFaultHandlerShield = true;
        } else if (isCompensationHandlerShield) {
            handlerScope.isCompensationHandlerShield = true;
        }
        return handlerScope;
    }
}

